/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core;

import com.fr.base.ColumnRow;
import com.fr.base.FRContext;
import com.fr.base.core.Converter;
import com.fr.base.core.GraphHelper;
import com.fr.base.core.html.Tag;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.util.vt.VT4FR;
import com.fr.report.FloatElement;
import com.fr.report.ReportHF;
import com.fr.report.ReportPage;
import com.fr.report.ReportSettings;
import com.fr.report.core.DynamicValueList;
import com.fr.report.core.PaintUtils;
import com.fr.report.core.ReportHelper;
import com.fr.report.core.ReportUtils;
import com.fr.report.js.NameJavaScriptGroup;
import com.fr.web.Repository;
import com.fr.web.core.HTMLWriter;
import com.fr.web.core.HTMLWriterUtils;
import com.fr.web.core.ReportBackgroundDimension;
import com.fr.web.core.chwriter.CellHtmlWriter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.logging.Level;

public class HTMLConverter
implements Converter {
    private ReportPage reportPage;
    private Tag resTag;
    private CellHtmlWriter cellHtmlWriter;
    private ColumnRow frozenColumnRow;
    private boolean showHeaderAndFooter;
    private Repository repo;

    public HTMLConverter(ReportPage reportPage, CellHtmlWriter cellHtmlWriter, ColumnRow columnRow, Repository repository, Tag tag, boolean bl) {
        this.reportPage = reportPage;
        this.cellHtmlWriter = cellHtmlWriter;
        this.frozenColumnRow = columnRow;
        this.repo = repository;
        this.resTag = tag;
        this.showHeaderAndFooter = bl;
    }

    public void convert() {
        this.toTag();
    }

    private void toTag() {
        Rectangle2D.Double double_;
        ReportHF reportHF;
        this.repo.getSessionIDInfor().clearReportPageImages();
        ReportSettings reportSettings = this.reportPage.getReportSettings();
        int n = this.reportPage.getPageWidth();
        int n2 = this.reportPage.getPageHeight();
        int n3 = this.reportPage.getMarginTop();
        int n4 = this.reportPage.getMarginLeft();
        int n5 = this.reportPage.getMarginBottom();
        int n6 = this.reportPage.getMarginRight();
        int n7 = n3 + (this.showHeaderAndFooter ? ReportUtils.getHeaderHeight(reportSettings) : 0);
        if (this.showHeaderAndFooter && (reportHF = this.reportPage.getHeader()) != null && ((RectangularShape)(double_ = new Rectangle2D.Double(n4, n3, n - n4 - n6, ReportUtils.getHeaderHeight(reportSettings)))).getWidth() > 0.0 && ((RectangularShape)double_).getHeight() > 0.0) {
            this.writeReportHF(this.resTag, "HF-header", ColumnRow.validate(this.frozenColumnRow), reportHF, double_, this.reportPage, this.repo);
        }
        this.writeContent(this.resTag, this.reportPage, this.frozenColumnRow, new Rectangle2D.Double(n4, n7, n - n4 - n6, n2 - n3 - n5 - ReportUtils.getHeaderHeight(reportSettings) - ReportUtils.getFooterHeight(reportSettings)), this.repo);
        if (this.showHeaderAndFooter && (reportHF = this.reportPage.getFooter()) != null && ((RectangularShape)(double_ = new Rectangle2D.Double(n4, n2 - n5 - ReportUtils.getFooterHeight(reportSettings), n - n4 - n6, ReportUtils.getFooterHeight(reportSettings)))).getWidth() > 0.0 && ((RectangularShape)double_).getHeight() > 0.0) {
            this.writeReportHF(this.resTag, "HF-footer", ColumnRow.validate(this.frozenColumnRow), reportHF, double_, this.reportPage, this.repo);
        }
    }

    private void writeReportHF(Tag tag, String string, boolean bl, ReportHF reportHF, Rectangle2D rectangle2D, ReportPage reportPage, Repository repository) {
        Tag tag2 = new Tag("div").cls(string);
        tag.sub(tag2);
        tag2.css("overflow", "hidden");
        tag2.css("position", "absolute");
        if (!bl) {
            tag2.css("left", (int)rectangle2D.getX() + "px");
            tag2.css("top", (int)rectangle2D.getY() + "px");
        }
        tag2.css("width", (int)rectangle2D.getWidth() + "px");
        tag2.css("height", (int)rectangle2D.getHeight() + "px");
        BufferedImage bufferedImage = GraphHelper.createBufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, rectangle2D.getWidth(), rectangle2D.getHeight());
        graphics2D.setPaint(Color.white);
        GraphHelper.fill(graphics2D, double_);
        reportHF.paint(graphics2D, double_, (int)((RectangularShape)double_).getWidth(), (int)((RectangularShape)double_).getHeight(), reportPage.getCurrentPageNumber(), reportPage.getTotalPages(), false);
        bufferedImage.flush();
        graphics2D.dispose();
        repository.writeTagBackground(tag2, bufferedImage);
    }

    private void writeContent(Tag tag, ReportPage reportPage, ColumnRow columnRow, Rectangle2D rectangle2D, Repository repository) {
        int n = reportPage.getContentWidth();
        int n2 = reportPage.getContentHeight();
        n += 2;
        n2 += 2;
        double d = 0.0;
        double d2 = 0.0;
        ReportSettings reportSettings = reportPage.getReportSettings();
        if (reportSettings.isHorizontalCenterOnPage()) {
            d = (rectangle2D.getWidth() - (double)n) / 2.0;
        }
        if (reportSettings.isVerticalCenterOnPage()) {
            d2 = (rectangle2D.getHeight() - (double)n2) / 2.0;
        }
        Tag tag2 = new Tag("div");
        tag.sub(tag2);
        if (repository.getBrowser().shouldSetOverflowAsHiddenOnSheetContainer()) {
            tag2.css("overflow", "hidden");
        }
        tag2.css("position", "absolute");
        if (!ColumnRow.validate(columnRow)) {
            tag2.css("left", d + rectangle2D.getX() + "px");
            tag2.css("top", d2 + rectangle2D.getY() + "px");
        }
        tag2.css("width", n + 5 + "px");
        tag2.css("height", n2 + 5 + "px");
        if (reportSettings.getBackground() != null) {
            HTMLWriterUtils.writeBackground(tag2, reportSettings.getBackground(), new ReportBackgroundDimension(n + 5, n2 + 5), false, repository, false);
        }
        HTMLWriter hTMLWriter = this.createHTMLWriterCase();
        DynamicValueList dynamicValueList = ReportHelper.createColumnWidthList(reportPage);
        DynamicValueList dynamicValueList2 = ReportHelper.createRowHeightList(reportPage);
        if (VT4FR.FROZEN_VIEW.support() && ColumnRow.validate(columnRow)) {
            tag2.cls("frozen-page");
            Tag tag3 = new Tag("div");
            Tag tag4 = new Tag("div");
            Tag tag5 = new Tag("div");
            Tag tag6 = new Tag("div");
            hTMLWriter.writeFrozenContentWithCenterCornerNW(tag2, reportPage, columnRow, 0, this.cellHtmlWriter, repository, tag3, tag4, tag5, tag6);
            Iterator iterator = reportPage.floatIterator();
            while (iterator.hasNext()) {
                FloatElement floatElement = (FloatElement)iterator.next();
                int n3 = floatElement.getColumn();
                int n4 = floatElement.getRow();
                int n5 = 0;
                int n6 = 0;
                Tag tag7 = tag2;
                if (n3 < columnRow.column && n4 < columnRow.row) {
                    tag7 = tag4;
                    n5 = dynamicValueList.getRangeValueFromZero(n3) + floatElement.getLeftDistance();
                    n6 = dynamicValueList2.getRangeValueFromZero(n4) + floatElement.getTopDistance();
                } else if (n3 < columnRow.column) {
                    tag7 = tag6;
                    n5 = dynamicValueList.getRangeValueFromZero(n3) + floatElement.getLeftDistance();
                    n6 = dynamicValueList2.getRangeValue(columnRow.row, n4) + floatElement.getTopDistance();
                } else if (n4 < columnRow.row) {
                    tag7 = tag5;
                    n5 = dynamicValueList.getRangeValue(columnRow.column, n3) + floatElement.getLeftDistance();
                    n6 = dynamicValueList2.getRangeValueFromZero(n4) + floatElement.getTopDistance();
                } else {
                    tag7 = tag3;
                    n5 = dynamicValueList.getRangeValue(columnRow.column, n3) + floatElement.getLeftDistance();
                    n6 = dynamicValueList2.getRangeValue(columnRow.row, n4) + floatElement.getTopDistance();
                }
                this.writeFloatElementTag(floatElement, tag7, n5, n6);
            }
        } else {
            tag2.sub(hTMLWriter.writeJSReport(reportPage, 0, this.cellHtmlWriter, repository));
            Iterator iterator = reportPage.floatIterator();
            while (iterator.hasNext()) {
                FloatElement floatElement = (FloatElement)iterator.next();
                int n7 = dynamicValueList.getRangeValueFromZero(floatElement.getColumn()) + floatElement.getLeftDistance();
                int n8 = dynamicValueList2.getRangeValueFromZero(floatElement.getRow()) + floatElement.getTopDistance();
                this.writeFloatElementTag(floatElement, tag2, n7, n8);
            }
        }
    }

    private void writeFloatElementTag(FloatElement floatElement, Tag tag, int n, int n2) {
        Tag tag2 = null;
        NameJavaScriptGroup nameJavaScriptGroup = floatElement.getNameHyperlinkGroup();
        if (nameJavaScriptGroup != null && nameJavaScriptGroup.size() > 0) {
            tag2 = new Tag("span");
            String string = "{}";
            try {
                string = HTMLWriterUtils.writeJSLinkContent(nameJavaScriptGroup, this.repo);
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
            }
            tag2.attr("onclick", "FR.doHyperlink(event ||window.event," + string + ")");
            tag2.css("cursor", "pointer");
        }
        int n3 = floatElement.getSize().width + 1;
        int n4 = floatElement.getSize().height + 1;
        Tag tag3 = new Tag("div");
        if (tag2 == null) {
            tag2 = tag3;
        } else {
            tag2.sub(tag3);
        }
        tag.sub(tag2);
        tag3.css("overflow", "hidden");
        tag3.css("position", "absolute");
        tag3.css("left", n + "px");
        tag3.css("top", n2 + "px");
        tag3.css("width", n3 + "px");
        tag3.css("height", n4 + "px");
        Tag tag4 = floatElement.toTag(this.repo);
        this.repo.writeTagBackground(tag4, this.paint4Float(floatElement, n3, n4));
        tag3.sub(tag4);
    }

    protected HTMLWriter createHTMLWriterCase() {
        return HTMLWriter.getInstance();
    }

    private Image paint4Float(FloatElement floatElement, int n, int n2) {
        BufferedImage bufferedImage = GraphHelper.createBufferedImage(n, n2, 6);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setPaint(Color.white);
        PaintUtils.paintBackground(graphics2D, floatElement.getStyle(), n - 1, n2 - 1);
        PaintUtils.paintBorder(graphics2D, floatElement.getStyle(), n - 1, n2 - 1);
        bufferedImage.flush();
        graphics2D.dispose();
        return bufferedImage;
    }
}

