/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core;

import com.fr.base.ColumnRow;
import com.fr.base.FRContext;
import com.fr.base.Style;
import com.fr.base.core.html.Tag;
import com.fr.base.core.json.JSONException;
import com.fr.report.Cell;
import com.fr.report.CellElement;
import com.fr.report.DefaultCellElement;
import com.fr.report.ReportGetter;
import com.fr.report.cellElement.core.CellElementAttribute;
import com.fr.web.Repository;
import com.fr.web.core.HTMLWriterUtils;
import com.fr.web.core.chwriter.CellHtmlWriter;
import com.fr.web.core.chwriter.PageCellWriter;
import com.fr.web.core.chwriter.WriteCellWriter;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;

public class HTMLWriter {
    private static HTMLWriter SC = new HTMLWriter();
    static int ID = 0;
    private static int ID_MAX = 2147482647;

    protected HTMLWriter() {
    }

    public static HTMLWriter getInstance() {
        return SC;
    }

    protected static int _GENERATE_ID() {
        if (ID >= ID_MAX) {
            ID = 0;
        }
        return ++ID;
    }

    public void writeFrozenContentWithCenterCornerNW(Tag tag, ReportGetter reportGetter, ColumnRow columnRow, int n, CellHtmlWriter cellHtmlWriter, Repository repository, Tag tag2, Tag tag3, Tag tag4, Tag tag5) {
        int n2 = HTMLWriter._GENERATE_ID();
        cellHtmlWriter.setTableID(n2);
        tag.sub(tag2.css("position", "absolute").css("overflow", "scroll").cls("offset-c frozen-center").sub(this.clipReport2Html(reportGetter, new Rectangle(columnRow.getColumn(), columnRow.getRow(), reportGetter.getColumnCount() - columnRow.getColumn(), reportGetter.getRowCount() - columnRow.getRow()), n, cellHtmlWriter, repository)));
        Tag tag6 = tag3.css("position", "absolute").css("overflow", "hiden").cls("frozen-row frozen-column offset-c frozen-corner");
        if (columnRow.column != 0 && columnRow.row != 0) {
            tag.sub(tag6.sub(this.clipReport2Html(reportGetter, new Rectangle(0, 0, columnRow.getColumn(), columnRow.getRow()), n, cellHtmlWriter, repository)));
        }
        Tag tag7 = tag4.css("position", "absolute").css("overflow-y", "scroll").cls("frozen-row offset-c frozen-north");
        if (columnRow.row != 0) {
            tag.sub(tag7.sub(this.clipReport2Html(reportGetter, new Rectangle(columnRow.getColumn(), 0, reportGetter.getColumnCount() - columnRow.getColumn(), columnRow.getRow()), n, cellHtmlWriter, repository)));
        }
        Tag tag8 = tag5.css("position", "absolute").css("overflow-x", "scroll").cls("frozen-column offset-c frozen-west");
        if (columnRow.column != 0) {
            tag.sub(tag8.sub(this.clipReport2Html(reportGetter, new Rectangle(0, columnRow.getRow(), columnRow.getColumn(), reportGetter.getRowCount() - columnRow.getRow()), n, cellHtmlWriter, repository)));
        }
    }

    public void writeFrozenContent(Tag tag, ReportGetter reportGetter, ColumnRow columnRow, int n, CellHtmlWriter cellHtmlWriter, Repository repository) {
        this.writeFrozenContentWithCenterCornerNW(tag, reportGetter, columnRow, n, cellHtmlWriter, repository, new Tag("div"), new Tag("div"), new Tag("div"), new Tag("div"));
    }

    protected Tag clipReport2Html(ReportGetter reportGetter, Rectangle rectangle, int n, CellHtmlWriter cellHtmlWriter, Repository repository) {
        int n2;
        int n3;
        Tag tag = new Tag("table").cls("x-table").attr("id", "" + cellHtmlWriter.getTableID()).attr("cellSpacing", "0").attr("cellPadding", "0");
        if (cellHtmlWriter instanceof PageCellWriter) {
            tag.css("position", "absolute").css("left", "0px");
        }
        Tag tag2 = new Tag("colgroup");
        tag.sub(tag2);
        int n4 = 0;
        int n5 = rectangle.width + n3;
        for (n3 = rectangle.x; n3 < n5; ++n3) {
            int n6 = reportGetter.getColumnWidth(n3);
            if (n6 == 0) continue;
            tag2.sub(new Tag("col").attr("col", n3 + "").css("width", n6 + "px"));
            n4 += n6;
        }
        if (repository.getBrowser().shouldDoSomeStuff4MissingRightBorderOfTable()) {
            // empty if block
        }
        tag.css("width", n4 + 1 + "px");
        n3 = 0;
        Tag tag3 = new Tag("tbody");
        tag.sub(tag3);
        Tag tag4 = null;
        boolean[][] blArrayArray = new boolean[rectangle.height][];
        for (int i = 0; i < blArrayArray.length; ++i) {
            blArrayArray[i] = new boolean[rectangle.width];
            for (int j = 0; j < blArrayArray[i].length; ++j) {
                blArrayArray[i][j] = false;
            }
        }
        Tag tag5 = null;
        ArrayList[] arrayListArray = new ArrayList[reportGetter.getRowCount()];
        int n7 = 0;
        CellElement cellElement = null;
        Cell cell = null;
        int n8 = 0;
        int n9 = n2 + rectangle.height;
        for (n2 = rectangle.y; n2 < n9; ++n2) {
            n8 = reportGetter.getRowHeight(n2);
            if (n2 == rectangle.y) {
                tag4 = new Tag("tr").attr("id", "r-" + n2 + "-" + n).attr("tridx", "" + n2);
                tag3.sub(tag4.css("height", n8 + "px"));
                this.dealWithTrTag(tag4, n2 - rectangle.y);
                if (n8 == 0) {
                    cellHtmlWriter.dealWithEmptyHeight(tag4);
                }
            }
            n3 += n8;
            CellElement[] cellElementArray = new CellElement[reportGetter.getColumnCount()];
            Iterator iterator = reportGetter.getRow(n2);
            while (iterator.hasNext()) {
                cellElementArray[cellElement.getColumn()] = cellElement = (CellElement)iterator.next();
            }
            if (arrayListArray[n2] != null) {
                ArrayList arrayList = arrayListArray[n2];
                for (int i = 0; i < arrayList.size(); ++i) {
                    cellElementArray[cellElement.getColumn()] = cellElement = (CellElement)arrayList.get(i);
                }
            }
            for (int i = 0; i < cellElementArray.length; ++i) {
                if (cellElementArray[i] == null) continue;
                cellElement = cellElementArray[i];
                Rectangle rectangle2 = rectangle.intersection(new Rectangle(cellElement.getColumn(), cellElement.getRow(), cellElement.getColumnSpan(), cellElement.getRowSpan()));
                if (rectangle2.width <= 0 || rectangle2.height <= 0) continue;
                cell = cellElement;
                int n10 = rectangle2.y - rectangle.y;
                int n11 = rectangle2.x - rectangle.x;
                if (n7 < n10) {
                    for (int j = n7; j < n10; ++j) {
                        this.fillBlankTD(tag4, blArrayArray, j, rectangle.width, n, cellHtmlWriter.getTableID(), rectangle, reportGetter, repository);
                        n8 = reportGetter.getRowHeight(j + rectangle.y + 1);
                        tag4 = new Tag("tr").attr("id", "r-" + (j + rectangle.y + 1) + "-" + n).attr("tridx", "" + (j + rectangle.y + 1));
                        tag3.sub(tag4.css("height", n8 + "px"));
                        this.dealWithTrTag(tag4, j + 1);
                        if (n8 != 0) continue;
                        cellHtmlWriter.dealWithEmptyHeight(tag4);
                    }
                    n7 = n10;
                }
                this.fillBlankTD(tag4, blArrayArray, n10, n11, n, cellHtmlWriter.getTableID(), rectangle, reportGetter, repository);
                this.fillFrozenContentTD(blArrayArray, n10, n11, rectangle2.height, rectangle2.width);
                Rectangle rectangle3 = new Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                if (rectangle3.height > 1 || rectangle3.width > 1) {
                    int n12;
                    int n13;
                    if (reportGetter.getRowHeight(n2) == 0 || reportGetter.getColumnWidth(cellElement.getColumn()) == 0) {
                        int n14;
                        int n15 = n2;
                        n13 = cellElement.getColumn();
                        n12 = rectangle3.height;
                        int n16 = rectangle3.width;
                        if (rectangle3.height > 1) {
                            for (n14 = 0; n14 < rectangle3.height && reportGetter.getRowHeight(n15 = n2 + n14) <= 0; ++n14) {
                                --n12;
                            }
                        }
                        if (n12 > 0 && rectangle3.width > 1) {
                            for (n14 = 0; n14 < rectangle3.width && reportGetter.getColumnWidth(n13 = cellElement.getColumn() + n14) <= 0; ++n14) {
                                --n16;
                            }
                        }
                        if (n12 > 0 && n16 > 0) {
                            CellElement cellElement2 = null;
                            try {
                                cellElement2 = cellElement.clone(n13, n15, n16, n12);
                            }
                            catch (CloneNotSupportedException cloneNotSupportedException) {
                                cellElement2 = new DefaultCellElement(n13, n15, n16, n12, cellElement.getValue());
                                FRContext.getLogger().log(Level.WARNING, cloneNotSupportedException.getMessage(), cloneNotSupportedException);
                            }
                            cellElement2.setAttribute(CellElementAttribute.HTML_ID, WriteCellWriter.retriveCellElementPositions(cellElement));
                            cellElement.setAttribute(CellElementAttribute.HTML_ID, new Object());
                            rectangle3.height = 1;
                            rectangle3.width = 1;
                            rectangle2.height = 1;
                            rectangle2.width = 1;
                            if (n15 == n2) {
                                cellElementArray[n13] = cellElement2;
                            } else {
                                if (arrayListArray[n15] == null) {
                                    arrayListArray[n15] = new ArrayList();
                                }
                                arrayListArray[n15].add(cellElement2);
                            }
                        }
                    } else {
                        int n17 = rectangle3.height;
                        n13 = rectangle3.width;
                        if (repository.getBrowser().justDealWithTheHiddenRowsOfTail()) {
                            for (n12 = n17 - 1; n12 > 0 && reportGetter.getRowHeight(n2 + n12) <= 0; --n12) {
                                --rectangle3.height;
                            }
                        } else {
                            for (n12 = 1; n12 < n17; ++n12) {
                                if (reportGetter.getRowHeight(n2 + n12) > 0) continue;
                                --rectangle3.height;
                            }
                        }
                        for (n12 = 1; n12 < n13; ++n12) {
                            if (reportGetter.getColumnWidth(cellElement.getColumn() + n12) > 0) continue;
                            --rectangle3.width;
                        }
                    }
                }
                try {
                    tag5 = cellHtmlWriter.cell2Tag(cellElement, reportGetter, rectangle3, rectangle2);
                    tag4.sub(tag5);
                    this.dealWithTdTag(tag5, cellElement.getColumn() - rectangle.x, cellElement.getRow() - rectangle.y);
                    cellElement.removeAttribute(CellElementAttribute.HTML_ID);
                    continue;
                }
                catch (JSONException jSONException) {
                    FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
                }
            }
        }
        if (cell != null) {
            int n18;
            this.fillBlankTD(tag4, blArrayArray, cell.getRow() - rectangle.y, rectangle.width, n, cellHtmlWriter.getTableID(), rectangle, reportGetter, repository);
            n2 = cell.getRowSpan();
            for (n18 = 1; n18 < n2; ++n18) {
                Tag tag6 = this.fillBlankTR(reportGetter.getRowHeight(n18 + cell.getRow()));
                tag6.attr("tridx", "" + (n18 + cell.getRow()));
                tag3.sub(tag6);
                this.dealWithTrTag(tag6, n18 + cell.getRow() - rectangle.y);
            }
            for (int i = n18 = rectangle.height - cell.getRow() - cell.getRowSpan(); i > 0; --i) {
                Tag tag7 = this.fillBlankTR(reportGetter.getRowHeight(rectangle.height - 1 - i));
                tag7.attr("tridx", "" + (rectangle.height - 1 - i));
                tag3.sub(tag7);
                this.dealWithTrTag(tag7, rectangle.height - 1 - i - rectangle.y);
            }
        }
        return tag;
    }

    protected void dealWithTrTag(Tag tag, int n) {
    }

    protected void dealWithTdTag(Tag tag, int n, int n2) {
    }

    public Tag writeJSReport(ReportGetter reportGetter, int n, CellHtmlWriter cellHtmlWriter, Repository repository) {
        int n2 = HTMLWriter._GENERATE_ID();
        cellHtmlWriter.setTableID(n2);
        return this.clipReport2Html(reportGetter, new Rectangle(0, 0, reportGetter.getColumnCount(), reportGetter.getRowCount()), n, cellHtmlWriter, repository);
    }

    protected void fillBlankTD(Tag tag, boolean[][] blArray, int n, int n2, int n3, int n4, Rectangle rectangle, ReportGetter reportGetter, Repository repository) {
        if (n2 < 0 || n < 0) {
            return;
        }
        for (int i = 0; i < n2; ++i) {
            if (blArray[n][i]) continue;
            blArray[n][i] = true;
            Tag tag2 = new Tag("td");
            tag.sub(tag2);
            tag2.attr("id", ColumnRow.valueOf(rectangle.x + i, n + rectangle.y) + "-" + n3 + "-" + n4).attr("row", "" + (n + rectangle.y)).attr("col", "" + (rectangle.x + i));
            this.dealWithTdTag(tag2, i, n - rectangle.y);
            HTMLWriterUtils.contentStyle2Css(Style.DEFAULT_STYLE, tag2);
            HTMLWriterUtils.borderStyle2Css(Style.DEFAULT_STYLE, tag2);
            if (reportGetter.getColumnWidth(rectangle.x + i) != 0) continue;
            tag2.css("display", "none");
        }
    }

    protected void fillFrozenContentTD(boolean[][] blArray, int n, int n2, int n3, int n4) {
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                blArray[i + n][j + n2] = true;
            }
        }
    }

    protected Tag fillBlankTR(double d) {
        Tag tag = new Tag("tr");
        if (d == 0.0) {
            tag.css("display", "none");
        } else {
            tag.css("height", d + "px");
        }
        return tag;
    }
}

