/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core;

import com.fr.base.FRContext;
import com.fr.base.FRFont;
import com.fr.base.Inter;
import com.fr.base.Painter;
import com.fr.base.Style;
import com.fr.base.background.Background;
import com.fr.base.background.ColorBackground;
import com.fr.base.background.ImageBackground;
import com.fr.base.background.TextureBackground;
import com.fr.base.core.GraphHelper;
import com.fr.base.core.html.Tag;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.report.DefaultCellElement;
import com.fr.report.WorkSheet;
import com.fr.report.cellElement.CellGUIAttr;
import com.fr.report.cellElement.core.CellUtils;
import com.fr.report.core.ReportHelper;
import com.fr.report.io.core.IOHelper;
import com.fr.report.js.NameJavaScriptGroup;
import com.fr.report.parameter.Parameter;
import com.fr.report.web.ui.impl.form.FormResetButton;
import com.fr.report.web.ui.impl.form.FormSubmitButton;
import com.fr.util.Utils;
import com.fr.web.Repository;
import com.fr.web.core.BackgroundDimension;
import com.fr.web.core.HTMLWriter;
import com.fr.web.core.chwriter.FormCellWriter;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class HTMLWriterUtils {
    private HTMLWriterUtils() {
    }

    public static void writeBackground(Tag tag, Background background, BackgroundDimension backgroundDimension, boolean bl, Repository repository, boolean bl2) {
        if (background instanceof ColorBackground) {
            tag.css("background-color", Utils.javaColorToCSSColor(((ColorBackground)background).getColor()));
        } else if (background != null) {
            int n = backgroundDimension.getWidth();
            int n2 = backgroundDimension.getHeight();
            if (n == 0 || n2 == 0) {
                return;
            }
            BufferedImage bufferedImage = GraphHelper.createBufferedImage(n, n2, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            background.paint(graphics2D, new Rectangle2D.Double(0.0, 0.0, n, n2));
            bufferedImage.flush();
            graphics2D.dispose();
            if (!bl) {
                tag.css("background-repeat", "no-repeat");
            }
            repository.writeTagBackground(tag, bufferedImage, bl2);
        }
    }

    public static void writeBackground(Tag tag, Background background, BackgroundDimension backgroundDimension, boolean bl, Repository repository) {
        HTMLWriterUtils.writeBackground(tag, background, backgroundDimension, bl, repository, true);
    }

    public static JSONObject jsonBackground(Background background, Repository repository) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (background instanceof ColorBackground) {
            stringBuffer.append(Utils.javaColorToCSSColor(((ColorBackground)background).getColor()));
        } else if (background instanceof ImageBackground) {
            object = (ImageBackground)background;
            stringBuffer.append("url(").append(repository.checkoutImage(((ImageBackground)object).getDefaultImage())).append(") ");
            if (((ImageBackground)object).getLayout() == 3) {
                stringBuffer.append("no-repeat");
            } else if (((ImageBackground)object).getLayout() == 1) {
                stringBuffer.append("no-repeat center");
            } else if (((ImageBackground)object).getLayout() == 0) {
                stringBuffer.append("repeat");
            } else if (((ImageBackground)object).getLayout() == 2) {
                stringBuffer.append("no-repeat center");
            }
        } else if (background != null) {
            int n;
            int n2;
            if (background instanceof TextureBackground) {
                n2 = 174;
                n = 126;
            } else {
                n2 = 160;
                n = 160;
            }
            BufferedImage bufferedImage = GraphHelper.createBufferedImage(n2, n, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            background.paint(graphics2D, new Rectangle2D.Double(0.0, 0.0, n2, n));
            bufferedImage.flush();
            graphics2D.dispose();
            stringBuffer.append("url(").append(repository.checkoutImage(bufferedImage)).append(") ").append("repeat ");
        }
        object = new JSONObject();
        if (stringBuffer.length() > 0) {
            try {
                ((JSONObject)object).put("background", stringBuffer.toString());
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
            }
        }
        return object;
    }

    public static String writeJSLinkContent(NameJavaScriptGroup nameJavaScriptGroup, Repository repository) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (int i = 0; i < nameJavaScriptGroup.size(); ++i) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("data", nameJavaScriptGroup.getNameHyperlink(i).getJavaScript().createJS(repository).replaceAll("\n", ""));
            jSONObject.put("name", nameJavaScriptGroup.getNameHyperlink(i).getName());
            jSONArray.put(jSONObject);
        }
        return jSONArray.toString();
    }

    public static void value2PaintableTag(Object object, Style style, int n, int n2, Tag tag, Repository repository, boolean bl) {
        if (object instanceof Image && style != null && style.getImageLayout() == 3) {
            Image image = (Image)object;
            tag.sub(repository.checkoutImageTag(image, image.getWidth(null), image.getHeight(null)));
        } else if (object instanceof Painter) {
            if (repository.getBrowser().shouldModifyWidth4PainterAccordingToBorderWidth()) {
                n -= (IOHelper.getBorderWidth(style.getBorderLeft()) + IOHelper.getBorderWidth(style.getBorderRight()) + 1) / 2;
            }
            if (bl) {
                tag.sub(repository.checkoutImageTag(CellUtils.value2Image((Object)((Painter)object), style, n, n2), n, n2));
            } else {
                ((Painter)object).paintTag(repository, n, n2, style, tag);
            }
        } else {
            Image image = CellUtils.value2ImageWithBackground(object, style, n, n2);
            tag.sub(repository.checkoutImageTag(image, n, n2));
        }
    }

    public static StringBuffer writeAlign(Style style) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = style.getHorizontalAlignment();
        if (n == 2) {
            stringBuffer.append("text-align:left;");
        } else if (n == 0) {
            stringBuffer.append("text-align:center;");
        } else if (n == 4) {
            stringBuffer.append("text-align:right;");
        }
        int n2 = style.getVerticalAlignment();
        if (n2 == 1) {
            stringBuffer.append("vertical-align:top;");
        } else if (n2 == 0) {
            stringBuffer.append("vertical-align:middle;");
        } else if (n2 == 3) {
            stringBuffer.append("vertical-align:bottom;");
        }
        return stringBuffer;
    }

    public static void contentStyle2Css(Style style, Tag tag) {
        tag.cls(style.getContentClsCss());
        Map map = style.getContentStyleCssMap();
        if (map.size() > 0) {
            tag.css(map);
        }
    }

    public static void borderStyle2Css(Style style, Tag tag) {
        tag.cls(style.getBorderClsCss());
        Map map = style.getBorderStyleCssMap();
        if (map.size() > 0) {
            tag.css(map);
        }
    }

    public static void style_background2css(Style style, Tag tag, CellGUIAttr cellGUIAttr, BackgroundDimension backgroundDimension, Repository repository) {
        HTMLWriterUtils.style_noBorder_background2css(style, tag, cellGUIAttr, backgroundDimension, repository);
        if (cellGUIAttr == null || cellGUIAttr.isPreviewBorder()) {
            HTMLWriterUtils.borderStyle2Css(style, tag);
        }
    }

    public static void style_noBorder_background2css(Style style, Tag tag, CellGUIAttr cellGUIAttr, BackgroundDimension backgroundDimension, Repository repository) {
        HTMLWriterUtils.contentStyle2Css(style, tag);
        if (cellGUIAttr == null || cellGUIAttr.isPreviewBackground()) {
            HTMLWriterUtils.writeBackground(tag, style.getBackground(), backgroundDimension, false, repository);
        }
    }

    public static Tag writeRegForm(HttpServletRequest httpServletRequest) {
        WorkSheet workSheet = new WorkSheet();
        workSheet.setHeader(0, null);
        workSheet.setFooter(0, null);
        workSheet.setColumnWidth(0, 100);
        Tag tag = new Tag("form").attr("id", "fr_reg_form");
        Style style = Style.DEFAULT_STYLE.deriveHorizontalAlignment(4);
        style = style.deriveFRFont(FRFont.getInstance("Dialog", 0, 13));
        DefaultCellElement defaultCellElement = new DefaultCellElement(0, 0, Inter.getLocText("Registration-Company_Name") + ":");
        workSheet.addCellElement(defaultCellElement);
        defaultCellElement.setStyle(style);
        DefaultCellElement defaultCellElement2 = new DefaultCellElement(1, 0, 4, 1, new Parameter("companyName"));
        workSheet.addCellElement(defaultCellElement2);
        DefaultCellElement defaultCellElement3 = new DefaultCellElement(0, 1, Inter.getLocText("Registration-Project_Name") + ":");
        workSheet.addCellElement(defaultCellElement3);
        defaultCellElement3.setStyle(style);
        DefaultCellElement defaultCellElement4 = new DefaultCellElement(1, 1, 4, 1, new Parameter("projectName"));
        workSheet.addCellElement(defaultCellElement4);
        DefaultCellElement defaultCellElement5 = new DefaultCellElement(0, 2, Inter.getLocText("Registration-Concurrency") + ":");
        workSheet.addCellElement(defaultCellElement5);
        defaultCellElement5.setStyle(style);
        Parameter parameter = new Parameter("concurrency");
        DefaultCellElement defaultCellElement6 = new DefaultCellElement(1, 2, 4, 1, parameter);
        workSheet.addCellElement(defaultCellElement6);
        DefaultCellElement defaultCellElement7 = new DefaultCellElement(1, 3, new FormSubmitButton(Inter.getLocText("Registration-Use_Authorization_File")));
        defaultCellElement7.setStyle(Style.DEFAULT_STYLE.deriveHorizontalAlignment(0));
        workSheet.addCellElement(defaultCellElement7);
        DefaultCellElement defaultCellElement8 = new DefaultCellElement(3, 3, new FormResetButton(Inter.getLocText("Reset")));
        workSheet.addCellElement(defaultCellElement8);
        Repository repository = new Repository(httpServletRequest, null);
        tag.sub(HTMLWriter.getInstance().writeJSReport(workSheet, 0, new FormCellWriter(repository, 0), repository));
        int n = ReportHelper.getColumnWidthList(workSheet).getRangeValueFromZero(workSheet.getColumnCount()) + 10;
        int n2 = ReportHelper.getRowHeightList(workSheet).getRangeValueFromZero(workSheet.getRowCount()) + 45;
        tag.attr("title", Inter.getLocText("Registration")).attr("width", "" + n).attr("height", "" + n2);
        return tag;
    }
}

