/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core;

import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.dav.LocalEnv;
import com.fr.report.RWorkBook;
import com.fr.report.ResultWorkBook;
import com.fr.report.TemplateWorkBook;
import com.fr.report.WorkBook;
import com.fr.report.io.TemplateImporter;
import com.fr.web.ReportletException;
import com.fr.web.core.WebUtils;
import java.io.InputStream;
import javax.servlet.ServletContext;

public class ServerEnv
extends LocalEnv {
    private ServletContext servletContext = null;

    public ServerEnv(ServletContext servletContext) {
        super(WebUtils.getWebINFPath(servletContext));
        this.servletContext = servletContext;
    }

    public InputStream readResource(String string) {
        return this.servletContext.getResourceAsStream(BaseCoreUtils.pathJoin(new String[]{"/", "WEB-INF", "resources", string}));
    }

    public boolean isTemplateExist(String string) throws Exception {
        if (string == null) {
            return false;
        }
        InputStream inputStream = this.servletContext.getResourceAsStream(BaseCoreUtils.pathJoin(new String[]{"/", "WEB-INF", "reportlets", string}));
        return inputStream != null;
    }

    public TemplateWorkBook readTemplate(String string) throws Exception, ReportletException {
        WorkBook workBook;
        if (string == null) {
            return null;
        }
        FRContext.getLogger().info(Inter.getLocText("INFO-Start_Reading_XML"));
        long l = System.currentTimeMillis();
        InputStream inputStream = this.servletContext.getResourceAsStream(BaseCoreUtils.pathJoin(new String[]{"/", "WEB-INF", "reportlets", string}));
        try {
            workBook = new TemplateImporter().generateTemplate(inputStream);
            Object var7_6 = null;
        }
        catch (ReportletException reportletException) {
            try {
                throw new ReportletException(reportletException.getMessage());
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                long l2 = System.currentTimeMillis();
                FRContext.getLogger().info(Inter.getLocText("INFO-End_Reading_XML") + "\t" + Inter.getLocText("INFO-Time_Taken") + (l2 - l) + Inter.getLocText("Milliseconds"));
                throw throwable;
            }
        }
        long l3 = System.currentTimeMillis();
        FRContext.getLogger().info(Inter.getLocText("INFO-End_Reading_XML") + "\t" + Inter.getLocText("INFO-Time_Taken") + (l3 - l) + Inter.getLocText("Milliseconds"));
        return workBook;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public ResultWorkBook readResult(String string) throws Exception, ReportletException {
        RWorkBook rWorkBook;
        if (string == null) {
            return null;
        }
        FRContext.getLogger().info(Inter.getLocText("INFO-Start_Reading_XML"));
        long l = System.currentTimeMillis();
        InputStream inputStream = this.servletContext.getResourceAsStream(BaseCoreUtils.pathJoin(new String[]{"/", "WEB-INF", "resultlets", string}));
        try {
            rWorkBook = new TemplateImporter().generateResult(inputStream);
            Object var7_6 = null;
        }
        catch (ReportletException reportletException) {
            try {
                throw new ReportletException(reportletException.getMessage());
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                long l2 = System.currentTimeMillis();
                FRContext.getLogger().info(Inter.getLocText("INFO-End_Reading_XML") + "\t" + Inter.getLocText("INFO-Time_Taken") + (l2 - l) + Inter.getLocText("Milliseconds"));
                throw throwable;
            }
        }
        long l3 = System.currentTimeMillis();
        FRContext.getLogger().info(Inter.getLocText("INFO-End_Reading_XML") + "\t" + Inter.getLocText("INFO-Time_Taken") + (l3 - l) + Inter.getLocText("Milliseconds"));
        return rWorkBook;
    }
}

