/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core;

import com.fr.base.FRContext;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.report.PageSetChain;
import com.fr.report.ReportWebAttr;
import com.fr.report.ResultWorkBook;
import com.fr.report.TemplateWorkBook;
import com.fr.report.core.ReportUtils;
import com.fr.report.web.ToolBarManager;
import com.fr.report.web.WebForm;
import com.fr.report.web.WebPage;
import com.fr.report.web.WebWrite;
import com.fr.report.web.event.Listener;
import com.fr.web.EmbeddedResultResultlet;
import com.fr.web.EmbeddedTplReportlet;
import com.fr.web.Reportlet;
import com.fr.web.Repository;
import com.fr.web.Resultlet;
import com.fr.web.core.SessionIDInfor;
import java.io.Serializable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public abstract class ShowWorkBookPolicy
implements Serializable,
Cloneable {
    public static final String PANEL_TYPE_PAGE = "page";
    public static final String PANEL_TYPE_VIEW = "view";
    public static final String PANEL_TYPE_FORM = "form";
    public static final String PANEL_TYPE_SHEET = "sheet";
    public static final String PANEL_TYPE_WRITE = "write";
    public static final String PANEL_TYPE_EDIT = "edit";
    public static final String PANEL_TYPE_PREVIEW = "preview";

    public abstract ResultWorkBook show(TemplateWorkBook var1, Map var2);

    public abstract String panelType();

    public PageSetChain getPageSet(ResultWorkBook resultWorkBook) {
        return resultWorkBook == null ? null : resultWorkBook.generateReportPageSet(ReportUtils.getPaperSettingListFromWorkBook(resultWorkBook));
    }

    public JSONObject panelConfig(Repository repository) throws JSONException {
        return new JSONObject();
    }

    public abstract ToolBarManager[] toolbarManagers(Repository var1);

    public static ShowWorkBookPolicy getInstance(HttpServletRequest httpServletRequest, Reportlet reportlet) {
        if (reportlet instanceof EmbeddedTplReportlet) {
            return ((EmbeddedTplReportlet)reportlet).getPolicy();
        }
        String string = httpServletRequest.getParameter("op");
        ShowWorkBookPolicy showWorkBookPolicy = ShowWorkBookPolicy.getCommonPolicy(string);
        if (showWorkBookPolicy == null) {
            showWorkBookPolicy = PANEL_TYPE_WRITE.equals(string) ? new Policy4Write() : (PANEL_TYPE_FORM.equals(string) || PANEL_TYPE_SHEET.equals(string) ? new Policy4Form() : new Policy4Page());
        }
        return showWorkBookPolicy;
    }

    public static ShowWorkBookPolicy getInstance(HttpServletRequest httpServletRequest, Resultlet resultlet) {
        if (resultlet instanceof EmbeddedResultResultlet) {
            return ((EmbeddedResultResultlet)resultlet).getPolicy();
        }
        String string = httpServletRequest.getParameter("op");
        ShowWorkBookPolicy showWorkBookPolicy = ShowWorkBookPolicy.getCommonPolicy(string);
        if (showWorkBookPolicy == null) {
            showWorkBookPolicy = new Policy4Page();
        }
        return showWorkBookPolicy;
    }

    private static ShowWorkBookPolicy getCommonPolicy(String string) {
        if (PANEL_TYPE_VIEW.equals(string) || PANEL_TYPE_EDIT.equals(string)) {
            return new Policy4View();
        }
        if ("simplesheet".equals(string)) {
            return new Policy4SimpleSheet();
        }
        return null;
    }

    public static final class Policy4Write
    extends ShowWorkBookPolicy {
        public ResultWorkBook show(TemplateWorkBook templateWorkBook, Map map) {
            return templateWorkBook.execute4Write(map);
        }

        public String panelType() {
            return ShowWorkBookPolicy.PANEL_TYPE_WRITE;
        }

        public JSONObject panelConfig(Repository repository) throws JSONException {
            ReportWebAttr reportWebAttr;
            JSONObject jSONObject = super.panelConfig(repository);
            SessionIDInfor sessionIDInfor = repository.getSessionIDInfor();
            String[] stringArray = ReportUtils.getWriteImportedCssFromWorkBook(sessionIDInfor.getContextBook());
            if (stringArray.length > 0) {
                jSONObject.put("writeCss", stringArray);
            }
            if ((reportWebAttr = sessionIDInfor.getContextBook().getReportWebAttr()) == null) {
                reportWebAttr = FRContext.getConfigManager().getReportWebAttr();
            }
            if (reportWebAttr != null && reportWebAttr.getWebWrite() != null) {
                WebWrite webWrite = reportWebAttr.getWebWrite();
                JSONArray jSONArray = null;
                for (int i = 0; i < webWrite.getListenerSize(); ++i) {
                    Listener listener = webWrite.getListener(i);
                    if (jSONArray == null) {
                        jSONArray = new JSONArray();
                    }
                    jSONArray.put(listener.createJSONConfig(repository));
                }
                if (jSONArray != null) {
                    jSONObject.put("listeners", jSONArray);
                }
                if (webWrite.getSelectedColor() != null) {
                    jSONObject.put("selectedColor", webWrite.getColor());
                }
            }
            return jSONObject;
        }

        public ToolBarManager[] toolbarManagers(Repository repository) {
            WebWrite webWrite;
            ReportWebAttr reportWebAttr;
            ToolBarManager[] toolBarManagerArray = ReportUtils.getToolBarFromWorkBook(repository.getSessionIDInfor().getContextBook(), 2);
            if (toolBarManagerArray == null && (reportWebAttr = FRContext.getConfigManager().getReportWebAttr()) != null && (webWrite = reportWebAttr.getWebWrite()) != null) {
                toolBarManagerArray = webWrite.getToolBarManagers();
            }
            if (toolBarManagerArray == null) {
                toolBarManagerArray = new ToolBarManager[]{ToolBarManager.createDefaultWriteToolBar()};
            }
            return toolBarManagerArray;
        }

        public String toString() {
            return "execute4write";
        }
    }

    public static final class Policy4SimpleSheet
    extends Policy4Form {
        public String panelType() {
            return "simplesheet";
        }

        public String toString() {
            return "execute4simplesheet";
        }
    }

    public static class Policy4Form
    extends ShowWorkBookPolicy {
        public ResultWorkBook show(TemplateWorkBook templateWorkBook, Map map) {
            return templateWorkBook.execute4Form(map);
        }

        public ToolBarManager[] toolbarManagers(Repository repository) {
            return new ToolBarManager[0];
        }

        public String panelType() {
            return ShowWorkBookPolicy.PANEL_TYPE_FORM;
        }

        public JSONObject panelConfig(Repository repository) {
            JSONObject jSONObject = null;
            try {
                jSONObject = super.panelConfig(repository);
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().warning(jSONException.getMessage());
            }
            SessionIDInfor sessionIDInfor = repository.getSessionIDInfor();
            ReportWebAttr reportWebAttr = sessionIDInfor.getContextBook().getReportWebAttr();
            if (reportWebAttr == null) {
                reportWebAttr = FRContext.getConfigManager().getReportWebAttr();
            }
            if (reportWebAttr != null && reportWebAttr.getWebForm() != null) {
                WebForm webForm = reportWebAttr.getWebForm();
                JSONArray jSONArray = null;
                for (int i = 0; i < webForm.getListenerSize(); ++i) {
                    Listener listener = webForm.getListener(i);
                    try {
                        if (jSONArray == null) {
                            jSONArray = new JSONArray();
                        }
                        jSONArray.put(listener.createJSONConfig(repository));
                        continue;
                    }
                    catch (JSONException jSONException) {
                        FRContext.getLogger().warning(jSONException.getMessage());
                    }
                }
                if (jSONArray != null) {
                    try {
                        jSONObject.put("listeners", jSONArray);
                    }
                    catch (JSONException jSONException) {
                        FRContext.getLogger().warning(jSONException.getMessage());
                    }
                }
            }
            return jSONObject;
        }

        public String toString() {
            return "execute4form";
        }
    }

    public static final class Policy4View
    extends Policy4Page {
        public String panelType() {
            return ShowWorkBookPolicy.PANEL_TYPE_VIEW;
        }

        protected ToolBarManager[] getDefineToolBars(Repository repository) {
            return ReportUtils.getToolBarFromWorkBook(repository.getSessionIDInfor().getContextBook(), 3);
        }

        public PageSetChain getPageSet(ResultWorkBook resultWorkBook) {
            return resultWorkBook == null ? null : resultWorkBook.generateReportPageSet(null);
        }

        public String toString() {
            return "execute4view";
        }
    }

    public static class Policy4Page
    extends ShowWorkBookPolicy {
        public ResultWorkBook show(TemplateWorkBook templateWorkBook, Map map) {
            return templateWorkBook.execute(map);
        }

        public ToolBarManager[] toolbarManagers(Repository repository) {
            WebPage webPage;
            ReportWebAttr reportWebAttr;
            ToolBarManager[] toolBarManagerArray = this.getDefineToolBars(repository);
            if (toolBarManagerArray == null && (reportWebAttr = FRContext.getConfigManager().getReportWebAttr()) != null && (webPage = reportWebAttr.getWebPage()) != null) {
                toolBarManagerArray = webPage.getToolBarManagers();
            }
            if (toolBarManagerArray == null) {
                toolBarManagerArray = new ToolBarManager[]{ToolBarManager.createDefaultToolBar()};
            }
            return toolBarManagerArray;
        }

        protected ToolBarManager[] getDefineToolBars(Repository repository) {
            return ReportUtils.getToolBarFromWorkBook(repository.getSessionIDInfor().getContextBook(), 0);
        }

        public String panelType() {
            return ShowWorkBookPolicy.PANEL_TYPE_PAGE;
        }

        public JSONObject panelConfig(Repository repository) {
            JSONObject jSONObject = null;
            try {
                jSONObject = super.panelConfig(repository);
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().warning(jSONException.getMessage());
            }
            SessionIDInfor sessionIDInfor = repository.getSessionIDInfor();
            ReportWebAttr reportWebAttr = sessionIDInfor.getContextBook().getReportWebAttr();
            if (reportWebAttr == null) {
                reportWebAttr = FRContext.getConfigManager().getReportWebAttr();
            }
            if (reportWebAttr != null && reportWebAttr.getWebPage() != null) {
                WebPage webPage = reportWebAttr.getWebPage();
                JSONArray jSONArray = null;
                for (int i = 0; i < webPage.getListenerSize(); ++i) {
                    Listener listener = webPage.getListener(i);
                    try {
                        if (jSONArray == null) {
                            jSONArray = new JSONArray();
                        }
                        jSONArray.put(listener.createJSONConfig(repository));
                        continue;
                    }
                    catch (JSONException jSONException) {
                        FRContext.getLogger().warning(jSONException.getMessage());
                    }
                }
                if (jSONArray != null) {
                    try {
                        jSONObject.put("listeners", jSONArray);
                    }
                    catch (JSONException jSONException) {
                        FRContext.getLogger().warning(jSONException.getMessage());
                    }
                }
            }
            return jSONObject;
        }

        public String toString() {
            return "execute";
        }
    }
}

