/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core;

import com.fr.base.CodeUtils;
import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.StringUtils;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.FRCoreContext;
import com.fr.base.core.RSADecode;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.json.JSONUtils;
import com.fr.base.core.util.TemplateUtils;
import com.fr.report.TemplateWorkBook;
import com.fr.report.core.ReportUtils;
import com.fr.report.parameter.Parameter;
import com.fr.report.script.core.FArray;
import com.fr.report.web.ToolBarManager;
import com.fr.util.Consts;
import com.fr.web.ParameterConsts;
import com.fr.web.Reportlet;
import com.fr.web.ReportletException;
import com.fr.web.ReportletRequest;
import com.fr.web.Repository;
import com.fr.web.ScheduleReportlet;
import com.fr.web.TemplateReportlet;
import com.fr.web.core.HTMLWriterUtils;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.core.ShowWorkBookPolicy;
import com.fr.web.core.service.RTypeService;
import com.fr.web.platform.PlatformConstants;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.util.URIUtil;

public class WebUtils {
    public static final String FILE = "text";
    public static final String IMAGE = "image";
    public static final String OTHER = "other";
    public static final String SUCCESS = "success";
    public static final String FAILURE = "failure";
    private static String rights;

    private WebUtils() {
    }

    public static String getHTTPRequestParameter(HttpServletRequest httpServletRequest, String string) {
        Object object;
        Object object2 = httpServletRequest.getParameter(string);
        if (object2 == null) {
            object2 = httpServletRequest.getAttribute(string);
        }
        if (object2 == null && (object = httpServletRequest.getSession(false)) != null) {
            object2 = object.getAttribute(string);
        }
        if (object2 == null && (object = httpServletRequest.getParameter("__parameters__")) instanceof String) {
            try {
                object = WebUtils.decodeText((String)object, httpServletRequest);
                Map map = JSONUtils.jsonString2Map((String)object);
                object2 = map.get(string);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        if (object2 == null && (object2 = httpServletRequest.getParameter(string = CodeUtils.cjkEncode(string))) == null && (object2 = httpServletRequest.getAttribute(string)) == null && (object = httpServletRequest.getSession(false)) != null) {
            object2 = object.getAttribute(string);
        }
        return object2 == null ? null : WebUtils.decodeText(String.valueOf(object2), httpServletRequest);
    }

    public static String getReportTitleFromRequest(HttpServletRequest httpServletRequest) {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "reportletTitle");
        if (string == null) {
            string = WebUtils.getHTTPRequestParameter(httpServletRequest, "reportlet");
        }
        if (string == null) {
            string = WebUtils.getHTTPRequestParameter(httpServletRequest, "reportlets");
        }
        if (string == null) {
            string = WebUtils.getHTTPRequestParameter(httpServletRequest, "resultlet");
        }
        return string;
    }

    public static String createServletURL(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(httpServletRequest.getContextPath());
        stringBuffer.append("/").append(FRContext.getConfigManager().getServletMapping());
        return stringBuffer.toString();
    }

    public static PrintWriter createPrintWriter(HttpServletResponse httpServletResponse) throws IOException {
        return WebUtils.createPrintWriter(httpServletResponse, FRContext.getConfigManager().getServerCharset());
    }

    public static PrintWriter createPrintWriter(HttpServletResponse httpServletResponse, String string) throws IOException {
        PrintWriter printWriter;
        try {
            try {
                httpServletResponse.setCharacterEncoding(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            String string2 = null;
            try {
                string2 = httpServletResponse.getContentType();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (StringUtils.isBlank(string2)) {
                httpServletResponse.setContentType("text/html;charset=" + string);
            } else if (string2.indexOf("charset=") == -1) {
                httpServletResponse.setContentType(string2 + ";charset=" + string);
            }
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)httpServletResponse.getOutputStream(), string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FRContext.getLogger().log(Level.INFO, unsupportedEncodingException.getMessage());
            printWriter = new PrintWriter((OutputStream)httpServletResponse.getOutputStream());
        }
        return printWriter;
    }

    public static Map createTemplateMap(HttpServletRequest httpServletRequest) {
        HashMap<String, CharSequence> hashMap = new HashMap<String, CharSequence>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(httpServletRequest.getScheme());
        stringBuffer.append("://");
        stringBuffer.append(httpServletRequest.getServerName());
        stringBuffer.append(":");
        stringBuffer.append(httpServletRequest.getServerPort());
        hashMap.put("servletURL", WebUtils.createServletURL(httpServletRequest));
        hashMap.put("serverURL", stringBuffer);
        hashMap.put("scheme", httpServletRequest.getScheme());
        hashMap.put("serverName", httpServletRequest.getServerName());
        hashMap.put("serverPort", Integer.toString(httpServletRequest.getServerPort()));
        hashMap.put("contextPath", httpServletRequest.getContextPath());
        hashMap.put("fr_right", WebUtils.getRights());
        hashMap.put("company_project", WebUtils.getStatus());
        return hashMap;
    }

    public static Map context4PageTpl(HttpServletRequest httpServletRequest, SessionIDInfor sessionIDInfor) {
        return WebUtils.context4PolicyPaneTpl(httpServletRequest, sessionIDInfor, null);
    }

    public static Map context4EditTpl(HttpServletRequest httpServletRequest, SessionIDInfor sessionIDInfor) {
        Map map = WebUtils.context4CommonPaneTpl(httpServletRequest, sessionIDInfor);
        Repository repository = new Repository(httpServletRequest, sessionIDInfor);
        try {
            int n = sessionIDInfor.getReportCount();
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; i < n; ++i) {
                jSONArray.put(new JSONObject().put("title", sessionIDInfor.getReportName(i)));
            }
            map.put("sheets", jSONArray);
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
        }
        try {
            map.put("param", RTypeService.config4ParameterPanel(repository, repository.isShowParameterPanel()));
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
        }
        map.put("browserbg", HTMLWriterUtils.jsonBackground(ReportUtils.getBrowserBackgroundFromWorkBook(sessionIDInfor.getContextBook()), repository));
        return map;
    }

    public static Map context4CommonPaneTpl(HttpServletRequest httpServletRequest, SessionIDInfor sessionIDInfor) {
        Map map = WebUtils.createTemplateMap(httpServletRequest);
        if (sessionIDInfor == null) {
            return map;
        }
        map.put("charset", FRContext.getConfigManager().getServerCharset());
        map.put("sessionID", sessionIDInfor.getSessionID());
        map.put("reportlet_title", sessionIDInfor.getReportletTitle());
        map.put("csslink", sessionIDInfor.getCssLinks(map));
        map.put("jslink", sessionIDInfor.getJsLinks(map));
        return map;
    }

    public static Map context4PolicyPaneTpl(HttpServletRequest httpServletRequest, SessionIDInfor sessionIDInfor, ShowWorkBookPolicy showWorkBookPolicy) {
        Map map = WebUtils.context4CommonPaneTpl(httpServletRequest, sessionIDInfor);
        showWorkBookPolicy = showWorkBookPolicy == null ? sessionIDInfor.getPolicy() : showWorkBookPolicy;
        try {
            Repository repository = new Repository(httpServletRequest, sessionIDInfor);
            if (repository.isNeedToolbar()) {
                map.put("script", TemplateUtils.renderTemplate("/com/fr/web/core/js/tpl_script.js", WebUtils.policyMap4Tpl(repository, showWorkBookPolicy)));
            } else {
                map.put("script", TemplateUtils.renderTemplate("/com/fr/web/core/js/tpl_script_without_toolbar.js", WebUtils.policyMap4Tpl(repository, showWorkBookPolicy)));
            }
        }
        catch (IOException iOException) {
            FRContext.getLogger().log(Level.WARNING, iOException.getMessage(), iOException);
        }
        return map;
    }

    public static Map policyMap4Tpl(Repository repository, ShowWorkBookPolicy showWorkBookPolicy) {
        Map map = repository.checkoutTplContext();
        SessionIDInfor sessionIDInfor = repository.getSessionIDInfor();
        boolean bl = sessionIDInfor.getParameterValue("__isdebug__") != null;
        map.put("sessionID", sessionIDInfor.getSessionID());
        if (showWorkBookPolicy == null) {
            return map;
        }
        map.put("panel_type", showWorkBookPolicy.panelType());
        JSONObject jSONObject = null;
        try {
            jSONObject = showWorkBookPolicy.panelConfig(repository);
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().warning(jSONException.getMessage());
        }
        String string = null;
        try {
            string = bl ? jSONObject.toString(4) : jSONObject.toString();
        }
        catch (JSONException jSONException) {
            string = jSONObject.toString();
        }
        map.put("panel_config", string);
        map.put("__pi__", String.valueOf(repository.isShowParameterPanel()));
        StringWriter stringWriter = new StringWriter();
        try {
            RTypeService.dealWithLoading(repository, new PrintWriter(stringWriter), showWorkBookPolicy.panelType(), repository.isShowParameterPanel());
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
        }
        map.put("loading", stringWriter.getBuffer().toString());
        if (repository.isNeedToolbar()) {
            ToolBarManager[] toolBarManagerArray = showWorkBookPolicy.toolbarManagers(repository);
            JSONArray jSONArray = new JSONArray();
            for (int i = 0; toolBarManagerArray != null && i < toolBarManagerArray.length; ++i) {
                jSONArray.put(toolBarManagerArray[i].toJSONConfig(repository));
            }
            String string2 = null;
            try {
                string2 = bl ? jSONArray.toString(4) : jSONArray.toString();
            }
            catch (JSONException jSONException) {
                string2 = jSONArray.toString();
            }
            map.put("toolbar_conf", string2);
        }
        return map;
    }

    private static String getRights() {
        if (rights == null) {
            byte[] byArray = FRCoreContext.getBytes();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                RSADecode.decode(byArray, (OutputStream)byteArrayOutputStream);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                JSONObject jSONObject = new JSONObject(new String(byteArrayOutputStream.toByteArray(), "UTF-8"));
                String string = jSONObject.getString("projectname");
                if (jSONObject.getLong("deadline") - Calendar.getInstance().getTimeInMillis() > 0L && jSONObject.has("version") && ComparatorUtils.equals(Consts.VERSION, jSONObject.getString("version")) && (jSONObject.getLong("deadline") - Calendar.getInstance().getTimeInMillis() < new Long("3153600000") || jSONObject.has("macaddress") && BaseCoreUtils.getMacAddresses().contains(jSONObject.getString("macaddress")) && jSONObject.has("version"))) {
                    rights = StringUtils.isEmpty(string) ? null : string;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (rights == null) {
                rights = "&nbsp;-&nbsp;<a href=\\'http://www.finereport.com\\' target=\\'_blank\\' style=\\'text-decoration:none\\'>FineReport Software</a>";
            }
        }
        return rights;
    }

    private static String getStatus() {
        String string = WebUtils.getRights();
        if (string.equals("&nbsp;-&nbsp;<a href=\\'http://www.finereport.com\\' target=\\'_blank\\' style=\\'text-decoration:none\\'>FineReport Software</a>")) {
            string = "FineReport";
        }
        return string;
    }

    public static String decodeText(String string, HttpServletRequest httpServletRequest) {
        if (string == null) {
            return string;
        }
        if (CodeUtils.isCJKEncoded(string)) {
            try {
                return CodeUtils.cjkDecode(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public static void overflow(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Collection collection) throws IOException {
        Map map = WebUtils.createTemplateMap(httpServletRequest);
        map.put("addresses", new FArray(collection));
        TemplateUtils.dealWithTemplate("/com/fr/web/core/overflow.html", httpServletResponse, map);
    }

    public static Map createSessionIDParameterMap(HttpServletRequest httpServletRequest) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string == null || "reportlet".equalsIgnoreCase(string) || "format".equalsIgnoreCase(string) || "op".equalsIgnoreCase(string)) continue;
            hashMap.put(string, WebUtils.getHTTPRequestParameter(httpServletRequest, string));
        }
        return hashMap;
    }

    public static Map dealWithExecuteParamMap(Map map) {
        HashMap hashMap = new HashMap();
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object v = map.get(string);
                if (!(v instanceof JSONObject)) continue;
                Map map2 = ((JSONObject)v).toMap();
                Iterator iterator2 = map2.keySet().iterator();
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    hashMap.put(string2, map2.get(string2));
                }
            }
            hashMap.putAll(map);
        }
        for (int i = 0; i < ParameterConsts.ALL.length; ++i) {
            if (!hashMap.containsKey(ParameterConsts.ALL[i])) continue;
            hashMap.remove(ParameterConsts.ALL[i]);
        }
        return hashMap;
    }

    public static Map dealWithReportParameters(TemplateWorkBook templateWorkBook, Map map) {
        HashMap<String, Object> hashMap;
        Parameter[] parameterArray;
        Parameter[] parameterArray2 = parameterArray = templateWorkBook == null ? null : templateWorkBook.getParameters();
        if (map == null) {
            if (parameterArray == null || parameterArray.length == 0) {
                return Collections.EMPTY_MAP;
            }
            hashMap = new HashMap(parameterArray.length);
        } else {
            if (parameterArray == null || parameterArray.length == 0) {
                hashMap = new HashMap<String, Object>(map.size());
            } else {
                hashMap = new HashMap(parameterArray.length);
                for (int i = 0; i < parameterArray.length; ++i) {
                    hashMap.put(parameterArray[i].getName(), parameterArray[i].getValue());
                }
            }
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                hashMap.put((String)k, map.get(k));
            }
        }
        return hashMap;
    }

    public static Reportlet initReportletFromPath(String string) throws Exception {
        Reportlet reportlet = "schedule".equals(string) || "schedulereport".equalsIgnoreCase(string) ? new ScheduleReportlet() : (string.indexOf("/") != -1 || string.indexOf("\\") != -1 || string.toLowerCase().endsWith(".cpt") || string.toLowerCase().endsWith(".fwb") ? new TemplateReportlet(string) : FRCoreContext.classForName(string).newInstance());
        if (reportlet instanceof Reportlet) {
            return reportlet;
        }
        return null;
    }

    public static TemplateWorkBook reportlet2ReportTemplate(String string, ReportletRequest reportletRequest) throws Exception {
        try {
            TemplateWorkBook templateWorkBook = WebUtils.initReportletFromPath(string).createReport(reportletRequest);
            if (templateWorkBook == null) {
                throw new ReportletException(Inter.getLocText("EX-Can_not_create_WorkBook_from_Reportlet"));
            }
            return templateWorkBook;
        }
        catch (ReportletException reportletException) {
            throw new ReportletException("The Report in path:" + string + " " + Inter.getLocText("Error_To_Create_Report_From"), reportletException);
        }
    }

    public static String getWebINFPath(ServletContext servletContext) {
        String string = servletContext.getRealPath("/");
        if (string == null) {
            return null;
        }
        if (!string.endsWith("/") && !string.endsWith("\\")) {
            string = string + File.separator;
        }
        return string + "WEB-INF" + File.separator;
    }

    public static Map parameters4SessionIDInfor(HttpServletRequest httpServletRequest) {
        Object object;
        Object object2;
        Object object3;
        Enumeration enumeration;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        if (httpServletRequest == null) {
            return hashMap;
        }
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            enumeration = httpSession.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                object3 = enumeration.nextElement();
                object2 = WebUtils.decodeText("" + object3, httpServletRequest);
                hashMap.put(object2, httpSession.getAttribute("" + object3));
            }
        }
        enumeration = httpServletRequest.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            object3 = enumeration.nextElement();
            object2 = WebUtils.decodeText("" + object3, httpServletRequest);
            try {
                hashMap.put(object2, WebUtils.getHTTPRequestParameter(httpServletRequest, "" + object3));
            }
            catch (Exception exception) {}
        }
        object3 = httpServletRequest.getParameterNames();
        while (object3.hasMoreElements()) {
            object2 = object3.nextElement();
            object = WebUtils.decodeText("" + object2, httpServletRequest);
            try {
                hashMap.put(object, WebUtils.getHTTPRequestParameter(httpServletRequest, "" + object2));
            }
            catch (Exception exception) {}
        }
        object2 = hashMap.get("__parameters__");
        if (object2 instanceof String) {
            try {
                object = JSONUtils.jsonString2Map((String)object2);
                hashMap.putAll((Map<Object, Object>)object);
                hashMap.remove("__parameters__");
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().log(Level.INFO, jSONException.getMessage(), jSONException);
            }
        }
        for (int i = 0; i < PlatformConstants.InnerParameter.PRIVILEGE_AUTHENCATION_ALL.length; ++i) {
            hashMap.remove(PlatformConstants.InnerParameter.PRIVILEGE_AUTHENCATION_ALL[i]);
        }
        if (httpSession != null) {
            String string;
            Object object4 = httpSession.getAttribute("fr_authority");
            if (object4 != null) {
                hashMap.put("fr_authority", object4);
            }
            if ((string = (String)httpSession.getAttribute("fr_username")) != null) {
                hashMap.put("fr_username", string);
            }
        }
        return hashMap;
    }

    public static String getOriginalURL(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            return "";
        }
        StringBuffer stringBuffer = httpServletRequest.getRequestURL();
        Map map = httpServletRequest.getParameterMap();
        Iterator iterator = map.entrySet().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (bl) {
                stringBuffer.append("?");
                bl = false;
            } else {
                stringBuffer.append("&");
            }
            stringBuffer.append(entry.getKey().toString());
            stringBuffer.append("=");
            stringBuffer.append(WebUtils.getHTTPRequestParameter(httpServletRequest, entry.getKey().toString()));
        }
        return CodeUtils.cjkEncode(stringBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String string, String string2, String string3, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        HttpClient httpClient = new HttpClient();
        GetMethod getMethod = new GetMethod(string);
        getMethod.getPath();
        try {
            if (StringUtils.isNotBlank(string2)) {
                getMethod.setQueryString(URIUtil.encodeQuery((String)string2));
            }
            httpClient.executeMethod((HttpMethod)getMethod);
            if (getMethod.getStatusCode() == 200) {
                String string4;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(getMethod.getResponseBodyAsStream(), string3));
                while ((string4 = bufferedReader.readLine()) != null) {
                    if (bl) {
                        stringBuffer.append(string4).append(System.getProperty("line.separator"));
                        continue;
                    }
                    stringBuffer.append(string4);
                }
                bufferedReader.close();
            }
        }
        catch (URIException uRIException) {
            FRContext.getLogger().log(Level.WARNING, uRIException.getMessage(), uRIException);
        }
        catch (IOException iOException) {
            FRContext.getLogger().log(Level.WARNING, iOException.getMessage(), iOException);
        }
        finally {
            getMethod.releaseConnection();
        }
        return stringBuffer.toString();
    }
}

