/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.chwriter;

import com.fr.base.ColumnRow;
import com.fr.base.Style;
import com.fr.base.background.ColorBackground;
import com.fr.base.core.html.Tag;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.data.core.db.BinaryObject;
import com.fr.report.CellElement;
import com.fr.report.ReportGetter;
import com.fr.report.cellElement.CellGUIAttr;
import com.fr.report.cellElement.Formula;
import com.fr.report.cellElement.core.CellElementAttribute;
import com.fr.report.js.NameJavaScriptGroup;
import com.fr.report.web.ui.Widget;
import com.fr.util.Utils;
import com.fr.web.Repository;
import com.fr.web.core.HTMLWriterUtils;
import java.awt.Rectangle;
import java.sql.Blob;
import java.sql.Clob;

public abstract class CellHtmlWriter {
    protected Repository repo;
    protected Tag resTag;
    protected int cellWidth;
    protected int cellHeight;
    protected CellGUIAttr cellGUIAttr;
    protected boolean heavy = false;
    protected int reportIndex;
    protected int tableID = 0;

    public CellHtmlWriter(Repository repository, int n) {
        this.repo = repository;
        this.reportIndex = n;
    }

    public Tag cell2Tag(CellElement cellElement, ReportGetter reportGetter, Rectangle rectangle, Rectangle rectangle2) throws JSONException {
        String string;
        int n;
        this.resTag = new Tag("td");
        if (rectangle.width > 1) {
            this.resTag.attr("colSpan", rectangle.width + "");
        }
        if (rectangle.height > 1) {
            this.resTag.attr("rowSpan", rectangle.height + "");
        }
        if (reportGetter.getColumnWidth(cellElement.getColumn()) == 0) {
            this.resTag.css("display", "none");
        }
        this.cellHeight = 0;
        int n2 = rectangle2.y;
        for (n = 0; n < rectangle2.height; ++n) {
            this.cellHeight += reportGetter.getRowHeight(n2);
            ++n2;
        }
        this.cellWidth = 0;
        n2 = rectangle2.x;
        for (n = 0; n < rectangle2.width; ++n) {
            this.cellWidth += reportGetter.getColumnWidth(n2);
            ++n2;
        }
        this.cellGUIAttr = cellElement.getCellGUIAttr();
        if (this.cellGUIAttr == null) {
            this.cellGUIAttr = CellGUIAttr.DEFAULT_CELLGUIATTR;
        }
        if ((string = this.cellGUIAttr.getTooltipText()) != null) {
            this.resTag.attr("title", string);
        }
        return this.dealWithHyperlinkGroup(cellElement, this.resTag);
    }

    protected Tag dealWithHyperlinkGroup(CellElement cellElement, Tag tag) throws JSONException {
        NameJavaScriptGroup nameJavaScriptGroup = cellElement.getNameHyperlinkGroup();
        if (nameJavaScriptGroup != null && nameJavaScriptGroup.size() > 0) {
            Style style = cellElement.getStyle();
            Tag tag2 = tag;
            if (style.getBackground() == null || style.getBackground() instanceof ColorBackground) {
                tag2 = new Tag("span");
                tag.sub(tag2);
            }
            tag2.css("cursor", "pointer");
            tag2.attr("onclick", "FR.doHyperlink(event||window.event, " + HTMLWriterUtils.writeJSLinkContent(nameJavaScriptGroup, this.repo) + ", true)");
            tag.cls("celink");
            tag2.cls("linkspan");
            return tag2;
        }
        return tag;
    }

    public void dealWithEmptyHeight(Tag tag) {
        tag.css("display", "none");
    }

    protected String widget2Config(Widget widget, Object object, ColumnRow columnRow, CellElement cellElement, int n, String string) throws JSONException {
        JSONObject jSONObject = widget.createJSONConfig(object, this.repo);
        jSONObject.put("widgetUrl", this.repo.checkoutWidgetUrl(new JSONObject().put("reportIndex", n).put("column", columnRow.getColumn()).put("row", columnRow.getRow()), string));
        jSONObject.put("sessionID", this.repo.getSessionIDInfor().getSessionID());
        jSONObject.put("location", ColumnRow.valueOf(columnRow.getColumn(), columnRow.getRow()));
        jSONObject.put("reportIndex", n);
        if (cellElement.getAttribute(CellElementAttribute.WIDGET_DEPENDENCE) != null) {
            jSONObject.put("dependenceMap", cellElement.getAttribute(CellElementAttribute.WIDGET_DEPENDENCE));
        }
        return jSONObject.toString();
    }

    protected Object dealWithValue4Formula(Object object) {
        return ((Formula)object).getResult();
    }

    protected Object dealWithValue4Blob(Object object) {
        return Utils.blob2Object((Blob)object, this.cellGUIAttr.isShowAsImage());
    }

    protected Object dealBinaryObject(Object object) {
        if (this.cellGUIAttr.isShowAsImage()) {
            return ((BinaryObject)object).getImage();
        }
        return ((BinaryObject)object).getValue();
    }

    protected String dealClobValue(Object object) {
        return Utils.clob2String((Clob)object);
    }

    public void setHeavy(boolean bl) {
        this.heavy = bl;
    }

    public boolean isHeavy() {
        return this.heavy;
    }

    public void setTableID(int n) {
        this.tableID = n;
    }

    public int getTableID() {
        return this.tableID;
    }
}

