/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.chwriter;

import com.fr.base.CodeUtils;
import com.fr.base.ColumnRow;
import com.fr.base.FRContext;
import com.fr.base.Painter;
import com.fr.base.Style;
import com.fr.base.core.DateUtils;
import com.fr.base.core.html.Tag;
import com.fr.base.core.html.TextHtml;
import com.fr.base.core.json.JSONException;
import com.fr.chart.ChartPainter;
import com.fr.data.core.db.BinaryObject;
import com.fr.report.CellElement;
import com.fr.report.ReportGetter;
import com.fr.report.cellElement.Formula;
import com.fr.report.cellElement.TextFormat;
import com.fr.report.cellElement.core.CellElementAttribute;
import com.fr.report.cellElement.core.CellUtils;
import com.fr.report.core.PaintUtils;
import com.fr.web.Repository;
import com.fr.web.core.CellBackgroundDimension;
import com.fr.web.core.HTMLWriterUtils;
import com.fr.web.core.chwriter.CellHtmlWriter;
import java.awt.Image;
import java.awt.Rectangle;
import java.sql.Blob;
import java.sql.Clob;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;

public class EditCellWriter
extends CellHtmlWriter {
    public EditCellWriter(Repository repository, int n) {
        super(repository, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tag cell2Tag(CellElement cellElement, ReportGetter reportGetter, Rectangle rectangle, Rectangle rectangle2) {
        Tag tag = null;
        try {
            tag = super.cell2Tag(cellElement, reportGetter, rectangle, rectangle2);
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
        }
        Object object = cellElement.getAttribute(CellElementAttribute.HTML_ID);
        if (object != null) {
            if (!(object instanceof ColumnRow[])) return this.resTag;
            ColumnRow[] columnRowArray = (ColumnRow[])object;
            this.resTag.attr("id", columnRowArray[0] + "-" + this.reportIndex + "-" + this.tableID).attr("row", "" + columnRowArray[0].getRow()).attr("col", "" + columnRowArray[0].getColumn());
        } else {
            this.resTag.attr("id", ColumnRow.valueOf(cellElement.getColumn(), cellElement.getRow()) + "-" + this.reportIndex + "-" + this.tableID).attr("row", "" + cellElement.getRow()).attr("col", "" + cellElement.getColumn());
        }
        Style style = cellElement.getStyle();
        Format format = style.getFormat();
        Object object2 = cellElement.getValue();
        if (object2 instanceof Formula) {
            this.resTag.attr("fm", ((Formula)object2).getContent().substring(1));
            object2 = this.dealWithValue4Formula(object2);
        }
        if (object2 != null) {
            if (object2 instanceof Date && format == null) {
                format = DateUtils.DATEFORMAT1;
            } else if (format == null && object2 instanceof String && object2.toString().length() > 0) {
                format = TextFormat.getInstance();
            }
            if (object2 instanceof Blob) {
                object2 = this.dealWithValue4Blob(object2);
            }
            if (object2 instanceof BinaryObject) {
                object2 = this.dealBinaryObject(object2);
            }
            if (object2 instanceof Clob) {
                object2 = this.dealClobValue(object2);
            }
            try {
                this.resTag.attr("cv", CodeUtils.jsonEncode(CodeUtils.object2JSONable(object2)));
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
            }
            if (this.cellGUIAttr.isPreviewContent()) {
                if (object2 instanceof ChartPainter) {
                    HTMLWriterUtils.value2PaintableTag(object2, cellElement.getStyle(), this.cellWidth, this.cellHeight, tag, this.repo, false);
                    style = style.derivePadding(0, 0);
                } else if (style.getVerticalText() == 1 || object2 instanceof Image || object2 instanceof Painter) {
                    this.repo.writeTagBackground(tag, CellUtils.value2Image(object2, style, this.cellWidth, this.cellHeight));
                    style = style.derivePadding(0, 0);
                } else if (this.cellHeight > 0 && this.cellWidth > 0) {
                    String string = PaintUtils.valueToText(object2, format);
                    if (!this.cellGUIAttr.isShowAsHTML()) {
                        string = CodeUtils.htmlEncode(string);
                    }
                    tag.sub(new TextHtml(string));
                }
            }
        }
        if (format instanceof SimpleDateFormat) {
            this.resTag.attr("fmt", "D" + ((SimpleDateFormat)format).toPattern().trim());
        } else if (format instanceof DecimalFormat) {
            this.resTag.attr("fmt", ((DecimalFormat)format).toPattern().trim());
        } else if (format == TextFormat.getInstance()) {
            this.resTag.attr("fmt", "T");
        }
        if (!this.cellGUIAttr.isPreviewContent()) {
            this.resTag.cls("cehide");
            return this.resTag;
        }
        if (reportGetter.getRowHeight(cellElement.getRow()) == 0 || reportGetter.getColumnWidth(cellElement.getColumn()) == 0) return this.resTag;
        HTMLWriterUtils.style_background2css(style, this.resTag, this.cellGUIAttr, new CellBackgroundDimension(cellElement, reportGetter), this.repo);
        return this.resTag;
    }
}

