/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.chwriter;

import com.fr.base.CodeUtils;
import com.fr.base.ColumnRow;
import com.fr.base.FRContext;
import com.fr.base.Painter;
import com.fr.base.StringUtils;
import com.fr.base.Style;
import com.fr.base.core.html.Tag;
import com.fr.base.core.html.TextHtml;
import com.fr.base.core.json.JSONException;
import com.fr.data.core.db.BinaryObject;
import com.fr.report.CellElement;
import com.fr.report.ReportGetter;
import com.fr.report.cellElement.Formula;
import com.fr.report.core.PaintUtils;
import com.fr.report.script.Calculator;
import com.fr.report.script.ParameterMapNameSpace;
import com.fr.report.script.core.parser.UtilEvalError;
import com.fr.report.web.ui.Widget;
import com.fr.report.web.ui.impl.form.TreeNodeToogleButton;
import com.fr.web.Repository;
import com.fr.web.core.CellBackgroundDimension;
import com.fr.web.core.HTMLWriterUtils;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.core.chwriter.TreeCellWriter;
import java.awt.Image;
import java.awt.Rectangle;
import java.sql.Blob;
import java.sql.Clob;
import java.util.logging.Level;

public class FormCellWriter
extends TreeCellWriter {
    private String fType = null;

    public FormCellWriter(Repository repository, int n) {
        super(repository, n);
        this.reportIndex = n;
    }

    public FormCellWriter(Repository repository, int n, String string) {
        super(repository, n);
        this.fType = string;
    }

    public String getFType() {
        return this.fType;
    }

    public void setFType(String string) {
        this.fType = string;
    }

    public Tag cell2Tag(CellElement cellElement, ReportGetter reportGetter, Rectangle rectangle, Rectangle rectangle2) {
        Cloneable cloneable;
        Tag tag = null;
        try {
            tag = super.cell2Tag(cellElement, reportGetter, rectangle, rectangle2);
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
        }
        this.resTag.attr("id", ColumnRow.valueOf(cellElement.getColumn(), cellElement.getRow()) + "-" + this.reportIndex + "-" + this.tableID);
        if (this.cellHeight == 0) {
            return this.resTag;
        }
        Style style = cellElement.getStyle();
        if (!this.cellGUIAttr.isPreviewContent()) {
            HTMLWriterUtils.style_background2css(style, this.resTag, this.cellGUIAttr, new CellBackgroundDimension(cellElement, reportGetter), this.repo);
            return this.resTag;
        }
        boolean bl = false;
        Object object = cellElement.getValue();
        if (object instanceof Formula) {
            cloneable = Calculator.createCalculator();
            ((Calculator)cloneable).pushNameSpace(ParameterMapNameSpace.create(this.repo.getSessionIDInfor().getParameterMap4Execute()));
            try {
                object = ((Calculator)cloneable).eval(((Formula)object).getContent().substring(1));
            }
            catch (UtilEvalError utilEvalError) {
                FRContext.getLogger().log(Level.WARNING, utilEvalError.getMessage(), utilEvalError);
            }
        }
        if (object instanceof Blob) {
            object = this.dealWithValue4Blob(object);
        }
        if (object instanceof BinaryObject) {
            object = this.dealBinaryObject(object);
        }
        if (object instanceof Clob) {
            object = this.dealClobValue(object);
        }
        if ((cloneable = cellElement.getWidget()) != null) {
            SessionIDInfor sessionIDInfor;
            String string = ((Widget)cloneable).getWidgetName();
            if (StringUtils.isNotBlank(string) && (sessionIDInfor = this.repo.getSessionIDInfor()).getParameterValue(string) != null) {
                object = sessionIDInfor.getParameterValue(string);
            }
            if (cloneable instanceof TreeNodeToogleButton) {
                this.dealWithTreeNodeSonList((TreeNodeToogleButton)cloneable);
            }
            try {
                this.resTag.attr("width", this.cellWidth + "");
                this.resTag.attr("height", this.cellHeight + "");
                this.resTag.attr("widget", this.widget2Config((Widget)cloneable, object, ColumnRow.valueOf(cellElement.getColumn(), cellElement.getRow()), cellElement, this.reportIndex, this.fType));
                bl = true;
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
            }
        }
        if (!bl) {
            if (style.getVerticalText() == 1 || object instanceof Painter || object instanceof Image) {
                HTMLWriterUtils.value2PaintableTag(object, cellElement.getStyle(), this.cellWidth, this.cellHeight, tag, this.repo, false);
                bl = true;
            } else if (object != null) {
                tag.sub(new TextHtml(CodeUtils.htmlEncode(PaintUtils.valueToText(object, cellElement.getStyle().getFormat()))));
            }
        }
        if (bl) {
            style = style.derivePadding(0, 0).deriveHorizontalAlignment(2);
        }
        HTMLWriterUtils.style_background2css(style, this.resTag, this.cellGUIAttr, new CellBackgroundDimension(cellElement, reportGetter), this.repo);
        return this.resTag;
    }
}

