/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.chwriter;

import com.fr.base.CodeUtils;
import com.fr.base.ColumnRow;
import com.fr.base.FRContext;
import com.fr.base.Painter;
import com.fr.base.Style;
import com.fr.base.core.html.Html;
import com.fr.base.core.html.Tag;
import com.fr.base.core.html.TextHtml;
import com.fr.base.core.json.JSONException;
import com.fr.data.core.db.BinaryObject;
import com.fr.report.CellElement;
import com.fr.report.ReportGetter;
import com.fr.report.cellElement.Formula;
import com.fr.report.core.PaintUtils;
import com.fr.report.io.core.IOHelper;
import com.fr.util.Utils;
import com.fr.web.Repository;
import com.fr.web.core.HTMLWriterUtils;
import com.fr.web.core.ReportBackgroundDimension;
import com.fr.web.core.chwriter.TreeCellWriter;
import java.awt.Image;
import java.awt.Rectangle;
import java.sql.Blob;
import java.sql.Clob;
import java.util.logging.Level;

public class PageCellWriter
extends TreeCellWriter {
    protected boolean isPrint = false;

    public PageCellWriter(Repository repository, int n, boolean bl) {
        super(repository, n);
        this.isPrint = bl;
    }

    public Tag cell2Tag(CellElement cellElement, ReportGetter reportGetter, Rectangle rectangle, Rectangle rectangle2) {
        Object object;
        Tag tag = null;
        try {
            tag = super.cell2Tag(cellElement, reportGetter, rectangle, rectangle2);
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
        }
        this.resTag.attr("id", ColumnRow.valueOf(cellElement.getColumn(), cellElement.getRow()) + "-" + this.reportIndex + "-" + this.tableID);
        Style style = cellElement.getStyle();
        if (this.isPrint && !this.cellGUIAttr.isPrintContent() || this.cellHeight == 0) {
            return this.resTag;
        }
        if (!this.isPrint && !this.cellGUIAttr.isPreviewContent()) {
            HTMLWriterUtils.style_background2css(style, this.resTag, this.cellGUIAttr, new ReportBackgroundDimension(this.cellWidth, this.cellHeight), this.repo);
            return this.resTag;
        }
        int n = this.cellHeight - (IOHelper.getBorderWidth(cellElement.getStyle().getBorderTop()) + IOHelper.getBorderWidth(cellElement.getStyle().getBorderBottom()) + 1) / 2;
        Tag tag2 = tag;
        if (this.isHeavy()) {
            object = new Tag("div").cls("fx").css("height", (n > 0 ? n : 0) + "px");
            tag.sub((Html)object);
            tag2 = new Tag("td").css("height", n + "px").css("width", this.cellWidth + "px");
            ((Tag)object).sub(new Tag("table").sub(new Tag("tbody").sub(new Tag("tr").sub(tag2))));
        }
        if ((object = cellElement.getValue()) instanceof Formula) {
            object = this.dealWithValue4Formula(object);
        }
        if (this.isPrint && !this.cellGUIAttr.isPrintZeroValue() && object != null && object.toString().matches("[\\-]?0[\\.]?[0]*")) {
            object = null;
        }
        if (object instanceof Blob) {
            object = this.dealWithValue4Blob(object);
        }
        if (object instanceof BinaryObject) {
            object = this.dealBinaryObject(object);
        }
        if (object instanceof Clob) {
            object = this.dealClobValue(object);
        }
        if (this.isPrint || !this.dealWithTreeNodeButton(cellElement, object)) {
            if (style.getVerticalText() == 1 || object instanceof Painter || object instanceof Image || this.cellGUIAttr.isShowAsImage()) {
                HTMLWriterUtils.value2PaintableTag(object, cellElement.getStyle(), this.cellWidth, n, tag2, this.repo, this.isPrint);
                style = style.derivePadding(0, 0);
            } else if (object != null) {
                if (this.cellGUIAttr.isShowAsHTML()) {
                    tag2.sub(new TextHtml(Utils.objectToString(object)));
                } else {
                    String string = PaintUtils.valueToText(object, cellElement.getStyle().getFormat());
                    style = PaintUtils.modCellStyleString(this.cellWidth, n, string, style);
                    tag2.sub(new TextHtml(CodeUtils.htmlEncode(string)));
                }
            }
        }
        if (this.cellGUIAttr == null || this.cellGUIAttr.isPreviewBorder()) {
            HTMLWriterUtils.borderStyle2Css(style, this.resTag);
        }
        HTMLWriterUtils.style_noBorder_background2css(style, this.isHeavy() ? tag2 : this.resTag, this.cellGUIAttr, new ReportBackgroundDimension(this.cellWidth, this.cellHeight), this.repo);
        return this.resTag;
    }

    protected boolean dealWithTreeNodeButton(CellElement cellElement, Object object) {
        return false;
    }

    protected Tag dealWithHyperlinkGroup(CellElement cellElement, Tag tag) throws JSONException {
        if (!this.isPrint) {
            return super.dealWithHyperlinkGroup(cellElement, tag);
        }
        return tag;
    }
}

