/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.chwriter;

import com.fr.base.ArrayUtils;
import com.fr.base.CodeUtils;
import com.fr.base.ColumnRow;
import com.fr.base.FRContext;
import com.fr.base.Painter;
import com.fr.base.Style;
import com.fr.base.core.DateUtils;
import com.fr.base.core.html.Tag;
import com.fr.base.core.html.TextHtml;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONException;
import com.fr.chart.ChartPainter;
import com.fr.data.core.db.BinaryObject;
import com.fr.data.impl.NameWidget;
import com.fr.privilege.authentication.Authentication;
import com.fr.report.CellElement;
import com.fr.report.ReportGetter;
import com.fr.report.cellElement.Formula;
import com.fr.report.cellElement.TextFormat;
import com.fr.report.cellElement.core.CellElementAttribute;
import com.fr.report.cellElement.core.CellUtils;
import com.fr.report.core.PaintUtils;
import com.fr.report.web.ui.DateEditor;
import com.fr.report.web.ui.Widget;
import com.fr.web.Repository;
import com.fr.web.core.CellBackgroundDimension;
import com.fr.web.core.HTMLWriterUtils;
import com.fr.web.core.chwriter.CellHtmlWriter;
import java.awt.Image;
import java.awt.Rectangle;
import java.sql.Blob;
import java.sql.Clob;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;

public class WriteCellWriter
extends CellHtmlWriter {
    public WriteCellWriter(int n, Repository repository) {
        super(repository, n);
    }

    public static ColumnRow[] retriveCellElementPositions(CellElement cellElement) {
        if (cellElement.getColumnSpan() <= 1 && cellElement.getRowSpan() <= 1) {
            return new ColumnRow[]{ColumnRow.valueOf(cellElement.getColumn(), cellElement.getRow())};
        }
        int n = cellElement.getRow();
        int n2 = cellElement.getColumn();
        int n3 = cellElement.getRowSpan();
        int n4 = cellElement.getColumnSpan();
        ArrayList<ColumnRow> arrayList = new ArrayList<ColumnRow>();
        for (int i = n; i < n + n3; ++i) {
            for (int j = n2; j < n2 + n4; ++j) {
                arrayList.add(ColumnRow.valueOf(j, i));
            }
        }
        return arrayList.toArray(new ColumnRow[arrayList.size()]);
    }

    public static String generateTdPositionAttr(ColumnRow[] columnRowArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < columnRowArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append('-');
            }
            stringBuffer.append(columnRowArray[i] + "-" + n);
        }
        return stringBuffer.toString();
    }

    public Tag cell2Tag(CellElement cellElement, ReportGetter reportGetter, Rectangle rectangle, Rectangle rectangle2) {
        Object object;
        Object object2;
        Object object3;
        Format format;
        Object object4;
        Tag tag = null;
        try {
            tag = super.cell2Tag(cellElement, reportGetter, rectangle, rectangle2);
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
        }
        ColumnRow[] columnRowArray = WriteCellWriter.retriveCellElementPositions(cellElement);
        Object object5 = cellElement.getAttribute(CellElementAttribute.HTML_ID);
        if (object5 != null) {
            if (object5 instanceof ColumnRow[]) {
                columnRowArray = (ColumnRow[])object5;
            } else {
                return this.resTag;
            }
        }
        this.resTag.attr("id", columnRowArray[0] + "-" + this.reportIndex + "-" + this.tableID);
        this.resTag.attr("position", WriteCellWriter.generateTdPositionAttr(columnRowArray, this.reportIndex));
        if (Boolean.TRUE.equals(cellElement.getAttribute(CellElementAttribute.DEL))) {
            this.resTag.cls("del");
            return this.resTag;
        }
        Authentication authentication = this.repo.getCurrentAuthentication();
        Widget widget = cellElement.getWidget();
        if (widget != null) {
            this.resTag.attr("width", this.cellWidth + "");
            this.resTag.attr("height", this.cellHeight + "");
            try {
                object4 = this.widget2Config(widget, cellElement.getValue(), columnRowArray[0], cellElement, this.reportIndex, null);
                if (widget instanceof NameWidget) {
                    widget = FRContext.getWidgetManager().getWidgetConfig(((NameWidget)widget).getName()).toWidget();
                }
                if (widget.isEditor()) {
                    this.resTag.attr("editor", (String)object4);
                } else {
                    this.resTag.attr("widget", (String)object4);
                }
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
            }
        }
        if ((format = ((Style)(object4 = cellElement.getStyle())).getFormat()) == null && widget instanceof DateEditor) {
            object3 = ((DateEditor)widget).getFormatText();
            format = new SimpleDateFormat((String)object3);
        }
        if ((object3 = cellElement.getPresent()) != null) {
            this.resTag.cls("presentable");
            object2 = object3.dependence();
            if (!ArrayUtils.isEmpty(object2)) {
                try {
                    object = new JSONArray(object2);
                    this.resTag.attr("presentDep", ((JSONArray)object).toString());
                }
                catch (JSONException jSONException) {
                    FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
                }
            }
        }
        if ((object2 = cellElement.getValue()) instanceof Formula) {
            this.resTag.attr("fm", ((Formula)object2).getContent().substring(1));
            object2 = this.dealWithValue4Formula(object2);
        }
        if (object2 != null) {
            if (object2 instanceof Date && format == null) {
                format = DateUtils.DATEFORMAT1;
            } else if (format == null && object2 instanceof String && object2.toString().length() > 0) {
                format = TextFormat.getInstance();
            }
            if (object2 instanceof Blob) {
                object2 = this.dealWithValue4Blob(object2);
            }
            if (object2 instanceof BinaryObject) {
                object2 = this.dealBinaryObject(object2);
            }
            if (object2 instanceof Clob) {
                object2 = this.dealClobValue(object2);
            }
            try {
                this.resTag.attr("cv", CodeUtils.jsonEncode(CodeUtils.object2JSONable(object2)));
            }
            catch (JSONException jSONException) {
                FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
            }
            if (this.cellGUIAttr.isPreviewContent()) {
                if (object3 != null) {
                    object2 = cellElement.getAttribute(CellElementAttribute.PRESENT_VALUE);
                }
                if (object2 instanceof ChartPainter) {
                    HTMLWriterUtils.value2PaintableTag(object2, cellElement.getStyle(), this.cellWidth, this.cellHeight, tag, this.repo, false);
                    object4 = ((Style)object4).derivePadding(0, 0);
                } else if (((Style)object4).getVerticalText() == 1 || object2 instanceof Image || object2 instanceof Painter) {
                    this.repo.writeTagBackground(tag, CellUtils.value2Image(object2, (Style)object4, this.cellWidth, this.cellHeight));
                    object4 = ((Style)object4).derivePadding(0, 0);
                } else if (this.cellHeight > 0 && this.cellWidth > 0) {
                    object = PaintUtils.valueToText(object2, format);
                    if (!this.cellGUIAttr.isShowAsHTML()) {
                        object = CodeUtils.htmlEncode((CharSequence)object);
                    }
                    if (widget == null || widget.isEditor()) {
                        tag.sub(new TextHtml((String)object));
                    }
                }
            }
        }
        if (format instanceof SimpleDateFormat) {
            this.resTag.attr("fmt", "D" + ((SimpleDateFormat)format).toPattern().trim());
        } else if (format instanceof DecimalFormat) {
            this.resTag.attr("fmt", ((DecimalFormat)format).toPattern().trim());
        } else if (format == TextFormat.getInstance()) {
            this.resTag.attr("fmt", "T");
        }
        if (!this.cellGUIAttr.isPreviewContent()) {
            this.resTag.cls("cehide");
            return this.resTag;
        }
        if (reportGetter.getRowHeight(cellElement.getRow()) != 0 && reportGetter.getColumnWidth(cellElement.getColumn()) != 0) {
            HTMLWriterUtils.style_background2css((Style)object4, this.resTag, this.cellGUIAttr, new CellBackgroundDimension(cellElement, reportGetter), this.repo);
        }
        return this.resTag;
    }
}

