/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.gzip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class GZIPResponseStream
extends ServletOutputStream {
    protected ByteArrayOutputStream baos = null;
    protected GZIPOutputStream gzipstream = null;
    protected boolean closed = false;
    protected HttpServletResponse response = null;
    protected ServletOutputStream output = null;

    public GZIPResponseStream(HttpServletResponse httpServletResponse) throws IOException {
        this.response = httpServletResponse;
        this.output = httpServletResponse.getOutputStream();
        this.baos = new ByteArrayOutputStream();
        this.gzipstream = new GZIPOutputStream(this.baos);
    }

    public void close() throws IOException {
        this.gzipstream.finish();
        byte[] byArray = this.baos.toByteArray();
        this.response.addHeader("Content-Length", Integer.toString(byArray.length));
        this.response.addHeader("Content-Encoding", "gzip");
        this.output.write(byArray);
        this.output.flush();
        this.output.close();
        this.closed = true;
    }

    public void flush() throws IOException {
        this.gzipstream.flush();
    }

    public void write(int n) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        this.gzipstream.write((byte)n);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("Cannot write to a closed output stream");
        }
        this.gzipstream.write(byArray, n, n2);
    }

    public boolean closed() {
        return this.closed;
    }

    public void reset() {
    }
}

