/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.service;

import com.fr.base.CodeUtils;
import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.util.TemplateUtils;
import com.fr.base.core.util.vt.VT4FR;
import com.fr.base.file.DatasourceManager;
import com.fr.data.core.db.TableProcedure;
import com.fr.data.impl.ADHOCNamedTableData;
import com.fr.data.impl.ADHOCSQLTableData;
import com.fr.data.impl.ADHOCTableData;
import com.fr.data.impl.DatabaseConnection;
import com.fr.web.core.WebUtils;
import com.fr.web.core.service.NoSessionIDService;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ADHOCReportService
extends NoSessionIDService {
    public static String KEY = "adhoc";
    public static String ADHOCDATA = "adhoc_dataset";
    public static String ADHOCDESIGN = "adhoc_design";
    public static String GETCONNECTIONSNAME = "adhoc_getconnectionsname";
    public static String GETDBDATASNAME = "adhoc_getdbdatasname";
    public static String GETDBDATATABLES = "adhoc_getdbdatatables";
    public static String GETTABLEFIELDS = "adhoc_gettablefields";
    public static String ADDVIEW = "adhoc_addview";
    public static String GETVIEW = "adhoc_getview";
    public static String GETVIEWSNAME = "adhoc_getviewsname";
    public static String EDITVIEW = "adhoc_editview";
    public static String GETVIEWPARTDATA = "adhoc_getviewpartdata";
    public static String GETVIEWDESCRIPTION = "adhoc_getviewdescription";
    public static String GETVIEWFIELDS = "adhoc_getviewfields";
    public static String GENERATEREPORT = "adhoc_generatereport";
    private static ADHOCReportService ADHOCSERVICE = new ADHOCReportService();

    private ADHOCReportService() {
    }

    public static ADHOCReportService getInstance() {
        return ADHOCSERVICE;
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        if (ADHOCDATA.equals(string)) {
            ADHOCReportService.generateADHOCData(httpServletRequest, httpServletResponse);
        } else if (ADHOCDESIGN.equals(string)) {
            ADHOCReportService.generateADHOCDesign(httpServletRequest, httpServletResponse);
        } else if ("adhoc_getdatanames".equals(string)) {
            ADHOCReportService.dealADHOCDataNames(httpServletRequest, httpServletResponse);
        } else if ("adhoc_adddata".equals(string)) {
            ADHOCReportService.addADHOCData(httpServletRequest, httpServletResponse);
        } else if ("adhoc_getdata".equals(string)) {
            ADHOCReportService.dealGetADHOCData(httpServletRequest, httpServletResponse);
        } else if ("adhoc_editdata".equals(string)) {
            ADHOCReportService.dealEditADHOCData(httpServletRequest, httpServletResponse);
        } else if ("adhoc_removedata".equals(string)) {
            ADHOCReportService.dealRemoveADHOCData(httpServletRequest);
        } else if ("adhoc_getdatasourcenames".equals(string)) {
            ADHOCReportService.dealGetDataNames(httpServletRequest, httpServletResponse);
        } else if ("adhoc_getdetail".equals(string)) {
            ADHOCReportService.dealGetDataDetail(httpServletRequest, httpServletResponse);
        } else if ("adhoc_getdatafields".equals(string)) {
            ADHOCReportService.dealGetDataFields(httpServletRequest, httpServletResponse);
        } else if ("adhoc_design_viewlist".equals(string)) {
            ADHOCReportService.dealGetViewList(httpServletRequest, httpServletResponse);
        } else if ("adhoc_gettabledatanames".equals(string)) {
            ADHOCReportService.dealGetTableDataNames(httpServletRequest, httpServletResponse);
        } else if ("adhoc_gettablenames".equals(string)) {
            ADHOCReportService.dealGetTableNames(httpServletRequest, httpServletResponse);
        }
    }

    private static void dealEditADHOCData(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "oldname");
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "newname");
        ADHOCTableData aDHOCTableData = (ADHOCTableData)FRContext.getDatasourceManager().getADHOC(string);
        FRContext.getDatasourceManager().removeADHOC(string);
        FRContext.getDatasourceManager().putADHOC(string2, aDHOCTableData);
        FRContext.getCurrentEnv().writeResource(FRContext.getDatasourceManager());
        ADHOCReportService.dealPrinter(httpServletResponse, ADHOCReportService.nameADHOCDataString(aDHOCTableData, string2));
    }

    private static void dealGetTableNames(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "datalink");
        JSONArray jSONArray = new JSONArray();
        if (StringUtils.isNotEmpty(string)) {
            DatabaseConnection databaseConnection = (DatabaseConnection)FRContext.getDatasourceManager().getConnection(string);
            TableProcedure[] tableProcedureArray = FRContext.getCurrentEnv().getSQLTablesProcedure(databaseConnection, null);
            int n = tableProcedureArray.length;
            for (int i = 0; i < n; ++i) {
                if (tableProcedureArray[i].getType() == "PROCEDURE") continue;
                jSONArray.put(new JSONObject().put("text", tableProcedureArray[i].getName()).put("value", tableProcedureArray[i].getName()));
            }
        }
        ADHOCReportService.dealPrinter(httpServletResponse, CodeUtils.jsonEncode(jSONArray));
    }

    private static void dealGetTableDataNames(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        JSONArray jSONArray = new JSONArray();
        Iterator iterator = FRContext.getDatasourceManager().getTableDataNameIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            jSONArray.put(new JSONObject().put("value", string).put("text", string));
        }
        ADHOCReportService.dealPrinter(httpServletResponse, CodeUtils.jsonEncode(jSONArray));
    }

    private static void dealADHOCReport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
    }

    private static void dealGetViewList(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "viewname");
        ADHOCTableData aDHOCTableData = (ADHOCTableData)FRContext.getDatasourceManager().getADHOC(string);
        JSONArray jSONArray = new JSONArray();
        int n = aDHOCTableData.getColumnCount();
        for (int i = 0; i < n; ++i) {
            jSONArray.put(aDHOCTableData.getColumnName(i));
        }
        ADHOCReportService.dealPrinter(httpServletResponse, CodeUtils.jsonEncode(jSONArray));
    }

    private static void dealGetDataFields(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "viewname");
        ADHOCTableData aDHOCTableData = (ADHOCTableData)FRContext.getDatasourceManager().getADHOC(string);
        JSONArray jSONArray = new JSONArray();
        int n = aDHOCTableData.getColumnCount();
        for (int i = 0; i < n; ++i) {
            jSONArray.put(new JSONObject().put("value", aDHOCTableData.getColumnName(i)).put("text", aDHOCTableData.getColumnName(i)));
        }
        ADHOCReportService.dealPrinter(httpServletResponse, CodeUtils.jsonEncode(jSONArray));
    }

    private static void dealGetDataDetail(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "dataname");
        ADHOCTableData aDHOCTableData = (ADHOCTableData)FRContext.getDatasourceManager().getADHOC(string);
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        int n = aDHOCTableData.getRowCount() > 5 ? 5 : aDHOCTableData.getRowCount();
        int n2 = aDHOCTableData.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            JSONArray jSONArray2 = new JSONArray();
            jSONArray2.put(aDHOCTableData.getColumnName(i));
            for (int j = 0; j < n; ++j) {
                jSONArray2.put(aDHOCTableData.getValueAt(j, i));
            }
            jSONArray.put(jSONArray2);
        }
        jSONObject.put("description", aDHOCTableData.getDescription());
        jSONObject.put("tabledata", jSONArray);
        aDHOCTableData.release();
        ADHOCReportService.dealPrinter(httpServletResponse, CodeUtils.jsonEncode(jSONObject));
    }

    private static void dealGetDataNames(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        JSONArray jSONArray = new JSONArray();
        Iterator iterator = FRContext.getDatasourceManager().getConnectionNameIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            jSONArray.put(new JSONObject().put("value", string).put("text", string));
        }
        ADHOCReportService.dealPrinter(httpServletResponse, CodeUtils.jsonEncode(jSONArray));
    }

    private static void dealADHOCDataNames(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Iterator iterator = FRContext.getDatasourceManager().getADHOCNameIterator();
        JSONArray jSONArray = new JSONArray();
        while (iterator.hasNext()) {
            jSONArray.put(iterator.next());
        }
        ADHOCReportService.dealPrinter(httpServletResponse, jSONArray.toString());
    }

    private static void addADHOCData(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "namedata");
        JSONObject jSONObject = new JSONObject(string);
        String string2 = null;
        if (jSONObject.get("text") != null) {
            string2 = jSONObject.getString("text");
        }
        if (StringUtils.isEmpty(string2)) {
            ADHOCReportService.dealFailedStatePrinter(httpServletResponse);
            return;
        }
        ADHOCTableData aDHOCTableData = null;
        if (jSONObject.get("type") != null) {
            if (jSONObject.getInt("type") == ADHOCSQLTableData.TYPE) {
                aDHOCTableData = new ADHOCSQLTableData();
            } else if (jSONObject.getInt("type") == ADHOCNamedTableData.TYPE) {
                aDHOCTableData = new ADHOCNamedTableData();
            }
            ((ADHOCTableData)aDHOCTableData).parseJSON(jSONObject);
            DatasourceManager datasourceManager = FRContext.getDatasourceManager();
            datasourceManager.putADHOC(string2, aDHOCTableData);
            FRContext.getCurrentEnv().writeResource(datasourceManager);
        }
        ADHOCReportService.dealPrinter(httpServletResponse, "success");
    }

    private static void dealGetADHOCData(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string;
        DatasourceManager datasourceManager = FRContext.getDatasourceManager();
        ADHOCTableData aDHOCTableData = (ADHOCTableData)datasourceManager.getADHOC(string = WebUtils.getHTTPRequestParameter(httpServletRequest, "dataname"));
        if (aDHOCTableData == null) {
            ADHOCReportService.dealFailedStatePrinter(httpServletResponse);
            return;
        }
        ADHOCReportService.dealPrinter(httpServletResponse, ADHOCReportService.nameADHOCDataString(aDHOCTableData, string));
    }

    private static String nameADHOCDataString(ADHOCTableData aDHOCTableData, String string) throws Exception {
        JSONObject jSONObject = aDHOCTableData.createJSON();
        jSONObject.put("text", string);
        return jSONObject.toString();
    }

    private static void dealRemoveADHOCData(HttpServletRequest httpServletRequest) throws Exception {
        DatasourceManager datasourceManager = FRContext.getDatasourceManager();
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "dataname");
        datasourceManager.removeADHOC(string);
    }

    private static void dealFailedStatePrinter(HttpServletResponse httpServletResponse) throws Exception {
        ADHOCReportService.dealPrinter(httpServletResponse, "false");
    }

    private static void dealPrinter(HttpServletResponse httpServletResponse, String string) throws Exception {
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.print(string);
        printWriter.flush();
        printWriter.close();
    }

    private static void generateADHOCData(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Map map = WebUtils.createTemplateMap(httpServletRequest);
        TemplateUtils.dealWithTemplate("/com/fr/web/adhoc/html/adhocdata.html", httpServletResponse, map);
    }

    private static void generateADHOCDesign(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Map map = WebUtils.createTemplateMap(httpServletRequest);
        TemplateUtils.dealWithTemplate("/com/fr/web/adhoc/html/adhocdesign.html", httpServletResponse, map);
    }

    public boolean accept(String string) {
        return VT4FR.ADHOC.support() && string.startsWith(KEY);
    }
}

