/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.service;

import com.fr.base.FRContext;
import com.fr.report.PageSet;
import com.fr.report.ReportPage;
import com.fr.util.Consts;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.core.WebUtils;
import com.fr.web.core.service.NoSessionIDService;
import com.fr.web.core.service.SessionDealWith;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AppletPrintService
extends NoSessionIDService {
    private static AppletPrintService APPLET_PRINT_SERVICE = null;

    private AppletPrintService() {
    }

    public static AppletPrintService getInstance() {
        if (APPLET_PRINT_SERVICE == null) {
            APPLET_PRINT_SERVICE = new AppletPrintService();
        }
        return APPLET_PRINT_SERVICE;
    }

    public boolean accept(String string) {
        return string.startsWith("fr_applet_");
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        if (string.equals("fr_applet_load")) {
            AppletPrintService.dealAppletLoad(httpServletRequest, httpServletResponse);
        } else if (string.equals("fr_applet_print")) {
            AppletPrintService.dealAppletPrint(httpServletRequest, httpServletResponse);
        }
    }

    private static void dealAppletPrint(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ReportPage reportPage;
        int n;
        httpServletResponse.setContentType("application/octet-stream");
        String string = SessionDealWith.getOrGenerateSessionID(httpServletRequest, httpServletResponse);
        if (string == null) {
            return;
        }
        SessionIDInfor sessionIDInfor = SessionDealWith.getSessionIDInfor(string);
        if (sessionIDInfor == null) {
            return;
        }
        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)httpServletResponse.getOutputStream());
        ArrayList<ReportPage> arrayList = new ArrayList<ReportPage>();
        PageSet pageSet = sessionIDInfor.getPrintPreviewPageSet4Traversing();
        for (n = 0; n < pageSet.size() && (reportPage = pageSet.getPage(n)) != null; n += 1) {
            arrayList.add(reportPage);
        }
        objectOutputStream.writeObject(arrayList.toArray(new ReportPage[0]));
        n = 0;
        objectOutputStream.writeObject(new Boolean(n != 0));
        objectOutputStream.flush();
        objectOutputStream.close();
    }

    private static void dealAppletLoad(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = SessionDealWith.getOrGenerateSessionID(httpServletRequest, httpServletResponse);
        if (string == null) {
            return;
        }
        Map map = WebUtils.createTemplateMap(httpServletRequest);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<OBJECT ID='AppletPrinter' name='AppletPrinter' WIDTH='0' HEIGHT='0' CLASSID='clsid:8AD9C840-044E-11D1-B3E9-00805F499D93'");
        stringBuffer.append(" codebase=\"" + map.get("serverURL") + map.get("contextPath") + "/jre.exe\">");
        stringBuffer.append("<param name='code' value='com.fr.base.print.PrintApplet'>");
        stringBuffer.append("<param name='archive' value='" + map.get("serverURL") + map.get("contextPath") + "/fr-applet-" + Consts.Main_Version + "." + Consts.Minor_Version + ".jar'>");
        stringBuffer.append("<param name='sessionid' value='" + string + "'>");
        stringBuffer.append("<param name='url' value='" + map.get("serverURL") + httpServletRequest.getContextPath() + "/" + FRContext.getConfigManager().getServletMapping() + "?op=fr_applet_print&sessionID=" + string + "'>");
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.print(stringBuffer);
        printWriter.flush();
        printWriter.close();
    }
}

