/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.service;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.base.cache.DiskCacheMap;
import com.fr.base.core.UUID;
import com.fr.util.Base64;
import com.fr.web.Browser;
import com.fr.web.cluster.ClusterService;
import com.fr.web.core.Attachment;
import com.fr.web.core.WebUtils;
import com.fr.web.core.service.NoSessionIDService;
import com.fr.web.core.upload.SmartFile;
import com.fr.web.core.upload.SmartFiles;
import com.fr.web.core.upload.SmartUpload;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AttachmentService
extends NoSessionIDService {
    private static AttachmentService ATTACHMENT_SERVICE = null;
    private static Map attachmentMap = new DiskCacheMap();
    private static final String UPLOAD = "attach_upload";
    private static final String DOWNLOAD = "attach_download";
    private static final String IMAGE = "attach_image";
    private static final String RELEASE = "attach_release";

    private AttachmentService() {
    }

    public static AttachmentService getInstance() {
        if (ATTACHMENT_SERVICE == null) {
            ATTACHMENT_SERVICE = new AttachmentService();
        }
        return ATTACHMENT_SERVICE;
    }

    public boolean accept(String string) {
        return string.startsWith("attach_");
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        if (UPLOAD.equals(string)) {
            AttachmentService.dealWithUploadAttachment(httpServletRequest, httpServletResponse);
        } else if (DOWNLOAD.equals(string)) {
            AttachmentService.dealWithDownloadAttachment(httpServletRequest, httpServletResponse);
        } else if (IMAGE.equals(string)) {
            AttachmentService.dealWithImageAttachment(httpServletRequest, httpServletResponse);
        } else if (RELEASE.equals(string)) {
            AttachmentService.dealWithReleaseAttachment(httpServletRequest);
        }
    }

    public static Attachment addAttachment(Image image) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BaseUtils.writeImage(image, "png", byteArrayOutputStream);
        return AttachmentService.addAttachment("image", "attach.png", byteArrayOutputStream.toByteArray());
    }

    public static Attachment addAttachment(String string, String string2, byte[] byArray) {
        Cloneable cloneable;
        String string3 = UUID.randomUUID().toString();
        if (FRContext.getClusterConfigManager().isUseCluster() && (cloneable = FRContext.getClusterConfigManager().getSelfService()) != null && ((ClusterService)cloneable).getServiceName() != null) {
            string3 = ((ClusterService)cloneable).getServiceName() + "_" + string3;
        }
        cloneable = new Attachment(string3, string, string2, byArray);
        attachmentMap.put(string3, cloneable);
        return cloneable;
    }

    public static Attachment getAttachment(String string) {
        return (Attachment)attachmentMap.get(string);
    }

    public static void removeAttachment(String string) {
        attachmentMap.remove(string);
    }

    private static void dealWithUploadAttachment(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ServletContext servletContext = httpServletRequest.getSession().getServletContext();
        SmartUpload smartUpload = new SmartUpload();
        smartUpload.initialize(servletContext, httpServletRequest, httpServletResponse);
        smartUpload.upload();
        SmartFiles smartFiles = smartUpload.getFiles();
        if (smartFiles.getSize() == 0L) {
            return;
        }
        SmartFile smartFile = smartFiles.getFile(0);
        Attachment attachment = AttachmentService.addAttachment(smartFile.getContentType().indexOf("image") > 0 ? "image" : "other", smartFile.getFileName(), smartFile.getBytes());
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.print(attachment.toConfig());
        printWriter.flush();
        printWriter.close();
    }

    private static void dealWithDownloadAttachment(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Attachment attachment;
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "id");
        if (string != null && (attachment = AttachmentService.getAttachment(string)) != null) {
            byte[] byArray = attachment.getBytes();
            httpServletResponse.setHeader("Pragma", "No-cache");
            httpServletResponse.setHeader("Cache-Control", "max-age=180");
            String string2 = attachment.getFilename();
            httpServletResponse.setHeader("Content-disposition", "attachment; filename=" + Browser.resolve(httpServletRequest).getEncodedFileName4Download(string2));
            string2 = string2.toLowerCase();
            if (string2.endsWith(".pdf")) {
                httpServletResponse.setContentType("application/pdf");
                httpServletResponse.setHeader("extension", "pdf");
            } else if (string2.endsWith(".xls")) {
                httpServletResponse.setContentType("application/x-excel");
                httpServletResponse.setHeader("extension", "xls");
            } else if (string2.endsWith(".doc")) {
                httpServletResponse.setContentType("application/msword");
                httpServletResponse.setHeader("extension", "doc");
            } else if (string2.endsWith(".svg")) {
                httpServletResponse.setContentType("image/svg+xml");
                httpServletResponse.setHeader("extension", "svg");
            } else if (string2.endsWith(".csv")) {
                httpServletResponse.setContentType("application/octet-stream");
                httpServletResponse.setHeader("extension", "csv");
            } else if (string2.endsWith(".txt")) {
                httpServletResponse.setContentType("application/octet-stream");
                httpServletResponse.setHeader("extension", "txt");
            } else {
                httpServletResponse.setContentType("application/x-msdownload");
            }
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            servletOutputStream.write(byArray);
            servletOutputStream.flush();
            servletOutputStream.close();
        }
    }

    private static void dealWithImageAttachment(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        httpServletResponse.setHeader("Cache-Control", "max-age=86400");
        httpServletResponse.setDateHeader("Expires", System.currentTimeMillis() + 86400000L);
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "id");
        if (string != null) {
            Object object;
            byte[] byArray = null;
            if (string.startsWith("icon_name_")) {
                byArray = FRContext.getWidgetManager().getIconManager().getIconImage4Web(WebUtils.createServletURL(httpServletRequest), string);
            } else if (string.equals("toolbar-image.png")) {
                byArray = FRContext.getWidgetManager().getIconManager().getAllInOneImageBytes(WebUtils.createServletURL(httpServletRequest));
            } else {
                object = AttachmentService.getAttachment(string);
                if (object != null) {
                    byArray = ((Attachment)object).getBytes();
                }
            }
            if (byArray == null) {
                byArray = new byte[]{};
            }
            if ("base64".equals(object = WebUtils.getHTTPRequestParameter(httpServletRequest, "format"))) {
                byArray = Base64.encode(byArray).getBytes("ISO-8859-1");
            } else {
                httpServletResponse.setContentType("image/png");
            }
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            try {
                servletOutputStream.write(byArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                servletOutputStream.flush();
                servletOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void dealWithReleaseAttachment(HttpServletRequest httpServletRequest) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "id");
        if (string != null) {
            AttachmentService.removeAttachment(string);
        }
    }

    private static class NullImage
    extends Image {
        private static NullImage nullImage = null;
        private static byte[] nullBytes = null;

        private NullImage() {
        }

        public static synchronized NullImage getNullImageInstance() {
            if (nullImage == null) {
                nullImage = new NullImage();
            }
            return nullImage;
        }

        public static synchronized byte[] getNullImageBytes() {
            if (nullBytes == null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                BaseUtils.writeImage(NullImage.getNullImageInstance(), "png", byteArrayOutputStream);
                try {
                    byteArrayOutputStream.flush();
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {
                    FRContext.getLogger().log(Level.WARNING, iOException.getMessage(), iOException);
                }
                nullBytes = byteArrayOutputStream.toByteArray();
            }
            return nullBytes;
        }

        public void flush() {
        }

        public Graphics getGraphics() {
            return null;
        }

        public int getHeight(ImageObserver imageObserver) {
            return 0;
        }

        public Object getProperty(String string, ImageObserver imageObserver) {
            return null;
        }

        public ImageProducer getSource() {
            return null;
        }

        public int getWidth(ImageObserver imageObserver) {
            return 0;
        }
    }
}

