/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.service;

import com.fr.base.FRContext;
import com.fr.base.core.util.vt.VT4FR;
import com.fr.util.Utils;
import com.fr.web.cluster.ClusterService;
import com.fr.web.core.WebUtils;
import com.fr.web.core.service.NoSessionIDService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;

public class ClusterUtilService
extends NoSessionIDService {
    private static ClusterUtilService CLUSTERUTIL_SERVICE = new ClusterUtilService();

    private ClusterUtilService() {
    }

    public static ClusterUtilService getInstance() {
        return CLUSTERUTIL_SERVICE;
    }

    public boolean accept(String string) {
        return "cluster_test_all".equals(string) || "cluster_test".equals(string) || "test_cluster".equals(string);
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        if ("cluster_test_all".equals(string)) {
            ClusterUtilService.ClusterTestAll(httpServletRequest, httpServletResponse);
        } else if ("cluster_test".equals(string)) {
            ClusterUtilService.clusterTest(httpServletRequest, httpServletResponse);
        } else if ("test_cluster".equals(string)) {
            ClusterUtilService.reClusterTest(httpServletRequest, httpServletResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doRedirect(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ClusterService clusterService, ClusterService clusterService2) throws IOException {
        HttpClient httpClient = new HttpClient();
        PostMethod postMethod = ClusterUtilService.createMethod(httpServletRequest, clusterService, clusterService2);
        int n = httpClient.executeMethod((HttpMethod)postMethod);
        if (n != 200) {
            FRContext.getLogger().log(Level.WARNING, "Cluster Redirect Method failed: " + postMethod.getStatusLine());
        }
        try {
            Header[] headerArray = postMethod.getResponseHeaders();
            for (int i = 0; i < headerArray.length; ++i) {
                if (headerArray[i].getName().equalsIgnoreCase("transfer-encoding") || headerArray[i].getName().equalsIgnoreCase("content-length")) continue;
                httpServletResponse.setHeader(headerArray[i].getName(), headerArray[i].getValue());
            }
            InputStream inputStream = postMethod.getResponseBodyAsStream();
            if (inputStream != null) {
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                Utils.copyBinaryTo(inputStream, (OutputStream)servletOutputStream);
            }
        }
        finally {
            postMethod.releaseConnection();
        }
    }

    private static PostMethod createMethod(HttpServletRequest httpServletRequest, ClusterService clusterService, ClusterService clusterService2) {
        String string;
        PostMethod postMethod = new PostMethod("http://" + clusterService.getIp() + ":" + clusterService.getPort() + "/" + clusterService.getWebAppName() + "/" + FRContext.getConfigManager().getServletMapping());
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            NameValuePair nameValuePair = new NameValuePair();
            nameValuePair.setName(string);
            nameValuePair.setValue(httpServletRequest.getParameter(string));
            postMethod.addParameter(nameValuePair);
        }
        postMethod.addParameter("gzip", "false");
        postMethod.addParameter("redirect_from", clusterService2 == null ? "unknown" : clusterService2.getServiceName() + "");
        enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (string.equalsIgnoreCase("host") || string.equalsIgnoreCase("refer") || string.equalsIgnoreCase("content-length")) continue;
            postMethod.setRequestHeader(string, httpServletRequest.getHeader(string));
        }
        return postMethod;
    }

    public static boolean CheckCluster(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (FRContext.getClusterConfigManager().isUseCluster() && VT4FR.SERVER_CLUSTER.support()) {
            Object object;
            Object object2;
            FRContext.getClusterConfigManager().initClusterServiceConfig(httpServletRequest);
            String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "redirect_from");
            if (string != null) {
                return false;
            }
            String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "cluster_redirect");
            String string3 = null;
            if (string2 != null) {
                string3 = string2;
            } else {
                String[] stringArray;
                String string4;
                object2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "sessionID");
                object = WebUtils.getHTTPRequestParameter(httpServletRequest, "op");
                if (object2 != null) {
                    String[] stringArray2 = ((String)object2).split("_");
                    if (stringArray2.length > 0) {
                        string3 = stringArray2[0];
                    }
                } else if (object != null && ((String)object).startsWith("attach") && (string4 = WebUtils.getHTTPRequestParameter(httpServletRequest, "id")) != null && (stringArray = string4.split("_")).length > 0) {
                    string3 = stringArray[0];
                }
            }
            if (string3 != null) {
                object2 = FRContext.getClusterConfigManager().getSelfService();
                if (object2 != null && ((ClusterService)object2).getServiceName().equals(string3)) {
                    return false;
                }
                object = FRContext.getClusterConfigManager().getService(string3);
                if (object != null) {
                    ClusterUtilService.doRedirect(httpServletRequest, httpServletResponse, (ClusterService)object, (ClusterService)object2);
                    return true;
                }
            }
        }
        return false;
    }

    private static void clusterTest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.print("<html>");
        if (FRContext.getClusterConfigManager().isUseCluster()) {
            printWriter.print("Cluster is start!<br/>");
            ClusterService clusterService = FRContext.getClusterConfigManager().getSelfService();
            if (clusterService != null) {
                printWriter.print("SELF:<br/>");
                printWriter.print("ServiceName:" + clusterService.getServiceName() + "<br/>");
                printWriter.print("IP:" + clusterService.getIp() + "<br/>");
                printWriter.print("PORT:" + clusterService.getPort() + "<br/>");
                printWriter.print("WebAppName:" + clusterService.getWebAppName() + "<br/>");
                printWriter.print("<br/>");
            } else {
                printWriter.print("Can not find Own Service Info. <br/>LocalIP:" + FRContext.getClusterConfigManager().getLocalIp() + "<br/>LocalPort:" + FRContext.getClusterConfigManager().getLocalPort() + "<br/>");
            }
            printWriter.print("Other Server List:<br/>");
            List list = FRContext.getClusterConfigManager().getOtherServices();
            for (int i = 0; i < list.size(); ++i) {
                ClusterService clusterService2 = (ClusterService)list.get(i);
                printWriter.print("NO" + (i + 1) + ": ");
                printWriter.print("ServiceName:" + clusterService2.getServiceName() + " = " + clusterService2.getIp() + ":" + clusterService2.getPort() + "/" + clusterService2.getWebAppName() + " - ");
                try {
                    printWriter.print("<font color='green'>" + ClusterUtilService.testOtherClusterService(clusterService2, "test_cluster") + "</font><br/>");
                }
                catch (IOException iOException) {
                    printWriter.print("<font color='red'>" + iOException.getMessage() + "</font><br/>");
                }
                printWriter.print("<br/><br/>");
            }
        } else {
            printWriter.print("Cluster is close!<br/>");
        }
        printWriter.print("</html>");
    }

    private static void ClusterTestAll(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.print("<html>");
        if (FRContext.getClusterConfigManager().isUseCluster()) {
            printWriter.print("Cluster is start<br/>");
            ClusterService clusterService = FRContext.getClusterConfigManager().getSelfService();
            if (clusterService != null) {
                printWriter.print("SELF:<br/>");
                printWriter.print("ServiceName:" + clusterService.getServiceName() + "<br/>");
                printWriter.print("IP:" + clusterService.getIp() + "<br/>");
                printWriter.print("PORT:" + clusterService.getPort() + "<br/>");
                printWriter.print("WebAppName:" + clusterService.getWebAppName() + "<br/>");
                printWriter.print("<br/>");
            } else {
                printWriter.print("<font color='red'>");
                printWriter.print("Can not find Own Service Info. LocalIP:" + FRContext.getClusterConfigManager().getLocalIp() + "LocalPort:" + FRContext.getClusterConfigManager().getLocalPort() + "<br/>");
                printWriter.print("</font><br/>");
            }
            printWriter.print("Other Server List:<br/>");
            List list = FRContext.getClusterConfigManager().getOtherServices();
            for (int i = 0; i < list.size(); ++i) {
                ClusterService clusterService2 = (ClusterService)list.get(i);
                printWriter.print("NO" + (i + 1) + ": ");
                printWriter.print("ServiceName:" + clusterService2.getServiceName() + " = " + clusterService2.getIp() + ":" + clusterService2.getPort() + "/" + clusterService2.getWebAppName() + "<br/>");
                printWriter.print("------------------------------------------<br/>");
                printWriter.print("Test it(op = cluster_test) - RE:<br/>");
                try {
                    printWriter.print(ClusterUtilService.testOtherClusterService(clusterService2, "cluster_test") + "<br/>");
                }
                catch (IOException iOException) {
                    printWriter.print(iOException.getMessage() + "<br/>");
                }
                printWriter.print("------------------------------------------<br/>");
                printWriter.print("<br/><br/><br/><br/>");
            }
        } else {
            printWriter.print("Cluster is close!<br/>");
        }
        printWriter.print("</html>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String testOtherClusterService(ClusterService clusterService, String string) throws IOException {
        PostMethod postMethod = new PostMethod("http://" + clusterService.getIp() + ":" + clusterService.getPort() + "/" + clusterService.getWebAppName() + "/" + FRContext.getConfigManager().getServletMapping());
        postMethod.addParameter("op", string);
        HttpClient httpClient = new HttpClient();
        int n = httpClient.executeMethod((HttpMethod)postMethod);
        if (n != 200) {
            return "" + n;
        }
        try {
            String string2 = postMethod.getResponseBodyAsString();
            return string2;
        }
        finally {
            postMethod.releaseConnection();
        }
    }

    private static void reClusterTest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.print("OK");
    }

    public static String getLocalIP() throws Exception {
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        InetAddress inetAddress = null;
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
            while (enumeration2.hasMoreElements()) {
                inetAddress = enumeration2.nextElement();
                if (!inetAddress.isSiteLocalAddress() || inetAddress.isLoopbackAddress() || inetAddress.getHostAddress().indexOf(":") != -1) continue;
                return inetAddress.getHostAddress();
            }
        }
        return null;
    }
}

