/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.service;

import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.core.json.JSONObject;
import com.fr.base.file.DatasourceManager;
import com.fr.data.impl.Connection;
import com.fr.data.impl.JDBCDatabaseConnection;
import com.fr.web.cache.WebletFactory;
import com.fr.web.core.ShowWorkBookPolicy;
import com.fr.web.core.WebUtils;
import com.fr.web.core.service.NoSessionIDService;
import com.fr.web.core.service.ReportletDealWith;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ConsoleService
extends NoSessionIDService {
    private static final String CONSOLE_CONNECTION = "console_connection";
    private static final String CONSOLE_REGISTER = "console_reg";
    private static final String CONSOLE_GLIC = "console_glic";
    private static final String CONSOLE_SVN = "console_svn";
    private static ConsoleService CONSOLE_SERVICE = new ConsoleService();

    private ConsoleService() {
    }

    public static ConsoleService getInstance() {
        return CONSOLE_SERVICE;
    }

    public boolean accept(String string) {
        return string.startsWith("console_");
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        if (CONSOLE_CONNECTION.equals(string)) {
            ConsoleService.dealWithConnection(httpServletRequest, httpServletResponse);
        } else if (CONSOLE_REGISTER.equals(string)) {
            ConsoleService.dealWithRegister(httpServletRequest, httpServletResponse);
        } else if (CONSOLE_GLIC.equals(string)) {
            ConsoleService.dealWidthGLic(httpServletRequest, httpServletResponse);
        } else if (CONSOLE_SVN.equals(string)) {
            ConsoleService.dealWidthSVN(httpServletRequest, httpServletResponse);
        }
    }

    private static void dealWithConnection(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "action");
        if (StringUtils.isBlank(string)) {
            ReportletDealWith.dealWithReportlet(httpServletRequest, httpServletResponse, WebletFactory.createEmbeddedReportlet("/com/fr/web/console/JDBCDatabaseConnection.cpt", new ShowWorkBookPolicy.Policy4Form()));
            return;
        }
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "form_value");
        JSONObject jSONObject = new JSONObject(string2);
        DatasourceManager datasourceManager = FRContext.getDatasourceManager();
        if ("column_modify".equals(string)) {
            String string3 = (String)jSONObject.get("Name");
            Connection connection = datasourceManager.getConnection(string3);
            if (connection instanceof JDBCDatabaseConnection) {
                JDBCDatabaseConnection jDBCDatabaseConnection = (JDBCDatabaseConnection)connection;
                jDBCDatabaseConnection.setDriver(jSONObject.getString("Driver"));
                jDBCDatabaseConnection.setURL(jSONObject.getString("URL"));
                jDBCDatabaseConnection.setUser(jSONObject.getString("User"));
                jDBCDatabaseConnection.setPassword(jSONObject.getString("Password"));
                jDBCDatabaseConnection.setNewCharsetName((String)jSONObject.get("newCharsetName"));
                jDBCDatabaseConnection.setOriginalCharsetName((String)jSONObject.get("originalCharsetName"));
            }
        } else if ("column_delete".equals(string)) {
            String string4 = (String)jSONObject.get("Name");
            datasourceManager.removeConnection(string4);
        } else if ("add".equals(string)) {
            // empty if block
        }
    }

    private static void dealWithRegister(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ReportletDealWith.dealWithReportlet(httpServletRequest, httpServletResponse, WebletFactory.createEmbeddedReportlet("/com/fr/web/console/register.cpt", new ShowWorkBookPolicy.Policy4Form()));
    }

    private static void dealWidthGLic(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ReportletDealWith.dealWithReportlet(httpServletRequest, httpServletResponse, WebletFactory.createEmbeddedReportlet("/com/fr/web/console/generateLicense.cpt", new ShowWorkBookPolicy.Policy4Form()));
    }

    private static void dealWidthSVN(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ReportletDealWith.dealWithReportlet(httpServletRequest, httpServletResponse, WebletFactory.createEmbeddedReportlet("/com/fr/web/console/logInfo.cpt", new ShowWorkBookPolicy.Policy4Form()));
    }
}

