/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.service;

import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.list.IntList;
import com.fr.base.core.util.TemplateUtils;
import com.fr.base.file.ConfigManager;
import com.fr.base.print.PrintUtils;
import com.fr.report.ArrayPageSet;
import com.fr.report.Margin;
import com.fr.report.PageSet;
import com.fr.report.PaperSetting;
import com.fr.report.PaperSize;
import com.fr.report.ReportConstants;
import com.fr.report.ReportPage;
import com.fr.report.ReportWebAttr;
import com.fr.report.core.cal.LayerPageReport;
import com.fr.report.core.cal.LayerReport;
import com.fr.report.io.AbstractAppExporter;
import com.fr.report.io.CSVExporter;
import com.fr.report.io.ExcelExporter;
import com.fr.report.io.PDFExporter;
import com.fr.report.io.SVGExporter;
import com.fr.report.io.TextExporter;
import com.fr.report.io.WordExporter;
import com.fr.report.web.EmailManager;
import com.fr.util.Utils;
import com.fr.web.Browser;
import com.fr.web.cache.WebletFactory;
import com.fr.web.core.ErrorHandlerHelper;
import com.fr.web.core.Service;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.core.ShowWorkBookPolicy;
import com.fr.web.core.WebUtils;
import com.fr.web.core.service.ReportletDealWith;
import com.fr.web.core.service.SessionDealWith;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DialogService
implements Service {
    private static DialogService DIALOG_SERVICE = new DialogService();

    private DialogService() {
    }

    public static DialogService getInstance() {
        return DIALOG_SERVICE;
    }

    public boolean accept(String string) {
        return string.startsWith("dialog_");
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws Exception {
        SessionIDInfor sessionIDInfor = SessionDealWith.getSessionIDInfor(string2);
        if (sessionIDInfor == null) {
            ErrorHandlerHelper.getErrorHandler().error(httpServletRequest, httpServletResponse, "SessionID: \"" + string2 + "\" time out.");
            return;
        }
        Map map = WebUtils.createTemplateMap(httpServletRequest);
        map.put("sessionID", string2);
        if ("dialog_readPageSetupDialog".equalsIgnoreCase(string)) {
            DialogService.readPageSetup0(string2, sessionIDInfor, httpServletRequest, httpServletResponse);
        } else if ("dialog_readPageSetupTpl".equalsIgnoreCase(string)) {
            DialogService.readPageSetupTpl(sessionIDInfor, httpServletRequest, httpServletResponse);
        } else if ("dialog_changePageSetup".equalsIgnoreCase(string)) {
            DialogService.dealWithPageSetup(sessionIDInfor, httpServletRequest);
        } else if ("dialog_readPrintServerDialog".equalsIgnoreCase(string)) {
            DialogService.readPrintServerDialog(map, sessionIDInfor, httpServletRequest, httpServletResponse);
        } else if ("dialog_submitPrintServerDialog".equalsIgnoreCase(string)) {
            DialogService.submitPrintServerDialog(sessionIDInfor, httpServletRequest, httpServletResponse);
        } else if (!"dialog_readEmailDialog".equalsIgnoreCase(string)) {
            if ("dialog_writeEmailDialog".equalsIgnoreCase(string)) {
                DialogService.writeEmailDialog(sessionIDInfor, httpServletRequest, httpServletResponse);
            } else if ("dialog_submitEmailDialog".equalsIgnoreCase(string)) {
                DialogService.submitEmailDialog(sessionIDInfor, httpServletRequest, httpServletResponse);
            } else if ("dialog_acrobatReaderDialog".equalsIgnoreCase(string)) {
                DialogService.readAcrobatReaderDialog(map, httpServletResponse);
            } else if ("dialog_parameters".equalsIgnoreCase(string)) {
                sessionIDInfor.applySessionIDInforParameters(httpServletRequest);
                sessionIDInfor.clearPageSet();
                sessionIDInfor.clearPrintPreviewPageSet();
            }
        }
    }

    private static void readPrintServerDialog(Map map, SessionIDInfor sessionIDInfor, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String[] stringArray = sessionIDInfor.getServerPrinterNames();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<select name='serverPrinter' style='width:360px'>");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = "";
            if (i == 0) {
                string2 = " selected ";
            }
            stringBuffer.append("<option value='");
            stringBuffer.append(string);
            stringBuffer.append("'");
            stringBuffer.append(string2);
            stringBuffer.append(">");
            stringBuffer.append(string);
            stringBuffer.append("</option>");
        }
        stringBuffer.append("</select>");
        map.put("PrinterServerNameList", stringBuffer);
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "pn");
        if (string != null) {
            map.put("pageIndex", string);
        }
        TemplateUtils.dealWithTemplate("/com/fr/web/core/dialog/printServer.html", httpServletResponse, map);
    }

    private static void submitPrintServerDialog(SessionIDInfor sessionIDInfor, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        PageSet pageSet = null;
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "range");
        if (string.equals("all")) {
            pageSet = sessionIDInfor.getPrintPreviewPageSet4Traversing();
        } else if (string.equals("current")) {
            int n = Integer.parseInt(WebUtils.getHTTPRequestParameter(httpServletRequest, "pageIndex"));
            pageSet = new ArrayPageSet(new ReportPage[]{sessionIDInfor.getPrintPreviewReportPage(n)}, false);
        } else if (string.equals("specify")) {
            String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "specify");
            object = new ArrayList();
            IntList intList = IntList.toIntListDecimal(string2, ',');
            intList.sort();
            intList.removeEqual();
            for (int i = 0; i < intList.size(); ++i) {
                object.add(sessionIDInfor.getPrintPreviewReportPage(intList.get(i)));
            }
            pageSet = new ArrayPageSet(object.toArray(new ReportPage[object.size()]), false);
        }
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        try {
            object = WebUtils.getHTTPRequestParameter(httpServletRequest, "serverPrinter");
            if (StringUtils.isNotBlank((String)object)) {
                PrintUtils.print(pageSet, false, (String)object);
            } else {
                PrintUtils.print(pageSet, false, null);
            }
            printWriter.print(true);
        }
        catch (PrinterException printerException) {
            printerException.printStackTrace();
            printWriter.print(false);
        }
        printWriter.flush();
        printWriter.close();
    }

    private static void readPageSetup0(String string, SessionIDInfor sessionIDInfor, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Map map = WebUtils.createTemplateMap(httpServletRequest);
        int n = Integer.parseInt(WebUtils.getHTTPRequestParameter(httpServletRequest, "reportIndex"));
        map.put("sessionID", string);
        map.put("reportIndex", new Integer(n));
        TemplateUtils.dealWithTemplate("/com/fr/web/core/dialog/pageSetup.html", httpServletResponse, map);
    }

    private static void readPageSetupTpl(SessionIDInfor sessionIDInfor, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ReportletDealWith.dealWithReportlet(httpServletRequest, httpServletResponse, WebletFactory.createEmbeddedReportlet("/com/fr/web/core/dialog/pageSetup.cpt", new ShowWorkBookPolicy.Policy4Form(), DialogService.createPageParameterMap(sessionIDInfor, httpServletRequest, httpServletResponse)));
    }

    private static Map createPageParameterMap(SessionIDInfor sessionIDInfor, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        int n = Integer.parseInt(WebUtils.getHTTPRequestParameter(httpServletRequest, "reportIndex"));
        PaperSetting paperSetting = sessionIDInfor.getPagerSetting(n);
        if (paperSetting == null) {
            return hashMap;
        }
        hashMap.put("reportIndex", new Integer(n));
        int n2 = paperSetting.getOrientation();
        hashMap.put("portrait", new Boolean(n2 == 0));
        hashMap.put("landscape", new Boolean(n2 != 0));
        Locale locale = FRContext.getLocale();
        PaperSize paperSize = paperSetting.getPaperSize();
        boolean bl = true;
        for (int i = 0; i < ReportConstants.PaperSizeNameSizeArray.length; ++i) {
            Object[] objectArray = ReportConstants.PaperSizeNameSizeArray[i];
            if (!ComparatorUtils.equals(paperSize, objectArray[1])) continue;
            String string = (String)objectArray[0];
            hashMap.put("paperSize", string);
            bl = false;
            break;
        }
        if (ComparatorUtils.equals(Locale.CHINA, locale)) {
            hashMap.put("user_width", Utils.doubleToString(BaseCoreUtils.convertInchesToMillimeters(paperSize.getWidth())));
            hashMap.put("user_height", Utils.doubleToString(BaseCoreUtils.convertInchesToMillimeters(paperSize.getHeight())));
        } else {
            hashMap.put("user_width", Utils.doubleToString(paperSize.getWidth()));
            hashMap.put("user_height", Utils.doubleToString(paperSize.getHeight()));
        }
        hashMap.put("predefined", new Boolean(!bl));
        hashMap.put("customed", new Boolean(bl));
        Margin margin = paperSetting.getMargin();
        double d = margin.getLeft();
        double d2 = margin.getTop();
        double d3 = margin.getRight();
        double d4 = margin.getBottom();
        if (ComparatorUtils.equals(Locale.CHINA, locale)) {
            hashMap.put("margin_top", Utils.doubleToString(BaseCoreUtils.convertInchesToMillimeters(d2)));
            hashMap.put("margin_left", Utils.doubleToString(BaseCoreUtils.convertInchesToMillimeters(d)));
            hashMap.put("margin_bottom", Utils.doubleToString(BaseCoreUtils.convertInchesToMillimeters(d4)));
            hashMap.put("margin_right", Utils.doubleToString(BaseCoreUtils.convertInchesToMillimeters(d3)));
        } else {
            hashMap.put("margin_top", Utils.doubleToString(d2));
            hashMap.put("margin_left", Utils.doubleToString(d));
            hashMap.put("margin_bottom", Utils.doubleToString(d4));
            hashMap.put("margin_right", Utils.doubleToString(d3));
        }
        return hashMap;
    }

    private static void dealWithPageSetup(SessionIDInfor sessionIDInfor, HttpServletRequest httpServletRequest) throws Exception {
        Locale locale = FRContext.getLocale();
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "__parameters__");
        JSONObject jSONObject = new JSONObject(string);
        int n = Integer.parseInt(WebUtils.getHTTPRequestParameter(httpServletRequest, "reportIndex"));
        PaperSetting paperSetting = new PaperSetting();
        boolean bl = jSONObject.getBoolean("portrait");
        paperSetting.setOrientation(bl ? 0 : 1);
        boolean bl2 = jSONObject.getBoolean("predefined");
        if (bl2) {
            String string2 = jSONObject.getString("paperSize");
            for (int i = 0; i < ReportConstants.PaperSizeNameSizeArray.length; ++i) {
                Object[] objectArray = ReportConstants.PaperSizeNameSizeArray[i];
                if (!ComparatorUtils.equals(string2, objectArray[0])) continue;
                paperSetting.setPaperSize((PaperSize)objectArray[1]);
                break;
            }
        } else {
            double d = jSONObject.getDouble("user_width");
            double d2 = jSONObject.getDouble("user_height");
            PaperSize paperSize = new PaperSize();
            if (ComparatorUtils.equals(Locale.CHINA, locale)) {
                paperSize.setWidth(BaseCoreUtils.convertMillimetersToInches(d));
                paperSize.setHeight(BaseCoreUtils.convertMillimetersToInches(d2));
            } else {
                paperSize.setWidth(d);
                paperSize.setHeight(d2);
            }
            paperSetting.setPaperSize(paperSize);
        }
        double d = jSONObject.getDouble("margin_top");
        double d3 = jSONObject.getDouble("margin_left");
        double d4 = jSONObject.getDouble("margin_bottom");
        double d5 = jSONObject.getDouble("margin_right");
        Margin margin = new Margin();
        if (ComparatorUtils.equals(Locale.CHINA, locale)) {
            margin.setTop(BaseCoreUtils.convertMillimetersToInches(d));
            margin.setLeft(BaseCoreUtils.convertMillimetersToInches(d3));
            margin.setBottom(BaseCoreUtils.convertMillimetersToInches(d4));
            margin.setRight(BaseCoreUtils.convertMillimetersToInches(d5));
        } else {
            margin.setTop(d);
            margin.setLeft(d3);
            margin.setBottom(d4);
            margin.setRight(d5);
        }
        paperSetting.setMargin(margin);
        sessionIDInfor.setPaperSetting(n, paperSetting);
    }

    private static void writeEmailDialog(SessionIDInfor sessionIDInfor, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        EmailManager emailManager = sessionIDInfor.getEmailManager();
        if (emailManager != null) {
            hashMap.put("fromAddress", emailManager.getFromEmailAddress());
        }
        hashMap.put("parentSessionID", sessionIDInfor.getSessionID());
        ReportletDealWith.dealWithReportlet(httpServletRequest, httpServletResponse, WebletFactory.createEmbeddedReportlet("/com/fr/web/core/dialog/email.cpt", new ShowWorkBookPolicy.Policy4Form(), hashMap));
    }

    private static void submitEmailDialog(SessionIDInfor sessionIDInfor, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        int n;
        Serializable serializable;
        ConfigManager configManager = FRContext.getConfigManager();
        String string = sessionIDInfor.getReportletTitle().replaceAll("\\s", "_");
        string = Browser.resolve(httpServletRequest).getEncodedFileName4Download(string);
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        String string2 = "";
        String string3 = WebUtils.getHTTPRequestParameter(httpServletRequest, "format");
        if (string3.equalsIgnoreCase("PDF")) {
            string2 = "pdf";
        } else if (string3.equalsIgnoreCase("Excel")) {
            serializable = sessionIDInfor.getWorkBook2Show();
            n = 0;
            for (int i = 0; i < serializable.getReportCount(); ++i) {
                if (!(serializable.getReport(i) instanceof LayerReport) && !(serializable.getReport(i) instanceof LayerPageReport)) continue;
                n = 1;
                break;
            }
            string2 = n != 0 ? "zip" : "xls";
        } else if (string3.equalsIgnoreCase("SVG")) {
            string2 = "svg";
        } else if (string3.equalsIgnoreCase("HTML")) {
            string2 = "zip";
        } else if (string3.equalsIgnoreCase("CSV")) {
            string2 = "csv";
        } else if (string3.equalsIgnoreCase("Text")) {
            string2 = "txt";
        } else if (string3.equalsIgnoreCase("Word")) {
            string2 = "doc";
        }
        serializable = new File(FRContext.getCacheManager().getCacheDirectory(), "_" + System.currentTimeMillis() + File.separator + string + "." + string2);
        n = 0;
        while (((File)serializable).exists()) {
            serializable = new File(FRContext.getCacheManager().getCacheDirectory(), "_" + System.currentTimeMillis() + File.separator + string + "_" + n + "." + string2);
            ++n;
        }
        Utils.mkdirs(((File)serializable).getParentFile());
        FileOutputStream fileOutputStream = new FileOutputStream((File)serializable);
        AbstractAppExporter abstractAppExporter = null;
        if (string3.equalsIgnoreCase("PDF")) {
            abstractAppExporter = new PDFExporter();
        } else if (string3.equalsIgnoreCase("Excel")) {
            abstractAppExporter = new ExcelExporter(null);
        } else if (string3.equalsIgnoreCase("SVG")) {
            abstractAppExporter = new SVGExporter();
        } else if (string3.equalsIgnoreCase("CSV")) {
            abstractAppExporter = new CSVExporter();
        } else if (string3.equalsIgnoreCase("Text")) {
            abstractAppExporter = new TextExporter();
        } else if (string3.equalsIgnoreCase("Word")) {
            abstractAppExporter = new WordExporter();
        } else {
            ErrorHandlerHelper.getErrorHandler().error(httpServletRequest, httpServletResponse, "Cannot recognize the specifed export format:" + string3);
            return;
        }
        try {
            if (abstractAppExporter != null) {
                if (abstractAppExporter instanceof ExcelExporter) {
                    ((ExcelExporter)abstractAppExporter).export(fileOutputStream, sessionIDInfor.getWorkBook2Show(), true);
                } else {
                    object = sessionIDInfor.getPrintPreviewPageSet4Traversing();
                    abstractAppExporter.export((OutputStream)fileOutputStream, (PageSet)object);
                }
            }
            ((File)serializable).deleteOnExit();
            ((File)serializable).getParentFile().deleteOnExit();
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            printWriter.print("false");
            printWriter.flush();
            printWriter.close();
            return;
        }
        try {
            object = configManager.getReportWebAttr();
            EmailManager emailManager = ((ReportWebAttr)object).getEmailManager();
            if (emailManager != null) {
                emailManager.send(WebUtils.getHTTPRequestParameter(httpServletRequest, "to"), WebUtils.getHTTPRequestParameter(httpServletRequest, "cc"), WebUtils.getHTTPRequestParameter(httpServletRequest, "bcc"), WebUtils.getHTTPRequestParameter(httpServletRequest, "from"), WebUtils.getHTTPRequestParameter(httpServletRequest, "subject"), WebUtils.getHTTPRequestParameter(httpServletRequest, "message"), serializable);
                printWriter.print("true");
            } else {
                printWriter.print("EmailManager is null");
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            printWriter.print("false");
        }
        printWriter.flush();
        printWriter.close();
    }

    private static void readAcrobatReaderDialog(Map map, HttpServletResponse httpServletResponse) throws Exception {
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse, "UTF8");
        TemplateUtils.dealWithTemplate("/com/fr/web/core/dialog/loadAcrobatReader.html", printWriter, map);
        printWriter.flush();
        printWriter.close();
    }
}

