/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.service;

import com.fr.base.CodeUtils;
import com.fr.base.ColumnRow;
import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.FRCoreContext;
import com.fr.base.core.RSADecode;
import com.fr.base.core.html.Tag;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.util.TemplateUtils;
import com.fr.base.core.util.vt.VT4FR;
import com.fr.report.CellElement;
import com.fr.report.EditResultWorkSheet;
import com.fr.report.FloatElement;
import com.fr.report.RWorkBook;
import com.fr.report.Report;
import com.fr.report.ResultWorkBook;
import com.fr.report.core.DynamicValueList;
import com.fr.report.core.ReportHelper;
import com.fr.report.core.ReportUtils;
import com.fr.report.io.DefaultResultSaver;
import com.fr.report.io.ResultSaver;
import com.fr.report.io.TemplateImporter;
import com.fr.report.js.NameJavaScriptGroup;
import com.fr.report.script.Calculator;
import com.fr.util.Consts;
import com.fr.web.Repository;
import com.fr.web.core.ErrorHandlerHelper;
import com.fr.web.core.HTMLWriter;
import com.fr.web.core.HTMLWriterUtils;
import com.fr.web.core.ReportBackgroundDimension;
import com.fr.web.core.Service;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.core.WebUtils;
import com.fr.web.core.chwriter.EditCellWriter;
import com.fr.web.core.service.SessionDealWith;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EditService
implements Service {
    private static EditService SC = new EditService();
    private static boolean supportEdit = true;

    private EditService() {
    }

    public static EditService getInstance() {
        return SC;
    }

    public boolean accept(String string) {
        return supportEdit && string.startsWith("edit_");
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws Exception {
        SessionIDInfor sessionIDInfor = SessionDealWith.getSessionIDInfor(string2);
        if (sessionIDInfor == null) {
            ErrorHandlerHelper.getErrorHandler().error(httpServletRequest, httpServletResponse, "SessionID: \"" + string2 + "\" time out.");
            return;
        }
        if ("edit_init".equals(string)) {
            EditService.initEditPage(sessionIDInfor, httpServletRequest, httpServletResponse);
        } else if ("edit_content".equals(string)) {
            EditService.getReportContent(sessionIDInfor, httpServletRequest, httpServletResponse);
        } else if ("edit_savedata".equals(string)) {
            EditService.saveData(sessionIDInfor, httpServletRequest, httpServletResponse);
        } else if ("edit_savereport".equals(string)) {
            EditService.saveReport(sessionIDInfor, httpServletRequest, httpServletResponse);
        } else if ("edit_calcualte".equals(string)) {
            EditService.calculate(sessionIDInfor, httpServletRequest, httpServletResponse);
        }
    }

    private static void getReportContent(SessionIDInfor sessionIDInfor, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        int n = Integer.parseInt(WebUtils.getHTTPRequestParameter(httpServletRequest, "reportIndex"));
        Report report = sessionIDInfor.getReport2Show(n);
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        EditService.writeReportPane(printWriter, report, n, new Repository(httpServletRequest, sessionIDInfor));
        printWriter.flush();
        printWriter.close();
    }

    private static void writeReportPane(PrintWriter printWriter, Report report, int n, Repository repository) {
        ColumnRow columnRow;
        Tag tag = new Tag("div");
        tag.cls("sheet-container");
        if (repository.getBrowser().shouldSetOverflowAsHiddenOnSheetContainer()) {
            tag.css("overflow", "hidden");
        }
        HTMLWriter hTMLWriter = HTMLWriter.getInstance();
        ColumnRow columnRow2 = columnRow = report.getReportPageAttr() == null ? null : report.getReportPageAttr().getFreezeColumnRow();
        if (columnRow != null) {
            hTMLWriter.writeFrozenContent(tag, report, columnRow, n, new EditCellWriter(repository, n), repository);
        } else {
            Tag tag2 = hTMLWriter.writeJSReport(report, n, new EditCellWriter(repository, n), repository);
            DynamicValueList dynamicValueList = ReportHelper.getColumnWidthList(report);
            DynamicValueList dynamicValueList2 = ReportHelper.getRowHeightList(report);
            int n2 = Math.max(dynamicValueList.getRangeValueFromZero(report.getColumnCount()), 1);
            int n3 = Math.max(dynamicValueList2.getRangeValueFromZero(report.getRowCount()), 1);
            Tag tag3 = new Tag("div").cls("fr-edit-sheetcontent-container");
            HTMLWriterUtils.writeBackground(tag3, ReportUtils.getReportSettings(report).getBackground(), new ReportBackgroundDimension(n2 + 5, n3 + 5), false, repository, false);
            tag3.sub(tag2);
            tag.sub(tag3);
            Iterator iterator = report.floatIterator();
            while (iterator.hasNext()) {
                FloatElement floatElement = (FloatElement)iterator.next();
                Tag tag4 = null;
                NameJavaScriptGroup nameJavaScriptGroup = floatElement.getNameHyperlinkGroup();
                if (nameJavaScriptGroup != null && nameJavaScriptGroup.size() > 0) {
                    tag4 = new Tag("span");
                    String string = "{}";
                    try {
                        string = HTMLWriterUtils.writeJSLinkContent(nameJavaScriptGroup, repository);
                    }
                    catch (JSONException jSONException) {
                        FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
                    }
                    tag4.attr("onclick", "FR.doHyperlink(event ||window.event," + string + ")");
                    tag4.css("cursor", "pointer");
                }
                int n4 = dynamicValueList.getRangeValueFromZero(floatElement.getColumn()) + floatElement.getLeftDistance();
                int n5 = dynamicValueList2.getRangeValueFromZero(floatElement.getRow()) + floatElement.getTopDistance();
                int n6 = floatElement.getSize().width + 1;
                int n7 = floatElement.getSize().height + 1;
                n2 = Math.max(n2, n4 + n6);
                n3 = Math.max(n3, n5 + n7);
                Tag tag5 = new Tag("div");
                if (tag4 == null) {
                    tag4 = tag5;
                } else {
                    tag4.sub(tag5);
                }
                tag3.sub(tag4);
                tag5.css("overflow", "hidden");
                tag5.css("position", "absolute");
                tag5.css("left", n4 + "px");
                tag5.css("top", n5 + "px");
                tag5.css("width", n6 + "px");
                tag5.css("height", n7 + "px");
                tag5.sub(floatElement.toTag(repository));
            }
            tag3.css("width", n2 + 5 + "px").css("height", n3 + 5 + "px");
        }
        tag.writeHtml(printWriter);
    }

    private static void initEditPage(SessionIDInfor sessionIDInfor, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Map map = WebUtils.context4CommonPaneTpl(httpServletRequest, sessionIDInfor);
        Repository repository = new Repository(httpServletRequest, sessionIDInfor);
        int n = sessionIDInfor.getReportCount();
        JSONArray jSONArray = new JSONArray();
        for (int i = 0; i < n; ++i) {
            jSONArray.put(new JSONObject().put("title", sessionIDInfor.getReportName(i)));
        }
        map.put("sheets", jSONArray);
        map.put("browserbg", HTMLWriterUtils.jsonBackground(ReportUtils.getBrowserBackgroundFromWorkBook(sessionIDInfor.getContextBook()), repository));
        try {
            TemplateUtils.dealWithTemplate("/com/fr/web/core/edit.html", httpServletResponse, map);
        }
        catch (IOException iOException) {
            FRContext.getLogger().log(Level.WARNING, iOException.getMessage(), iOException);
        }
    }

    private static void saveReport(SessionIDInfor sessionIDInfor, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        boolean bl = false;
        try {
            EditService.saveData(sessionIDInfor, httpServletRequest, httpServletResponse);
            object = sessionIDInfor.getWorkBook2Show();
            String string = FRContext.getConfigManager().getResultSaverClassName();
            ResultSaver resultSaver = null;
            if (StringUtils.isBlank(string)) {
                resultSaver = DefaultResultSaver.getInstance();
            } else {
                Object var7_8 = null;
                try {
                    Class clazz = FRCoreContext.classForName(string);
                    var7_8 = clazz.newInstance();
                }
                catch (Exception exception) {
                    FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                }
                if (var7_8 instanceof ResultSaver) {
                    resultSaver = var7_8;
                }
            }
            for (int i = 0; i < object.getReportCount(); ++i) {
                object.getResultReport(i).recalculate(sessionIDInfor.getParameterMap4Execute());
            }
            if (resultSaver != null) {
                resultSaver.save((ResultWorkBook)object, sessionIDInfor.getReportletTitle(), Collections.EMPTY_MAP);
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
            throw exception;
        }
        object = WebUtils.createPrintWriter(httpServletResponse);
        ((PrintWriter)object).print(bl ? "success" : "failure");
        ((PrintWriter)object).flush();
        ((PrintWriter)object).close();
    }

    private static void saveData(SessionIDInfor sessionIDInfor, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "editReportXML");
        if (string != null && string.length() > 0) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
            RWorkBook rWorkBook = new TemplateImporter().generateResult(byteArrayInputStream);
            ResultWorkBook resultWorkBook = sessionIDInfor.getWorkBook2Show();
            int n = rWorkBook.getReportCount();
            for (int i = 0; i < n; ++i) {
                Report report = rWorkBook.getReport(i);
                Report report2 = resultWorkBook.getReport(Integer.valueOf(rWorkBook.getReportName(i)));
                Iterator iterator = report.cellIterator();
                while (iterator.hasNext()) {
                    EditResultWorkSheet.EditCellELement editCellELement = (EditResultWorkSheet.EditCellELement)iterator.next();
                    CellElement cellElement = report2.getCellElement(editCellELement.getColumn(), editCellELement.getRow());
                    editCellELement.checkDirtyValueAndStyle(cellElement, report2);
                }
            }
        }
    }

    private static void calculate(SessionIDInfor sessionIDInfor, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "ptype");
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "pcontent");
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        Object[] objectArray = new Object[1];
        if ("parameter".equals(string)) {
            Object object = sessionIDInfor.getParameterValue(string2);
            objectArray[0] = CodeUtils.object2JSONable(object);
        } else if ("expression".equals(string)) {
            Calculator calculator = Calculator.createCalculator();
            calculator.setCurrentTableDataSource(sessionIDInfor.getContextBook());
            objectArray[0] = CodeUtils.object2JSONable(calculator.eval(string2));
        }
        new JSONArray(objectArray).write(printWriter);
        printWriter.flush();
        printWriter.close();
    }

    static {
        byte[] byArray = FRCoreContext.getBytes();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            RSADecode.decode(byArray, (OutputStream)byteArrayOutputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            JSONObject jSONObject = new JSONObject(new String(byteArrayOutputStream.toByteArray(), "UTF-8"));
            supportEdit = jSONObject.getLong("deadline") > Calendar.getInstance().getTimeInMillis() && jSONObject.has("version") && ComparatorUtils.equals(Consts.VERSION, jSONObject.getString("version")) && (jSONObject.getLong("deadline") - Calendar.getInstance().getTimeInMillis() < 3153600000L || jSONObject.has("macaddress") && BaseCoreUtils.getMacAddresses().contains(jSONObject.getString("macaddress"))) && VT4FR.ONLINE_EDIT.support();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

