/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.service;

import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.report.PageSet;
import com.fr.report.core.cal.LayerPageReport;
import com.fr.report.core.cal.LayerReport;
import com.fr.report.io.AbstractAppExporter;
import com.fr.report.io.CSVExporter;
import com.fr.report.io.ExcelExporter;
import com.fr.report.io.PDFExporter;
import com.fr.report.io.SVGExporter;
import com.fr.report.io.TextExporter;
import com.fr.report.web.EmailManager;
import com.fr.util.Utils;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.core.WebUtils;
import com.fr.web.core.service.NoOPService;
import com.fr.web.core.service.SessionDealWith;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EmailService
extends NoOPService {
    private static EmailService EMAIL_SERVICE = new EmailService();

    private EmailService() {
    }

    public static EmailService getInstance() {
        return EMAIL_SERVICE;
    }

    public boolean accept(String string) {
        return string.equals("email");
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        Object object;
        int n;
        Serializable serializable;
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.println("<html><head>");
        printWriter.println("<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\">");
        printWriter.println("<link rel='stylesheet' href='" + WebUtils.createServletURL(httpServletRequest) + "?op=resource&resource=/com/fr/web/core/reportPage.css' type='text/css'>");
        printWriter.println("<title>" + Inter.getLocText("Email") + "</title>");
        printWriter.println("</head><body>");
        SessionIDInfor sessionIDInfor = SessionDealWith.getSessionIDInfor(string);
        if (sessionIDInfor == null) {
            return;
        }
        String string2 = "";
        String string3 = WebUtils.getHTTPRequestParameter(httpServletRequest, "format");
        if (string3.equalsIgnoreCase("PDF")) {
            string2 = "pdf";
        } else if (string3.equalsIgnoreCase("Excel")) {
            serializable = sessionIDInfor.getWorkBook2Show();
            n = 0;
            for (int i = 0; i < serializable.getReportCount(); ++i) {
                if (!(serializable.getResultReport(i) instanceof LayerReport) && !(serializable.getResultReport(i) instanceof LayerPageReport)) continue;
                n = 1;
                break;
            }
            string2 = n != 0 ? "zip" : "xls";
        } else if (string3.equalsIgnoreCase("SVG")) {
            string2 = "svg";
        } else if (string3.equalsIgnoreCase("HTML")) {
            string2 = "zip";
        } else if (string3.equalsIgnoreCase("CSV")) {
            string2 = "csv";
        } else if (string3.equalsIgnoreCase("Text")) {
            string2 = "txt";
        }
        serializable = new File(FRContext.getCacheManager().getCacheDirectory(), "_" + System.currentTimeMillis() + File.separator + "report." + string2);
        n = 0;
        while (((File)serializable).exists()) {
            serializable = new File(FRContext.getCacheManager().getCacheDirectory(), "_" + System.currentTimeMillis() + File.separator + "report_" + n + "." + string2);
            ++n;
        }
        Utils.mkdirs(((File)serializable).getParentFile());
        FileOutputStream fileOutputStream = new FileOutputStream((File)serializable);
        AbstractAppExporter abstractAppExporter = null;
        if (string3.equalsIgnoreCase("PDF")) {
            abstractAppExporter = new PDFExporter();
        } else if (string3.equalsIgnoreCase("Excel")) {
            abstractAppExporter = new ExcelExporter(null);
        } else if (string3.equalsIgnoreCase("SVG")) {
            abstractAppExporter = new SVGExporter();
        } else if (string3.equalsIgnoreCase("CSV")) {
            abstractAppExporter = new CSVExporter();
        } else if (string3.equalsIgnoreCase("Text")) {
            abstractAppExporter = new TextExporter();
        }
        try {
            if (abstractAppExporter != null) {
                if (abstractAppExporter instanceof ExcelExporter) {
                    ((ExcelExporter)abstractAppExporter).export(fileOutputStream, sessionIDInfor.getWorkBook2Show(), true);
                } else {
                    object = sessionIDInfor.getPrintPreviewPageSet4Traversing();
                    abstractAppExporter.export((OutputStream)fileOutputStream, (PageSet)object);
                }
            }
            ((File)serializable).deleteOnExit();
            ((File)serializable).getParentFile().deleteOnExit();
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            printWriter.println("<form><input type=\"button\" value=\"Back\" onClick=\"history.back();\">");
            printWriter.println("<input type=\"button\" value=\"Close\" onClick=\"window.close();\"></form>");
            printWriter.println("<pre>");
            exception.printStackTrace(printWriter);
            printWriter.println("</pre>");
            printWriter.println("<br>");
            printWriter.println("</body></html>");
            printWriter.flush();
            printWriter.close();
            return;
        }
        try {
            object = sessionIDInfor.getEmailManager();
            if (object == null) {
                throw new Exception("Email Config needed.");
            }
            ((EmailManager)object).send(WebUtils.getHTTPRequestParameter(httpServletRequest, "to"), WebUtils.getHTTPRequestParameter(httpServletRequest, "cc"), WebUtils.getHTTPRequestParameter(httpServletRequest, "bcc"), WebUtils.getHTTPRequestParameter(httpServletRequest, "from"), WebUtils.getHTTPRequestParameter(httpServletRequest, "subject"), WebUtils.getHTTPRequestParameter(httpServletRequest, "message"), serializable);
            printWriter.println("Send successfully...<br>");
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            printWriter.println("<form><input type=\"button\" value=\"Back\" onClick=\"history.back();\">");
            printWriter.println("<input type=\"button\" value=\"Close\" onClick=\"window.close();\"></form>");
            printWriter.println("<p>");
            printWriter.println("<pre>");
            printWriter.println("Send failed...");
            exception.printStackTrace(printWriter);
            printWriter.println("</pre>");
            printWriter.println("</body></html>");
            printWriter.flush();
            printWriter.close();
            return;
        }
        printWriter.println("<form><input type=\"button\" value=\"Back\" onClick=\"history.back();\">");
        printWriter.println("<input type=\"button\" value=\"Close\" onClick=\"window.close();\"></form>");
        printWriter.println("</body></html>");
        printWriter.flush();
        printWriter.close();
    }
}

