/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.service;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.base.core.util.TemplateUtils;
import com.fr.web.Browser;
import com.fr.web.core.WebUtils;
import com.fr.web.core.service.NoSessionIDOPService;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EmbResourceService
extends NoSessionIDOPService {
    public static final String DEFAULT_JS_NAME = "finereport.js";
    public static final String TOOLBAR_CSS_NAME = "toolbar.css";
    public static final String DEFAULT_CSS_NAME = "finereport.css";
    private static String defaultJs = null;
    private static String defaultCss = null;
    private static EmbResourceService EMBRESOURCE_SERVICE = new EmbResourceService();

    private EmbResourceService() {
    }

    public static EmbResourceService getInstance() {
        return EMBRESOURCE_SERVICE;
    }

    public boolean accept(String string) {
        return string.equals("emb");
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        EmbResourceService.dealWithEmbResource(httpServletRequest, httpServletResponse);
    }

    public static void dealWithEmbResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "resource");
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        httpServletResponse.setHeader("Cache-Control", "max-age=86400");
        httpServletResponse.setDateHeader("Expires", System.currentTimeMillis() + 86400000L);
        String string2 = FRContext.getConfigManager().getServerCharset();
        if (DEFAULT_JS_NAME.equals(string)) {
            httpServletResponse.setContentType("text/javascript;charset=" + string2);
            Map map = WebUtils.createTemplateMap(httpServletRequest);
            TemplateUtils.dealWithTemplate(new StringReader(EmbResourceService.createDefaultJs()), printWriter, map);
        } else if (DEFAULT_CSS_NAME.equals(string)) {
            httpServletResponse.setContentType("text/css;charset=" + string2);
            Map map = WebUtils.createTemplateMap(httpServletRequest);
            TemplateUtils.dealWithTemplate(new StringReader(EmbResourceService.createDefaultCss()), printWriter, map);
        } else if (TOOLBAR_CSS_NAME.equals(string)) {
            String string3 = EmbResourceService.createToolbarCss(httpServletRequest);
            httpServletResponse.setContentType("text/css;charset=" + string2);
            if (string3 == null) {
                string3 = "";
            }
            printWriter.write(string3);
        }
        printWriter.flush();
        printWriter.close();
    }

    public static String createDefaultJs() throws Exception {
        if (defaultJs != null) {
            return defaultJs;
        }
        String[] stringArray = new String[]{"/com/fr/web/jquery.js", "/com/fr/web/load.js", "/com/fr/web/core/js/i18n.js", "/com/fr/web/core/js/events.js", "/com/fr/web/core/js/jquery.hotkeys.js", "/com/fr/web/core/js/ui/jquery.ui.core.js", "/com/fr/web/core/js/ui/jquery.ui.widget.js", "/com/fr/web/core/js/ui/jquery.ui.mouse.js", "/com/fr/web/core/js/ui/jquery.ui.position.js", "/com/fr/web/core/js/ui/jquery.ui.draggable.js", "/com/fr/web/core/js/ui/jquery.ui.resizable.js", "/com/fr/web/core/js/ui/jquery.ui.button.js", "/com/fr/web/core/js/ui/jquery.ui.dialog.js", "/com/fr/web/core/js/ui/jquery.ui.tabs.js", "/com/fr/web/core/js/jLayout.js", "/com/fr/web/core/js/jquery.sizes.js", "/com/fr/web/core/js/jquery.jlayout.js", "/com/fr/web/core/js/jquery.menu.js", "/com/fr/web/core/js/jquery.ux.js", "/com/fr/web/core/js/jquery.ux.date.js", "/com/fr/web/core/js/form/fr.form.panel.js", "/com/fr/web/core/js/form/fr.form.layout.border.js", "/com/fr/web/core/js/form/fr.form.tabs.js"};
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(BaseUtils.readResourceAsString(stringArray[i]));
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(";");
        }
        defaultJs = stringBuffer.toString();
        return defaultJs;
    }

    public static void setDefaultJS(String string) {
        defaultJs = string;
    }

    private static String createDefaultCss() throws Exception {
        if (defaultCss != null) {
            return defaultCss;
        }
        String[] stringArray = new String[]{"/com/fr/web/core/css/page.css", "/com/fr/web/core/css/redmond/jquery-ui.custom.css", "/com/fr/web/core/css/widget/fr.form.panel.css", "/com/fr/web/core/css/widget/fr.form.tabs.css", "/com/fr/web/core/css/widget/fr.form.borderlayout.css", "/com/fr/web/core/css/widget/fr.form.widget.css", "/com/fr/web/core/css/jquery.menu.css", "/com/fr/web/core/css/jquery.ux.css"};
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(BaseUtils.readResourceAsString(stringArray[i]));
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append("\n");
        }
        defaultCss = stringBuffer.toString();
        return defaultCss;
    }

    private static String createToolbarCss(HttpServletRequest httpServletRequest) {
        return FRContext.getWidgetManager().getIconManager().getCssFile(WebUtils.createServletURL(httpServletRequest), Browser.resolve(httpServletRequest));
    }
}

