/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.service;

import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.xml.BaseXMLUtils;
import com.fr.base.xml.XMLFileReader;
import com.fr.report.PageSet;
import com.fr.report.ResultWorkBook;
import com.fr.report.core.cal.LayerPageReport;
import com.fr.report.core.cal.LayerReport;
import com.fr.report.io.AbstractAppExporter;
import com.fr.report.io.CSVExporter;
import com.fr.report.io.ExcelExporter;
import com.fr.report.io.LargeDataPageExcelExporter;
import com.fr.report.io.PDFExporter;
import com.fr.report.io.PDFExporter2;
import com.fr.report.io.PageExcelExporter;
import com.fr.report.io.PageToSheetExcelExporter;
import com.fr.report.io.SVGExporter;
import com.fr.report.io.TextExporter;
import com.fr.report.io.WordExporter;
import com.fr.schedule.ViewScheduleSavedInfo;
import com.fr.schedule.util.ScheduleUtils;
import com.fr.util.Utils;
import com.fr.web.Browser;
import com.fr.web.core.ErrorHandlerHelper;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.core.WebUtils;
import com.fr.web.core.service.NoOPService;
import com.fr.web.core.service.SessionDealWith;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExportService
extends NoOPService {
    private static ExportService EXPORT_SERVICE = new ExportService();

    private ExportService() {
    }

    public static ExportService getInstance() {
        return EXPORT_SERVICE;
    }

    public boolean accept(String string) {
        return string.equals("export");
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        ExportService.dealWithExport(httpServletRequest, httpServletResponse, string, false);
    }

    public static void dealScheduleExport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "format");
        if (StringUtils.isBlank(string)) {
            return;
        }
        Map map = WebUtils.createSessionIDParameterMap(httpServletRequest);
        File file = ScheduleUtils.getScheduleSavaPathFile(map);
        Map map2 = ScheduleUtils.getParaMap(map);
        if (file.exists() && file.isDirectory()) {
            File file2 = new File(file, "info.xml");
            if (!file2.exists()) {
                return;
            }
            ViewScheduleSavedInfo viewScheduleSavedInfo = new ViewScheduleSavedInfo();
            try {
                viewScheduleSavedInfo = (ViewScheduleSavedInfo)BaseXMLUtils.readXMLFile(new FileInputStream(file2), (XMLFileReader)viewScheduleSavedInfo);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            String string2 = null;
            if (StringUtils.isNotEmpty(WebUtils.getHTTPRequestParameter(httpServletRequest, "fileName"))) {
                string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "fileName");
            }
            httpServletResponse.reset();
            httpServletResponse.setHeader("Cache-Control", "public");
            httpServletResponse.setHeader("Cache-Control", "max-age=3");
            if (string.equalsIgnoreCase("excel")) {
                string2 = StringUtils.isEmpty(string2) ? viewScheduleSavedInfo.getExcelName(map2) : string2;
                httpServletResponse.setContentType("application/x-excel");
                httpServletResponse.setHeader("extension", "xls");
                httpServletResponse.setHeader("Content-disposition", "attachment; filename=download.xls");
            } else if (string.equalsIgnoreCase("word")) {
                string2 = StringUtils.isEmpty(string2) ? viewScheduleSavedInfo.getWordName(map2) : string2;
                httpServletResponse.setContentType("application/msword");
                httpServletResponse.setHeader("extension", "doc");
                httpServletResponse.setHeader("Content-disposition", "attachment; filename=download.doc");
            } else if (string.equalsIgnoreCase("pdf")) {
                string2 = StringUtils.isEmpty(string2) ? viewScheduleSavedInfo.getPDFName(map2) : string2;
                httpServletResponse.setContentType("application/pdf");
                httpServletResponse.setHeader("extension", "pdf");
                httpServletResponse.setHeader("Content-disposition", "attachment; filename=download.pdf");
            } else {
                return;
            }
            File file3 = new File(file, string2);
            if (file3.exists()) {
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                servletOutputStream.write(Utils.inputStream2Bytes(new FileInputStream(file3)));
                servletOutputStream.flush();
                servletOutputStream.close();
            }
        }
    }

    public static void dealWithExport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, boolean bl) throws Exception {
        AbstractAppExporter abstractAppExporter;
        String string2;
        SessionIDInfor sessionIDInfor;
        if (string == null) {
            string = WebUtils.getHTTPRequestParameter(httpServletRequest, "sessionID");
        }
        if ((sessionIDInfor = SessionDealWith.getSessionIDInfor(string)) == null) {
            return;
        }
        String string3 = WebUtils.getHTTPRequestParameter(httpServletRequest, "format");
        httpServletResponse.reset();
        String string4 = WebUtils.getHTTPRequestParameter(httpServletRequest, "__filename__");
        if (string4 == null) {
            string4 = sessionIDInfor.getReportletTitle().replaceAll("\\s", "_");
        }
        Browser browser = Browser.resolve(httpServletRequest);
        string4 = browser.getEncodedFileName4Download(string4);
        httpServletResponse.setHeader("Cache-Control", "public");
        httpServletResponse.setHeader("Cache-Control", "max-age=3");
        if (string3.equalsIgnoreCase("PDF")) {
            httpServletResponse.setContentType("application/pdf");
            httpServletResponse.setHeader("extension", "pdf");
            if (bl) {
                httpServletResponse.setHeader("Content-disposition", "anyword; filename=" + string4 + ".pdf");
            } else {
                httpServletResponse.setHeader("Content-disposition", "attachment; filename=" + string4 + ".pdf");
            }
            string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "extype");
            boolean bl2 = ComparatorUtils.equals(WebUtils.getHTTPRequestParameter(httpServletRequest, "isPDFPrint"), "true");
            sessionIDInfor.setAttribute("genpdfprint", new Boolean(bl2));
            abstractAppExporter = "rs".equals(string2) ? new PDFExporter2(bl2) : new PDFExporter(bl2);
        } else if (string3.equalsIgnoreCase("Excel")) {
            string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "extype");
            ResultWorkBook resultWorkBook = sessionIDInfor.getWorkBook2Show();
            boolean bl3 = true;
            for (int i = 0; i < resultWorkBook.getReportCount(); ++i) {
                if (!(resultWorkBook.getReport(i) instanceof LayerReport) && !(resultWorkBook.getReport(i) instanceof LayerPageReport)) continue;
                if ("simple".equals(string2)) {
                    bl3 = false;
                }
                if ("sheet".equals(string2)) break;
                string2 = "ldpage";
                break;
            }
            if ("ldpage".equals(string2)) {
                if (browser.shouldSetContentTypeOnZipDownload()) {
                    httpServletResponse.setContentType("application/zip");
                }
                httpServletResponse.setHeader("extension", "zip");
                httpServletResponse.setHeader("Content-disposition", "attachment; filename=" + string4 + ".zip");
                abstractAppExporter = new LargeDataPageExcelExporter(sessionIDInfor.getPaperSettingList(), bl3);
            } else {
                httpServletResponse.setContentType("application/x-excel");
                httpServletResponse.setHeader("extension", "xls");
                httpServletResponse.setHeader("Content-disposition", "attachment; filename=" + string4 + ".xls");
                abstractAppExporter = "simple".equals(string2) ? new ExcelExporter(sessionIDInfor.getPaperSettingList()) : ("sheet".equals(string2) ? new PageToSheetExcelExporter(sessionIDInfor.getPaperSettingList()) : new PageExcelExporter(sessionIDInfor.getPaperSettingList()));
            }
        } else if (string3.equalsIgnoreCase("Word")) {
            httpServletResponse.setContentType("application/msword");
            httpServletResponse.setHeader("extension", "doc");
            httpServletResponse.setHeader("Content-disposition", "attachment; filename=" + string4 + ".doc");
            abstractAppExporter = new WordExporter();
        } else if (string3.equalsIgnoreCase("SVG")) {
            httpServletResponse.setContentType("image/svg+xml");
            httpServletResponse.setHeader("extension", "svg");
            httpServletResponse.setHeader("Content-disposition", "attachment; filename=" + string4 + ".svg");
            abstractAppExporter = new SVGExporter();
        } else if (string3.equalsIgnoreCase("CSV")) {
            httpServletResponse.setContentType("application/octet-stream");
            httpServletResponse.setHeader("extension", "csv");
            httpServletResponse.setHeader("Content-disposition", "attachment; filename=" + string4 + ".csv");
            abstractAppExporter = new CSVExporter();
        } else if (string3.equalsIgnoreCase("Text")) {
            httpServletResponse.setContentType("application/octet-stream");
            httpServletResponse.setHeader("extension", "txt");
            httpServletResponse.setHeader("Content-disposition", "attachment; filename=" + string4 + ".txt");
            abstractAppExporter = new TextExporter();
        } else {
            ErrorHandlerHelper.getErrorHandler().error(httpServletRequest, httpServletResponse, "Cannot recognize the specifed export format:" + string3);
            return;
        }
        string2 = httpServletResponse.getOutputStream();
        try {
            if (abstractAppExporter instanceof ExcelExporter) {
                ((ExcelExporter)abstractAppExporter).export((OutputStream)((Object)string2), sessionIDInfor.getWorkBook2Show(), true);
            } else {
                PageSet pageSet = sessionIDInfor.getPrintPreviewPageSet4Traversing();
                abstractAppExporter.export((OutputStream)((Object)string2), pageSet);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            ErrorHandlerHelper.getErrorHandler().error(httpServletRequest, httpServletResponse, exception);
        }
        try {
            ((OutputStream)((Object)string2)).flush();
            ((OutputStream)((Object)string2)).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        sessionIDInfor.setAttribute("genpdfprint", new Boolean(false));
    }
}

