/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.service;

import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.util.TemplateUtils;
import com.fr.base.file.FaceManager;
import com.fr.privilege.authentication.Authentication;
import com.fr.privilege.authentication.AuthenticationFactory;
import com.fr.web.core.WebUtils;
import com.fr.web.core.service.NoSessionIDOPService;
import com.fr.web.face.FaceNode;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSService
extends NoSessionIDOPService {
    private static FSService FSSERVICE = new FSService();

    private FSService() {
    }

    public static FSService getInstance() {
        return FSSERVICE;
    }

    public boolean accept(String string) {
        return "fs".equals(string);
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        FaceManager faceManager = FRContext.getFaceManager();
        if (faceManager != null) {
            try {
                Authentication authentication = AuthenticationFactory.extractAuthentication(httpServletRequest);
                FaceNode faceNode = faceManager.getRootFaceNode();
                Map map = WebUtils.createTemplateMap(httpServletRequest);
                if (authentication != null && authentication.getPrincipal() != null) {
                    map.put("username", Inter.getLocText("Username") + ":" + authentication.getPrincipal().toString());
                    map.put("loginout", FSService.createLoginoutHtml(map, httpServletRequest, httpServletResponse));
                } else {
                    map.put("username", Inter.getLocText("Username") + ":" + "administrator");
                }
                map.put("charset", FRContext.getConfigManager().getServerCharset());
                JSONArray jSONArray = new JSONArray();
                if (faceNode.getChildCount() > 0) {
                    for (int i = 0; i < faceNode.getChildCount(); ++i) {
                        FaceNode faceNode2 = faceNode.getChild(i);
                        JSONObject jSONObject = faceNode2.toJSONConfig(httpServletRequest, authentication, faceManager, "1", i + 1);
                        if (jSONObject == null) continue;
                        jSONArray.put(jSONObject);
                    }
                }
                if (jSONArray.length() == 0) {
                    map.put("warning", "warning");
                }
                map.put("trees", jSONArray.toString());
                if (faceManager.isShowHomePage() && faceManager.getHomeURLPath() != null) {
                    map.put("home", faceManager.getHomeURLPath());
                }
                if (faceManager.getHomeTitle() != null) {
                    map.put("homeTitle", faceManager.getHomeTitle());
                }
                map.put("fsdirectory", Inter.getLocText("Folder"));
                map.put("fscontent", Inter.getLocText("Content"));
                TemplateUtils.dealWithTemplate("com/fr/web/face/face.html", httpServletResponse, map);
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, "Error happens when deal with op=face", exception);
            }
        }
    }

    private static String createLoginoutHtml(Map map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<a href='");
        stringBuffer.append("${servletURL}?op=auth_logout'>");
        stringBuffer.append(Inter.getLocText("Logout"));
        stringBuffer.append("</a>");
        return TemplateUtils.render(stringBuffer.toString(), map);
    }
}

