/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.service;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.FRCoreContext;
import com.fr.base.core.RSADecode;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.list.IntList;
import com.fr.base.core.util.vt.VT4FR;
import com.fr.report.ArrayPageSet;
import com.fr.report.PaperSetting;
import com.fr.report.PaperSize;
import com.fr.report.ReportPage;
import com.fr.report.io.SWFExporter;
import com.fr.util.Consts;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.core.WebUtils;
import com.fr.web.core.service.NoSessionIDService;
import com.fr.web.core.service.SessionDealWith;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Calendar;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FlashPrintService
extends NoSessionIDService {
    private static boolean flashPrintable = true;
    private static FlashPrintService FLASHPRINT_SERVICE;

    private FlashPrintService() {
    }

    public static FlashPrintService getInstance() {
        return FLASHPRINT_SERVICE;
    }

    public boolean accept(String string) {
        return string.startsWith("flash_") || string.equals("png_print");
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        if (string.equals("flash_getflashprintsetting")) {
            FlashPrintService.dealWithGetFlashPrintSetting(httpServletResponse);
        } else if (string.equals("flash_getflashinstallpath")) {
            FlashPrintService.dealWithGetFlashInstallPath(httpServletRequest, httpServletResponse);
        } else if (string.equals("flash_getpageinfo")) {
            FlashPrintService.dealWithGetPageInfo(httpServletRequest, httpServletResponse);
        } else if (string.equals("flash_print")) {
            FlashPrintService.dealWithPaintReportPage(httpServletRequest, httpServletResponse, true);
        } else if (string.equals("png_print")) {
            FlashPrintService.dealWithPaintReportPage(httpServletRequest, httpServletResponse, false);
        }
    }

    public static void dealWithPaintReportPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) throws Exception {
        SessionIDInfor sessionIDInfor;
        if (!flashPrintable) {
            return;
        }
        httpServletResponse.setHeader("Cache-Control", "private");
        httpServletResponse.setHeader("Cache-Control", "max-age=1");
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "sessionID");
        int n = 0;
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "pn");
        if (string2 != null) {
            n = Integer.parseInt(string2);
        }
        if ((sessionIDInfor = SessionDealWith.getSessionIDInfor(string)) == null) {
            FlashPrintService.resFlashDone(httpServletResponse);
            return;
        }
        ReportPage reportPage = sessionIDInfor.getPrintPreviewReportPage(n);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        if (bl) {
            httpServletResponse.setContentType("application/x-shockwave-flash");
            new SWFExporter().export((OutputStream)servletOutputStream, new ArrayPageSet(new ReportPage[]{reportPage}, false));
        } else {
            httpServletResponse.setContentType("image/png");
            BaseUtils.writeImage(reportPage.toImage(), "png", (OutputStream)servletOutputStream);
        }
        servletOutputStream.flush();
        try {
            servletOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void dealWithGetPageInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        if (!flashPrintable) {
            printWriter.write("failpass");
            printWriter.flush();
            printWriter.close();
            return;
        }
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "sessionID");
        SessionIDInfor sessionIDInfor = SessionDealWith.getSessionIDInfor(string);
        StringBuffer stringBuffer = new StringBuffer();
        int n = sessionIDInfor.getPrintPageCount();
        stringBuffer.append(n);
        IntList intList = sessionIDInfor.getPrintPageSetChainPageInfo();
        if (intList != null && intList.size() == sessionIDInfor.getWorkBook2Show().getReportCount()) {
            for (int i = 0; i < intList.size(); ++i) {
                int n2;
                int n3;
                PaperSetting paperSetting = sessionIDInfor.getPagerSetting(i);
                if (paperSetting == null) {
                    paperSetting = new PaperSetting();
                }
                PaperSize paperSize = paperSetting.getPaperSize();
                if (paperSetting.getOrientation() == 1) {
                    n3 = (int)(paperSize.getHeight() * 72.0);
                    n2 = (int)(paperSize.getWidth() * 72.0);
                } else {
                    n3 = (int)(paperSize.getWidth() * 72.0);
                    n2 = (int)(paperSize.getHeight() * 72.0);
                }
                if (i == 0) {
                    stringBuffer.append(";");
                } else {
                    stringBuffer.append("&");
                }
                stringBuffer.append(intList.get(i)).append(":").append(n3).append(",").append(n2);
            }
        }
        printWriter.write(stringBuffer.toString());
        printWriter.flush();
        printWriter.close();
    }

    private static void resFlashDone(HttpServletResponse httpServletResponse) throws Exception {
        httpServletResponse.setContentType("text/plain");
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.print("done");
        printWriter.flush();
        printWriter.close();
    }

    public static void dealWithGetFlashPrintSetting(HttpServletResponse httpServletResponse) throws Exception {
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.write(FRContext.getConfigManager().isPopupFlashPrintSetting() + "");
        printWriter.flush();
        printWriter.close();
    }

    public static void dealWithGetFlashInstallPath(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.write("");
        printWriter.flush();
        printWriter.close();
    }

    static {
        byte[] byArray = FRCoreContext.getBytes();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            RSADecode.decode(byArray, (OutputStream)byteArrayOutputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            JSONObject jSONObject = new JSONObject(new String(byteArrayOutputStream.toByteArray(), "UTF-8"));
            flashPrintable = jSONObject.getLong("deadline") > Calendar.getInstance().getTimeInMillis() && jSONObject.has("version") && ComparatorUtils.equals(Consts.VERSION, jSONObject.getString("version")) && (jSONObject.getLong("deadline") - Calendar.getInstance().getTimeInMillis() < 3153600000L || jSONObject.has("macaddress") && BaseCoreUtils.getMacAddresses().contains(jSONObject.getString("macaddress"))) && VT4FR.FLASH_PRINT.support();
        }
        catch (Exception exception) {
            // empty catch block
        }
        FLASHPRINT_SERVICE = new FlashPrintService();
    }
}

