/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.service;

import com.fr.base.ColumnRow;
import com.fr.base.core.html.Tag;
import com.fr.report.Report;
import com.fr.report.ReportWebAttr;
import com.fr.report.SheetPage;
import com.fr.report.core.ReportUtils;
import com.fr.web.Repository;
import com.fr.web.core.ErrorHandlerHelper;
import com.fr.web.core.Service;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.core.TreeHTMLConverter;
import com.fr.web.core.WebUtils;
import com.fr.web.core.chwriter.FormCellWriter;
import com.fr.web.core.service.SessionDealWith;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FormService
implements Service {
    private static FormService FORM_SERVICE = new FormService();

    private FormService() {
    }

    public static FormService getInstance() {
        return FORM_SERVICE;
    }

    public boolean accept(String string) {
        return string.startsWith("form_");
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws Exception {
        if ("form_content".equals(string)) {
            FormService.readFormContent(string, string2, httpServletRequest, httpServletResponse);
        }
    }

    private static void readFormContent(String string, String string2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Tag tag;
        SessionIDInfor sessionIDInfor = SessionDealWith.getSessionIDInfor(string2);
        if (sessionIDInfor == null) {
            ErrorHandlerHelper.getErrorHandler().error(httpServletRequest, httpServletResponse, "SessionID: \"" + string2 + "\" time out.");
            return;
        }
        int n = Integer.parseInt(WebUtils.getHTTPRequestParameter(httpServletRequest, "reportIndex"));
        Report report = sessionIDInfor.getReport2Show(n);
        SheetPage sheetPage = new SheetPage(report);
        ColumnRow columnRow = null;
        if (report.getReportSettings() != null && report.getReportSettings().getWriteFrozenColumnRow() != null) {
            columnRow = report.getReportSettings().getWriteFrozenColumnRow();
        }
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        Tag tag2 = new Tag("div").cls("formContentDIV");
        Repository repository = new Repository(httpServletRequest, sessionIDInfor);
        ReportWebAttr reportWebAttr = repository.getSessionIDInfor().getContextBook().getReportWebAttr();
        if (ReportUtils.isWebPageModel(reportWebAttr)) {
            tag2.cls("contentDIV").css("width", sheetPage.getPageWidth() + "px").css("height", sheetPage.getPageHeight() + "px");
        }
        new TreeHTMLConverter(sheetPage, new FormCellWriter(repository, n), columnRow, repository, tag2, true).convert();
        if (repository.getBrowser().shouldWrapCenter()) {
            tag = tag2;
            tag2 = new Tag("center").sub(tag);
        }
        tag = new Tag("form").attr("name", "form-" + sessionIDInfor.getReportName(n)).cls("form-submit");
        tag2.sub(tag);
        tag2.writeHtml(printWriter);
        printWriter.flush();
        printWriter.close();
    }
}

