/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.service;

import com.fr.base.CodeUtils;
import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.StringUtils;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.util.TemplateUtils;
import com.fr.privilege.authentication.AbstractAuthentication;
import com.fr.privilege.authentication.Authentication;
import com.fr.privilege.authentication.AuthenticationFactory;
import com.fr.privilege.authentication.FreeAuthentication;
import com.fr.privilege.authentication.UsernamePasswordAuthentication;
import com.fr.privilege.authority.Authority;
import com.fr.privilege.manager.PrivilegeManager;
import com.fr.privilege.providers.AuthenticationProvider;
import com.fr.privilege.ui.LoginoutUI;
import com.fr.util.Utils;
import com.fr.web.cache.WebletFactory;
import com.fr.web.core.ShowWorkBookPolicy;
import com.fr.web.core.WebUtils;
import com.fr.web.core.service.NoSessionIDService;
import com.fr.web.core.service.ReportletDealWith;
import com.fr.web.platform.PlatformUtils;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class LoginOutService
extends NoSessionIDService {
    private static LoginOutService LOGINOUT_SERVICE = new LoginOutService();

    private LoginOutService() {
    }

    public static LoginOutService getInstance() {
        return LOGINOUT_SERVICE;
    }

    public boolean accept(String string) {
        return string.startsWith("auth_") || string.startsWith("platform_");
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        if ("auth_loginui".equals(string)) {
            LoginOutService.loginUI(httpServletRequest, httpServletResponse);
        } else if ("auth_loginplatformui".equals(string)) {
            LoginOutService.loginPlatformUI(httpServletRequest, httpServletResponse);
        } else if ("auth_login".equals(string)) {
            LoginOutService.login(httpServletRequest, httpServletResponse);
        } else if ("auth_logout".equals(string)) {
            LoginOutService.logout(httpServletRequest, httpServletResponse);
        }
    }

    private static void loginUI(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Authentication authentication = AuthenticationFactory.extractAuthentication(httpServletRequest);
        if (authentication == null || !authentication.isAuthenticated()) {
            ReportletDealWith.dealWithReportlet(httpServletRequest, httpServletResponse, WebletFactory.createEmbeddedReportlet("/com/fr/privilege/ui/login.cpt", new ShowWorkBookPolicy.Policy4Form()));
        } else {
            String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "fr_from");
            LoginoutUI loginoutUI = FRContext.getPrivilegeManager().getAuthenticationProvider().getLoginoutUI();
            if (StringUtils.isNotEmpty(string)) {
                httpServletResponse.sendRedirect(CodeUtils.cjkEncode(string));
                return;
            }
            if (StringUtils.isNotEmpty(loginoutUI.getAutoRedirect())) {
                httpServletResponse.sendRedirect(TemplateUtils.render(loginoutUI.getAutoRedirect(), WebUtils.createTemplateMap(httpServletRequest)));
                return;
            }
            Map map = WebUtils.createTemplateMap(httpServletRequest);
            map.put("fr_info", authentication.getPrincipal() + " already been registered!");
            TemplateUtils.dealWithTemplate("/com/fr/web/platform/html/info.html", httpServletResponse, map);
        }
    }

    private static void loginPlatformUI(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Authentication authentication = AuthenticationFactory.extractAuthentication(httpServletRequest);
        Map map = WebUtils.createTemplateMap(httpServletRequest);
        TemplateUtils.dealWithTemplate("/com/fr/web/platform/html/login.html", httpServletResponse, map);
    }

    private static void login(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        Object object2;
        Object object3;
        String string;
        Authority[] authorityArray;
        PrivilegeManager privilegeManager = FRContext.getPrivilegeManager();
        AuthenticationProvider authenticationProvider = privilegeManager.getAuthenticationProvider();
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        JSONObject jSONObject = new JSONObject();
        HttpSession httpSession = LoginOutService.safeGetSession(httpServletRequest);
        Authority[] authorityArray2 = PlatformUtils.createSessionAuthorities(httpServletRequest, httpServletResponse);
        AbstractAuthentication abstractAuthentication = null;
        if (authorityArray2.length > 0) {
            abstractAuthentication = new FreeAuthentication(authorityArray2);
        } else {
            authorityArray = WebUtils.getHTTPRequestParameter(httpServletRequest, "form_value");
            string = WebUtils.getHTTPRequestParameter(httpServletRequest, "__parameters__");
            object3 = authorityArray;
            if (StringUtils.isEmpty((String)object3)) {
                object3 = string;
                if (StringUtils.isEmpty((String)object3)) {
                    abstractAuthentication = new FreeAuthentication();
                } else {
                    object2 = new JSONObject((String)object3);
                    object = ((JSONObject)object2).getString("fr_username");
                    String string2 = ((JSONObject)object2).getString("fr_password");
                    abstractAuthentication = new UsernamePasswordAuthentication((String)object, string2);
                }
            } else {
                object2 = new JSONObject((String)object3);
                object = ((JSONObject)object2).getString("fr_username");
                String string3 = ((JSONObject)object2).getString("fr_password");
                abstractAuthentication = new UsernamePasswordAuthentication((String)object, string3);
            }
        }
        try {
            authenticationProvider.authenticate(abstractAuthentication);
        }
        catch (Exception exception) {
            if (StringUtils.isNotEmpty(WebUtils.getHTTPRequestParameter(httpServletRequest, "showError"))) {
                jSONObject.put("resError", "showError");
                printWriter.print(jSONObject);
                printWriter.flush();
                printWriter.close();
                return;
            }
            throw exception;
        }
        authorityArray = abstractAuthentication.getAuthorities();
        httpSession.setAttribute("fr_authentication_key", (Object)abstractAuthentication);
        httpSession.setAttribute("fr_username", abstractAuthentication.getPrincipal());
        httpSession.setAttribute("fr_authority", (Object)PlatformUtils.obtainAuthority(authorityArray));
        string = WebUtils.getHTTPRequestParameter(httpServletRequest, "fr_from");
        object3 = Utils.objectToString(httpSession.getAttribute("fr_error"));
        httpSession.removeAttribute("fr_error");
        object2 = FRContext.getPrivilegeManager().getAuthenticationProvider().getLoginoutUI();
        if (StringUtils.isNotEmpty(string)) {
            if (string.indexOf("op=fr_") != -1) {
                object = httpServletRequest.getRequestURL().toString() + "?op=fr_platform";
                jSONObject.put("url", object);
                printWriter.print(jSONObject);
                printWriter.flush();
                printWriter.close();
            } else {
                jSONObject.put("url", string);
                printWriter.print(jSONObject);
                printWriter.flush();
                printWriter.close();
            }
        } else if (StringUtils.isNotEmpty(((LoginoutUI)object2).getAutoRedirect())) {
            jSONObject.put("url", ((LoginoutUI)object2).getAutoRedirect());
            printWriter.print(jSONObject);
            httpServletResponse.sendRedirect(TemplateUtils.render(((LoginoutUI)object2).getAutoRedirect(), WebUtils.createTemplateMap(httpServletRequest)));
            printWriter.flush();
            printWriter.close();
        } else if (StringUtils.isNotBlank((String)object3)) {
            printWriter.println((String)object3);
            printWriter.flush();
            printWriter.close();
        } else {
            object = WebUtils.createTemplateMap(httpServletRequest);
            object.put("fr_info", abstractAuthentication.getPrincipal() + Inter.getLocText("Login") + Inter.getLocText("Successfully") + "!");
            TemplateUtils.dealWithTemplate("/com/fr/web/platform/html/info.html", httpServletResponse, (Map)object);
        }
    }

    private static void logout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HttpSession httpSession = LoginOutService.safeGetSession(httpServletRequest);
        httpSession.removeAttribute("fr_authentication_key");
        httpSession.removeAttribute("fr_username");
        httpSession.removeAttribute("fr_authority");
        LoginoutUI loginoutUI = FRContext.getPrivilegeManager().getAuthenticationProvider().getLoginoutUI();
        loginoutUI.redirect2LoginUI(httpServletRequest, httpServletResponse, "");
    }

    private static HttpSession safeGetSession(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getSession(true);
    }
}

