/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.service;

import com.fr.base.ColumnRow;
import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.FRCoreContext;
import com.fr.base.core.RSADecode;
import com.fr.base.core.html.Html;
import com.fr.base.core.html.Tag;
import com.fr.base.core.html.TextHtml;
import com.fr.base.core.json.JSONObject;
import com.fr.report.ReportPage;
import com.fr.report.ReportWebAttr;
import com.fr.report.core.ReportUtils;
import com.fr.report.io.HTMLExportAttr;
import com.fr.report.io.ReportExportAttr;
import com.fr.util.Consts;
import com.fr.util.Utils;
import com.fr.web.Repository;
import com.fr.web.core.HTMLConverter;
import com.fr.web.core.Service;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.core.WebUtils;
import com.fr.web.core.chwriter.PageCellWriter;
import com.fr.web.core.service.SessionDealWith;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PageService
implements Service {
    private static PageService PAGE_SERVICE = new PageService();
    private static boolean registed = false;

    private PageService() {
    }

    public static PageService getInstance() {
        return PAGE_SERVICE;
    }

    public boolean accept(String string) {
        return string.startsWith("page_");
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws Exception {
        if ("page_content".equals(string)) {
            PageService.readPageContent(string2, httpServletRequest, httpServletResponse);
        }
    }

    private static void readPageContent(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        Cloneable cloneable;
        Serializable serializable;
        int n = 0;
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "pn");
        if (string2 != null && ((serializable = Utils.string2Number(string2)) == null || (n = ((Number)serializable).intValue()) < 0)) {
            n = Integer.MAX_VALUE;
        }
        if ((serializable = SessionDealWith.getSessionIDInfor(string)) == null) {
            return;
        }
        ReportPage reportPage = ((SessionIDInfor)serializable).getReportPage(n);
        if (reportPage == null) {
            return;
        }
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        int n2 = reportPage.getCurrentPageNumber();
        int n3 = reportPage.getTotalPages();
        int n4 = ((SessionIDInfor)serializable).getPageOwnerIndex(reportPage);
        new Tag("script").sub(new TextHtml("FR._p=FR.SessionMgr.get(\"" + string + "\");" + "FR._p.currentPageIndex=" + n2 + ";" + "FR._p.reportTotalPage=" + n3 + ";" + "FR._p.ownerIndex=" + n4 + ";" + "delete FR._p;")).writeHtml(printWriter);
        Tag tag = new Tag("div").cls("pageContentDIV");
        Repository repository = new Repository(httpServletRequest, (SessionIDInfor)serializable);
        ColumnRow columnRow = reportPage.getReportPageAttr() == null ? null : reportPage.getReportPageAttr().getFreezeColumnRow();
        FRContext.getLogger().info(Inter.getLocText("INFO-Start_Converting_ReportPage_To_Html"));
        long l = System.currentTimeMillis();
        PageCellWriter pageCellWriter = new PageCellWriter(repository, 0, false);
        if (repository.getBrowser().shouldConsiderHeavyTD() && (cloneable = ((SessionIDInfor)serializable).getContextBook().getReportExportAttr()) != null && ((ReportExportAttr)cloneable).getHtmlExportAttr() != null && ((HTMLExportAttr)(object = ((ReportExportAttr)cloneable).getHtmlExportAttr())).isTDHeavy()) {
            pageCellWriter.setHeavy(true);
        }
        if (ReportUtils.isWebPageModel((ReportWebAttr)(cloneable = repository.getSessionIDInfor().getContextBook().getReportWebAttr()))) {
            tag.cls("contentDIV").css("width", reportPage.getPageWidth() + "px").css("height", reportPage.getPageHeight() + "px");
        }
        if (ReportUtils.isWebPagePaintModel((ReportWebAttr)cloneable)) {
            object = reportPage.toImage(false);
            tag.css("background-repeat", "no-repeat");
            repository.writeTagBackground(tag, (Image)object);
        } else {
            object = new HTMLConverter(reportPage, pageCellWriter, columnRow, repository, tag, true);
            ((HTMLConverter)object).convert();
        }
        if (repository.getBrowser().shouldWrapCenter()) {
            object = tag;
            tag = new Tag("center").sub((Html)object);
        }
        tag.writeHtml(printWriter);
        SessionDealWith.writeRegistionDiv(httpServletRequest, printWriter);
        printWriter.flush();
        printWriter.close();
        long l2 = System.currentTimeMillis();
        FRContext.getLogger().info(Inter.getLocText("INFO-End_Converting_ReportPage_To_Html") + "\t" + Inter.getLocText("INFO-Time_Taken") + (l2 - l) + Inter.getLocText("Milliseconds"));
    }

    static {
        byte[] byArray = FRCoreContext.getBytes();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            RSADecode.decode(byArray, (OutputStream)byteArrayOutputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            JSONObject jSONObject = new JSONObject(new String(byteArrayOutputStream.toByteArray(), "UTF-8"));
            registed = jSONObject.getLong("deadline") > Calendar.getInstance().getTimeInMillis() && jSONObject.has("version") && ComparatorUtils.equals(Consts.VERSION, jSONObject.getString("version")) && (jSONObject.getLong("deadline") - Calendar.getInstance().getTimeInMillis() < 3153600000L || jSONObject.has("macaddress") && BaseCoreUtils.getMacAddresses().contains(jSONObject.getString("macaddress")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

