/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.service;

import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.StringUtils;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.util.TemplateUtils;
import com.fr.base.dav.Env;
import com.fr.privilege.providers.NoAuthenticationProvider;
import com.fr.web.cache.WebletFactory;
import com.fr.web.core.ShowWorkBookPolicy;
import com.fr.web.core.WebUtils;
import com.fr.web.core.service.NoSessionIDService;
import com.fr.web.core.service.PrivilegeService;
import com.fr.web.core.service.ReportletDealWith;
import com.fr.web.core.service.SessionDealWith;
import com.fr.web.platform.PlatformConstants;
import com.fr.web.platform.PlatformControl;
import com.fr.web.platform.PlatformManager;
import com.fr.web.platform.PlatformNoControl;
import com.fr.web.platform.PlatformPermissionAndAuthorityControl;
import com.fr.web.platform.PlatformPermissionControl;
import com.fr.web.platform.module.Module;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PlatformService
extends NoSessionIDService {
    private static PlatformService PLATFORM_SERVICE = new PlatformService();

    private PlatformService() {
    }

    public static PlatformService getInstance() {
        return PLATFORM_SERVICE;
    }

    public boolean accept(String string) {
        return string.startsWith("fr_");
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        if ("fr_module".equals(string)) {
            PlatformService.createModule(httpServletRequest, httpServletResponse);
        } else if ("fr_platform_manage".equals(string)) {
            PlatformService.createPlatformManageType(httpServletRequest, httpServletResponse);
        } else if ("fr_platform_manage_all_control".equals(string)) {
            PlatformService.createAllControl(httpServletRequest, httpServletResponse);
        } else if ("fr_platform_manage_list_all".equals(string)) {
            PlatformService.listPlatformManagers(httpServletRequest, httpServletResponse);
        } else if ("fr_platform_manage_all_control_save".equals(string)) {
            PlatformService.updateAllControl(httpServletRequest, httpServletResponse);
        } else if ("fr_platform_manage_permission_control".equals(string)) {
            PlatformService.createPermissionControl(httpServletRequest, httpServletResponse);
        } else if ("fr_platform_manage_permission_control_save".equals(string)) {
            PlatformService.updatePermissionControl(httpServletRequest, httpServletResponse);
        } else if ("fr_platform_manage_no_control".equals(string)) {
            PlatformService.createNoControl(httpServletRequest, httpServletResponse);
        } else if ("fr_platform_manage_no_control_save".equals(string)) {
            PlatformService.updateNoControl(httpServletRequest, httpServletResponse);
        } else if (PrivilegeService.getInstance().accept(string)) {
            PrivilegeService.getInstance().process(httpServletRequest, httpServletResponse, string);
        } else if ("fr_platform".equals(string)) {
            PlatformService.generatePlatform(httpServletRequest, httpServletResponse);
        } else if ("fr_getuserinfo".equals(string)) {
            PlatformService.getUserInfo(httpServletRequest, httpServletResponse);
        }
    }

    private static void getUserInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        JSONObject jSONObject = new JSONObject();
        String string = SessionDealWith.getUserIp(httpServletRequest);
        if (string.equals("0:0:0:0:0:0:0:1") || string.equals("127.0.0.1")) {
            string = "localhost";
        }
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "fr_username");
        boolean bl = !(FRContext.getPrivilegeManager().getAuthenticationProvider() instanceof NoAuthenticationProvider);
        jSONObject.put("username", string2);
        jSONObject.put("userip", string);
        jSONObject.put("authSet", bl);
        printWriter.print(jSONObject);
        printWriter.flush();
        printWriter.close();
    }

    private static void generatePlatform(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Map map = WebUtils.createTemplateMap(httpServletRequest);
        TemplateUtils.dealWithTemplate("/com/fr/web/platform/html/frplatform.html", httpServletResponse, map);
    }

    private static void createModule(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Map map = WebUtils.createTemplateMap(httpServletRequest);
        int n = Integer.parseInt(WebUtils.getHTTPRequestParameter(httpServletRequest, "index"));
        Module module = FRContext.getModuleManager().getModule(n);
        map.put("src", TemplateUtils.render(module.getSrc(), map));
        TemplateUtils.dealWithTemplate("/com/fr/web/platform/html/template.html", httpServletResponse, map);
    }

    private static void createPlatformManageType(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("rType", FRContext.getPlatformManager().getPlatformControl().getID());
        ReportletDealWith.dealWithReportlet(httpServletRequest, httpServletResponse, WebletFactory.createEmbeddedReportlet("/com/fr/web/platform/cpt/platformManager.cpt", new ShowWorkBookPolicy.Policy4Form(), hashMap));
    }

    private static void createAllControl(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ReportletDealWith.dealWithReportlet(httpServletRequest, httpServletResponse, WebletFactory.createEmbeddedReportlet("/com/fr/web/platform/cpt/platformRole.cpt", new ShowWorkBookPolicy.Policy4Form()));
    }

    private static void listPlatformManagers(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        PlatformManager platformManager = FRContext.getPlatformManager();
        PlatformControl platformControl = platformManager.getPlatformControl();
        JSONObject jSONObject = new JSONObject();
        int n = platformControl.getAuthoryryNameCount();
        for (int i = 0; i < n; ++i) {
            String string = platformControl.getAuthorityName(i);
            jSONObject.put(string, string);
        }
        printWriter.print(jSONObject);
        printWriter.flush();
        printWriter.close();
    }

    private static void updateAllControl(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        String string = PlatformConstants.Success.DATA_SAVE_INFO;
        try {
            object = WebUtils.getHTTPRequestParameter(httpServletRequest, "__parameters__");
            JSONArray jSONArray = new JSONArray((String)object);
            PlatformManager platformManager = FRContext.getPlatformManager();
            PlatformPermissionAndAuthorityControl platformPermissionAndAuthorityControl = new PlatformPermissionAndAuthorityControl();
            platformManager.setPlatformControl(platformPermissionAndAuthorityControl);
            int n = jSONArray.length();
            for (int i = 0; i < n; ++i) {
                platformPermissionAndAuthorityControl.addAuthorityName(jSONArray.getJSONObject(i).getString("text"));
            }
            Env env = FRContext.getCurrentEnv();
            try {
                env.writeResource(platformManager);
            }
            catch (IOException iOException) {
                FRContext.getLogger().log(Level.WARNING, iOException.getMessage(), iOException);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            string = PlatformConstants.Failure.DATA_SAVE_INFO;
        }
        object = WebUtils.createPrintWriter(httpServletResponse);
        ((PrintWriter)object).print(string);
        ((PrintWriter)object).flush();
    }

    private static void createPermissionControl(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ReportletDealWith.dealWithReportlet(httpServletRequest, httpServletResponse, WebletFactory.createEmbeddedReportlet("/com/fr/web/platform/cpt/platformPermissionControl.cpt", new ShowWorkBookPolicy.Policy4Form()));
    }

    private static void updatePermissionControl(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = PlatformConstants.Success.DATA_SAVE_INFO;
        PlatformManager platformManager = FRContext.getPlatformManager();
        PlatformPermissionControl platformPermissionControl = new PlatformPermissionControl();
        platformManager.setPlatformControl(platformPermissionControl);
        Env env = FRContext.getCurrentEnv();
        try {
            env.writeResource(platformManager);
        }
        catch (IOException iOException) {
            FRContext.getLogger().log(Level.WARNING, iOException.getMessage(), iOException);
            string = PlatformConstants.Failure.DATA_SAVE_INFO;
        }
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.print(string);
        printWriter.flush();
    }

    private static void createNoControl(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ReportletDealWith.dealWithReportlet(httpServletRequest, httpServletResponse, WebletFactory.createEmbeddedReportlet("/com/fr/web/platform/cpt/platformNoControl.cpt", new ShowWorkBookPolicy.Policy4Form()));
    }

    private static void updateNoControl(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = PlatformConstants.Success.DATA_SAVE_INFO;
        PlatformManager platformManager = FRContext.getPlatformManager();
        PlatformNoControl platformNoControl = new PlatformNoControl();
        platformManager.setPlatformControl(platformNoControl);
        Env env = FRContext.getCurrentEnv();
        try {
            env.writeResource(platformManager);
        }
        catch (IOException iOException) {
            FRContext.getLogger().log(Level.WARNING, iOException.getMessage(), iOException);
            string = PlatformConstants.Failure.DATA_SAVE_INFO;
        }
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.print(string);
        printWriter.flush();
    }

    private static String createPlatformLogoutURL(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "fr_username");
        if (StringUtils.isBlank(string)) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<li class='ui-state-default ui-corner-top' style='float:right'>");
        stringBuffer.append("<a href='");
        stringBuffer.append(TemplateUtils.render("${servletURL}?op=auth_logout", WebUtils.createTemplateMap(httpServletRequest)));
        stringBuffer.append("'>");
        stringBuffer.append(Inter.getLocText("Username"));
        stringBuffer.append(":");
        stringBuffer.append(string);
        stringBuffer.append("&nbsp;&nbsp;");
        stringBuffer.append(Inter.getLocText("Logout"));
        stringBuffer.append("</a></li>");
        return stringBuffer.toString();
    }
}

