/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.service;

import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.FRCoreContext;
import com.fr.base.core.RSADecode;
import com.fr.base.core.html.Html;
import com.fr.base.core.html.Tag;
import com.fr.base.core.html.TextHtml;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.util.TemplateUtils;
import com.fr.report.PageSetChain;
import com.fr.report.ReportPage;
import com.fr.report.ReportWebAttr;
import com.fr.report.ResultWorkBook;
import com.fr.report.TemplateWorkBook;
import com.fr.report.core.ReportUtils;
import com.fr.report.io.ReportExportAttr;
import com.fr.report.web.ToolBarManager;
import com.fr.report.web.WebPage;
import com.fr.util.Consts;
import com.fr.util.Utils;
import com.fr.web.Repository;
import com.fr.web.core.HTMLConverter;
import com.fr.web.core.Service;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.core.ShowWorkBookPolicy;
import com.fr.web.core.WebUtils;
import com.fr.web.core.chwriter.PageCellWriter;
import com.fr.web.core.service.SessionDealWith;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PrintPreviewService
implements Service {
    private static PrintPreviewService SC = new PrintPreviewService();
    private static boolean registed = false;

    private PrintPreviewService() {
    }

    public static PrintPreviewService getInstance() {
        return SC;
    }

    public boolean accept(String string) {
        return "printpreview".equals(string) || string.startsWith("printpreview_");
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws Exception {
        if ("printpreview".equals(string)) {
            PrintPreviewService.initPrintPreviewPage(string2, httpServletRequest, httpServletResponse);
        } else if ("printpreview_content".equals(string)) {
            PrintPreviewService.getPrintPreviewContent(string2, httpServletRequest, httpServletResponse);
        }
    }

    private static void getPrintPreviewContent(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Cloneable cloneable;
        Object object;
        Serializable serializable;
        int n = 0;
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "pn");
        if (string2 != null && ((serializable = Utils.string2Number(string2)) == null || (n = ((Number)serializable).intValue()) < 0)) {
            n = Integer.MAX_VALUE;
        }
        if ((serializable = SessionDealWith.getSessionIDInfor(string)) == null) {
            return;
        }
        ReportPage reportPage = ((SessionIDInfor)serializable).getPrintPreviewReportPage(n);
        if (reportPage == null) {
            return;
        }
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        int n2 = reportPage.getCurrentPageNumber();
        int n3 = reportPage.getTotalPages();
        int n4 = ((SessionIDInfor)serializable).getPageOwnerIndex(reportPage);
        new Tag("script").sub(new TextHtml("FR._p=FR.SessionMgr.get(\"" + string + "\");" + "FR._p.currentPageIndex=" + n2 + ";" + "FR._p.reportTotalPage=" + n3 + ";" + "FR._p.ownerIndex=" + n4 + ";" + "delete FR._p;")).writeHtml(printWriter);
        Tag tag = new Tag("div");
        Repository repository = new Repository(httpServletRequest, (SessionIDInfor)serializable);
        FRContext.getLogger().info(Inter.getLocText("INFO-Start_Converting_ReportPage_To_Html"));
        long l = System.currentTimeMillis();
        PageCellWriter pageCellWriter = new PageCellWriter(repository, 0, true);
        if (repository.getBrowser().shouldConsiderHeavyTD() && (object = ((SessionIDInfor)serializable).getContextBook().getReportExportAttr()) != null && ((ReportExportAttr)object).getHtmlExportAttr() != null && (cloneable = ((ReportExportAttr)object).getHtmlExportAttr()).isTDHeavy()) {
            pageCellWriter.setHeavy(true);
        }
        tag.cls("contentDIV").css("width", reportPage.getPageWidth() + "px").css("height", reportPage.getPageHeight() + "px");
        object = new HTMLConverter(reportPage, pageCellWriter, null, repository, tag, true);
        ((HTMLConverter)object).convert();
        if (repository.getBrowser().shouldWrapCenter()) {
            cloneable = tag;
            tag = new Tag("center").sub((Html)cloneable);
        }
        tag.writeHtml(printWriter);
        SessionDealWith.writeRegistionDiv(httpServletRequest, printWriter);
        printWriter.flush();
        printWriter.close();
        long l2 = System.currentTimeMillis();
        FRContext.getLogger().info(Inter.getLocText("INFO-End_Converting_ReportPage_To_Html") + "\t" + Inter.getLocText("INFO-Time_Taken") + (l2 - l) + Inter.getLocText("Milliseconds"));
    }

    private static void initPrintPreviewPage(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        SessionIDInfor sessionIDInfor = SessionDealWith.getSessionIDInfor(string);
        if (sessionIDInfor == null) {
            return;
        }
        Map map = WebUtils.context4PolicyPaneTpl(httpServletRequest, sessionIDInfor, new PreviewPolicy(sessionIDInfor.getPolicy()));
        try {
            if (httpServletRequest.getParameter("__isdebug__") != null) {
                TemplateUtils.dealWithTemplate("/com/fr/web/core/page_debug.html", httpServletResponse, map);
            } else {
                TemplateUtils.dealWithTemplate("/com/fr/web/core/page.html", httpServletResponse, map);
            }
        }
        catch (IOException iOException) {
            FRContext.getLogger().log(Level.WARNING, iOException.getMessage(), iOException);
        }
    }

    static {
        byte[] byArray = FRCoreContext.getBytes();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            RSADecode.decode(byArray, (OutputStream)byteArrayOutputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            JSONObject jSONObject = new JSONObject(new String(byteArrayOutputStream.toByteArray(), "UTF-8"));
            registed = jSONObject.getLong("deadline") > Calendar.getInstance().getTimeInMillis() && jSONObject.has("version") && ComparatorUtils.equals(Consts.VERSION, jSONObject.getString("version")) && (jSONObject.getLong("deadline") - Calendar.getInstance().getTimeInMillis() < 3153600000L || jSONObject.has("macaddress") && BaseCoreUtils.getMacAddresses().contains(jSONObject.getString("macaddress")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class PreviewPolicy
    extends ShowWorkBookPolicy {
        private ShowWorkBookPolicy policy;

        private PreviewPolicy(ShowWorkBookPolicy showWorkBookPolicy) {
            this.policy = showWorkBookPolicy;
        }

        public String panelType() {
            return "preview";
        }

        public ResultWorkBook show(TemplateWorkBook templateWorkBook, Map map) {
            throw new UnsupportedOperationException();
        }

        public PageSetChain getPageSet(ResultWorkBook resultWorkBook) {
            throw new UnsupportedOperationException();
        }

        public JSONObject panelConfig(Repository repository) throws JSONException {
            return this.policy == null ? null : this.policy.panelConfig(repository);
        }

        public ToolBarManager[] toolbarManagers(Repository repository) {
            WebPage webPage;
            ReportWebAttr reportWebAttr;
            ToolBarManager[] toolBarManagerArray = ReportUtils.getToolBarFromWorkBook(repository.getSessionIDInfor().getContextBook(), 0);
            if (toolBarManagerArray == null && (reportWebAttr = FRContext.getConfigManager().getReportWebAttr()) != null && (webPage = reportWebAttr.getWebPage()) != null) {
                toolBarManagerArray = webPage.getToolBarManagers();
            }
            if (toolBarManagerArray == null) {
                toolBarManagerArray = new ToolBarManager[]{ToolBarManager.createDefaultToolBar()};
            }
            return toolBarManagerArray;
        }
    }
}

