/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.service;

import com.fr.base.CodeUtils;
import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.dav.Env;
import com.fr.base.dav.FileNode;
import com.fr.privilege.allocation.Allocation;
import com.fr.privilege.allocation.FileFrag;
import com.fr.privilege.authority.Authority;
import com.fr.privilege.authority.AuthorityAllocation;
import com.fr.privilege.authority.AuthorityControl;
import com.fr.privilege.authority.Control;
import com.fr.privilege.authority.NoAuthorityControl;
import com.fr.privilege.authority.PermissonControl;
import com.fr.privilege.manager.PrivilegeManager;
import com.fr.privilege.providers.AuthenticationProvider;
import com.fr.privilege.providers.HttpAuthenticationProvider;
import com.fr.privilege.providers.NoAuthenticationProvider;
import com.fr.privilege.providers.dao.DaoAuthenticationProvider;
import com.fr.privilege.providers.ldap.LDAPAuthenticationProvider;
import com.fr.privilege.ui.CustomLogioutUI;
import com.fr.privilege.ui.LoginoutUI;
import com.fr.web.cache.WebletFactory;
import com.fr.web.core.ShowWorkBookPolicy;
import com.fr.web.core.WebUtils;
import com.fr.web.core.service.NoSessionIDService;
import com.fr.web.core.service.ReportletDealWith;
import com.fr.web.platform.PlatformConstants;
import com.fr.web.platform.core.TTNode;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PrivilegeService
extends NoSessionIDService {
    private static PrivilegeService PRIVILEGE_SERVICE = new PrivilegeService();

    private PrivilegeService() {
    }

    public static PrivilegeService getInstance() {
        return PRIVILEGE_SERVICE;
    }

    public boolean accept(String string) {
        return string.startsWith("fr_privilege");
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        if ("fr_privilege".equals(string)) {
            PrivilegeService.createPrivilegeFace(httpServletRequest, httpServletResponse);
        } else if ("fr_privilege_user_type".equals(string)) {
            PrivilegeService.createUserType(httpServletRequest, httpServletResponse);
        } else if ("fr_privilege_type_tabledata".equals(string)) {
            PrivilegeService.createTableDataUserFace(httpServletRequest, httpServletResponse);
        } else if ("fr_privilege_type_tabledata_save".equals(string)) {
            PrivilegeService.updateTableDataUserType(httpServletRequest, httpServletResponse);
        } else if ("fr_privilege_type_ldap".equals(string)) {
            PrivilegeService.createLdapUserFace(httpServletRequest, httpServletResponse);
        } else if ("fr_privilege_type_ldap_save".equals(string)) {
            PrivilegeService.updateLdapUserType(httpServletRequest, httpServletResponse);
        } else if ("fr_privilege_type_http".equals(string)) {
            PrivilegeService.createHttpUserFace(httpServletRequest, httpServletResponse);
        } else if ("fr_privilege_type_http_save".equals(string)) {
            PrivilegeService.updateHttpUserType(httpServletRequest, httpServletResponse);
        } else if ("fr_privilege_roles".equals(string)) {
            PrivilegeService.createRolesFace(httpServletRequest, httpServletResponse);
        } else if ("fr_privilege_roles_save".equals(string)) {
            PrivilegeService.updateAuthorityAllocation(httpServletRequest, httpServletResponse);
        } else if ("fr_privilege_roles_refresh".equals(string)) {
            PrivilegeService.refreshRoles(httpServletRequest, httpServletResponse);
        } else if ("fr_privilege_get_roles".equals(string)) {
            PrivilegeService.createRoles(httpServletRequest, httpServletResponse);
        } else if ("fr_privilege_roles_tree".equals(string)) {
            PrivilegeService.createRolesTableTree(httpServletRequest, httpServletResponse);
        } else if ("fr_privilege_type_null".equals(string)) {
            PrivilegeService.createNullAuthFace(httpServletRequest, httpServletResponse);
        } else if ("fr_privilege_type_null_save".equals(string)) {
            PrivilegeService.updateNullAuth(httpServletRequest, httpServletResponse);
        } else if ("fr_privilege_role_type".equals(string)) {
            PrivilegeService.createAuthorirtyAllocationTypeFace(httpServletRequest, httpServletResponse);
        } else if ("fr_privilege_permission_control".equals(string)) {
            PrivilegeService.generatePermissionControl(httpServletRequest, httpServletResponse);
        } else if ("fr_privilege_permission_control_save".equals(string)) {
            PrivilegeService.updatePermissionControl(httpServletRequest, httpServletResponse);
        } else if ("fr_privilege_no_control".equals(string)) {
            PrivilegeService.generateNoControl(httpServletRequest, httpServletResponse);
        } else if ("fr_privilege_no_control_save".equals(string)) {
            PrivilegeService.updateNoControl(httpServletRequest, httpServletResponse);
        }
    }

    private static void createPrivilegeFace(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ReportletDealWith.dealWithReportlet(httpServletRequest, httpServletResponse, WebletFactory.createEmbeddedReportlet("/com/fr/web/platform/cpt/prm.cpt", new ShowWorkBookPolicy.Policy4Form()));
    }

    private static void createTableDataUserFace(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        PrivilegeManager privilegeManager = FRContext.getPrivilegeManager();
        AuthenticationProvider authenticationProvider = privilegeManager.getAuthenticationProvider();
        if (authenticationProvider instanceof DaoAuthenticationProvider) {
            DaoAuthenticationProvider.UserConfig userConfig = ((DaoAuthenticationProvider)authenticationProvider).getUserConfig();
            hashMap.put("up_tabledata", userConfig.getTableDataName());
            hashMap.put("up_user", userConfig.getUsernameField());
            hashMap.put("up_password", userConfig.getPasswordField());
            DaoAuthenticationProvider.RoleConfig roleConfig = ((DaoAuthenticationProvider)authenticationProvider).getRoleConfig();
            hashMap.put("ur_tabledata", roleConfig.getTableDataName());
            hashMap.put("ur_user", roleConfig.getUsernameField());
            hashMap.put("ur_role", roleConfig.getRoleField());
            LoginoutUI loginoutUI = authenticationProvider.getLoginoutUI();
            if (loginoutUI instanceof CustomLogioutUI) {
                hashMap.put("loginpath", ((CustomLogioutUI)loginoutUI).getLoginPath());
            }
            hashMap.put("autoredirect", loginoutUI.getAutoRedirect());
        }
        ReportletDealWith.dealWithReportlet(httpServletRequest, httpServletResponse, WebletFactory.createEmbeddedReportlet("/com/fr/web/platform/cpt/setting.cpt", new ShowWorkBookPolicy.Policy4Form(), hashMap));
    }

    private static void createUserType(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        PrivilegeManager privilegeManager = FRContext.getPrivilegeManager();
        AuthenticationProvider authenticationProvider = privilegeManager.getAuthenticationProvider();
        if (authenticationProvider instanceof DaoAuthenticationProvider) {
            hashMap.put("uType", "0");
        } else if (authenticationProvider instanceof LDAPAuthenticationProvider) {
            hashMap.put("uType", "1");
        } else if (authenticationProvider instanceof HttpAuthenticationProvider) {
            hashMap.put("uType", "2");
        } else {
            hashMap.put("uType", "-1");
        }
        ReportletDealWith.dealWithReportlet(httpServletRequest, httpServletResponse, WebletFactory.createEmbeddedReportlet("/com/fr/web/platform/cpt/userType.cpt", new ShowWorkBookPolicy.Policy4Form(), hashMap));
    }

    private static void createLdapUserFace(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        PrivilegeManager privilegeManager = FRContext.getPrivilegeManager();
        AuthenticationProvider authenticationProvider = privilegeManager.getAuthenticationProvider();
        if (authenticationProvider instanceof LDAPAuthenticationProvider) {
            LDAPAuthenticationProvider lDAPAuthenticationProvider = (LDAPAuthenticationProvider)authenticationProvider;
            hashMap.put("url", lDAPAuthenticationProvider.getUrl());
            hashMap.put("searchBase", lDAPAuthenticationProvider.getSearchBase());
            hashMap.put("suffix", lDAPAuthenticationProvider.getPrincipalSuffix());
            hashMap.put("sysUser", lDAPAuthenticationProvider.getSystemUsername());
            hashMap.put("sysPassword", lDAPAuthenticationProvider.getSystemPassword());
            hashMap.put("authen", lDAPAuthenticationProvider.getAuthentication());
            hashMap.put("context", lDAPAuthenticationProvider.getContextFactory());
            hashMap.put("referral", lDAPAuthenticationProvider.getReferral());
            LoginoutUI loginoutUI = authenticationProvider.getLoginoutUI();
            if (loginoutUI instanceof CustomLogioutUI) {
                hashMap.put("loginpath", ((CustomLogioutUI)loginoutUI).getLoginPath());
            }
            if (loginoutUI != null) {
                hashMap.put("autoredirect", loginoutUI.getAutoRedirect());
            }
        }
        ReportletDealWith.dealWithReportlet(httpServletRequest, httpServletResponse, WebletFactory.createEmbeddedReportlet("/com/fr/web/platform/cpt/ldap.cpt", new ShowWorkBookPolicy.Policy4Form(), hashMap));
    }

    private static void createHttpUserFace(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        PrivilegeManager privilegeManager = FRContext.getPrivilegeManager();
        AuthenticationProvider authenticationProvider = privilegeManager.getAuthenticationProvider();
        if (authenticationProvider instanceof HttpAuthenticationProvider) {
            HttpAuthenticationProvider httpAuthenticationProvider = (HttpAuthenticationProvider)authenticationProvider;
            hashMap.put("url", httpAuthenticationProvider.getUrl());
            LoginoutUI loginoutUI = authenticationProvider.getLoginoutUI();
            if (loginoutUI instanceof CustomLogioutUI) {
                hashMap.put("loginpath", ((CustomLogioutUI)loginoutUI).getLoginPath());
            }
            if (loginoutUI != null) {
                hashMap.put("autoredirect", loginoutUI.getAutoRedirect());
            }
        }
        ReportletDealWith.dealWithReportlet(httpServletRequest, httpServletResponse, WebletFactory.createEmbeddedReportlet("/com/fr/web/platform/cpt/httpAuth.cpt", new ShowWorkBookPolicy.Policy4Form(), hashMap));
    }

    private static void createRolesFace(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("servletURL", WebUtils.createServletURL(httpServletRequest));
        ReportletDealWith.dealWithReportlet(httpServletRequest, httpServletResponse, WebletFactory.createEmbeddedReportlet("/com/fr/web/platform/cpt/rs.cpt", new ShowWorkBookPolicy.Policy4Form(), hashMap));
    }

    private static void refreshRoles(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        PrivilegeManager privilegeManager = FRContext.getPrivilegeManager();
        AuthenticationProvider authenticationProvider = privilegeManager.getAuthenticationProvider();
        Authority[] authorityArray = authenticationProvider.listAuthorities();
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        JSONArray jSONArray = new JSONArray();
        int n = authorityArray.length;
        for (int i = 0; i < n; ++i) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("text", authorityArray[i].getName());
            jSONArray.put(jSONObject);
        }
        printWriter.print(jSONArray);
        printWriter.flush();
        printWriter.close();
    }

    private static void createRoles(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        JSONObject jSONObject = new JSONObject();
        PrivilegeManager privilegeManager = FRContext.getPrivilegeManager();
        Iterator iterator = privilegeManager.getControl().authorityAllocationIterator();
        while (iterator.hasNext()) {
            AuthorityAllocation authorityAllocation = (AuthorityAllocation)((Map.Entry)iterator.next()).getValue();
            String string = authorityAllocation.getAuthority().getName();
            jSONObject.put(string, PrivilegeService.createRoleTableTree(new Allow(string), false));
        }
        printWriter.print(jSONObject.toString());
        printWriter.flush();
        printWriter.close();
    }

    private static void createRolesTableTree(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        JSONArray jSONArray = PrivilegeService.createRoleTableTree(new Allow(), true);
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.print(jSONArray.toString());
        printWriter.flush();
        printWriter.close();
    }

    private static JSONArray createRoleTableTree(Allow allow, boolean bl) throws Exception {
        ArrayList arrayList = new ArrayList();
        PrivilegeService.createTTNode("reportlets", allow, "", arrayList, bl);
        JSONArray jSONArray = TTNode.toJSONArray(arrayList);
        return jSONArray;
    }

    private static JSONArray createTTNode(String string, Allow allow, String string2, List list, boolean bl) throws Exception {
        JSONArray jSONArray = new JSONArray();
        FileNode[] fileNodeArray = null;
        try {
            fileNodeArray = FRContext.getCurrentEnv().listFile(string);
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
        }
        if (fileNodeArray != null && fileNodeArray.length != 0) {
            int n = 1;
            for (int i = 0; i < fileNodeArray.length; ++i) {
                int n2;
                FileNode fileNode = fileNodeArray[i];
                if (ComparatorUtils.equals(fileNode.getName(), ".svn") || !fileNode.isDirectory() && (n2 = fileNode.getName().lastIndexOf(".")) >= 0 && !ComparatorUtils.equals(fileNode.getName().substring(n2), ".cpt")) continue;
                String string3 = fileNode.getEnvPath().substring("reportlets".length() + 1);
                TTNode tTNode = new TTNode();
                tTNode.setPath(StringUtils.perfectStart(string3, "/"));
                tTNode.setText(fileNode.getName());
                tTNode.setViewState(allow.allowView(string3));
                tTNode.setDesignState(allow.allowDesign(string3));
                tTNode.setWriteState(allow.allowWrite(string3));
                tTNode.setFormState(allow.allowForm(string3));
                String string4 = StringUtils.isEmpty(string2) ? n + "" : string2 + "-" + n;
                ++n;
                tTNode.setId(string4);
                if (bl) {
                    list.add(tTNode);
                } else if (tTNode.getViewState() != 0 || tTNode.getWriteState() != 0 || tTNode.getDesignState() != 0 || tTNode.getFormState() != 0) {
                    list.add(tTNode);
                }
                if (!fileNode.isDirectory()) continue;
                tTNode.setPath(StringUtils.perfectEnd(StringUtils.perfectStart(string3, "/"), "/"));
                tTNode.setHasChildren(true);
                PrivilegeService.createTTNode(fileNode.getEnvPath(), allow, string4, list, bl);
            }
        }
        return jSONArray;
    }

    private static void updateAuthorityAllocation(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        String string = PlatformConstants.Success.DATA_SAVE_INFO;
        try {
            PrivilegeService.roleDataSave(httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            string = PlatformConstants.Failure.DATA_SAVE_INFO;
        }
        printWriter.print(string);
        printWriter.flush();
        printWriter.close();
    }

    private static void roleDataSave(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "__parameters__");
        JSONArray jSONArray = new JSONArray(string);
        PrivilegeManager privilegeManager = FRContext.getPrivilegeManager();
        Control control = privilegeManager.getControl();
        if (!(control instanceof AuthorityControl)) {
            control = new AuthorityControl();
        }
        control.clearAuthorityAllocation();
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONArray jSONArray2;
            AuthorityAllocation authorityAllocation = new AuthorityAllocation();
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            Authority authority = new Authority(jSONObject.getString("text"));
            Allocation allocation = new Allocation();
            Object object = jSONObject.get("value");
            JSONArray jSONArray3 = jSONArray2 = object instanceof JSONArray ? (JSONArray)object : new JSONArray();
            if (jSONArray2.length() == 0) continue;
            int n = jSONArray2.length();
            for (int j = 0; j < n; ++j) {
                JSONObject jSONObject2 = jSONArray2.getJSONObject(j);
                if (jSONObject2.getInt("view") == 1) {
                    allocation.addView(new FileFrag(jSONObject2.getString("path"), false));
                }
                if (jSONObject2.getInt("write") == 1) {
                    allocation.addWrite(new FileFrag(jSONObject2.getString("path"), false));
                }
                if (jSONObject2.getInt("design") == 1) {
                    allocation.addDesign(new FileFrag(jSONObject2.getString("path"), false));
                }
                if (jSONObject2.getInt("form") != 1) continue;
                allocation.addForm(new FileFrag(jSONObject2.getString("path"), false));
            }
            authorityAllocation.setAllocation(allocation);
            authorityAllocation.setAuthority(authority);
            control.addAuthorityAllocation(authorityAllocation);
        }
        privilegeManager.setControl(control);
        Env env = FRContext.getCurrentEnv();
        try {
            env.writeResource(privilegeManager);
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
        }
    }

    private static void updateTableDataUserType(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        String string = PlatformConstants.Success.DATA_SAVE_INFO;
        try {
            object = WebUtils.getHTTPRequestParameter(httpServletRequest, "__parameters__");
            JSONObject jSONObject = new JSONObject((String)object);
            DaoAuthenticationProvider daoAuthenticationProvider = new DaoAuthenticationProvider();
            daoAuthenticationProvider.readJSON(jSONObject);
            PrivilegeManager privilegeManager = FRContext.getPrivilegeManager();
            privilegeManager.setAuthenticationProvider(daoAuthenticationProvider);
            Env env = FRContext.getCurrentEnv();
            try {
                env.writeResource(privilegeManager);
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            string = PlatformConstants.Failure.DATA_SAVE_INFO;
        }
        object = WebUtils.createPrintWriter(httpServletResponse);
        ((PrintWriter)object).print(string);
        ((PrintWriter)object).flush();
        ((PrintWriter)object).close();
    }

    private static void updateLdapUserType(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        String string = PlatformConstants.Success.DATA_SAVE_INFO;
        try {
            object = CodeUtils.cjkDecode(WebUtils.getHTTPRequestParameter(httpServletRequest, "__parameters__"));
            JSONObject jSONObject = new JSONObject((String)object);
            LDAPAuthenticationProvider lDAPAuthenticationProvider = new LDAPAuthenticationProvider();
            lDAPAuthenticationProvider.readJSON(jSONObject);
            PrivilegeManager privilegeManager = FRContext.getPrivilegeManager();
            privilegeManager.setAuthenticationProvider(lDAPAuthenticationProvider);
            Env env = FRContext.getCurrentEnv();
            try {
                env.writeResource(privilegeManager);
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            string = PlatformConstants.Failure.DATA_SAVE_INFO;
        }
        object = WebUtils.createPrintWriter(httpServletResponse);
        ((PrintWriter)object).print(string);
        ((PrintWriter)object).flush();
        ((PrintWriter)object).close();
    }

    private static void updateHttpUserType(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        String string = PlatformConstants.Success.DATA_SAVE_INFO;
        try {
            object = CodeUtils.cjkDecode(WebUtils.getHTTPRequestParameter(httpServletRequest, "__parameters__"));
            JSONObject jSONObject = new JSONObject((String)object);
            HttpAuthenticationProvider httpAuthenticationProvider = new HttpAuthenticationProvider();
            httpAuthenticationProvider.readJSON(jSONObject);
            PrivilegeManager privilegeManager = FRContext.getPrivilegeManager();
            privilegeManager.setAuthenticationProvider(httpAuthenticationProvider);
            Env env = FRContext.getCurrentEnv();
            try {
                env.writeResource(privilegeManager);
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            string = PlatformConstants.Failure.DATA_SAVE_INFO;
        }
        object = WebUtils.createPrintWriter(httpServletResponse);
        ((PrintWriter)object).print(string);
        ((PrintWriter)object).flush();
        ((PrintWriter)object).close();
    }

    private static void createNullAuthFace(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ReportletDealWith.dealWithReportlet(httpServletRequest, httpServletResponse, WebletFactory.createEmbeddedReportlet("/com/fr/web/platform/cpt/nullauthen.cpt", new ShowWorkBookPolicy.Policy4Form()));
    }

    private static void updateNullAuth(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = PlatformConstants.Success.DATA_SAVE_INFO;
        PrivilegeManager privilegeManager = FRContext.getPrivilegeManager();
        privilegeManager.setAuthenticationProvider(new NoAuthenticationProvider());
        Env env = FRContext.getCurrentEnv();
        try {
            env.writeResource(privilegeManager);
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            string = PlatformConstants.Failure.DATA_SAVE_INFO;
        }
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.print(string);
        printWriter.flush();
        printWriter.close();
    }

    private static void createAuthorirtyAllocationTypeFace(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Control control = FRContext.getPrivilegeManager().getControl();
        hashMap.put("rType", control.getID());
        ReportletDealWith.dealWithReportlet(httpServletRequest, httpServletResponse, WebletFactory.createEmbeddedReportlet("/com/fr/web/platform/cpt/roleType.cpt", new ShowWorkBookPolicy.Policy4Form(), hashMap));
    }

    private static void generatePermissionControl(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ReportletDealWith.dealWithReportlet(httpServletRequest, httpServletResponse, WebletFactory.createEmbeddedReportlet("/com/fr/web/platform/cpt/permissionControl.cpt", new ShowWorkBookPolicy.Policy4Form()));
    }

    private static void updatePermissionControl(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = PlatformConstants.Success.DATA_SAVE_INFO;
        PrivilegeManager privilegeManager = FRContext.getPrivilegeManager();
        privilegeManager.setControl(new PermissonControl());
        Env env = FRContext.getCurrentEnv();
        try {
            env.writeResource(privilegeManager);
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            string = PlatformConstants.Failure.DATA_SAVE_INFO;
        }
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.print(string);
        printWriter.flush();
        printWriter.close();
    }

    private static void generateNoControl(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ReportletDealWith.dealWithReportlet(httpServletRequest, httpServletResponse, WebletFactory.createEmbeddedReportlet("/com/fr/web/platform/cpt/noControl.cpt", new ShowWorkBookPolicy.Policy4Form()));
    }

    private static void updateNoControl(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = PlatformConstants.Success.DATA_SAVE_INFO;
        PrivilegeManager privilegeManager = FRContext.getPrivilegeManager();
        privilegeManager.setControl(new NoAuthorityControl());
        Env env = FRContext.getCurrentEnv();
        try {
            env.writeResource(privilegeManager);
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            string = PlatformConstants.Failure.DATA_SAVE_INFO;
        }
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.print(string);
        printWriter.flush();
        printWriter.close();
    }

    private static class Allow {
        private String roleName;

        public Allow() {
        }

        public Allow(String string) {
            this.roleName = string;
        }

        private Allocation getAllocation() {
            if (this.roleName == null) {
                return new Allocation();
            }
            Control control = FRContext.getPrivilegeManager().getControl();
            AuthorityAllocation authorityAllocation = control.getAuthorityAllocation(this.roleName);
            if (authorityAllocation == null) {
                control.addAuthorityAllocation(new AuthorityAllocation(new Authority(this.roleName), new Allocation()));
            }
            return control.getAuthorityAllocation(this.roleName).getAllocation();
        }

        public int allowView(String string) throws JSONException {
            Allocation allocation = this.getAllocation();
            int n = allocation.getViewCount();
            for (int i = 0; i < n; ++i) {
                if (!StringUtils.equalsIgnore(allocation.getView(i).getPath(), string, "/")) continue;
                return 1;
            }
            return 0;
        }

        public int allowWrite(String string) throws JSONException {
            Allocation allocation = this.getAllocation();
            int n = allocation.getWriteCount();
            for (int i = 0; i < n; ++i) {
                if (!StringUtils.equalsIgnore(allocation.getWrite(i).getPath(), string, "/")) continue;
                return 1;
            }
            return 0;
        }

        public int allowDesign(String string) throws JSONException {
            Allocation allocation = this.getAllocation();
            int n = allocation.getDesignCount();
            for (int i = 0; i < n; ++i) {
                if (!StringUtils.equalsIgnore(allocation.getDesign(i).getPath(), string, "/")) continue;
                return 1;
            }
            return 0;
        }

        public int allowForm(String string) throws JSONException {
            Allocation allocation = this.getAllocation();
            int n = allocation.getFormCount();
            for (int i = 0; i < n; ++i) {
                if (!StringUtils.equalsIgnore(allocation.getForm(i).getPath(), string, "/")) continue;
                return 1;
            }
            return 0;
        }
    }
}

