/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.service;

import com.fr.base.FRContext;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.FRCoreContext;
import com.fr.base.core.html.Tag;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.util.TemplateUtils;
import com.fr.base.dav.Env;
import com.fr.util.Consts;
import com.fr.web.core.HTMLWriterUtils;
import com.fr.web.core.WebUtils;
import com.fr.web.core.service.NoSessionIDService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.crypto.Cipher;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RegProcessorService
extends NoSessionIDService {
    private static RegProcessorService REGPROCESSOR_SERVICE = new RegProcessorService();

    private RegProcessorService() {
    }

    public static RegProcessorService getInstance() {
        return REGPROCESSOR_SERVICE;
    }

    public boolean accept(String string) {
        return string.equals("reg") || string.startsWith("reg_");
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        if (string == null) {
            return;
        }
        if ("reg".equals(string = string.toLowerCase())) {
            RegProcessorService.openRegPage(httpServletRequest, httpServletResponse);
        } else if ("reg_load".equals(string)) {
            RegProcessorService.loadRegPane(httpServletRequest, httpServletResponse);
        } else if ("reg_intranet".equals(string)) {
            RegProcessorService.regOnIntranet(httpServletRequest, httpServletResponse);
        } else if ("reg_successfully".equals(string)) {
            PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
            printWriter.println("Registration successfully! please restart your server!");
            printWriter.flush();
            printWriter.close();
        } else if ("reg_failed".equals(string)) {
            PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
            printWriter.println("Registration failed! please contact finereport!");
            printWriter.flush();
            printWriter.close();
        } else if ("reg_diagnose".equals(string)) {
            RegProcessorService.diagnose(httpServletRequest, httpServletResponse);
        }
    }

    private static void openRegPage(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Env env = FRContext.getCurrentEnv();
        InputStream inputStream = null;
        if (env != null) {
            try {
                inputStream = env.readResource("FineReport.lic");
            }
            catch (Exception exception) {
                inputStream = null;
            }
        }
        if (inputStream != null) {
            PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
            printWriter.println("This FineReport has been registered!<br>FineReport.lic is under directory WEB-INF/resources/");
            printWriter.flush();
            printWriter.close();
        } else {
            Map map = WebUtils.createTemplateMap(httpServletRequest);
            map.put("charset", FRContext.getConfigManager().getServerCharset());
            TemplateUtils.dealWithTemplate("/com/fr/web/core/dialog/reg.html", httpServletResponse, map);
        }
    }

    private static void loadRegPane(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        Tag tag = HTMLWriterUtils.writeRegForm(httpServletRequest);
        if (tag != null) {
            tag.writeHtml(printWriter);
            printWriter.flush();
            printWriter.close();
        }
        printWriter.flush();
        printWriter.close();
    }

    private static void diagnose(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        byte[] byArray = FRCoreContext.getBytes();
        if (byArray != null && byArray.length != 0) {
            PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
            Properties properties = new Properties();
            try {
                properties.load(new ByteArrayInputStream(byArray));
            }
            catch (IOException iOException) {
                FRContext.getLogger().log(Level.WARNING, iOException.getMessage(), iOException);
            }
            printWriter.println("version " + properties.getProperty("version"));
            printWriter.println("macaddress " + BaseCoreUtils.matchMacAddress((String)properties.get("macaddress")));
            printWriter.println("version " + (String)properties.get("vt4"));
            printWriter.flush();
            printWriter.close();
        }
    }

    private static void regOnIntranet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "form_value");
        JSONObject jSONObject = new JSONObject(string);
        jSONObject.put("version", Consts.VERSION).put("macaddress", BaseCoreUtils.getMacAddress()).put("appname", httpServletRequest.getContextPath().replaceAll("/", ""));
        httpServletResponse.setHeader("Cache-Control", "public");
        httpServletResponse.setHeader("Cache-Control", "max-age=180");
        httpServletResponse.setContentType("application/octet-stream");
        httpServletResponse.setHeader("extension", "txt");
        httpServletResponse.setHeader("Content-disposition", "attachment; filename=RegistrationInformation.txt");
        try {
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            servletOutputStream.write(jSONObject.toString().getBytes("UTF-8"));
            servletOutputStream.flush();
            servletOutputStream.close();
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
        }
    }

    private static void crypt(InputStream inputStream, OutputStream outputStream, Cipher cipher) throws IOException, GeneralSecurityException {
        int n = cipher.getBlockSize();
        int n2 = cipher.getOutputSize(n);
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        boolean bl = true;
        while (bl) {
            n3 = inputStream.read(byArray);
            if (n3 == n) {
                int n4 = cipher.update(byArray, 0, n, byArray2);
                outputStream.write(byArray2, 0, n4);
                continue;
            }
            bl = false;
        }
        byArray2 = n3 > 0 ? cipher.doFinal(byArray, 0, n3) : cipher.doFinal();
        outputStream.write(byArray2);
    }
}

