/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.service;

import com.fr.base.ArrayUtils;
import com.fr.base.FRContext;
import com.fr.base.XMLFileManager;
import com.fr.base.XMLTools;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.UUID;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.json.JSONUtils;
import com.fr.base.core.util.vt.VT4FR;
import com.fr.base.dav.DavXMLUtils;
import com.fr.base.dav.Env;
import com.fr.base.dav.EnvException;
import com.fr.base.dav.FileNode;
import com.fr.base.file.CacheManager;
import com.fr.base.file.ConfigManager;
import com.fr.base.file.DatasourceManager;
import com.fr.base.file.FaceManager;
import com.fr.base.file.FunctionManager;
import com.fr.data.TableData;
import com.fr.data.core.DataUtils;
import com.fr.data.core.db.TableProcedure;
import com.fr.data.impl.DatabaseConnection;
import com.fr.data.impl.EmbeddedTableData;
import com.fr.privilege.authentication.Authentication;
import com.fr.privilege.authentication.UsernamePasswordAuthentication;
import com.fr.privilege.authority.Authority;
import com.fr.privilege.authority.Control;
import com.fr.privilege.manager.PrivilegeManager;
import com.fr.privilege.providers.AuthenticationProvider;
import com.fr.report.ResultWorkBook;
import com.fr.report.TemplateWorkBook;
import com.fr.report.WorkBook;
import com.fr.report.io.ZipTemplateExporter;
import com.fr.report.io.ZipTemplateImporter;
import com.fr.report.parameter.Parameter;
import com.fr.report.web.ui.WidgetManager;
import com.fr.util.Utils;
import com.fr.web.core.WebUtils;
import com.fr.web.core.service.NoSessionIDOPService;
import com.fr.web.platform.PlatformControl;
import com.fr.web.platform.PlatformManager;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class RemoteDesignService
extends NoSessionIDOPService {
    private static RemoteDesignService REMOTEDESIGN_SERVICE = new RemoteDesignService();
    private static final UserEnv users = new UserEnv();
    private static final Object FILE_LOCK = new Object();
    public static final String INVALID_USER = "invalid user.";
    public static final String NO_SUCH_AUTHORITY = "No_Such_Authority";
    public static final String FILE_LOCKED = "file is locked by others.";
    public static final String RUNTIME_ERROR_PREFIX = "___FR_RUNTIME_ERROR_PREFIX___";
    public static final String NO_SUCH_RESOURCE = "No_such_resource";
    public static final String SIGN_IN = "design_sign_in";
    public static final String SIGN_OUT = "design_sign_out";
    public static final String GET_LOCK = "design_get_lock";
    public static final String RELEASE_LOCK = "design_release_lock";
    public static final String OPEN_REPORT = "design_open_report";
    public static final String SAVE_REPORT = "design_save_report";
    public static final String OPEN_RESOURCE = "design_open_resource";
    public static final String SAVE_RESOURCE = "design_save_resource";
    public static final String REPORT_EXIST = "design_report_exist";
    public static final String CREATE_FOLDER = "design_create_folder";
    public static final String CREATE_FILE = "design_create_file";
    public static final String FILE_EXISTS = "design_file_exists";
    public static final String FILE_INPUTSTREAM = "design_file_inputstream";
    public static final String LIST_FILE = "design_list_file";
    public static final String TEST_CON = "design_test_con";
    public static final String GET_TABLES = "design_get_tables";
    public static final String GET_TVP = "design_get_tvp";
    public static final String TABLEDATA_PARS = "design_td_pars";
    public static final String PREVIEW_TABLEDATA = "design_preview_td";
    public static final String REPORT_PARS = "design_report_pars";
    public static final String EXECUTE_REPORT = "design_execute_report";
    public static final String TEST_SERVER = "design_test_server_connection";
    public static final String GET_SCHEMA = "design_get_schema";
    private static final String ENTER = "\n";
    private static final String COLON = ":";

    private RemoteDesignService() {
    }

    public static RemoteDesignService getInstance() {
        return REMOTEDESIGN_SERVICE;
    }

    public boolean accept(String string) {
        return VT4FR.REMOTE_DESIGN.support() && string.startsWith("design_");
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = RemoteDesignService._dealWithRequest(httpServletRequest, httpServletResponse);
        if (string != null) {
            try {
                PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse, "UTF-8");
                printWriter.print(RUNTIME_ERROR_PREFIX + string);
                printWriter.flush();
                printWriter.close();
            }
            catch (Exception exception) {
                FRContext.getLogger().warning(exception.getMessage());
            }
        }
    }

    private static String _dealWithRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = null;
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "op");
        if (TEST_SERVER.equals(string2)) {
            try {
                RemoteDesignService.test_server_connnection(httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                FRContext.getLogger().warning(exception.getMessage());
                string = RemoteDesignService.createExceptionMessage("connect server error", exception);
            }
            return string;
        }
        String string3 = null;
        if (!SIGN_IN.equals(string2)) {
            String string4 = WebUtils.getHTTPRequestParameter(httpServletRequest, "id");
            string3 = RemoteDesignService.is_userID_invalid(httpServletResponse, string4);
            if (string3 == null) {
                return INVALID_USER;
            }
        } else {
            try {
                RemoteDesignService.sign_in(httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                FRContext.getLogger().warning(exception.getMessage());
                string = RemoteDesignService.createExceptionMessage("Response encode error", exception);
            }
            return string;
        }
        if (SIGN_OUT.equals(string2)) {
            try {
                RemoteDesignService.sign_out(httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                FRContext.getLogger().warning(exception.getMessage());
                string = RemoteDesignService.createExceptionMessage("Response encode error", exception);
            }
        } else if (OPEN_REPORT.equals(string2)) {
            try {
                RemoteDesignService.read_report(httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                FRContext.getLogger().warning(exception.getMessage());
                string = RemoteDesignService.createExceptionMessage("Open report error", exception);
            }
        } else if (SAVE_REPORT.equals(string2)) {
            try {
                RemoteDesignService.save_report(httpServletRequest, httpServletResponse, string3);
            }
            catch (Exception exception) {
                string = RemoteDesignService.createExceptionMessage("Save report error", exception);
                string = exception.getMessage();
            }
        } else if (GET_LOCK.equals(string2)) {
            try {
                RemoteDesignService.get_lock(httpServletRequest, httpServletResponse, string3);
            }
            catch (Exception exception) {
                FRContext.getLogger().warning(exception.getMessage());
                string = RemoteDesignService.createExceptionMessage("Get file lock error", exception);
            }
        } else if (RELEASE_LOCK.equals(string2)) {
            try {
                RemoteDesignService.release_lock(httpServletRequest, httpServletResponse, string3);
            }
            catch (Exception exception) {
                FRContext.getLogger().warning(exception.getMessage());
                string = RemoteDesignService.createExceptionMessage("Release file lock error", exception);
            }
        } else if (OPEN_RESOURCE.equals(string2)) {
            try {
                RemoteDesignService.read_resource(httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                FRContext.getLogger().warning(exception.getMessage());
                string = RemoteDesignService.createExceptionMessage("Open resource error", exception);
            }
        } else if (SAVE_RESOURCE.equals(string2)) {
            try {
                RemoteDesignService.save_resource(httpServletRequest, httpServletResponse, string3);
            }
            catch (Exception exception) {
                FRContext.getLogger().warning(exception.getMessage());
                string = RemoteDesignService.createExceptionMessage("Save resource error", exception);
            }
        } else if (REPORT_EXIST.equals(string2)) {
            try {
                RemoteDesignService.is_report_exist(httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                FRContext.getLogger().warning(exception.getMessage());
                string = RemoteDesignService.createExceptionMessage("Check report existing error", exception);
            }
        } else if (CREATE_FOLDER.equals(string2)) {
            try {
                RemoteDesignService.create_folder(httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                FRContext.getLogger().warning(exception.getMessage());
                string = RemoteDesignService.createExceptionMessage("Create folder error", exception);
            }
        } else if (CREATE_FILE.equals(string2)) {
            try {
                RemoteDesignService.create_file(httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                FRContext.getLogger().warning(exception.getMessage());
                string = RemoteDesignService.createExceptionMessage("Create file error", exception);
            }
        } else if (FILE_EXISTS.equals(string2)) {
            try {
                RemoteDesignService.file_exists(httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                FRContext.getLogger().warning(exception.getMessage());
                string = RemoteDesignService.createExceptionMessage("Check file exists error", exception);
            }
        } else if (FILE_INPUTSTREAM.equals(string2)) {
            try {
                RemoteDesignService.file_inputstream(httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                FRContext.getLogger().warning(exception.getMessage());
                string = RemoteDesignService.createExceptionMessage("Get file inputstreame error", exception);
            }
        } else if (LIST_FILE.equals(string2)) {
            try {
                RemoteDesignService.list_file(httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                FRContext.getLogger().warning(exception.getMessage());
                string = RemoteDesignService.createExceptionMessage("List files error", exception);
            }
        } else if (TEST_CON.equals(string2)) {
            try {
                RemoteDesignService.testConnection(httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                FRContext.getLogger().warning(exception.getMessage());
                string = RemoteDesignService.createExceptionMessage("Test database connection error", exception);
            }
        } else if (GET_TABLES.equals(string2)) {
            try {
                RemoteDesignService.getSQLTables(httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                FRContext.getLogger().warning(exception.getMessage());
                string = RemoteDesignService.createExceptionMessage("Get tables of the certain database error", exception);
            }
        } else if (GET_TVP.equals(string2)) {
            try {
                RemoteDesignService.getTVP(httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                FRContext.getLogger().warning(exception.getMessage());
                string = RemoteDesignService.createExceptionMessage("Get tables of the certain database error", exception);
            }
        } else if (GET_SCHEMA.equals(string2)) {
            try {
                RemoteDesignService.getSchema(httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                FRContext.getLogger().warning(exception.getMessage());
                string = RemoteDesignService.createExceptionMessage("Get schema of the certain database error", exception);
            }
        } else if (TABLEDATA_PARS.equals(string2)) {
            try {
                RemoteDesignService.getTableDataParameters(httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                FRContext.getLogger().warning(exception.getMessage());
                string = RemoteDesignService.createExceptionMessage("Get parameters of tabledata error", exception);
            }
        } else if (PREVIEW_TABLEDATA.equals(string2)) {
            try {
                RemoteDesignService.previewTableData(httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                string = RemoteDesignService.createExceptionMessage("Preview tabledata error", exception);
            }
        } else if (REPORT_PARS.equals(string2)) {
            try {
                RemoteDesignService.getReportParameters(httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                FRContext.getLogger().warning(exception.getMessage());
                string = RemoteDesignService.createExceptionMessage("Get parameters of report error", exception);
            }
        } else if (EXECUTE_REPORT.equals(string2)) {
            try {
                RemoteDesignService.executeReport(httpServletRequest, httpServletResponse);
            }
            catch (Exception exception) {
                FRContext.getLogger().warning(exception.getMessage());
                string = RemoteDesignService.createExceptionMessage("Execute report error", exception);
            }
        }
        return string;
    }

    private static String createExceptionMessage(String string, Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(":\n");
        stringBuffer.append("/------------------Remote Exception------------------").append(ENTER);
        Object[] objectArray = throwable.getStackTrace();
        if (!ArrayUtils.isEmpty(objectArray)) {
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append("\tat " + objectArray[i]).append(ENTER);
            }
            Throwable throwable2 = throwable.getCause();
            if (throwable2 != null) {
                RemoteDesignService.addThrowableMessage(stringBuffer, throwable2, (StackTraceElement[])objectArray);
            }
        }
        stringBuffer.append("------------------Remote Exception------------------/").append(ENTER);
        return stringBuffer.toString();
    }

    private static void addThrowableMessage(StringBuffer stringBuffer, Throwable throwable, StackTraceElement[] stackTraceElementArray) {
        Throwable throwable2;
        if (stringBuffer == null || throwable == null) {
            return;
        }
        Object[] objectArray = throwable.getStackTrace();
        if (ArrayUtils.isEmpty(objectArray) || ArrayUtils.isEmpty(stackTraceElementArray)) {
            return;
        }
        int n = objectArray.length - 1;
        for (int i = stackTraceElementArray.length - 1; n >= 0 && i >= 0 && ((StackTraceElement)objectArray[n]).equals(stackTraceElementArray[i]); --n, --i) {
        }
        int n2 = objectArray.length - 1 - n;
        stringBuffer.append("Caused by: " + throwable.getMessage()).append(":\n");
        for (int i = 0; i <= n; ++i) {
            stringBuffer.append("\tat " + objectArray[i]).append(ENTER);
        }
        if (n2 != 0) {
            stringBuffer.append("\t... " + n2 + " more").append(ENTER);
        }
        if ((throwable2 = throwable.getCause()) != null) {
            RemoteDesignService.addThrowableMessage(stringBuffer, throwable2, (StackTraceElement[])objectArray);
        }
    }

    private static String is_userID_invalid(HttpServletResponse httpServletResponse, String string) {
        return users.getUserName(string);
    }

    private static boolean is_file_writable(HttpServletResponse httpServletResponse, String string, String string2) throws Exception {
        String string3 = users.getLockOwner("reportlets/" + string);
        if (string3 != null && !ComparatorUtils.equals(string3, string2)) {
            PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
            printWriter.print(FILE_LOCKED);
            printWriter.flush();
            printWriter.close();
            return false;
        }
        return true;
    }

    private static void sign_in(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "user");
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "password");
        JSONObject jSONObject = new JSONObject();
        try {
            object = RemoteDesignService.createUserID(httpServletRequest, httpServletResponse, string, string2);
            if (object == null) {
                jSONObject.put("exp", "invalid user or password.");
                FRContext.getLogger().warning("Failed to sign in----USER:[" + string + "].");
            } else {
                Env env = FRContext.getCurrentEnv();
                jSONObject.put("id", object);
                FRContext.getLogger().info("Successfully sign in ----USER:[" + string + "].");
            }
        }
        catch (Exception exception) {
            jSONObject.put("exp", exception.getMessage());
        }
        object = WebUtils.createPrintWriter(httpServletResponse);
        ((PrintWriter)object).println(jSONObject.toString());
        ((PrintWriter)object).flush();
        ((PrintWriter)object).close();
    }

    private static void test_server_connnection(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "user");
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "password");
        String string3 = "";
        boolean bl = false;
        if (FRContext.getPrivilegeManager().usePrivilege()) {
            object = FRContext.getPrivilegeManager();
            AuthenticationProvider authenticationProvider = ((PrivilegeManager)object).getAuthenticationProvider();
            UsernamePasswordAuthentication usernamePasswordAuthentication = new UsernamePasswordAuthentication(string, string2);
            try {
                authenticationProvider.authenticate(usernamePasswordAuthentication);
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            string3 = !bl ? "invalid username or password." : "true";
        } else {
            string3 = "true";
        }
        object = WebUtils.createPrintWriter(httpServletResponse);
        ((PrintWriter)object).println(string3);
        ((PrintWriter)object).flush();
        ((PrintWriter)object).close();
    }

    private static String createUserID(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws Exception {
        if (!FRContext.getPrivilegeManager().usePrivilege()) {
            String string3 = RemoteDesignService.createRandomUserIDString();
            users.regUserName(string, string3);
            return string3;
        }
        PrivilegeManager privilegeManager = FRContext.getPrivilegeManager();
        AuthenticationProvider authenticationProvider = privilegeManager.getAuthenticationProvider();
        if (authenticationProvider == null) {
            return null;
        }
        UsernamePasswordAuthentication usernamePasswordAuthentication = new UsernamePasswordAuthentication(string, string2);
        try {
            authenticationProvider.authenticate(usernamePasswordAuthentication);
        }
        catch (Exception exception) {
            return null;
        }
        if (usernamePasswordAuthentication.isAuthenticated()) {
            PlatformManager platformManager = FRContext.getPlatformManager();
            PlatformControl platformControl = platformManager.getPlatformControl();
            if (platformControl.getAuthoryryNameCount() > 0) {
                Authority[] authorityArray = usernamePasswordAuthentication.getAuthorities();
                int n = authorityArray.length;
                for (int i = 0; i < n; ++i) {
                    if (platformControl.getAuthorityName(authorityArray[i].getName()) == null) continue;
                    String string4 = RemoteDesignService.createRandomUserIDString();
                    users.regUserName(string, string4);
                    users.setAuthentication(usernamePasswordAuthentication);
                    return string4;
                }
            } else {
                String string5 = RemoteDesignService.createRandomUserIDString();
                users.regUserName(string, string5);
                users.setAuthentication(usernamePasswordAuthentication);
                return string5;
            }
        }
        return null;
    }

    private static String createRandomUserIDString() {
        return UUID.randomUUID().toString();
    }

    private static void sign_out(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "id");
        String string2 = users.getUserName(string);
        JSONObject jSONObject = new JSONObject();
        try {
            boolean bl = users.unRegUserID(string);
            jSONObject.put("res", (Object)bl);
            FRContext.getLogger().info("Successfully sign out ----USER:[" + string2 + "].");
        }
        catch (Exception exception) {
            jSONObject.put("exp", exception.getMessage());
            FRContext.getLogger().warning("Failed to sign out ----USER:[" + string2 + "].");
        }
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.println(jSONObject.toString());
        printWriter.flush();
        printWriter.close();
    }

    private static void testConnection(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        DatabaseConnection databaseConnection = DavXMLUtils.readXMLDatabaseConnection((InputStream)servletInputStream);
        boolean bl = FRContext.getCurrentEnv().testConnection(databaseConnection);
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse, "UTF-8");
        printWriter.print(bl);
        printWriter.flush();
        printWriter.close();
    }

    private static void getSchema(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        DatabaseConnection databaseConnection = DavXMLUtils.readXMLDatabaseConnection((InputStream)servletInputStream);
        String[] stringArray = FRContext.getCurrentEnv().getTableSchema(databaseConnection);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        DavXMLUtils.writeXMLFileSchema(stringArray, (OutputStream)servletOutputStream);
        servletOutputStream.flush();
        servletOutputStream.close();
    }

    private static void getSQLTables(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        DatabaseConnection databaseConnection = DavXMLUtils.readXMLDatabaseConnection((InputStream)servletInputStream);
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "__dbschema__");
        string = string == null || string.equals("") ? null : string;
        TableProcedure[] tableProcedureArray = DataUtils.getDatabaseSQLTables(databaseConnection, string);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        DavXMLUtils.writeXMLFileSQLTable(tableProcedureArray, (OutputStream)servletOutputStream);
        servletOutputStream.flush();
        servletOutputStream.close();
    }

    private static void getTVP(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        DatabaseConnection databaseConnection = DavXMLUtils.readXMLDatabaseConnection((InputStream)servletInputStream);
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "__type__");
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "__dbschema__");
        string2 = string2 == null || string2.equals("") ? null : string2;
        TableProcedure[] tableProcedureArray = DataUtils.getTables(databaseConnection, string, string2, false);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        DavXMLUtils.writeXMLFileSQLTable(tableProcedureArray, (OutputStream)servletOutputStream);
        servletOutputStream.flush();
        servletOutputStream.close();
    }

    private static void getTableDataParameters(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        TableData tableData = DavXMLUtils.readXMLTableData((InputStream)servletInputStream);
        Parameter[] parameterArray = FRContext.getCurrentEnv().getTableDataParameters(tableData);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        DavXMLUtils.writeXMLFileParameters(parameterArray, (OutputStream)servletOutputStream);
        servletOutputStream.flush();
        servletOutputStream.close();
    }

    private static void previewTableData(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        TableData tableData = DavXMLUtils.readXMLTableData((InputStream)servletInputStream);
        int n = 200;
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "rowcount");
        if (string != null && string.matches("\\d+")) {
            n = Integer.parseInt(string);
        }
        Map map = JSONUtils.jsonString2Map(WebUtils.getHTTPRequestParameter(httpServletRequest, "pars"));
        TableData tableData2 = FRContext.getCurrentEnv().previewTableData(tableData, map, n);
        tableData2 = EmbeddedTableData.embedify(tableData2, n);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        DavXMLUtils.writeXMLFileTableData(tableData2, (OutputStream)servletOutputStream);
        servletOutputStream.flush();
        servletOutputStream.close();
    }

    private static void getReportParameters(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ZipTemplateImporter zipTemplateImporter = new ZipTemplateImporter();
        WorkBook workBook = zipTemplateImporter.generateTemplate((InputStream)httpServletRequest.getInputStream());
        Parameter[] parameterArray = FRContext.getCurrentEnv().getTemplateParameters(workBook);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        DavXMLUtils.writeXMLFileParameters(parameterArray, (OutputStream)servletOutputStream);
        servletOutputStream.flush();
        servletOutputStream.close();
    }

    private static void executeReport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ZipTemplateImporter zipTemplateImporter = new ZipTemplateImporter();
        WorkBook workBook = zipTemplateImporter.generateTemplate((InputStream)httpServletRequest.getInputStream());
        Map map = JSONUtils.jsonString2Map(WebUtils.getHTTPRequestParameter(httpServletRequest, "pars"));
        ResultWorkBook resultWorkBook = workBook.execute(map);
        ZipTemplateExporter zipTemplateExporter = new ZipTemplateExporter();
        zipTemplateExporter.export((OutputStream)httpServletResponse.getOutputStream(), resultWorkBook);
    }

    private static void create_folder(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "folder_path");
        Env env = FRContext.getCurrentEnv();
        boolean bl = env.createFolder(string);
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse, "UTF-8");
        printWriter.print(bl);
        printWriter.flush();
        printWriter.close();
    }

    private static void create_file(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "file_path");
        Env env = FRContext.getCurrentEnv();
        boolean bl = env.createFile(string);
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse, "UTF-8");
        printWriter.print(bl);
        printWriter.flush();
        printWriter.close();
    }

    private static void file_exists(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "file_path");
        boolean bl = FRContext.getCurrentEnv().fileExists(string);
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse, "UTF-8");
        printWriter.print(bl);
        printWriter.flush();
        printWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void file_inputstream(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "file_path");
        InputStream inputStream = FRContext.getCurrentEnv().fileInputStream(string);
        ServletOutputStream servletOutputStream = null;
        try {
            servletOutputStream = httpServletResponse.getOutputStream();
            if (inputStream == null) {
                PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
                printWriter.print(NO_SUCH_RESOURCE);
                printWriter.flush();
                printWriter.close();
            } else {
                Utils.copyBinaryTo(inputStream, (OutputStream)servletOutputStream);
            }
        }
        finally {
            if (servletOutputStream != null) {
                servletOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void list_file(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "file_path");
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "current_uid");
        if (string == null || string2 == null) {
            return;
        }
        Env env = FRContext.getCurrentEnv();
        FileNode[] fileNodeArray = env.listFile(string);
        Object object = FILE_LOCK;
        synchronized (object) {
            for (int i = 0; i < fileNodeArray.length; ++i) {
                fileNodeArray[i].setLock(users.getLockOwner(fileNodeArray[i].getEnvPath()));
            }
        }
        object = httpServletResponse.getOutputStream();
        DavXMLUtils.writeXMLFileNodes(fileNodeArray, (OutputStream)object);
        ((OutputStream)object).flush();
        ((OutputStream)object).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void get_lock(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        Env env = FRContext.getCurrentEnv();
        ArrayList<FileNode> arrayList = new ArrayList<FileNode>();
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "pathes");
        JSONArray jSONArray = new JSONArray(string2);
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            String string3 = jSONArray.getString(i);
            arrayList.addAll(Arrays.asList(env.listFile(string3)));
        }
        Object object = FILE_LOCK;
        synchronized (object) {
            n = 1;
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                FileNode fileNode = (FileNode)arrayList.get(i);
                String string4 = users.getLockOwner(fileNode.getEnvPath());
                if (string4 == null || ComparatorUtils.equals(string4, string)) continue;
                n = 0;
                break;
            }
            JSONObject jSONObject = new JSONObject();
            if (n != 0) {
                int n3 = arrayList.size();
                for (n2 = 0; n2 < n3; ++n2) {
                    users.setLockOwner(((FileNode)arrayList.get(n2)).getEnvPath(), string);
                }
                jSONObject.put("res", "success.");
            } else {
                jSONObject.put("exp", "some file is locked by others.");
            }
            PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
            printWriter.print(jSONObject.toString());
            printWriter.flush();
            printWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void release_lock(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        Env env = FRContext.getCurrentEnv();
        ArrayList<FileNode> arrayList = new ArrayList<FileNode>();
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "pathes");
        JSONArray jSONArray = new JSONArray(string2);
        int n = jSONArray.length();
        for (int i = 0; i < n; ++i) {
            String string3 = jSONArray.getString(i);
            arrayList.addAll(Arrays.asList(env.listFile(string3)));
        }
        Object object = FILE_LOCK;
        synchronized (object) {
            n = 1;
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                FileNode fileNode = (FileNode)arrayList.get(i);
                String string4 = users.getLockOwner(fileNode.getEnvPath());
                if (string4 == null || ComparatorUtils.equals(string4, string)) continue;
                n = 0;
                break;
            }
            JSONObject jSONObject = new JSONObject();
            if (n != 0) {
                int n3 = arrayList.size();
                for (n2 = 0; n2 < n3; ++n2) {
                    users.setLockOwner(((FileNode)arrayList.get(n2)).getEnvPath(), null);
                }
                jSONObject.put("res", "success.");
            } else {
                jSONObject.put("exp", "some file is locked by others.");
            }
            PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
            printWriter.print(jSONObject.toString());
            printWriter.flush();
            printWriter.close();
        }
    }

    private static void is_report_exist(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "report_path");
        boolean bl = FRContext.getCurrentEnv().isTemplateExist(string);
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse, "UTF-8");
        printWriter.print(bl);
        printWriter.flush();
        printWriter.close();
    }

    private static void read_report(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "report_path");
        Env env = FRContext.getCurrentEnv();
        TemplateWorkBook templateWorkBook = env.readTemplate(string);
        ZipTemplateExporter zipTemplateExporter = new ZipTemplateExporter();
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        zipTemplateExporter.export((OutputStream)servletOutputStream, templateWorkBook);
        servletOutputStream.flush();
        servletOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void save_report(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "report_path");
        Object object = FILE_LOCK;
        synchronized (object) {
            Cloneable cloneable;
            if (!RemoteDesignService.is_file_writable(httpServletResponse, string2, string)) {
                return;
            }
            if (FRContext.getCurrentEnv().isTemplateExist(string2) && !((Control)(cloneable = FRContext.getPrivilegeManager().getControl())).access(users.getAuthentication(), string2, 3)) {
                throw new EnvException(NO_SUCH_AUTHORITY);
            }
            cloneable = FRContext.getCurrentEnv();
            ZipTemplateImporter zipTemplateImporter = new ZipTemplateImporter();
            cloneable.writeTemplate(zipTemplateImporter.generateTemplate((InputStream)httpServletRequest.getInputStream()), string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void read_resource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "resource");
        InputStream inputStream = FRContext.getCurrentEnv().readResource(string);
        ServletOutputStream servletOutputStream = null;
        try {
            servletOutputStream = httpServletResponse.getOutputStream();
            if (inputStream == null) {
                PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
                printWriter.print(NO_SUCH_RESOURCE);
                printWriter.flush();
                printWriter.close();
            } else {
                Utils.copyBinaryTo(inputStream, (OutputStream)servletOutputStream);
            }
        }
        finally {
            if (servletOutputStream != null) {
                servletOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void save_resource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "resource");
        Object object = FILE_LOCK;
        synchronized (object) {
            if (!RemoteDesignService.is_file_writable(httpServletResponse, BaseCoreUtils.pathJoin(new String[]{"resources", string2}), string)) {
                return;
            }
            ServletInputStream servletInputStream = httpServletRequest.getInputStream();
            Env env = FRContext.getCurrentEnv();
            XMLFileManager xMLFileManager = null;
            if (FRContext.getDatasourceManager().fileName().equals(string2)) {
                DatasourceManager datasourceManager = new DatasourceManager();
                XMLTools.readInputStreamXML(datasourceManager, (InputStream)servletInputStream);
                FRContext.setDatasourceManager(datasourceManager);
                xMLFileManager = datasourceManager;
            } else if (FRContext.getWidgetManager().fileName().equals(string2)) {
                WidgetManager widgetManager = new WidgetManager();
                XMLTools.readInputStreamXML(widgetManager, (InputStream)servletInputStream);
                FRContext.setWidgetManager(widgetManager);
                xMLFileManager = widgetManager;
            } else if (FRContext.getFaceManager().fileName().equals(string2)) {
                FaceManager faceManager = new FaceManager();
                XMLTools.readInputStreamXML(faceManager, (InputStream)servletInputStream);
                FRContext.setFaceManager(faceManager);
                xMLFileManager = faceManager;
            } else if (FRContext.getFunctionManager().fileName().equals(string2)) {
                FunctionManager functionManager = new FunctionManager();
                XMLTools.readInputStreamXML(functionManager, (InputStream)servletInputStream);
                FRContext.setFunctionManager(functionManager);
                xMLFileManager = functionManager;
            } else if (FRContext.getConfigManager().fileName().equals(string2)) {
                ConfigManager configManager = new ConfigManager();
                XMLTools.readInputStreamXML(configManager, (InputStream)servletInputStream);
                FRContext.setConfigManager(configManager);
                xMLFileManager = configManager;
            } else if (FRContext.getCacheManager().fileName().equals(string2)) {
                CacheManager cacheManager = new CacheManager();
                XMLTools.readInputStreamXML(cacheManager, (InputStream)servletInputStream);
                FRContext.setCacheManager(cacheManager);
                xMLFileManager = cacheManager;
            } else {
                FRContext.getLogger().log(Level.WARNING, "The XMLFileManager for resource :" + string2 + " may not exist!");
            }
            if (xMLFileManager != null) {
                env.writeResource(xMLFileManager);
            }
        }
    }

    private static class UserInfo {
        private String userName;
        private List locks = Collections.EMPTY_LIST;

        UserInfo(String string) {
            this.userName = string;
        }

        public void lockFile(String string) {
            if (this.locks == Collections.EMPTY_LIST) {
                this.locks = new ArrayList();
            }
            this.locks.add(string);
        }

        public void unlockFile(String string) {
            this.locks.remove(string);
        }
    }

    private static class UserEnv {
        private final Map id_user_map = new HashMap();
        private final Map userName_user_map = new HashMap();
        private final Map lockingFiles = new HashMap();
        private Authentication authentication;

        private UserEnv() {
        }

        public Authentication getAuthentication() {
            return this.authentication;
        }

        public void setAuthentication(Authentication authentication) {
            this.authentication = authentication;
        }

        public void setLockOwner(String string, String string2) {
            if (string == null) {
                return;
            }
            this.unlockFile(string);
            UserInfo userInfo = (UserInfo)this.userName_user_map.get(string2);
            if (userInfo == null) {
                return;
            }
            string = string.replaceAll("\\\\", "/");
            this.lockingFiles.put(string, userInfo);
            userInfo.lockFile(string);
        }

        public void unlockFile(String string) {
            if (string == null) {
                return;
            }
            UserInfo userInfo = (UserInfo)this.lockingFiles.get(string = string.replaceAll("\\\\", "/"));
            if (userInfo != null) {
                userInfo.unlockFile(string);
                this.lockingFiles.remove(string);
            }
        }

        public String getLockOwner(String string) {
            if (string == null) {
                return null;
            }
            UserInfo userInfo = (UserInfo)this.lockingFiles.get(string = string.replaceAll("\\\\", "/"));
            return userInfo == null ? null : userInfo.userName;
        }

        public String getUserName(String string) {
            if (string == null) {
                return null;
            }
            UserInfo userInfo = (UserInfo)this.id_user_map.get(string);
            return userInfo == null ? null : userInfo.userName;
        }

        public void regUserName(String string, String string2) {
            if (string == null || string2 == null) {
                return;
            }
            UserInfo userInfo = new UserInfo(string);
            this.id_user_map.put(string2, userInfo);
            this.userName_user_map.put(string, userInfo);
        }

        public boolean unRegUserID(String string) {
            if (string == null) {
                return true;
            }
            UserInfo userInfo = (UserInfo)this.id_user_map.get(string);
            if (userInfo == null) {
                return true;
            }
            String[] stringArray = userInfo.locks.toArray(new String[userInfo.locks.size()]);
            for (int i = 0; i < stringArray.length; ++i) {
                this.unlockFile(stringArray[i]);
            }
            this.id_user_map.remove(string);
            this.userName_user_map.remove(userInfo.userName);
            return true;
        }

        public boolean isUserRegistrated(String string) {
            return this.userName_user_map.get(string) != null;
        }
    }
}

