/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.service;

import com.fr.base.FRContext;
import com.fr.base.core.util.TemplateUtils;
import com.fr.web.Weblet;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.core.WebUtils;
import com.fr.web.core.service.ExportService;
import com.fr.web.core.service.JMeterService;
import com.fr.web.core.service.PDFPrintService;
import com.fr.web.core.service.SessionDealWith;
import com.fr.web.core.service.SimpleSheetService;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ReportletDealWith {
    private ReportletDealWith() {
    }

    public static void dealWithReportlet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Weblet weblet) throws Exception {
        String string = SessionDealWith.generateSessionID(httpServletRequest, httpServletResponse, weblet);
        if (string == null || !SessionDealWith.hasSessionID(string)) {
            return;
        }
        if (httpServletRequest.getParameter("__isjmeter__") != null) {
            JMeterService.dealWithJMeter(string, httpServletRequest, httpServletResponse);
        } else if (WebUtils.getHTTPRequestParameter(httpServletRequest, "format") != null) {
            String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "format");
            if (string2.equals("pdfprint")) {
                PDFPrintService.dealWithPDFPrint(httpServletRequest, httpServletResponse);
            } else {
                String string3 = WebUtils.getHTTPRequestParameter(httpServletRequest, "__embed__");
                boolean bl = "true".equals(string3);
                ExportService.dealWithExport(httpServletRequest, httpServletResponse, string, bl);
            }
        } else {
            ReportletDealWith.dealWithPageHtml(httpServletRequest, httpServletResponse, string);
        }
    }

    private static void dealWithPageHtml(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        SessionIDInfor sessionIDInfor = SessionDealWith.getSessionIDInfor(string);
        if (sessionIDInfor == null) {
            return;
        }
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "op");
        Map map = null;
        map = "edit".equals(string2) ? WebUtils.context4EditTpl(httpServletRequest, sessionIDInfor) : WebUtils.context4PageTpl(httpServletRequest, sessionIDInfor);
        httpServletResponse.setHeader("Pragma", "No-cache");
        httpServletResponse.setHeader("Cache-Control", "no-cache, no-store");
        httpServletResponse.setDateHeader("Expires", -10L);
        try {
            if ("edit".equals(string2)) {
                TemplateUtils.dealWithTemplate("/com/fr/web/core/edit.html", httpServletResponse, map);
            } else if (httpServletRequest.getParameter("__isdebug__") != null) {
                TemplateUtils.dealWithTemplate("/com/fr/web/core/page_debug.html", httpServletResponse, map);
            } else if ("simplesheet".equals(string2)) {
                SimpleSheetService.dealWithSimpleSheet(sessionIDInfor, httpServletRequest, httpServletResponse, map);
            } else {
                TemplateUtils.dealWithTemplate("/com/fr/web/core/page.html", httpServletResponse, map);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
        }
    }
}

