/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.service;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.base.core.util.TemplateUtils;
import com.fr.util.Utils;
import com.fr.web.core.WebUtils;
import com.fr.web.core.service.NoSessionIDOPService;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResourceService
extends NoSessionIDOPService {
    private static ResourceService resourceService = null;
    public static final String RESOURCE_ENCODER = "GBK";

    private ResourceService() {
    }

    public static ResourceService getInstance() {
        if (resourceService == null) {
            resourceService = new ResourceService();
        }
        return resourceService;
    }

    public boolean accept(String string) {
        return string.equals("resource");
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        block7: {
            String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "resource");
            httpServletResponse.setHeader("Cache-Control", "max-age=86400");
            httpServletResponse.setDateHeader("Expires", System.currentTimeMillis() + 86400000L);
            String string2 = ResourceService.setResourceContentType(string, httpServletResponse);
            try {
                InputStream inputStream;
                if (string2 == "text") {
                    TemplateUtils.dealWithTemplate(string, httpServletResponse, WebUtils.createTemplateMap(httpServletRequest));
                    break block7;
                }
                if (!string.startsWith("/") && !string.startsWith("\\")) {
                    string = File.separator + string;
                }
                if ((inputStream = null) == null) {
                    inputStream = BaseUtils.readResource(string);
                }
                if (inputStream == null) break block7;
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                try {
                    Utils.copyBinaryTo(inputStream, (OutputStream)servletOutputStream);
                    servletOutputStream.flush();
                    servletOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                inputStream.close();
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, string, exception);
            }
        }
    }

    public static String setResourceContentType(String string, HttpServletResponse httpServletResponse) {
        String string2 = string.toLowerCase();
        String string3 = FRContext.getConfigManager().getServerCharset();
        if (string2.endsWith(".png")) {
            httpServletResponse.setContentType("image/png");
            return "image";
        }
        if (string2.endsWith(".gif")) {
            httpServletResponse.setContentType("image/gif");
            return "image";
        }
        if (string2.endsWith(".jpg")) {
            httpServletResponse.setContentType("image/jpeg");
            return "image";
        }
        if (string2.endsWith(".js")) {
            httpServletResponse.setContentType("text/javascript;charset=" + string3);
            return "text";
        }
        if (string2.endsWith(".css")) {
            httpServletResponse.setContentType("text/css;charset=" + string3);
            return "text";
        }
        if (string2.endsWith(".xml")) {
            httpServletResponse.setContentType("text/xml;charset=" + string3);
            return "text";
        }
        if (string2.endsWith(".swf")) {
            httpServletResponse.setContentType("application/x-shockwave-flash");
        } else if (string2.endsWith(".jnlp")) {
            httpServletResponse.setContentType("application/x-java-jnlp-file");
        } else if (string2.endsWith(".xls")) {
            httpServletResponse.setContentType("application/vnd.ms-excel");
        } else if (string2.endsWith(".exe")) {
            httpServletResponse.setContentType("application/x-msdownload");
            httpServletResponse.setHeader("extension", "exe");
            httpServletResponse.setHeader("Content-disposition", "attachment; filename=AcrobatReader.exe");
        } else {
            httpServletResponse.setContentType("text/html;charset=" + string3);
            return "text";
        }
        return "other";
    }
}

