/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.service;

import com.fr.base.CodeUtils;
import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.util.vt.VT4FR;
import com.fr.base.file.DatasourceManager;
import com.fr.data.core.db.dialect.Dialect;
import com.fr.data.core.db.dialect.DialectFactory;
import com.fr.data.impl.JDBCDatabaseConnection;
import com.fr.schedule.ScheduleContext;
import com.fr.schedule.entry.IdGenerator;
import com.fr.schedule.exception.CreateConnectionException;
import com.fr.schedule.exception.NoSourceException;
import com.fr.schedule.output.EmailNotification;
import com.fr.third.org.quartz.SchedulerException;
import com.fr.third.org.quartz.impl.StdSchedulerFactory;
import com.fr.web.core.WebUtils;
import com.fr.web.core.service.ExportService;
import com.fr.web.core.service.NoSessionIDService;
import com.fr.web.platform.entry.EntryManager;
import com.fr.web.platform.tables.PlatTables;
import com.fr.web.platform.tables.QuartzTables;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ScheduleService
extends NoSessionIDService {
    private static ScheduleService SCHEDULE_SERVICE = new ScheduleService();
    public static final String FACTORY_KEY = "com.fr.schedule.StdSchedulerFactory.KEY";
    private boolean performShutdown = true;

    private ScheduleService() {
    }

    public static ScheduleService getInstance() {
        return SCHEDULE_SERVICE;
    }

    public boolean accept(String string) {
        return string.startsWith("fr_schedule_");
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        if (string == null) {
            return;
        }
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        if ("fr_schedule_getdatanames".equals(string)) {
            JSONArray jSONArray = new JSONArray();
            Iterator iterator = FRContext.getDatasourceManager().getConnectionNameIterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                jSONArray.put(new JSONObject().put("value", string2).put("text", string2));
            }
            printWriter.write(CodeUtils.jsonEncode(jSONArray));
            printWriter.flush();
            printWriter.close();
            return;
        }
        if ("fr_schedule_getdataname".equals(string)) {
            if (StringUtils.isNotBlank(FRContext.getDatasourceManager().getScheduleDatasource())) {
                printWriter.write(FRContext.getDatasourceManager().getScheduleDatasource());
                printWriter.flush();
                printWriter.close();
            }
            return;
        }
        if ("fr_schedule_linkname".equals(string)) {
            ScheduleService.dealDatasource(httpServletRequest, httpServletResponse);
            return;
        }
        try {
            this.initScheduleServer(httpServletRequest);
        }
        catch (NoSourceException noSourceException) {
            ScheduleService.dealDatasource(httpServletRequest, httpServletResponse);
            return;
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            return;
        }
        if ("fr_schedule_setdataname".equals(string)) {
            printWriter.write("success");
        }
        if ("fr_schedule_stopcleardata".equals(string)) {
            this.clearScheduleData();
            return;
        }
        if ("fr_schedule_file".equals(string)) {
            ExportService.dealScheduleExport(httpServletRequest, httpServletResponse);
            return;
        }
        if (StringUtils.isEmpty(string)) {
            return;
        }
        if ("fr_schedule_getfolder".equals(string)) {
            JSONArray jSONArray = EntryManager.getFolderEntrys();
            printWriter.print(jSONArray.toString());
        } else if ("fr_schedule_getfiles".equals(string)) {
            String string3 = httpServletRequest.getParameter("folderID");
            JSONArray jSONArray = EntryManager.getContentEntrys(string3);
            printWriter.print(jSONArray.toString());
        } else if ("fr_schedule_addfolder".equals(string)) {
            String string4 = WebUtils.getHTTPRequestParameter(httpServletRequest, "folderJason");
            JSONObject jSONObject = EntryManager.addFolder(string4);
            printWriter.print(jSONObject.toString());
        } else if ("fr_schedule_editfolder".equals(string)) {
            String string5 = WebUtils.getHTTPRequestParameter(httpServletRequest, "folderJason");
            JSONObject jSONObject = EntryManager.addFolder(string5);
            printWriter.print(jSONObject.toString());
        } else if ("fr_schedule_delfolder".equals(string)) {
            String string6 = httpServletRequest.getParameter("folderId");
            EntryManager.deleleFolderByParentId(string6);
        } else if ("fr_schedule_getreport".equals(string)) {
            IdGenerator idGenerator = new IdGenerator();
            JSONArray jSONArray = EntryManager.getReportletsOfCurrentEnv("reportlets", idGenerator);
            printWriter.print(jSONArray.toString());
        } else if ("fr_schedule_addreport".equals(string)) {
            String string7 = WebUtils.getHTTPRequestParameter(httpServletRequest, "reportJason");
            JSONObject jSONObject = EntryManager.addReport(string7);
            printWriter.print(jSONObject.toString());
        } else if ("fr_schedule_delreports".equals(string)) {
            String string8 = httpServletRequest.getParameter("reportIds");
            EntryManager.delReports(string8);
        } else if ("fr_schedule_addurl".equals(string)) {
            String string9 = WebUtils.getHTTPRequestParameter(httpServletRequest, "urlJason");
            JSONObject jSONObject = EntryManager.addURLEntry(string9);
            printWriter.print(jSONObject.toString());
        } else if ("fr_schedule_gettask".equals(string)) {
            String string10 = httpServletRequest.getParameter("reportId");
            JSONArray jSONArray = EntryManager.getTasks(string10);
            printWriter.print(jSONArray.toString());
        } else if ("fr_schedule_aoutask".equals(string)) {
            String string11 = WebUtils.getHTTPRequestParameter(httpServletRequest, "taskJason");
            EntryManager.addOrUpdateTask(string11);
        } else if ("fr_schedule_deltasks".equals(string)) {
            String string12 = httpServletRequest.getParameter("taskIds");
            EntryManager.delTasks(string12);
        } else if ("fr_schedule_genparameter".equals(string)) {
            String string13 = httpServletRequest.getParameter("reportPath");
            JSONArray jSONArray = EntryManager.getParameters(string13);
            printWriter.print(jSONArray.toString());
        } else if ("fr_schedule_statejob".equals(string)) {
            String string14 = httpServletRequest.getParameter("taskId");
            long l = Long.parseLong(string14);
            int n = EntryManager.stateJob(l);
            printWriter.print(n);
        } else if ("fr_schedule_getemailattr".equals(string)) {
            if (EmailNotification.getEmailManager() == null) {
                printWriter.print("FR.i18n.Failed");
            } else {
                printWriter.print(EmailNotification.getEmailManager().createJSON().toString());
            }
        }
        printWriter.flush();
        printWriter.close();
    }

    public static void dealDatasource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.write("nullSchDS");
        printWriter.flush();
        printWriter.close();
    }

    private synchronized void initScheduleServer(HttpServletRequest httpServletRequest) throws Exception {
        Connection connection;
        boolean bl;
        if (!VT4FR.SCHEDULE.support()) {
            return;
        }
        DatasourceManager datasourceManager = FRContext.getDatasourceManager();
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "scheduledataname");
        boolean bl2 = bl = StringUtils.isEmpty(string) ? true : string.equals(datasourceManager.getScheduleDatasource());
        if (ScheduleContext.getScheduler() != null && bl) {
            return;
        }
        if (StringUtils.isNotEmpty(string) && !string.equals(datasourceManager.getScheduleDatasource())) {
            this.releaseSchedule();
        }
        if (StringUtils.isEmpty(datasourceManager.getScheduleDatasource()) && StringUtils.isEmpty(string)) {
            throw new NoSourceException("Need DataSource!");
        }
        if (StringUtils.isNotEmpty(string)) {
            datasourceManager.setScheduleDatasource(string);
            FRContext.getCurrentEnv().writeResource(datasourceManager);
            ScheduleContext.refreshDatabaseConnection();
        }
        JDBCDatabaseConnection jDBCDatabaseConnection = (JDBCDatabaseConnection)datasourceManager.getConnection(datasourceManager.getScheduleDatasource());
        try {
            connection = jDBCDatabaseConnection.createConnection();
        }
        catch (Exception exception) {
            throw new CreateConnectionException("Connection create Error!");
        }
        Dialect dialect = DialectFactory.generateDialect(connection);
        this.createScheduleTables(connection);
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            FRContext.getLogger().log(Level.WARNING, sQLException.getMessage(), sQLException);
        }
        ServletContext servletContext = httpServletRequest.getSession().getServletContext();
        try {
            Object object;
            StdSchedulerFactory stdSchedulerFactory;
            String string2 = servletContext.getInitParameter("config-file");
            String string3 = servletContext.getInitParameter("shutdown-on-unload");
            if (string3 != null) {
                this.performShutdown = Boolean.valueOf(string3);
            }
            if (string2 != null) {
                stdSchedulerFactory = new StdSchedulerFactory(string2);
            } else {
                object = new Properties();
                this.initProperties((Properties)object);
                ((Properties)object).put("com.fr.third.org.quartz.dataSource.myDS.URL", jDBCDatabaseConnection.getURL());
                ((Properties)object).put("com.fr.third.org.quartz.dataSource.myDS.driver", jDBCDatabaseConnection.getDriver());
                ((Properties)object).put("com.fr.third.org.quartz.dataSource.myDS.user", jDBCDatabaseConnection.getUser());
                ((Properties)object).put("com.fr.third.org.quartz.dataSource.myDS.password", jDBCDatabaseConnection.getPassword());
                ((Properties)object).put("com.fr.third.org.quartz.jobStore.driverDelegateClass", dialect.quartzDelegateClass());
                stdSchedulerFactory = new StdSchedulerFactory((Properties)object);
            }
            ScheduleContext.setScheduler(stdSchedulerFactory.getScheduler());
            object = servletContext.getInitParameter("start-scheduler-on-load");
            int n = 0;
            String string4 = servletContext.getInitParameter("start-delay-seconds");
            try {
                if (string4 != null && string4.trim().length() > 0) {
                    n = Integer.parseInt(string4);
                }
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, "Cannot parse value of 'start-delay-seconds' to an integer: " + string4 + ", defaulting to 5 seconds.");
                n = 5;
            }
            if (object == null || Boolean.valueOf((String)object).booleanValue()) {
                if (n <= 0) {
                    ScheduleContext.getScheduler().start();
                    FRContext.getLogger().log(Level.WARNING, "Scheduler has been started...");
                } else {
                    ScheduleContext.getScheduler().startDelayed(n);
                    FRContext.getLogger().log(Level.WARNING, "Scheduler will start in " + n + " seconds.");
                }
            } else {
                FRContext.getLogger().log(Level.WARNING, "Scheduler has not been started. Use scheduler.start()");
            }
            String string5 = servletContext.getInitParameter("servlet-context-factory-key");
            if (string5 == null) {
                string5 = FACTORY_KEY;
            }
            FRContext.getLogger().log(Level.WARNING, "Storing the FineReport Scheduler Factory in the servlet context at key: " + string5);
            servletContext.setAttribute(string5, (Object)stdSchedulerFactory);
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
        }
    }

    private static void releaseSchedule() {
        if (ScheduleContext.getScheduler() != null) {
            try {
                ScheduleContext.getScheduler().shutdown();
            }
            catch (SchedulerException schedulerException) {
                FRContext.getLogger().log(Level.WARNING, schedulerException.getMessage(), schedulerException);
                return;
            }
            ScheduleContext.setScheduler(null);
            FRContext.getLogger().log(Level.WARNING, "FineReport Scheduler has been shutdown successfully!");
        }
    }

    private void createScheduleTables(Connection connection) {
        QuartzTables quartzTables = new QuartzTables();
        PlatTables platTables = new PlatTables();
        quartzTables.generatorModuleTables(connection);
        platTables.generatorModuleTables(connection);
    }

    private void removeScheduleTables(Connection connection) {
        QuartzTables quartzTables = new QuartzTables();
        PlatTables platTables = new PlatTables();
        quartzTables.removeModuleTables(connection);
        platTables.removeModuleTables(connection);
    }

    private void clearScheduleData() {
        ScheduleService.releaseSchedule();
        DatasourceManager datasourceManager = FRContext.getDatasourceManager();
        JDBCDatabaseConnection jDBCDatabaseConnection = (JDBCDatabaseConnection)datasourceManager.getConnection(datasourceManager.getScheduleDatasource());
        Connection connection = null;
        try {
            connection = jDBCDatabaseConnection.createConnection();
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            return;
        }
        this.removeScheduleTables(connection);
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            FRContext.getLogger().log(Level.WARNING, sQLException.getMessage(), sQLException);
        }
        datasourceManager.setScheduleDatasource(null);
        try {
            FRContext.getCurrentEnv().writeResource(datasourceManager);
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
        }
    }

    private void initProperties(Properties properties) {
        properties.put("com.fr.third.org.quartz.jobStore.class", "com.fr.third.org.quartz.impl.jdbcjobstore.JobStoreTX");
        properties.put("com.fr.third.org.quartz.jobStore.dataSource", "myDS");
        properties.put("com.fr.third.org.quartz.dataSource.myDS.maxConnections", "5");
        properties.put("com.fr.third.org.quartz.jobStore.isClustered", new Boolean(false));
        properties.put("com.fr.third.org.quartz.jobStore.tablePrefix", "QRTZ_");
        properties.put("com.fr.third.org.quartz.jobStore.useProperties", new Boolean(false));
        properties.put("com.fr.third.org.quartz.threadPool.class", "com.fr.third.org.quartz.simpl.SimpleThreadPool");
        properties.put("com.fr.third.org.quartz.threadPool.threadCount", "10");
    }
}

