/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.service;

import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.cache.store.MemoryStoreEvictionPolicy;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.print.PrintUtils;
import com.fr.data.impl.Connection;
import com.fr.data.impl.JDBCDatabaseConnection;
import com.fr.data.pool.ConnectionPoolManager;
import com.fr.report.web.EmailManager;
import com.fr.schedule.ScheduleContext;
import com.fr.schedule.output.EmailNotification;
import com.fr.web.core.ServerConstants;
import com.fr.web.core.WebUtils;
import com.fr.web.core.service.NoSessionIDService;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServerConfigService
extends NoSessionIDService {
    private static ServerConfigService SERVER_SERVICE = new ServerConfigService();

    private ServerConfigService() {
    }

    public static ServerConfigService getInstance() {
        return SERVER_SERVICE;
    }

    public boolean accept(String string) {
        return string.startsWith("fr_server");
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        if (string == null) {
            return;
        }
        if ("fr_server_testmail".equals(string)) {
            ServerConfigService.dealWithTestMail(httpServletRequest, httpServletResponse);
        } else if ("fr_server_emailattrset".equals(string)) {
            ServerConfigService.dealWithEmailAttrSet(httpServletRequest, httpServletResponse);
        } else if ("fr_server_getmailinfo".equals(string)) {
            ServerConfigService.dealWithGetMailInfo(httpServletRequest, httpServletResponse);
        } else if ("fr_server_getcacheinfo".equals(string)) {
            ServerConfigService.dealWithGetCacheInfo(httpServletRequest, httpServletResponse);
        } else if ("fr_server_cacheattrset".equals(string)) {
            ServerConfigService.dealWithCacheAttrSet(httpServletRequest, httpServletResponse);
        } else if ("fr_server_getconfiginfo".equals(string)) {
            ServerConfigService.dealWithGetConfigInfo(httpServletRequest, httpServletResponse);
        } else if ("fr_server_configattrset".equals(string)) {
            ServerConfigService.dealWithConfigAttrSet(httpServletRequest, httpServletResponse);
        } else if ("fr_server_getconpoolinfo".equals(string)) {
            ServerConfigService.dealWithGetConPoolInfo(httpServletRequest, httpServletResponse);
        } else if ("fr_server_getconnectioninfo".equals(string)) {
            this.dealWithGetConnectionInfo(httpServletRequest, httpServletResponse);
        } else if ("fr_server_connectionattrset".equals(string)) {
            this.dealWithConnectionAttrSet(httpServletRequest, httpServletResponse);
        }
    }

    private static void dealWithTestMail(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        JSONObject jSONObject = null;
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        String string = "success";
        try {
            jSONObject = new JSONObject(WebUtils.getHTTPRequestParameter(httpServletRequest, "emailToAttr"));
            EmailManager emailManager = new EmailManager();
            emailManager.setMailHost(jSONObject.getString("serverName"));
            emailManager.setUser(jSONObject.getString("userName"));
            emailManager.setPassword(jSONObject.getString("passWord"));
            emailManager.setFromEmailAddress(jSONObject.getString("fromAddress"));
            emailManager.sendTestMail(jSONObject.getString("toAddress"));
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            string = exception.getMessage();
        }
        printWriter.write(string);
        printWriter.flush();
        printWriter.close();
    }

    private static void dealWithEmailAttrSet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        JSONObject jSONObject = null;
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        String string = "success";
        try {
            jSONObject = new JSONObject(WebUtils.getHTTPRequestParameter(httpServletRequest, "emailAttrJson"));
            EmailNotification.getEmailManager().parseJSON(jSONObject);
            FRContext.getCurrentEnv().writeResource(FRContext.getConfigManager());
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
            string = jSONException.getMessage();
        }
        printWriter.write(string);
        printWriter.flush();
        printWriter.close();
    }

    private static void dealWithGetMailInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        JSONObject jSONObject = new JSONObject();
        String string = EmailNotification.getEmailManager().getMailHost();
        String string2 = EmailNotification.getEmailManager().getUser();
        String string3 = EmailNotification.getEmailManager().getPassword();
        String string4 = EmailNotification.getEmailManager().getFromEmailAddress();
        jSONObject.put("serverName", string);
        jSONObject.put("userName", string2);
        jSONObject.put("passWord", string3);
        jSONObject.put("fromAddress", string4);
        printWriter.print(jSONObject);
        printWriter.flush();
        printWriter.close();
    }

    private static void dealWithGetCacheInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        JSONObject jSONObject = new JSONObject();
        int n = FRContext.getCacheManager().getDbConfig().getMaxElementsInMemory();
        MemoryStoreEvictionPolicy memoryStoreEvictionPolicy = FRContext.getCacheManager().getDbConfig().getMemoryStoreEvictionPolicy();
        long l = FRContext.getCacheManager().getDbConfig().getTimeToIdleSeconds();
        long l2 = FRContext.getCacheManager().getDbConfig().getTimeToLiveSeconds();
        boolean bl = FRContext.getCacheManager().isAlwaysReloadTpl();
        jSONObject.put("maxElementsInMemory", n);
        jSONObject.put("memoryStoreEvictionPolicy", memoryStoreEvictionPolicy);
        jSONObject.put("timeToIdleSeconds", l);
        jSONObject.put("timeToLiveSeconds", l2);
        jSONObject.put("alwaysReloadTpl", bl);
        printWriter.print(jSONObject);
        printWriter.flush();
        printWriter.close();
    }

    private static void dealWithCacheAttrSet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        JSONObject jSONObject = new JSONObject();
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        String string = "success";
        try {
            jSONObject = new JSONObject(WebUtils.getHTTPRequestParameter(httpServletRequest, "cacheAttrJson"));
            FRContext.getCacheManager().getDbConfig().parseJSON(jSONObject);
            FRContext.getCacheManager().setAlwaysReloadTpl(jSONObject.getBoolean("alwaysReloadTpl"));
            FRContext.getCurrentEnv().writeResource(FRContext.getConfigManager());
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
            string = jSONException.getMessage();
        }
        printWriter.write(string);
        printWriter.flush();
        printWriter.close();
    }

    private static void dealWithGetConfigInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        JSONObject jSONObject = new JSONObject();
        Object[] objectArray = FRContext.getDatasourceManager().getConnectionNameArray();
        String string = FRContext.getDatasourceManager().getScheduleDatasource();
        String string2 = "reportlets";
        String string3 = "resources";
        String string4 = FRContext.getConfigManager().getServerCharset();
        String[] stringArray = ServerConstants.ENCODING_ARRAY;
        String[] stringArray2 = new String[]{"", Inter.getLocText("Simplified_Chinese_Language"), Inter.getLocText("English_Language"), Inter.getLocText("Japanese_Language"), Inter.getLocText("Traditional_Chinese_Language")};
        String string5 = stringArray2[FRContext.getConfigManager().getServerLanguage()];
        String string6 = FRContext.getConfigManager().getServletMapping();
        boolean bl = FRContext.getConfigManager().isSupportGzip();
        boolean bl2 = FRContext.getConfigManager().isPopupFlashPrintSetting();
        boolean bl3 = FRContext.getConfigManager().isPopupPdfPrintSetting();
        Level[] levelArray = new Level[]{Level.SEVERE, Level.WARNING, Level.INFO};
        Level level = FRContext.getConfigManager().getServerLogLevel();
        int n = FRContext.getConfigManager().getConcurrency();
        int n2 = FRContext.getConfigManager().getConcurrencyOnce();
        String[] stringArray3 = PrintUtils.getSystemPrinterNameArray();
        String[] stringArray4 = FRContext.getConfigManager().getReportWebAttr().getPrinter().getPrinters();
        jSONObject.put("connectionNameArray", objectArray);
        jSONObject.put("scheduleDatasource", string);
        jSONObject.put("reportletsName", string2);
        jSONObject.put("resourcesName", string3);
        jSONObject.put("serverCharSet", string4);
        jSONObject.put("encodingArray", stringArray);
        jSONObject.put("serverLanguageArray", stringArray2);
        jSONObject.put("serverLanguage", string5);
        jSONObject.put("serverletMapping", string6);
        jSONObject.put("isSupportGzip", bl);
        jSONObject.put("isPopupFlashPrintSetting", bl2);
        jSONObject.put("isPopupPdfPrintSetting", bl3);
        jSONObject.put("LOG_LEVELS", levelArray);
        jSONObject.put("serverLogLevel", level);
        jSONObject.put("concurrency", n);
        jSONObject.put("concurrencyOnce", n2);
        jSONObject.put("serverPrinterList", stringArray3);
        jSONObject.put("serverActivePrinterList", stringArray4);
        printWriter.print(jSONObject);
        printWriter.flush();
        printWriter.close();
    }

    private static void dealWithConfigAttrSet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        JSONObject jSONObject = new JSONObject();
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        String string = "success";
        try {
            jSONObject = new JSONObject(WebUtils.getHTTPRequestParameter(httpServletRequest, "configAttrJson"));
            FRContext.getDatasourceManager().setScheduleDatasource(jSONObject.getString("scheduleDatasource"));
            FRContext.getConfigManager().setServerCharset(jSONObject.getString("serverCharSet"));
            String[] stringArray = new String[]{"", Inter.getLocText("Simplified_Chinese_Language"), Inter.getLocText("English_Language"), Inter.getLocText("Japanese_Language"), Inter.getLocText("Traditional_Chinese_Language")};
            FRContext.getConfigManager().setServerLanguage(jSONObject.getInt("serverLanguage"));
            FRContext.getConfigManager().setServletMapping(jSONObject.getString("serverletMapping"));
            FRContext.getConfigManager().setSupportGzip(jSONObject.getBoolean("isSupportGzip"));
            FRContext.getConfigManager().setPopupFlashPrintSetting(jSONObject.getBoolean("isPopupFlashPrintSetting"));
            FRContext.getConfigManager().setPopupPdfPrintSetting(jSONObject.getBoolean("isPopupPdfPrintSetting"));
            Level level = Level.parse(jSONObject.getString("serverLogLevel"));
            FRContext.getConfigManager().setServerLogLevel(level);
            FRContext.getConfigManager().setConcurrency(jSONObject.getInt("concurrency"));
            FRContext.getConfigManager().setConcurrencyOnce(jSONObject.getInt("concurrencyOnce"));
            String string2 = jSONObject.getString("serverActivePrinterList");
            String[] stringArray2 = new String[]{};
            if (!string2.equals("")) {
                stringArray2 = string2.substring(0, string2.length() - 1).split(",");
            }
            FRContext.getConfigManager().getReportWebAttr().getPrinter().setPrinters(stringArray2);
            FRContext.getCurrentEnv().writeResource(FRContext.getConfigManager());
            FRContext.getCurrentEnv().writeResource(FRContext.getDatasourceManager());
            ScheduleContext.refreshDatabaseConnection();
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
            string = jSONException.getMessage();
        }
        printWriter.write(string);
        printWriter.flush();
        printWriter.close();
    }

    private static void dealWithGetConPoolInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        JSONObject jSONObject = new JSONObject();
        String[] stringArray = ConnectionPoolManager.getConnectionPoolManager().getPoolManagerInfo();
        String[] stringArray2 = ConnectionPoolManager.getConnectionPoolManager().getLogs();
        jSONObject.put("poolInfo", stringArray);
        jSONObject.put("runningCon", stringArray2);
        printWriter.print(jSONObject);
        printWriter.flush();
        printWriter.close();
    }

    private void dealWithGetConnectionInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        Iterator iterator = FRContext.getDatasourceManager().getConnectionNameIterator();
        JSONArray jSONArray = new JSONArray();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Connection connection = FRContext.getDatasourceManager().getConnection(string);
            if (!(connection instanceof JDBCDatabaseConnection)) continue;
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("name", string);
            jSONObject.put("driver", ((JDBCDatabaseConnection)connection).getDriver());
            jSONObject.put("url", ((JDBCDatabaseConnection)connection).getURL());
            jSONObject.put("user", ((JDBCDatabaseConnection)connection).getUser());
            jSONObject.put("password", ((JDBCDatabaseConnection)connection).getPassword());
            jSONArray.put(jSONObject);
        }
        printWriter.print(jSONArray);
        printWriter.flush();
        printWriter.close();
    }

    private void dealWithConnectionAttrSet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        String string = "success";
        try {
            jSONObject = new JSONObject(WebUtils.getHTTPRequestParameter(httpServletRequest, "connectionAttrJson"));
            jSONArray = new JSONArray(WebUtils.getHTTPRequestParameter(httpServletRequest, "changedConName"));
            for (int i = 0; i < jSONArray.length(); ++i) {
                String string2 = jSONArray.getString(i);
                JDBCDatabaseConnection jDBCDatabaseConnection = (JDBCDatabaseConnection)FRContext.getDatasourceManager().getConnection(string2);
                if (jSONObject.getJSONObject(string2).has("driver")) {
                    jDBCDatabaseConnection.setDriver(jSONObject.getJSONObject(string2).getString("driver"));
                }
                if (jSONObject.getJSONObject(string2).has("url")) {
                    jDBCDatabaseConnection.setURL(jSONObject.getJSONObject(string2).getString("url"));
                }
                if (jSONObject.getJSONObject(string2).has("user")) {
                    jDBCDatabaseConnection.setUser(jSONObject.getJSONObject(string2).getString("user"));
                }
                if (!jSONObject.getJSONObject(string2).has("password")) continue;
                jDBCDatabaseConnection.setPassword(jSONObject.getJSONObject(string2).getString("password"));
            }
            FRContext.getCurrentEnv().writeResource(FRContext.getDatasourceManager());
        }
        catch (JSONException jSONException) {
            FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
            string = jSONException.getMessage();
        }
        printWriter.write(string);
        printWriter.flush();
        printWriter.close();
    }
}

