/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.service;

import com.fr.base.FRContext;
import com.fr.base.core.util.TemplateUtils;
import com.fr.base.dav.DavXMLUtils;
import com.fr.base.dav.Env;
import com.fr.base.file.DatasourceManager;
import com.fr.web.core.WebUtils;
import com.fr.web.core.service.NoSessionIDService;
import com.fr.web.core.service.RemoteDesignService;
import com.fr.web.core.service.SessionDealWith;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServerProcessorService
extends NoSessionIDService {
    private static ServerProcessorService SERVERPROCESS_SERVICE = new ServerProcessorService();

    public static ServerProcessorService getInstance() {
        return SERVERPROCESS_SERVICE;
    }

    public boolean accept(String string) {
        return string.startsWith("server");
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        if ("server".equals(string)) {
            ServerProcessorService.bsServer(httpServletRequest, httpServletResponse);
        }
        if ("server_xml_read".equals(string)) {
            ServerProcessorService.viewServerXML(httpServletRequest, httpServletResponse);
        }
        if ("server_xml_save".equals(string)) {
            ServerProcessorService.saveServerXML(httpServletRequest, httpServletResponse);
        }
        if ("server_sessions_view".equals(string)) {
            SessionDealWith.viewSessions(httpServletRequest, httpServletResponse);
        }
        if ("server_sessions_close".equals(string)) {
            ServerProcessorService.closeSessions(httpServletRequest, httpServletResponse);
        }
        if ("server_config_read".equals(string)) {
            ServerProcessorService.dealWithConfig(httpServletRequest, httpServletResponse);
        }
    }

    private static void bsServer(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        try {
            TemplateUtils.dealWithTemplate("/com/fr/web/bmp/FineReportServer.html", httpServletResponse, WebUtils.createTemplateMap(httpServletRequest));
        }
        catch (IOException iOException) {
            FRContext.getLogger().log(Level.WARNING, iOException.getMessage(), iOException);
        }
    }

    private static void dealWithConfig(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        RemoteDesignService.read_resource(httpServletRequest, httpServletResponse);
    }

    private static void viewServerXML(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        RemoteDesignService.read_resource(httpServletRequest, httpServletResponse);
    }

    private static void saveServerXML(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "datasource");
        DatasourceManager datasourceManager = FRContext.getDatasourceManager();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        if (byteArrayInputStream != null) {
            try {
                DavXMLUtils.readXMLDatabaseMapConnection(byteArrayInputStream);
            }
            catch (Exception exception) {
                FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
            }
        }
        Env env = FRContext.getCurrentEnv();
        try {
            env.writeResource(datasourceManager);
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
        }
    }

    private static void closeSessions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "closeSessions");
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            SessionDealWith.closeSession(stringArray[i]);
        }
    }
}

