/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.service;

import com.fr.base.ConcurrentHashMap;
import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.StringUtils;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.FRCoreContext;
import com.fr.base.core.RSADecode;
import com.fr.base.core.html.Tag;
import com.fr.base.core.html.TextHtml;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.util.TemplateUtils;
import com.fr.util.Consts;
import com.fr.web.EmbeddedTplReportlet;
import com.fr.web.ReportletException;
import com.fr.web.Weblet;
import com.fr.web.cache.WebletFactory;
import com.fr.web.cluster.ClusterService;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.core.ShowWorkBookPolicy;
import com.fr.web.core.WebUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SessionDealWith {
    private static boolean registed = false;
    private static Random sessionIDRandom = null;
    private static int maxAddressCount = 5;
    private static final long __init_time__ = System.currentTimeMillis();
    public static final Object SESSION_ID_MAP_LOCK;
    public static final Object ADDRESS_MANAGER_LOCK;
    private static Map sessionIDMap;
    private static ConcurrentHashMap addressManager;
    private static Comparator keysTimeCompartor;

    private SessionDealWith() {
    }

    public static String getOrGenerateSessionID(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "sessionID");
        if (string == null) {
            string = SessionDealWith.generateSessionID(httpServletRequest, httpServletResponse, WebletFactory.createWebletByRequest(httpServletRequest));
        }
        return string;
    }

    public static String generateSessionID(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Weblet weblet) throws Exception {
        if (weblet == null) {
            throw new ReportletException("Need to specify parameter \"reportlet\" or \"resultlet\".");
        }
        if (SessionDealWith.generateSessionID_isPromptRegisted(httpServletRequest)) {
            weblet = WebletFactory.createEmbeddedResultlet("/com/fr/web/console/lic.xml", new ShowWorkBookPolicy.Policy4Page());
        }
        String string = SessionDealWith.getIpAddr(httpServletRequest);
        Map map = WebUtils.parameters4SessionIDInfor(httpServletRequest);
        SessionDealWith.generateSessionID_dealWithOverFlow(httpServletRequest, httpServletResponse);
        SessionIDInfor sessionIDInfor = null;
        if (weblet != null) {
            if (weblet instanceof EmbeddedTplReportlet) {
                EmbeddedTplReportlet embeddedTplReportlet = (EmbeddedTplReportlet)weblet;
                map.putAll(embeddedTplReportlet.getParameterMap());
            }
            sessionIDInfor = weblet.createSessionIDInfor(httpServletRequest, string, map);
        }
        return SessionDealWith.generateSessionID_addSessionIDInfor(sessionIDInfor, string);
    }

    private static String generateSessionID_addSessionIDInfor(SessionIDInfor sessionIDInfor, String string) throws Exception {
        String string2 = SessionDealWith.addSessionIDInfor(sessionIDInfor);
        HashSet<String> hashSet = new HashSet<String>();
        Set set = (Set)addressManager.putIfAbsent(string, hashSet);
        hashSet = set == null ? hashSet : set;
        hashSet.add(string2);
        return string2;
    }

    private static void generateSessionID_dealWithOverFlow(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (maxAddressCount < addressManager.size()) {
            try {
                WebUtils.overflow(httpServletRequest, httpServletResponse, addressManager.keySet());
            }
            catch (Exception exception) {
                throw new Exception(Inter.getLocText("EX-IP_Address_Overflow"));
            }
        }
    }

    private static boolean generateSessionID_isPromptRegisted(HttpServletRequest httpServletRequest) {
        if (registed || SessionDealWith.isLocalHost(httpServletRequest)) {
            return false;
        }
        return Math.random() * 10.0 <= (double)((System.currentTimeMillis() - __init_time__) / 3600000L / 24L + 1L);
    }

    public static void writeRegistionDiv(HttpServletRequest httpServletRequest, PrintWriter printWriter) {
        if (SessionDealWith.generateSessionID_isPromptRegisted(httpServletRequest)) {
            Tag tag = new Tag("div");
            tag.css("left", "2px");
            tag.css("bottom", "36px");
            tag.css("font", "normal bolder 10pt Arial");
            tag.css("position", "absolute");
            tag.sub(new TextHtml("<a href='" + Consts.WEBSITE_URL + "' target='_blank'>" + Inter.getLocText("Registration-Please_Purchase") + Consts.APP_NAME + Inter.getLocText("Registration-Enterprise_Edition") + "</a>---" + "<a href='" + WebUtils.createServletURL(httpServletRequest) + "?op=console_reg' target='_blank'>" + Inter.getLocText("Registration") + "</a>"));
            tag.writeHtml(printWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String addSessionIDInfor(SessionIDInfor sessionIDInfor) throws Exception {
        String string = null;
        Object object = SESSION_ID_MAP_LOCK;
        synchronized (object) {
            SessionDealWith.removeExtraSession();
            if (sessionIDInfor != null) {
                string = SessionDealWith.createSessionID();
                sessionIDMap.put(string, sessionIDInfor);
                sessionIDInfor.setSessionID(string);
            }
        }
        return string;
    }

    protected static String createSessionID() throws Exception {
        String string = SessionDealWith.randomSessionID();
        while (sessionIDMap.containsKey(string)) {
            string = SessionDealWith.randomSessionID();
        }
        return string;
    }

    private static String getIpAddr(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("x-forwarded-for");
        if (StringUtils.isEmpty(string) || "unknown".equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader("Proxy-Client-IP");
        }
        if (StringUtils.isEmpty(string) || "unknown".equalsIgnoreCase(string)) {
            string = httpServletRequest.getHeader("WL-Proxy-Client-IP");
        }
        if (StringUtils.isEmpty(string) || "unknown".equalsIgnoreCase(string)) {
            string = httpServletRequest.getRemoteAddr();
        }
        return string;
    }

    public static String getUserIp(HttpServletRequest httpServletRequest) {
        return SessionDealWith.getIpAddr(httpServletRequest);
    }

    private static boolean isLocalHost(HttpServletRequest httpServletRequest) {
        String string = SessionDealWith.getIpAddr(httpServletRequest);
        return "127.0.0.1".equals(string) || "localhost".equals(string) || "0:0:0:0:0:0:0:1".equals(string);
    }

    public static void removeExtraSession() {
        int n = FRContext.getConfigManager().getConcurrency();
        if (n >= 0 && sessionIDMap.size() > n) {
            SessionIDInfor[] sessionIDInforArray = sessionIDMap.values().toArray(new SessionIDInfor[0]);
            Arrays.sort(sessionIDInforArray, keysTimeCompartor);
            for (int i = sessionIDInforArray.length - n - 1; i >= 0; --i) {
                SessionDealWith.closeSession(sessionIDInforArray[i].getSessionID());
            }
        }
    }

    private static String randomSessionID() {
        ClusterService clusterService;
        if (sessionIDRandom == null) {
            sessionIDRandom = new Random();
        }
        String string = System.currentTimeMillis() + "_" + sessionIDRandom.nextInt(5000);
        if (FRContext.getClusterConfigManager().isUseCluster() && (clusterService = FRContext.getClusterConfigManager().getSelfService()) != null && clusterService.getServiceName() != null) {
            return clusterService.getServiceName() + "_" + string;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeSession(Object object) {
        SessionIDInfor sessionIDInfor = (SessionIDInfor)sessionIDMap.remove(object);
        if (sessionIDInfor != null) {
            sessionIDInfor.release();
            String string = sessionIDInfor.getRemoteAddress();
            Object object2 = ADDRESS_MANAGER_LOCK;
            synchronized (object2) {
                Set set = (Set)addressManager.get(string);
                if (set != null) {
                    set.remove(object);
                }
                if (set == null || set.size() == 0) {
                    addressManager.remove(string);
                }
            }
        }
        FRContext.getLogger().log(Level.INFO, "Close Session: " + object);
    }

    public static void writeSessionTimeout(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        TemplateUtils.dealWithTemplate("/com/fr/web/core/session.html", httpServletResponse, WebUtils.createTemplateMap(httpServletRequest));
    }

    public static void responseSessionID(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = SessionDealWith.getOrGenerateSessionID(httpServletRequest, httpServletResponse);
        if (string != null && !sessionIDMap.containsKey(string)) {
            string = null;
        }
        if (string != null) {
            PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
            printWriter.write(string);
            printWriter.flush();
            printWriter.close();
        }
    }

    public static SessionIDInfor getSessionIDInfor(String string) {
        if (StringUtils.isBlank(string)) {
            return null;
        }
        SessionIDInfor sessionIDInfor = (SessionIDInfor)sessionIDMap.get(string);
        if (sessionIDInfor != null) {
            sessionIDInfor.updateTime();
        }
        return sessionIDInfor;
    }

    public static boolean hasSessionID(String string) {
        return sessionIDMap.containsKey(string);
    }

    public static void viewSessions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        JSONArray jSONArray = new JSONArray();
        Iterator iterator = sessionIDMap.values().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof SessionIDInfor)) continue;
            SessionIDInfor sessionIDInfor = (SessionIDInfor)object;
            jSONArray.put(new JSONObject().put("sessionID", sessionIDInfor.getSessionID()).put("name", sessionIDInfor.getReportletTitle()).put("ip", sessionIDInfor.getRemoteAddress()).put("user", sessionIDInfor.getParameterValue("fr_username")));
        }
        object = WebUtils.createPrintWriter(httpServletResponse);
        ((PrintWriter)object).print(jSONArray);
        ((PrintWriter)object).flush();
        ((PrintWriter)object).close();
    }

    static {
        byte[] byArray = FRCoreContext.getBytes();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            RSADecode.decode(byArray, (OutputStream)byteArrayOutputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            JSONObject jSONObject = new JSONObject(new String(byteArrayOutputStream.toByteArray(), "UTF-8"));
            if (jSONObject.getLong("deadline") > Calendar.getInstance().getTimeInMillis() && jSONObject.has("version") && ComparatorUtils.equals(Consts.VERSION, jSONObject.getString("version")) && (jSONObject.getLong("deadline") - Calendar.getInstance().getTimeInMillis() < new Long("3153600000") || jSONObject.has("macaddress") && BaseCoreUtils.getMacAddresses().contains(jSONObject.getString("macaddress")))) {
                registed = true;
                int n = 0;
                if (jSONObject.has("concurrency")) {
                    n = jSONObject.getInt("concurrency");
                }
                maxAddressCount = n <= 0 ? Integer.MAX_VALUE : n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        SESSION_ID_MAP_LOCK = new Object();
        ADDRESS_MANAGER_LOCK = new Object();
        sessionIDMap = new Hashtable();
        addressManager = new ConcurrentHashMap();
        keysTimeCompartor = new Comparator(){

            public int compare(Object object, Object object2) {
                long l;
                SessionIDInfor sessionIDInfor = (SessionIDInfor)object;
                SessionIDInfor sessionIDInfor2 = (SessionIDInfor)object2;
                long l2 = sessionIDInfor.getLastTime();
                if (l2 < (l = sessionIDInfor2.getLastTime())) {
                    return -1;
                }
                if (l2 > l) {
                    return 1;
                }
                return 0;
            }
        };
    }
}

