/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.service;

import com.fr.data.pool.ConnectionPoolManager;
import com.fr.report.script.core.FArray;
import com.fr.web.Browser;
import com.fr.web.cache.WebletFactory;
import com.fr.web.core.ShowWorkBookPolicy;
import com.fr.web.core.WebUtils;
import com.fr.web.core.service.NoSessionIDService;
import com.fr.web.core.service.ReportletDealWith;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class TestService
extends NoSessionIDService {
    private static TestService TEST_SERVICE = new TestService();

    public static TestService getInstance() {
        return TEST_SERVICE;
    }

    @Override
    public boolean accept(String paramString) {
        return "test".equals(paramString) || "get_jsession_id".equals(paramString) || "pool_info".equals(paramString);
    }

    @Override
    public void process(HttpServletRequest paramHttpServletRequest, HttpServletResponse paramHttpServletResponse, String paramString) throws Exception {
        if (paramString.equals("test")) {
            TestService.dealWithTest(paramHttpServletRequest, paramHttpServletResponse);
        } else if (paramString.equals("get_jsession_id")) {
            TestService.returnCurrentJSessionID(paramHttpServletRequest, paramHttpServletResponse);
        } else if (paramString.equals("pool_info")) {
            TestService.dealWithPool(paramHttpServletRequest, paramHttpServletResponse);
        }
    }

    private static void dealWithTest(HttpServletRequest paramHttpServletRequest, HttpServletResponse paramHttpServletResponse) throws IOException {
        Browser localBrowser = Browser.resolve(paramHttpServletRequest);
        PrintWriter localPrintWriter = WebUtils.createPrintWriter(paramHttpServletResponse);
        localPrintWriter.println("ReportServer installed successfully!");
        localPrintWriter.println("<table><tbody>");
        localPrintWriter.print("<tr><td>UserAgent</td><td>" + localBrowser.getUserAgent() + "</td></tr>");
        localPrintWriter.print("<tr><td>Browser</td><td>" + localBrowser.getBrowser() + "</td></tr>");
        localPrintWriter.print("<tr><td>Version</td><td>" + localBrowser.getVersion() + "</td></tr>");
        localPrintWriter.println("</tbody></table>");
        localPrintWriter.flush();
        localPrintWriter.close();
    }

    public static void dealWithUnresolvableOperation(HttpServletResponse paramHttpServletResponse, String paramString) throws IOException {
        PrintWriter localPrintWriter = WebUtils.createPrintWriter(paramHttpServletResponse);
        localPrintWriter.println("Unresolvable Operation:" + paramString);
        localPrintWriter.flush();
        localPrintWriter.close();
    }

    public static boolean checkOperation(HttpServletRequest paramHttpServletRequest) throws Exception {
        return true;
    }

    private static void returnCurrentJSessionID(HttpServletRequest paramHttpServletRequest, HttpServletResponse paramHttpServletResponse) throws Exception {
        HttpSession localHttpSession = paramHttpServletRequest.getSession(false);
        PrintWriter localPrintWriter = WebUtils.createPrintWriter(paramHttpServletResponse);
        localPrintWriter.write(localHttpSession == null ? null : localHttpSession.getId());
        localPrintWriter.flush();
        localPrintWriter.close();
    }

    private static void dealWithPool(HttpServletRequest paramHttpServletRequest, HttpServletResponse paramHttpServletResponse) throws Exception {
        HashMap<String, FArray> localHashMap = new HashMap<String, FArray>();
        localHashMap.put("poolNumber", new FArray(ConnectionPoolManager.getConnectionPoolManager().getPoolManagerInfo()));
        localHashMap.put("runningConnection", new FArray(ConnectionPoolManager.getConnectionPoolManager().getLogs()));
        ReportletDealWith.dealWithReportlet(paramHttpServletRequest, paramHttpServletResponse, WebletFactory.createEmbeddedReportlet("/com/fr/web/console/poolInfo.cpt", new ShowWorkBookPolicy.Policy4Page(), localHashMap));
    }
}

