/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.service;

import com.fr.base.CodeUtils;
import com.fr.base.FRContext;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.dav.FileNode;
import com.fr.data.TableData;
import com.fr.privilege.allocation.Allocation;
import com.fr.privilege.authority.AuthorityAllocation;
import com.fr.privilege.manager.PrivilegeManager;
import com.fr.report.PaperSize;
import com.fr.report.ReportConstants;
import com.fr.util.Utils;
import com.fr.web.core.IdGenerator;
import com.fr.web.core.WebUtils;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class UtilsDealWith {
    private static final String SERVERTABLEDATANAME = "utils_servertabledataname";
    private static final String SERVERTABLEDATACOLUMN = "utils_servertabledatacolumn";
    private static final String AVAILABLEFONTS = "utils_availablefonts";
    private static final String UTILS_REPORTLETS = "utils_reportlets";
    private static final String UTILS_PAPERSIZE = "utils_papersize";

    private UtilsDealWith() {
    }

    public static void dealWithOperation(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "op");
        if (string == null) {
            return;
        }
        if (SERVERTABLEDATANAME.equals(string = string.toLowerCase())) {
            UtilsDealWith.dealWithServerTableDataName(httpServletRequest, httpServletResponse);
        } else if (SERVERTABLEDATACOLUMN.equals(string)) {
            UtilsDealWith.dealWithServerTableDataColumn(httpServletRequest, httpServletResponse);
        } else if (AVAILABLEFONTS.equals(string)) {
            UtilsDealWith.availableFonts(httpServletRequest, httpServletResponse);
        } else if (UTILS_REPORTLETS.equals(string)) {
            UtilsDealWith.availableReportlets(httpServletRequest, httpServletResponse);
        } else if (UTILS_PAPERSIZE.equals(string)) {
            UtilsDealWith.getPaperSizeByName(httpServletRequest, httpServletResponse);
        }
    }

    private static void getPaperSizeByName(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "paperSize");
        JSONObject jSONObject = new JSONObject();
        Locale locale = FRContext.getLocale();
        for (int i = 0; i < ReportConstants.PaperSizeNameSizeArray.length; ++i) {
            Object[] objectArray = ReportConstants.PaperSizeNameSizeArray[i];
            if (!ComparatorUtils.equals(string, objectArray[0])) continue;
            PaperSize paperSize = (PaperSize)objectArray[1];
            if (ComparatorUtils.equals(Locale.CHINA, locale)) {
                jSONObject.put("width", Utils.doubleToString(BaseCoreUtils.convertInchesToMillimeters(paperSize.getWidth())));
                jSONObject.put("height", Utils.doubleToString(BaseCoreUtils.convertInchesToMillimeters(paperSize.getHeight())));
                break;
            }
            jSONObject.put("width", Utils.doubleToString(paperSize.getWidth()));
            jSONObject.put("height", Utils.doubleToString(paperSize.getHeight()));
            break;
        }
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.print(jSONObject.toString());
        printWriter.flush();
        printWriter.close();
    }

    private static void dealWithServerTableDataName(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        JSONArray jSONArray = new JSONArray();
        if (FRContext.getPrivilegeManager().usePrivilege()) {
            object = FRContext.getPrivilegeManager();
            HttpSession httpSession = httpServletRequest.getSession();
            String string = "" + httpSession.getAttribute("fr_authority");
            AuthorityAllocation authorityAllocation = ((PrivilegeManager)object).getControl().getAuthorityAllocation(string);
            if (authorityAllocation != null) {
                Allocation allocation = authorityAllocation.getAllocation();
                int n = allocation.getServerDSCount();
                for (int i = 0; i < n; ++i) {
                    String string2 = allocation.getServerDS(i);
                    jSONArray.put(new JSONObject().put("text", string2).put("value", string2));
                }
            }
        } else {
            object = FRContext.getDatasourceManager().getTableDataNameIterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                jSONArray.put(new JSONObject().put("text", string).put("value", string));
            }
        }
        object = WebUtils.createPrintWriter(httpServletResponse);
        jSONArray.write((Writer)object);
        ((PrintWriter)object).flush();
        ((PrintWriter)object).close();
    }

    private static void dealWithServerTableDataColumn(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        int n;
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "name");
        TableData tableData = FRContext.getDatasourceManager().getTableData(string);
        JSONArray jSONArray = new JSONArray();
        int n2 = n = tableData != null ? tableData.getColumnCount() : 0;
        for (int i = 0; i < n; ++i) {
            String string2 = tableData.getColumnName(i);
            jSONArray.put(new JSONObject().put("text", string2).put("value", string2));
        }
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        jSONArray.write(printWriter);
        printWriter.flush();
        printWriter.close();
    }

    private static void availableFonts(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.print(new JSONArray(Arrays.asList(Utils.getAvailableFontFamilyNames4Report())));
        printWriter.flush();
        printWriter.close();
    }

    private static void availableReportlets(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.print(UtilsDealWith.writeReporletsJSON("reportlets"));
        printWriter.flush();
        printWriter.close();
    }

    public static StringBuffer writeReporletsJSON(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        FileNode[] fileNodeArray = null;
        try {
            fileNodeArray = FRContext.getCurrentEnv().listFile(string);
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
        }
        if (fileNodeArray == null || fileNodeArray.length == 0) {
            return stringBuffer;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        for (int i = 0; i < fileNodeArray.length; ++i) {
            StringBuffer stringBuffer4;
            FileNode fileNode = fileNodeArray[i];
            String string2 = fileNode.getEnvPath().substring("reportlets".length() + 1);
            if (ComparatorUtils.equals(fileNode.getName(), ".svn")) continue;
            StringBuffer stringBuffer5 = stringBuffer4 = fileNode.isDirectory() ? stringBuffer2 : stringBuffer3;
            if (stringBuffer4.length() > 0) {
                stringBuffer4.append(',');
            }
            stringBuffer4.append("{");
            stringBuffer4.append("text:'").append(fileNode.getName()).append('\'');
            if (!fileNode.isDirectory()) {
                stringBuffer4.append(",");
                stringBuffer4.append("dir:'").append(CodeUtils.cjkEncode(CodeUtils.javascriptEncode(string2))).append('\'');
            } else if (fileNode.isDirectory()) {
                stringBuffer4.append(",");
                stringBuffer4.append("items:").append('[').append(UtilsDealWith.writeReporletsJSON(fileNode.getEnvPath())).append(']');
            }
            stringBuffer4.append("}");
        }
        stringBuffer.append(stringBuffer2);
        if (stringBuffer2.length() > 0 && stringBuffer3.length() > 0) {
            stringBuffer.append(',');
        }
        stringBuffer.append(stringBuffer3);
        return stringBuffer;
    }

    public static JSONArray getReportletsOfCurrentEnv(String string, IdGenerator idGenerator) {
        JSONArray jSONArray = new JSONArray();
        FileNode[] fileNodeArray = null;
        try {
            fileNodeArray = FRContext.getCurrentEnv().listFile(string);
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
        }
        if (fileNodeArray == null || fileNodeArray.length == 0) {
            return jSONArray;
        }
        for (int i = 0; i < fileNodeArray.length; ++i) {
            int n;
            FileNode fileNode = fileNodeArray[i];
            if (ComparatorUtils.equals(fileNode.getName(), ".svn") || !fileNode.isDirectory() && (n = fileNode.getName().lastIndexOf(".")) >= 0 && !ComparatorUtils.equals(fileNode.getName().substring(n), ".cpt")) continue;
            String string2 = fileNode.getEnvPath().substring("reportlets".length() + 1);
            JSONObject jSONObject = new JSONObject();
            jSONArray.put(jSONObject);
            try {
                jSONObject.put("id", idGenerator.generateId());
                jSONObject.put("text", fileNode.getName());
                jSONObject.put("reportletPath", string2);
                jSONObject.put("complete", true);
                jSONObject.put("showcheck", true);
                jSONObject.put("isexpand", false);
                if (!fileNode.isDirectory()) continue;
                jSONObject.put("hasChildren", true);
                jSONObject.put("ChildNodes", UtilsDealWith.getReportletsOfCurrentEnv(fileNode.getEnvPath(), idGenerator));
                continue;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return jSONArray;
    }
}

