/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.service;

import com.fr.base.CodeUtils;
import com.fr.base.ColumnRow;
import com.fr.base.FRContext;
import com.fr.base.StringUtils;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.FRCoreContext;
import com.fr.base.core.RSADecode;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.util.TemplateUtils;
import com.fr.base.core.util.vt.VT4FR;
import com.fr.data.impl.NameWidget;
import com.fr.report.Report;
import com.fr.report.script.AbstractNameSpace;
import com.fr.report.script.Calculator;
import com.fr.report.script.core.parser.Ambiguity;
import com.fr.report.script.core.parser.ColumnRowRange;
import com.fr.report.web.ui.Widget;
import com.fr.util.Consts;
import com.fr.util.Utils;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.core.WebUtils;
import com.fr.web.core.service.NoOPService;
import com.fr.web.core.service.SessionDealWith;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WidgetService
extends NoOPService {
    public static WidgetService WIDGET_SERVICE = new WidgetService();
    public static boolean usePreWidget = true;

    private WidgetService() {
    }

    public static WidgetService getInstance() {
        return WIDGET_SERVICE;
    }

    public boolean accept(String string) {
        return "widget".equals(string);
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        SessionIDInfor sessionIDInfor = SessionDealWith.getSessionIDInfor(string);
        if (sessionIDInfor != null) {
            Object object;
            Cloneable cloneable;
            String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "location");
            String string3 = WebUtils.getHTTPRequestParameter(httpServletRequest, "ftype");
            JSONObject jSONObject = new JSONObject(string2);
            int n = jSONObject.getInt("reportIndex");
            int n2 = jSONObject.getInt("column");
            int n3 = jSONObject.getInt("row");
            Report report = null;
            if (string3 == null) {
                cloneable = sessionIDInfor.getWorkBook2Show();
                if (n < 0 || cloneable.getReportCount() <= n || n2 < 0 || n3 < 0) {
                    return;
                }
                report = cloneable.getResultReport(n);
            } else if ("parameter".equals(string3)) {
                report = (Report)sessionIDInfor.getAttribute("paramsheet");
            }
            if (report == null) {
                return;
            }
            cloneable = report.getCellElement(n2, n3);
            if (cloneable == null) {
                return;
            }
            Widget widget = cloneable.getWidget();
            if (widget == null) {
                return;
            }
            if (widget instanceof NameWidget) {
                if (!usePreWidget) {
                    object = WebUtils.createPrintWriter(httpServletResponse);
                    ((PrintWriter)object).print("failpass");
                    ((PrintWriter)object).flush();
                    ((PrintWriter)object).close();
                    FRContext.getLogger().log(Level.SEVERE, "This edition cannot support pre-widget, please buy other editions!");
                }
                widget = usePreWidget ? FRContext.getWidgetManager().getWidgetConfig(((NameWidget)widget).getName()).toWidget() : null;
            }
            object = Calculator.createStaticCalculator();
            ((Calculator)object).setCurrentReport(report);
            ((Calculator)object).setCurrentTableDataSource(sessionIDInfor.getContextBook());
            JSONArray jSONArray = widget.createJSONData(sessionIDInfor, (Calculator)object, httpServletRequest);
            ((Calculator)object).release();
            PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
            printWriter.print(CodeUtils.jsonEncode(jSONArray));
            printWriter.flush();
            printWriter.close();
        }
    }

    public static String toJSONString(Object object, HttpServletRequest httpServletRequest) throws Exception {
        if (object instanceof Number) {
            return JSONObject.numberToString((Number)object);
        }
        if (object instanceof Date) {
            return JSONObject.date2String((Date)object);
        }
        return TemplateUtils.render(Utils.objectToString(object), WebUtils.createTemplateMap(httpServletRequest));
    }

    static {
        byte[] byArray = FRCoreContext.getBytes();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            RSADecode.decode(byArray, (OutputStream)byteArrayOutputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            JSONObject jSONObject = new JSONObject(new String(byteArrayOutputStream.toByteArray(), "UTF-8"));
            usePreWidget = jSONObject.getLong("deadline") > Calendar.getInstance().getTimeInMillis() && jSONObject.has("version") && ComparatorUtils.equals(Consts.VERSION, jSONObject.getString("version")) && (jSONObject.getLong("deadline") - Calendar.getInstance().getTimeInMillis() < 3153600000L || jSONObject.has("macaddress") && BaseCoreUtils.getMacAddresses().contains(jSONObject.getString("macaddress"))) && VT4FR.PREDEFINED_WIDGET.support();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class DependenceNameSpace
    extends AbstractNameSpace {
        private JSONObject depJson;

        public DependenceNameSpace(String string) {
            if (StringUtils.isNotBlank(string)) {
                try {
                    Object object = CodeUtils.jsonDecode(string);
                    if (object instanceof JSONObject) {
                        this.depJson = (JSONObject)object;
                    }
                }
                catch (JSONException jSONException) {
                    FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
                }
            }
        }

        public Object getCellElementAttribute(ColumnRow columnRow, Object object, Calculator calculator) {
            return null;
        }

        public Object getVariable(Object object, Calculator calculator) {
            if (this.depJson != null) {
                String string;
                if (this.depJson.length() == 0) {
                    return null;
                }
                if ((object instanceof ColumnRowRange || object instanceof Ambiguity || object instanceof String) && (this.depJson.has(string = object.toString()) || this.depJson.has("$" + string))) {
                    try {
                        return this.depJson.get(string);
                    }
                    catch (JSONException jSONException) {
                        try {
                            return this.depJson.get("$" + string);
                        }
                        catch (JSONException jSONException2) {
                            FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
                        }
                    }
                }
            }
            return super.getVariable(object, calculator);
        }
    }
}

