/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.core.service;

import com.fr.base.CodeUtils;
import com.fr.base.ColumnRow;
import com.fr.base.FRContext;
import com.fr.base.Inter;
import com.fr.base.Painter;
import com.fr.base.StringUtils;
import com.fr.base.core.BaseCoreUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.FRCoreContext;
import com.fr.base.core.RSADecode;
import com.fr.base.core.html.Html;
import com.fr.base.core.html.Tag;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.core.util.vt.VT4FR;
import com.fr.report.CellElement;
import com.fr.report.FloatElement;
import com.fr.report.Report;
import com.fr.report.ResultReport;
import com.fr.report.ResultWorkBook;
import com.fr.report.cellElement.Present;
import com.fr.report.cellElement.core.CellElementAttribute;
import com.fr.report.cellElement.core.CellUtils;
import com.fr.report.core.DynamicValueList;
import com.fr.report.core.FormException;
import com.fr.report.core.FormReport;
import com.fr.report.core.ReportHelper;
import com.fr.report.core.ReportUtils;
import com.fr.report.io.ExcelImporter;
import com.fr.report.js.NameJavaScriptGroup;
import com.fr.report.script.Calculator;
import com.fr.report.write.ValueVerifier;
import com.fr.util.Consts;
import com.fr.web.Repository;
import com.fr.web.core.Attachment;
import com.fr.web.core.ErrorHandlerHelper;
import com.fr.web.core.HTMLWriter;
import com.fr.web.core.HTMLWriterUtils;
import com.fr.web.core.ReportBackgroundDimension;
import com.fr.web.core.Service;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.core.WebUtils;
import com.fr.web.core.chwriter.WriteCellWriter;
import com.fr.web.core.service.AttachmentService;
import com.fr.web.core.service.InsertUpdateService;
import com.fr.web.core.service.SessionDealWith;
import com.fr.web.core.upload.SmartFile;
import com.fr.web.core.upload.SmartFiles;
import com.fr.web.core.upload.SmartUpload;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Iterator;
import java.util.logging.Level;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WriteService
implements Service {
    private static boolean supportWrite = true;
    private static WriteService WRITE_SERVICE;

    private WriteService() {
    }

    public static WriteService getInstance() {
        return WRITE_SERVICE;
    }

    public boolean accept(String string) {
        return string.startsWith("write_");
    }

    public void process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws Exception {
        if (!supportWrite) {
            PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
            printWriter.print("This edition dosen't support write, please buy a enterprise edition!");
            printWriter.flush();
            printWriter.close();
            return;
        }
        SessionIDInfor sessionIDInfor = SessionDealWith.getSessionIDInfor(string2);
        if (sessionIDInfor == null) {
            ErrorHandlerHelper.getErrorHandler().error(httpServletRequest, httpServletResponse, "Reportlet SessionID: \"" + string2 + "\" time out.");
            return;
        }
        if ("write_content".equals(string)) {
            WriteService.readContent(sessionIDInfor, httpServletRequest, httpServletResponse);
        } else if ("write_appendrcdata".equals(string)) {
            InsertUpdateService.simpleInsertRecord(sessionIDInfor, httpServletRequest, httpServletResponse);
        } else if ("write_appenddata".equals(string)) {
            InsertUpdateService.insertRecord(sessionIDInfor, httpServletRequest, httpServletResponse);
        } else if ("write_deletercdata".equals(string)) {
            InsertUpdateService.simpleDeleteRecord(sessionIDInfor, httpServletRequest, httpServletResponse);
        } else if ("write_deletedata".equals(string)) {
            InsertUpdateService.smartDeleteRecord(sessionIDInfor, httpServletRequest, httpServletResponse);
        } else if ("write_undeletedata".equals(string)) {
            InsertUpdateService.smartUnDeleteRecord(sessionIDInfor, httpServletRequest, httpServletResponse);
        } else if ("write_calculate".equals(string)) {
            WriteService.calculate(httpServletRequest, httpServletResponse, sessionIDInfor);
        } else if ("write_verify".equalsIgnoreCase(string)) {
            WriteService.checkValueVerify(sessionIDInfor, httpServletRequest, httpServletResponse);
        } else if ("write_present".equalsIgnoreCase(string)) {
            WriteService.present(sessionIDInfor, httpServletRequest, httpServletResponse);
        } else if ("write_saveContent".equalsIgnoreCase(string)) {
            WriteService.saveContent(httpServletResponse);
        } else if ("write_writeContent".equalsIgnoreCase(string)) {
            WriteService.submitReport(sessionIDInfor, httpServletResponse);
        } else if (!"write_undoContent".equalsIgnoreCase(string) && "write_importExcelData".equalsIgnoreCase(string)) {
            WriteService.importExcelData(sessionIDInfor, httpServletRequest, httpServletResponse);
        }
    }

    private static void submitReport(SessionIDInfor sessionIDInfor, HttpServletResponse httpServletResponse) throws IOException {
        boolean bl = true;
        try {
            sessionIDInfor.submit();
        }
        catch (FormException formException) {
            FRContext.getLogger().log(Level.WARNING, formException.getMessage(), formException);
            bl = false;
        }
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.print(bl ? "success" : "failure");
        printWriter.flush();
        printWriter.close();
    }

    private static void readContent(SessionIDInfor sessionIDInfor, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        int n = Integer.parseInt(WebUtils.getHTTPRequestParameter(httpServletRequest, "reportIndex"));
        Report report = sessionIDInfor.getReport2Show(n);
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        WriteService.writeReportPane(printWriter, report, n, new Repository(httpServletRequest, sessionIDInfor));
        printWriter.flush();
        printWriter.close();
    }

    private static void writeReportPane(PrintWriter printWriter, Report report, int n, Repository repository) {
        Tag tag;
        Cloneable cloneable;
        Cloneable cloneable2;
        Object object;
        Tag tag2 = new Tag("div");
        tag2.css("position", "absolute").cls("sheet-container");
        if (repository.getBrowser().shouldSetOverflowAsHiddenOnSheetContainer()) {
            tag2.css("overflow", "hidden");
        }
        HTMLWriter hTMLWriter = HTMLWriter.getInstance();
        if (report.getReportSettings() != null && report.getReportSettings().getWriteFrozenColumnRow() != null) {
            object = (ColumnRow[])((FormReport)((Object)report)).getExtendedColumnRowList(new ColumnRow[]{report.getReportSettings().getWriteFrozenColumnRow()}, null).get(0);
            hTMLWriter.writeFrozenContent(tag2, report, object[0], n, new WriteCellWriter(n, repository), repository);
        } else {
            object = hTMLWriter.writeJSReport(report, n, new WriteCellWriter(n, repository), repository);
            cloneable2 = ReportHelper.getColumnWidthList(report);
            cloneable = ReportHelper.getRowHeightList(report);
            int n2 = Math.max(((DynamicValueList)cloneable2).getRangeValueFromZero(report.getColumnCount()), 1);
            int n3 = Math.max(((DynamicValueList)cloneable).getRangeValueFromZero(report.getRowCount()), 1);
            tag = new Tag("div");
            HTMLWriterUtils.writeBackground(tag, ReportUtils.getReportSettings(report).getBackground(), new ReportBackgroundDimension(n2 + 5, n3 + 5), false, repository, false);
            tag.sub((Html)object);
            tag2.sub(tag);
            Iterator iterator = report.floatIterator();
            while (iterator.hasNext()) {
                FloatElement floatElement = (FloatElement)iterator.next();
                Tag tag3 = null;
                NameJavaScriptGroup nameJavaScriptGroup = floatElement.getNameHyperlinkGroup();
                if (nameJavaScriptGroup != null && nameJavaScriptGroup.size() > 0) {
                    tag3 = new Tag("span");
                    String string = "{}";
                    try {
                        string = HTMLWriterUtils.writeJSLinkContent(nameJavaScriptGroup, repository);
                    }
                    catch (JSONException jSONException) {
                        FRContext.getLogger().log(Level.WARNING, jSONException.getMessage(), jSONException);
                    }
                    tag3.attr("onclick", "FR.doHyperlink(event ||window.event," + string + ")");
                    tag3.css("cursor", "pointer");
                }
                int n4 = ((DynamicValueList)cloneable2).getRangeValueFromZero(floatElement.getColumn()) + floatElement.getLeftDistance();
                int n5 = ((DynamicValueList)cloneable).getRangeValueFromZero(floatElement.getRow()) + floatElement.getTopDistance();
                int n6 = floatElement.getSize().width + 1;
                int n7 = floatElement.getSize().height + 1;
                n2 = Math.max(n2, n4 + n6);
                n3 = Math.max(n3, n5 + n7);
                Tag tag4 = new Tag("div");
                if (tag3 == null) {
                    tag3 = tag4;
                } else {
                    tag3.sub(tag4);
                }
                tag.sub(tag3);
                tag4.css("overflow", "hidden");
                tag4.css("position", "absolute");
                tag4.css("left", n4 + "px");
                tag4.css("top", n5 + "px");
                tag4.css("width", n6 + "px");
                tag4.css("height", n7 + "px");
                tag4.sub(floatElement.toTag(repository));
            }
            tag.css("width", n2 + 5 + "px").css("height", n3 + 5 + "px");
        }
        object = new Tag("div");
        cloneable2 = new Tag("div");
        cloneable = new Tag("div");
        Tag tag5 = new Tag("div");
        Tag tag6 = new Tag("div");
        tag2.sub((Html)object);
        tag2.sub((Html)cloneable2);
        tag2.sub((Html)cloneable);
        tag2.sub(tag5);
        tag2.sub(tag6);
        ((Tag)object).cls("fDtop");
        ((Tag)cloneable2).cls("fDleft");
        ((Tag)cloneable).cls("fDbottom");
        tag5.cls("fDright");
        tag6.cls("fDdot");
        ((Tag)object).sub(repository.checkoutImageTag(null, 1, 1).css("display", "none"));
        ((Tag)cloneable2).sub(repository.checkoutImageTag(null, 1, 1).css("display", "none"));
        ((Tag)cloneable).sub(repository.checkoutImageTag(null, 1, 1).css("display", "none"));
        tag5.sub(repository.checkoutImageTag(null, 1, 1).css("display", "none"));
        tag6.sub(repository.checkoutImageTag(null, 5, 5));
        tag = new Tag("div");
        tag2.sub(tag);
        tag.cls("x-editor").css("position", "absolute").css("display", "none").css("z-index", "4").css("padding-left", "0px");
        tag2.writeHtml(printWriter);
    }

    private static void saveContent(HttpServletResponse httpServletResponse) throws Exception {
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        printWriter.print("success");
        printWriter.flush();
        printWriter.close();
    }

    private static void checkValueVerify(SessionIDInfor sessionIDInfor, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        JSONArray jSONArray = null;
        int n = sessionIDInfor.getWorkBook2Show().getReportCount();
        for (int i = 0; i < n; ++i) {
            ResultReport resultReport = sessionIDInfor.getWorkBook2Show().getResultReport(i);
            if (!(resultReport instanceof FormReport)) continue;
            resultReport.recalculate(sessionIDInfor.getParameterMap4Execute());
            FormReport formReport = (FormReport)((Object)resultReport);
            ValueVerifier[] valueVerifierArray = formReport.checkValueVerifiers();
            for (int j = 0; j < valueVerifierArray.length; ++j) {
                ValueVerifier valueVerifier = valueVerifierArray[j];
                int n2 = valueVerifier.getType();
                if (n2 == 0) continue;
                if (jSONArray == null) {
                    jSONArray = new JSONArray();
                }
                JSONObject jSONObject = new JSONObject();
                jSONArray.put(jSONObject);
                jSONObject.put("formula", valueVerifier.getFormula().getContent().substring(1));
                if (n2 == 1) {
                    jSONObject.put("message", valueVerifier.getMessage());
                    continue;
                }
                if (n2 != 2) continue;
                jSONObject.put("message", Inter.getLocText("Verify-Formular_Parser_Error"));
            }
        }
        if (jSONArray != null && jSONArray.length() > 0) {
            PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
            jSONArray.write(printWriter);
            printWriter.flush();
            printWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void importExcelData(SessionIDInfor sessionIDInfor, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ServletContext servletContext = httpServletRequest.getSession().getServletContext();
        SmartUpload smartUpload = new SmartUpload();
        smartUpload.initialize(servletContext, httpServletRequest, httpServletResponse);
        smartUpload.upload();
        SmartFiles smartFiles = smartUpload.getFiles();
        if (smartFiles.getSize() == 0L) {
            return;
        }
        SmartFile smartFile = smartFiles.getFile(0);
        String string = smartFile.getContentType();
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        if (StringUtils.isBlank(string) || !smartFile.getFileName().endsWith(".xls")) {
            printWriter.write("typewrong");
            printWriter.flush();
            printWriter.close();
            return;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(smartFile.getBytes());
        try {
            ExcelImporter.importExcel2Book(sessionIDInfor.getWorkBook2Show(), sessionIDInfor.getContextBook(), byteArrayInputStream, sessionIDInfor.getParameterMap4Execute());
            printWriter.write("success");
        }
        catch (Exception exception) {
            printWriter.write("wrong");
        }
        finally {
            printWriter.flush();
            printWriter.close();
            ((InputStream)byteArrayInputStream).close();
        }
    }

    private static void calculate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, SessionIDInfor sessionIDInfor) throws Exception {
        String string = WebUtils.getHTTPRequestParameter(httpServletRequest, "ptype");
        String string2 = WebUtils.getHTTPRequestParameter(httpServletRequest, "pcontent");
        PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
        Object[] objectArray = new Object[1];
        if ("parameter".equals(string)) {
            Object object = sessionIDInfor.getParameterValue(string2);
            objectArray[0] = CodeUtils.object2JSONable(object);
        } else if ("expression".equals(string)) {
            Calculator calculator = Calculator.createCalculator();
            calculator.setCurrentTableDataSource(sessionIDInfor.getContextBook());
            objectArray[0] = CodeUtils.object2JSONable(calculator.eval(string2));
        }
        new JSONArray(objectArray).write(printWriter);
        printWriter.flush();
        printWriter.close();
    }

    private static void present(SessionIDInfor sessionIDInfor, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        ResultWorkBook resultWorkBook = sessionIDInfor.getWorkBook2Show();
        int n = StringUtils.stringToInt(WebUtils.getHTTPRequestParameter(httpServletRequest, "rptIdx"), -1);
        int n2 = StringUtils.stringToInt(WebUtils.getHTTPRequestParameter(httpServletRequest, "col"), -1);
        int n3 = StringUtils.stringToInt(WebUtils.getHTTPRequestParameter(httpServletRequest, "row"), -1);
        if (n < 0 || resultWorkBook.getReportCount() <= n || n2 < 0 || n3 < 0) {
            return;
        }
        Report report = resultWorkBook.getReport(n);
        CellElement cellElement = report.getCellElement(n2, n3);
        if (cellElement == null) {
            return;
        }
        Present present = cellElement.getPresent();
        if (present == null) {
            return;
        }
        Calculator calculator = Calculator.createStaticCalculator();
        calculator.setCurrentReport(report);
        calculator.setCurrentTableDataSource(sessionIDInfor.getContextBook());
        calculator.setCurrentColumnRow(ColumnRow.valueOf(n2, n3));
        Object object = present.present(CodeUtils.jsonDecode(WebUtils.getHTTPRequestParameter(httpServletRequest, "value")), calculator);
        calculator.release();
        cellElement.setAttribute(CellElementAttribute.PRESENT_VALUE, object);
        if (object instanceof Image || object instanceof Painter) {
            int n4;
            int n5 = 0;
            int n6 = cellElement.getRowSpan() + cellElement.getRow();
            for (n4 = cellElement.getRow(); n4 < n6; ++n4) {
                n5 += report.getRowHeight(n4);
            }
            n4 = 0;
            int n7 = cellElement.getColumnSpan() + cellElement.getColumn();
            for (n6 = cellElement.getColumn(); n6 < n7; ++n6) {
                n4 += report.getColumnWidth(n6);
            }
            Image image = CellUtils.value2Image(object, cellElement.getStyle(), n4, n5);
            Attachment attachment = AttachmentService.addAttachment(image);
            object = attachment.toConfig();
        }
        if (object != null) {
            PrintWriter printWriter = WebUtils.createPrintWriter(httpServletResponse);
            printWriter.print(CodeUtils.jsonEncode(object));
            printWriter.flush();
            printWriter.close();
        }
    }

    static {
        byte[] byArray = FRCoreContext.getBytes();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            RSADecode.decode(byArray, (OutputStream)byteArrayOutputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            JSONObject jSONObject = new JSONObject(new String(byteArrayOutputStream.toByteArray(), "UTF-8"));
            supportWrite = jSONObject.getLong("deadline") > Calendar.getInstance().getTimeInMillis() && jSONObject.has("version") && ComparatorUtils.equals(Consts.VERSION, jSONObject.getString("version")) && (jSONObject.getLong("deadline") - Calendar.getInstance().getTimeInMillis() < 3153600000L || jSONObject.has("macaddress") && BaseCoreUtils.getMacAddresses().contains(jSONObject.getString("macaddress"))) && VT4FR.ONLINE_WRITE.support();
        }
        catch (Exception exception) {
            // empty catch block
        }
        WRITE_SERVICE = new WriteService();
    }
}

