/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.face;

import com.fr.base.FRContext;
import com.fr.base.XMLable;
import com.fr.base.core.FRCoreContext;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONObject;
import com.fr.base.file.FaceManager;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.privilege.authentication.Authentication;
import com.fr.privilege.vote.VoteManager;
import com.fr.web.face.Access;
import com.fr.web.face.FolderDef;
import com.fr.web.face.NodeDef;
import com.fr.web.face.ViewReportletDef;
import com.fr.web.face.WebURLDef;
import com.fr.web.face.WriteReportletDef;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class FaceNode
implements XMLable {
    private NodeDef nodeDef;
    private List faceNodeList = new ArrayList();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JSONObject toJSONConfig(HttpServletRequest httpServletRequest, Authentication authentication, FaceManager faceManager, String string, int n) throws Exception {
        Object object;
        if (!VoteManager.vote(authentication, this.nodeDef)) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("id", string + n);
        if (this.nodeDef != null) {
            jSONObject.put("text", this.nodeDef.getName());
            object = this.nodeDef.createURI(httpServletRequest, authentication);
            if (!((Access)object).isAccess()) return null;
            jSONObject.put("value", ((Access)object).getUrl());
        } else {
            jSONObject.put("value", "undefined");
        }
        jSONObject.put("complete", true);
        jSONObject.put("isexpand", false);
        jSONObject.put("checkstate", 0);
        if (this.getChildCount() > 0) {
            jSONObject.put("hasChildren", true);
            object = new JSONArray();
            jSONObject.put("ChildNodes", object);
            for (int i = 0; i < this.getChildCount(); ++i) {
                FaceNode faceNode = this.getChild(i);
                JSONObject jSONObject2 = faceNode.toJSONConfig(httpServletRequest, authentication, faceManager, string + n, i + 1);
                if (jSONObject2 == null) continue;
                ((JSONArray)object).put(jSONObject2);
            }
            return jSONObject;
        } else {
            jSONObject.put("leaf", true);
        }
        return jSONObject;
    }

    public NodeDef getNodeDef() {
        return this.nodeDef;
    }

    public void setNodeDef(NodeDef nodeDef) {
        this.nodeDef = nodeDef;
    }

    public void addChild(FaceNode faceNode) {
        this.faceNodeList.add(faceNode);
    }

    public int getChildCount() {
        return this.faceNodeList.size();
    }

    public FaceNode getChild(int n) {
        return (FaceNode)this.faceNodeList.get(n);
    }

    public void clearChildren() {
        this.faceNodeList.clear();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.clearChildren();
        }
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if ("FaceNode".equals(string2)) {
                FaceNode faceNode = new FaceNode();
                this.addChild(faceNode);
                xMLableReader.readXMLObject(faceNode);
            } else if ("NodeDef".equals(string2) && (string = xMLableReader.getAttr("class")) != null) {
                NodeDef nodeDef = null;
                if (string.endsWith(".ReportletDef")) {
                    nodeDef = new ViewReportletDef();
                } else if (string.endsWith(".ViewReportletDef")) {
                    nodeDef = new ViewReportletDef();
                } else if (string.endsWith(".WriteReportletDef")) {
                    nodeDef = new WriteReportletDef();
                } else if (string.endsWith(".WebURLDef")) {
                    nodeDef = new WebURLDef();
                } else if (string.endsWith(".FolderDef")) {
                    nodeDef = new FolderDef();
                } else {
                    try {
                        nodeDef = (NodeDef)FRCoreContext.classForName(string).newInstance();
                    }
                    catch (Exception exception) {
                        FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
                    }
                }
                if (nodeDef != null) {
                    xMLableReader.readXMLObject(nodeDef);
                    this.setNodeDef(nodeDef);
                }
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("FaceNode");
        if (this.nodeDef != null) {
            xMLPrintWriter.startTAG("NodeDef").attr("class", this.nodeDef.getClass().getName());
            this.nodeDef.writeXML(xMLPrintWriter);
            xMLPrintWriter.end();
        }
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            FaceNode faceNode = this.getChild(i);
            faceNode.writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

