/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.face;

import com.fr.base.CodeUtils;
import com.fr.base.FRContext;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.privilege.authentication.Authentication;
import com.fr.privilege.filter.core.TemplateAccessDealWith;
import com.fr.report.parameter.Parameter;
import com.fr.web.face.AbstractNodeDef;
import com.fr.web.face.Access;
import com.fr.web.face.ReportletInfo;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class ViewReportletDef
extends AbstractNodeDef {
    private List reportletInfoList = new ArrayList();

    public int getReportletInfoCount() {
        return this.reportletInfoList.size();
    }

    public ReportletInfo getReportletInfo(int n) {
        return (ReportletInfo)this.reportletInfoList.get(n);
    }

    public void addReportletInfo(ReportletInfo reportletInfo) {
        this.reportletInfoList.add(reportletInfo);
    }

    public void setReportletInfo(int n, ReportletInfo reportletInfo) {
        this.reportletInfoList.set(n, reportletInfo);
    }

    public void clearReportletInfos() {
        this.reportletInfoList.clear();
    }

    public Access createURI(HttpServletRequest httpServletRequest, Authentication authentication) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getReportletInfoCount();
        if (n > 0) {
            stringBuffer.append(FRContext.getConfigManager().getServletMapping()).append("?");
            if (n == 1) {
                ReportletInfo reportletInfo = this.getReportletInfo(0);
                if (authentication != null && !TemplateAccessDealWith.hasLegalAccess(reportletInfo.getReporletPath(), 0, authentication)) {
                    return new Access("", false);
                }
                stringBuffer.append("reportlet=").append(CodeUtils.encodeURIComponent(reportletInfo.getReporletPath()));
                int n2 = reportletInfo.getParameterCount();
                if (n2 > 0) {
                    for (int i = 0; i < n2; ++i) {
                        stringBuffer.append("&");
                        Parameter parameter = reportletInfo.getParameter(i);
                        stringBuffer.append(CodeUtils.encodeURIComponent(parameter.getName())).append("=").append(CodeUtils.encodeURIComponent(parameter.valueToString()));
                    }
                }
            } else {
                stringBuffer.append("reportlets=");
                stringBuffer.append("(");
                for (int i = 0; i < n; ++i) {
                    ReportletInfo reportletInfo = this.getReportletInfo(i);
                    if (i != 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append("{reportlet:").append(CodeUtils.encodeURIComponent(reportletInfo.getReporletPath()));
                    int n3 = reportletInfo.getParameterCount();
                    if (n3 > 0) {
                        for (int j = 0; j < n3; ++j) {
                            stringBuffer.append(",");
                            Parameter parameter = reportletInfo.getParameter(j);
                            stringBuffer.append(CodeUtils.encodeURIComponent(parameter.getName())).append(":").append(CodeUtils.encodeURIComponent(parameter.valueToString()));
                        }
                    }
                    stringBuffer.append("}");
                }
                stringBuffer.append(")");
            }
        }
        return new Access(CodeUtils.cjkEncode(stringBuffer.toString()), true);
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && "ReportletInfo".equals(xMLableReader.getTagName())) {
            ReportletInfo reportletInfo = new ReportletInfo();
            xMLableReader.readXMLObject(reportletInfo);
            this.addReportletInfo(reportletInfo);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        int n = this.getReportletInfoCount();
        for (int i = 0; i < n; ++i) {
            ReportletInfo reportletInfo = this.getReportletInfo(i);
            reportletInfo.writeXML(xMLPrintWriter);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

