/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.face;

import com.fr.base.CodeUtils;
import com.fr.base.FRContext;
import com.fr.base.core.util.TemplateUtils;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.privilege.authentication.Authentication;
import com.fr.report.io.xml.ReportXMLUtils;
import com.fr.report.parameter.Parameter;
import com.fr.web.core.WebUtils;
import com.fr.web.face.AbstractNodeDef;
import com.fr.web.face.Access;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class WebURLDef
extends AbstractNodeDef {
    private String url = "";
    private Parameter[] parameters = null;

    public WebURLDef() {
    }

    public WebURLDef(String string) {
        this.setName(string);
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String string) {
        this.url = string;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Parameter[] parameterArray) {
        this.parameters = parameterArray;
    }

    public Access createURI(HttpServletRequest httpServletRequest, Authentication authentication) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getURL();
        try {
            string = TemplateUtils.render(string, WebUtils.createTemplateMap(httpServletRequest));
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
        }
        boolean bl = string.indexOf("?") != -1;
        stringBuffer.append(string);
        Parameter[] parameterArray = this.getParameters();
        if (parameterArray != null && parameterArray.length > 0) {
            int n = parameterArray.length;
            for (int i = 0; i < n; ++i) {
                if (i == 0 && !bl) {
                    stringBuffer.append("?");
                } else {
                    stringBuffer.append("&");
                }
                Parameter parameter = parameterArray[i];
                stringBuffer.append(CodeUtils.cjkEncode(parameter.getName())).append("=").append(CodeUtils.cjkEncode(parameter.getValue().toString()));
            }
        }
        return new Access(stringBuffer.toString(), true);
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("WebURLAttributes".equals(string)) {
                String string2 = xMLableReader.getAttr("url");
                if (string2 != null) {
                    this.setURL(string2);
                }
            } else if ("Parameters".equals(string)) {
                this.setParameters(ReportXMLUtils.readParameters(xMLableReader));
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("WebURLAttributes");
        if (this.getURL() != null) {
            xMLPrintWriter.attr("url", this.getURL());
        }
        xMLPrintWriter.end();
        Parameter[] parameterArray = this.getParameters();
        ReportXMLUtils.writeParameters(xMLPrintWriter, parameterArray);
    }

    public Object clone() throws CloneNotSupportedException {
        WebURLDef webURLDef = (WebURLDef)super.clone();
        Parameter[] parameterArray = this.getParameters();
        if (parameterArray != null) {
            Parameter[] parameterArray2 = new Parameter[parameterArray.length];
            for (int i = 0; i < parameterArray2.length; ++i) {
                parameterArray2[i] = (Parameter)parameterArray[i].clone();
            }
            webURLDef.setParameters(parameterArray2);
        }
        return webURLDef;
    }
}

