/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.platform;

import com.fr.base.FRContext;
import com.fr.base.core.ComparatorUtils;
import com.fr.data.TableData;
import com.fr.privilege.authority.Authority;
import com.fr.report.script.core.FArray;
import com.fr.web.core.WebUtils;
import com.fr.web.platform.exception.RedirectException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class PlatformUtils {
    public static void redirect(HttpServletResponse httpServletResponse, String string) throws Exception {
        httpServletResponse.sendRedirect(string);
        throw new RedirectException();
    }

    public static Connection createConnection() {
        if (FRContext.getPlatformConnection() == null) {
            return null;
        }
        Connection connection = null;
        try {
            connection = FRContext.getPlatformConnection().createConnection();
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
        }
        return connection;
    }

    public static Authority[] createSessionAuthorities(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        WebUtils.getHTTPRequestParameter(httpServletRequest, "fr_username");
        Object object = httpSession.getAttribute("fr_free_authority");
        Authority[] authorityArray = new Authority[]{};
        if (object instanceof String) {
            String[] stringArray = ((String)object).split(",");
            ArrayList<Authority> arrayList = new ArrayList<Authority>();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                arrayList.add(new Authority(stringArray[i]));
            }
            authorityArray = arrayList.toArray(new Authority[arrayList.size()]);
        } else if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            int n = stringArray.length;
            authorityArray = new Authority[n];
            for (int i = 0; i < n; ++i) {
                authorityArray[i] = new Authority(stringArray[i]);
            }
        }
        return authorityArray;
    }

    public static FArray obtainAuthority(Authority[] authorityArray) {
        FArray fArray = new FArray();
        if (authorityArray != null) {
            for (int i = 0; i < authorityArray.length; ++i) {
                fArray.add(authorityArray[i].getName());
            }
        }
        return fArray;
    }

    public static int[] getColumnIndics(TableData tableData, String[] stringArray) {
        int n;
        if (tableData == null) {
            return new int[0];
        }
        int[] nArray = new int[stringArray.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = -1;
        }
        try {
            for (n = 0; n < stringArray.length; ++n) {
                int n2 = tableData.getColumnCount();
                for (int i = 0; i < n2; ++i) {
                    if (!ComparatorUtils.tableDataColumnNameEquals(stringArray[n], tableData.getColumnName(i))) continue;
                    nArray[n] = i;
                }
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().log(Level.WARNING, exception.getMessage(), exception);
        }
        return nArray;
    }
}

