/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.platform.entry;

import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.base.xml.XMLPrintWriter;
import com.fr.base.xml.XMLableReader;
import com.fr.schedule.ScheduleContext;
import com.fr.web.platform.entry.Entry;
import com.fr.web.platform.entry.FolderEntry;

public abstract class BaseEntry
implements Entry {
    public static final String ID = "id";
    public static final String PARENTID = "parent";
    public static final String DISPLAYNAME = "name";
    public static final String DESCRIPTION = "description";
    public static final int IDTYPE = 4;
    public static final int PARENTIDTYPE = 4;
    public static final int DISPLAYNAMETYPE = 12;
    public static final int DESCRIPTIONTYPE = 12;
    private long id = -1L;
    private long parentId;
    private String displayName;
    private String description;

    public BaseEntry() {
    }

    public BaseEntry(String string) {
        this.displayName = string;
    }

    public BaseEntry(String string, String string2) {
        this.displayName = string;
        this.description = string2;
    }

    public JSONObject createJSONConfig() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(ID, this.getTypePrefix() + this.getId());
        jSONObject.put("type", this.getTypePrefix());
        jSONObject.put("parentId", "0" + this.getParentId());
        jSONObject.put("text", this.getDisplayName());
        jSONObject.put(DESCRIPTION, this.getDescription());
        return jSONObject;
    }

    public void parseJSON(JSONObject jSONObject) throws JSONException {
        this.setDisplayName(jSONObject.getString("text"));
        this.setDescription(jSONObject.getString(DESCRIPTION));
        this.setParentId(jSONObject.getLong("parentId"));
        if (jSONObject.has(ID) && StringUtils.isNotBlank(jSONObject.getString(ID))) {
            this.setId(jSONObject.getLong(ID));
        }
    }

    public abstract String getTypePrefix();

    public boolean appendToFolder(FolderEntry folderEntry) {
        this.setParentId(folderEntry.getId());
        return ScheduleContext.getJdbcDaoManager().saveOrUpdate(this);
    }

    public void setId(long l) {
        this.id = l;
    }

    public long getId() {
        return this.id;
    }

    public void setParentId(long l) {
        this.parentId = l;
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void readXML(XMLableReader xMLableReader) {
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
    }

    public boolean equals(Object object) {
        if (!(object instanceof BaseEntry)) {
            return false;
        }
        BaseEntry baseEntry = (BaseEntry)object;
        return baseEntry.id == this.id && baseEntry.parentId == this.parentId && ComparatorUtils.equals(baseEntry.displayName, this.displayName) && ComparatorUtils.equals(baseEntry.description, this.description);
    }

    public Object clone() throws CloneNotSupportedException {
        BaseEntry baseEntry = (BaseEntry)super.clone();
        return baseEntry;
    }
}

