/*
 * Decompiled with CFR 0.152.
 */
package com.fr.web.platform.entry;

import com.fr.base.StringUtils;
import com.fr.base.core.ComparatorUtils;
import com.fr.base.core.json.JSONArray;
import com.fr.base.core.json.JSONException;
import com.fr.base.core.json.JSONObject;
import com.fr.schedule.Schedulable;
import com.fr.schedule.dao.FieldMapper;
import com.fr.schedule.dao.ObjectMapper;
import com.fr.schedule.dao.ValueFieldMapper;
import com.fr.schedule.task.ScheduleTask;
import com.fr.third.org.quartz.JobDetail;
import com.fr.third.org.quartz.Scheduler;
import com.fr.third.org.quartz.SchedulerException;
import com.fr.web.platform.TransmitParameters;
import com.fr.web.platform.entry.BaseEntry;

public class ReportletEntry
extends BaseEntry
implements Schedulable {
    public static final String TYPE_PREFIX = "2";
    public static final String TABLE_NAME = "fr_reportletentry";
    public static final String TRANSMITPARAMETERS = "transmitParameters";
    public static final String ISVIEW = "isView";
    public static final String REPORTLETPATH = "reportletPath";
    public static final int TRANSMITPARAMETERSTYPE = 12;
    public static final int ISVIEWTYPE = 4;
    public static final int REPORTLETPATHTYPE = 12;
    private boolean isView = true;
    private String reportletPath = null;
    private TransmitParameters transmitParameters = null;
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper("fr_reportletentry", new FieldMapper[]{new FieldMapper("id", 4, "id"), new FieldMapper("parentId", 4, "parent"), new FieldMapper("displayName", 12, "name"), new FieldMapper("description", 12, "description"), new FieldMapper("reportletPath", 12, "reportletPath"), new ValueFieldMapper("isView", 4, "isView"){

        public Object field2Value(Object object) {
            if (Boolean.FALSE.equals(object)) {
                return new Integer(0);
            }
            return new Integer(1);
        }

        public Object value2Field(Object object) {
            if (object == null) {
                return Boolean.TRUE;
            }
            Number number = (Number)object;
            if (number.intValue() == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
    }, new ValueFieldMapper("transmitParameters", 12, "transmitParameters"){

        public Object value2Field(Object object) {
            String string = (String)object;
            if (StringUtils.isBlank(string)) {
                return null;
            }
            TransmitParameters transmitParameters = null;
            try {
                transmitParameters = TransmitParameters.parseJSON(new JSONArray(string));
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            return transmitParameters;
        }

        public Object field2Value(Object object) {
            if (object == null) {
                return "";
            }
            TransmitParameters transmitParameters = (TransmitParameters)object;
            String string = "";
            try {
                string = transmitParameters.createJSON().toString();
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            return string;
        }
    }});
    static /* synthetic */ Class class$com$fr$schedule$job$ViewReportletJob;
    static /* synthetic */ Class class$com$fr$schedule$job$WriteReportletJob;

    public ReportletEntry() {
        this("");
    }

    public ReportletEntry(String string) {
        this.setReportletPath(string);
    }

    public ReportletEntry(String string, String string2, String string3) {
        super(string, string2);
        this.reportletPath = string3;
    }

    public JSONObject createJSONConfig() throws JSONException {
        JSONObject jSONObject = super.createJSONConfig();
        jSONObject.put(ISVIEW, this.isView());
        jSONObject.put("path", this.getReportletPath());
        if (this.transmitParameters != null && this.transmitParameters.size() > 0) {
            jSONObject.put(TRANSMITPARAMETERS, this.transmitParameters.createJSON());
        }
        return jSONObject;
    }

    public void schedule(Scheduler scheduler, ScheduleTask scheduleTask) throws SchedulerException {
        JobDetail jobDetail = new JobDetail(scheduleTask.getName(), this.getDisplayName(), this.getReportJobClass());
        jobDetail.setDescription(scheduleTask.getDescription());
        jobDetail.getJobDataMap().put("__task__", scheduleTask.getId());
        jobDetail.getJobDataMap().put("__reportlet__", this.getId());
        scheduler.scheduleJob(jobDetail, scheduleTask.getITrigger().createTrigger());
    }

    public Class getReportJobClass() {
        Class clazz = this.isView ? (class$com$fr$schedule$job$ViewReportletJob == null ? (class$com$fr$schedule$job$ViewReportletJob = ReportletEntry.class$("com.fr.schedule.job.ViewReportletJob")) : class$com$fr$schedule$job$ViewReportletJob) : (class$com$fr$schedule$job$WriteReportletJob == null ? (class$com$fr$schedule$job$WriteReportletJob = ReportletEntry.class$("com.fr.schedule.job.WriteReportletJob")) : class$com$fr$schedule$job$WriteReportletJob);
        return clazz;
    }

    public void setView(boolean bl) {
        this.isView = bl;
    }

    public boolean isView() {
        return this.isView;
    }

    public void setReportletPath(String string) {
        this.reportletPath = string;
    }

    public String getReportletPath() {
        return this.reportletPath;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ReportletEntry)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ReportletEntry reportletEntry = (ReportletEntry)object;
        return ComparatorUtils.equals(reportletEntry.getReportletPath(), this.getReportletPath()) && reportletEntry.isView == this.isView;
    }

    public Object clone() throws CloneNotSupportedException {
        ReportletEntry reportletEntry = (ReportletEntry)super.clone();
        return reportletEntry;
    }

    public String getTypePrefix() {
        return TYPE_PREFIX;
    }

    public TransmitParameters getTransmitParameters() {
        return this.transmitParameters;
    }

    public void setTransmitParameters(TransmitParameters transmitParameters) {
        this.transmitParameters = transmitParameters;
    }

    public void parseJSON(JSONObject jSONObject) throws JSONException {
        super.parseJSON(jSONObject);
        this.setReportletPath(jSONObject.getString("path"));
        this.setView(jSONObject.getBoolean(ISVIEW));
        JSONArray jSONArray = null;
        try {
            jSONArray = jSONObject.getJSONArray(TRANSMITPARAMETERS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (jSONArray != null) {
            this.setTransmitParameters(TransmitParameters.parseJSON(jSONArray));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

