(function($) {
	
	$.fn.showPane= function(){
		this.siblings().hide();
		this.show();
	}//showPane
	
	$.fn.loadTree = function(tree){
		var right = this;
		$.get(
			"${servletURL}",
			{
				op: "fr_schedule_getFolder",
				type : 'POST'
			},
			function callback(jasonA){
				var treedata = JSON.parse(jasonA);
				var o = {
					onlyfolder: true,
					data: treedata,
					onnodeclick: function(){
						var currentItem = tree.getTCT();
						if (currentItem.id == '0-1') {
							right.filePane.hide();
							right.filePane.siblings().hide();
							return;
						}
						right.loadReport(currentItem);
					}
				};
				tree.treeview(o);
			}//callback
		);
	}//loadTree
	

	
	$.fn.loadTask = function(item){
		var schedule = this;
		var taskPane = schedule.taskPane;
		taskPane.showPane();
		taskPane.tableBody.empty();
		taskPane.populate(item);
		$.ajax({
				type : 'POST',
				url : '${servletURL}',
				data : {
					op : 'fr_schedule_getTask',
					reportId: item.id.substr(1)
					},
				async : false,
				complete : function(res, status) {
					var tasks = FR.jsonDecode(res.responseText);		
					item.tasks = tasks;				
					for (var i=0; i<tasks.length; i++){					
						var tableTR = $('<tr></tr>').appendTo(taskPane.tableBody)
						.mouseover(function() {$(this).addClass("over");}).mouseout(function() {$(this).removeClass("over");});
					
						var taskcheck = $('<input type="checkbox">').attr({id:i})
						.click(function(){
							if(this.checked){
								$(this.parentNode.parentNode).addClass("selected");
							}else{
								$(this.parentNode.parentNode).removeClass("selected");
							}
							tasks[this.id].checked = this.checked;
						});
						taskcheck.wrap($('<td></td>')).parent().appendTo(tableTR);
						
						var taskname = $('<td>'+ tasks[i].name +'</td>').appendTo(tableTR);
						
						var taskedit = $("<input height=25 type='image' src='${servletURL}?op=resource&resource=/com/fr/schedule/web/css/images/edit.png'>").attr({id:i, title:"༭"})
						.click(function(){
							schedule.processPane.populate(taskPane.report, tasks[this.id], item.isView);
							schedule.processPane.showPane();
						});
						taskedit.wrap($('<td></td>')).parent().appendTo(tableTR);
						
						var taskstate = $("<input height=25 type='image'>").attr({id:i})
						.click(function(){
							var task = this;
							$.get(
								"${servletURL}",
								{
								op: "fr_schedule_stateJob",
								taskId: tasks[task.id].id
								},
								function callback(state){
									tasks[task.id].state = state;
									if (state == -2) {
										state.title = "ȴ";
										state.src = '${servletURL}?op=resource&resource=/com/fr/schedule/web/css/images/wait.png';					
									} else if(state == 0){
										task.title = "";
										task.src = '${servletURL}?op=resource&resource=/com/fr/schedule/web/css/images/start.png';
									} else if(state == 1){
										task.title = "ͣ";
										task.src = '${servletURL}?op=resource&resource=/com/fr/schedule/web/css/images/pause.png';
									} else {
										task.title = "";
										task.src = '${servletURL}?op=resource&resource=/com/fr/schedule/web/css/images/stop.png';
									}
								}//callback
							);
						});
						if (tasks[i].state == -2) {
							taskstate[0].title = "ȴ";
							taskstate[0].src = '${servletURL}?op=resource&resource=/com/fr/schedule/web/css/images/wait.png';					
						} else if(tasks[i].state == 0){
							taskstate[0].title = "";
							taskstate[0].src = '${servletURL}?op=resource&resource=/com/fr/schedule/web/css/images/start.png';
						} else if(tasks[i].state == 1){
							taskstate[0].title = "ͣ";
							taskstate[0].src = '${servletURL}?op=resource&resource=/com/fr/schedule/web/css/images/pause.png';
						} else {
							taskstate[0].title = "";
							taskstate[0].src = '${servletURL}?op=resource&resource=/com/fr/schedule/web/css/images/stop.png';
						}
						taskstate.wrap($('<td></td>')).parent().appendTo(tableTR);
						if (item.isView) {
							var reporturl = tasks[i].name;
							$("<td title='鿴ɵı' onclick=window.open('${servletURL}?reportlet=schedulereport&task=" + $().dealplus(FR.cjkEncode(reporturl)) + "')>ʷ¼ѯ</td>").addClass("visitReport").appendTo(tableTR);								
						} else {
							$('<td>޼¼</td>').appendTo(tableTR);
						}
					}
				}
		});
	}//loadTask
	
	$.fn.dealplus = function(text) {
	    if (typeof text !== 'string') {
    		return text;
    	}
    	var newText = "";
        for (var i = 0; i < text.length; i++) {
            var code = text.charCodeAt(i);
            if (code == 43) {
                newText += "[" + code.toString(16) + "]";
            } else {
                newText += text.charAt(i);
            }
        }

        return newText
	}
	
})(jQuery);


