(function($) {

//file
$.fn.createFilePane = function(tree){
	var right = this;
	var filePane = $("<div></div>");
	var fileHeader = $("<div class='title'>ģ/ļб</div>").appendTo(filePane);

	var fileTable = $('<table></table>').addClass("table").appendTo(filePane);
	var tableHead = $('<thead></thead>').appendTo(fileTable);
	var tableHR = $('<tr></tr>').appendTo(tableHead);
	var tableHD = $('<th width="5%"></th><th width="30%">ʱ</th><th width="30%">ʱģ</th><th>Ƿ</th>').appendTo(tableHR);
	filePane.tableBody = $('<tbody></tbody>').appendTo(fileTable);
	var fileButton1 = {
		text: "ģ",
		handler: function(){
			FR.showDialog("ģ", 520, -1, SC.addReportDialog(tree));
		}//handler
	};
	var fileButton2 = {
		text: "ɾ",
		handler: function(){
			var currentItem = tree.getTCT();
			var childNodes = currentItem.ChildNodes;
			if(!childNodes){
				return;
			}
			var checklist = [];
			for(var i=0;i<childNodes.length;i++){
				if(childNodes[i].checked){
					checklist.push(childNodes[i].id);
				}
			}
			if(checklist.length==0){
				return;
			}
			var confirm = window.confirm("ȷɾѡģļ");
			if(confirm){
				var reportIds = [];
				for(var i=0; i<checklist.length; i++){
					reportIds[i]=checklist[i];
				}//ûȥǰ
				$.get(
					"${servletURL}",
					{
					type : 'POST',
					op: "fr_schedule_delReports",
					reportIds: reportIds.toString()
					},
					function callback(){//Ӧ
						tree.delNodes(currentItem,checklist);
					}//callback
				);
			}
		}//handler
	};
	SC.buttonTable([fileButton1,fileButton2]).appendTo(filePane);

	return filePane;
}//createFilePane

//task
$.fn.createTaskPane = function(){
	var right = this;
	var taskPane = $("<div></div>");
	var taskHeader = $("<div class='title'>ʱб</div>").appendTo(taskPane);

	var taskTable = $('<table class="table"></table>').attr('align', 'center')
		.attr('cellspacing', 0).attr('cellpadding', 0).appendTo(taskPane);
	var tableHead = $('<thead></thead>').appendTo(taskTable);
	var tableHR = $('<tr></tr>').appendTo(tableHead);
	var tableHD = $('<th></th><th></th><th>༭</th><th>״̬</th><th>ɽ</th>').appendTo(tableHR);
	taskPane.tableBody = $('<tbody></tbody>').appendTo(taskTable);

	var taskButtonTable = $("<table></table>").appendTo(taskPane);
	var taskButtons = $("<tr></tr>").appendTo(taskButtonTable);
	var taskButton2 = {
		text: "Ӷʱ",
		handler: function(){
			right.processPane.populate(taskPane.report, "new", taskPane.report.isView);
			right.processPane.showPane();
//			var stepFrame = $('<iframe name="stepframe" src="${servletURLURL}?action=getstep1"></iframe>').appendTo(right);
//			stepFrame.showPane();
		}
	};
	var taskButton3 = {
		text: "ɾʱ",
		handler: function(){
			var tasks = taskPane.report.tasks;
			var checklist = [];
			for(var i=0;i<tasks.length;i++){
				if(tasks[i].checked){
					checklist.push(tasks[i].id);
				}
			}
			if(checklist.length==0){
				return;
			}
			var confirm = window.confirm("ȷɾѡĶʱ");
			if(confirm){
				$.get(
					"${servletURL}",
					{
					op: "fr_schedule_delTasks",
					taskIds: checklist.toString()
					},
					function callback(){//Ӧ
						right.loadTask(taskPane.report);
					}//callback
				);
			}
		}//handler
	};
	var taskButton1 = {
		text: "ģ",
		handler: function(){
			FR.PLATFORM.catalogDesignModule.filesArea.show();
			FR.PLATFORM.SCHEDULE.hide();
		}//handler
	};
	SC.buttonTable([taskButton1,taskButton2,taskButton3]).appendTo(taskPane);
	
	taskPane.populate = function(report){
		taskPane.report = report;
	}

	return taskPane;
}//createTaskPane

//process
$.fn.createProcessPane = function(tree){
	var right = this;
	var processPane = $("<div></div>");
	var processHeader = $("<div class='title'>½ʱ</div>").appendTo(processPane);
	
	var finishbutton = {
		text : "",
		handler : function(){
			if(!processPane.checkvalid()){
				return;
			}
			processPane.update(processPane.task);
			$.get(
				"${servletURL}",
				{	
					type : 'POST',
					op: "fr_schedule_aouTask",
					taskJason: FR.cjkEncode(FR.jsonEncode(processPane.task))
				},
				function callback(jasonA){
					right.loadTask(processPane.report);
				}//callback
			);
		}
	}
	var cancelbutton = {
		text : "ȡ",
		handler : function(){
			right.taskPane.showPane();
		}
	}
	
	var basicPane = basicPane().appendTo(processPane);
	var itriggerPane = itriggerPane().appendTo(processPane).hide();
	var parameterPane = parameterPane().appendTo(processPane).hide();
	var outputPane = outputPane().appendTo(processPane).hide();
	
	function getCheckedRadio(radios) {
		var value;
		$.each(radios, function(i) {
			if (radios[i].checked) {
				value = radios[i].value;
				return false;
			}
		});
		return value;
	}
	
	function basicPane(){
		var basicPane = $("<div>һ</div>");
		var group = $('<p>飺*</p><input id="taskgroup" readonly="true"/>').appendTo(basicPane);
		var name = $('<p>ƣ*</p><input id="taskname"/>').appendTo(basicPane);
		var desc = $('<p></p><textarea id="taskdesc" cols="30" rows="3"></textarea>').appendTo(basicPane);
		basicPane.populate = function (task){
			$("#taskgroup").attr({value:processPane.report.text});
			$("#taskname").attr({value:(task.name)? task.name : ""});
			$("#taskdesc").attr({value:(task.description)? task.description : ""});
		}
		basicPane.update = function(task){
			task.groupId = processPane.report.id.substr(1);//ȥǰ
			task.name = $("#taskname").attr("value");
			task.description = $("#taskdesc").attr("value");
		}
		basicPane.checkvalid = function() {
			if(!$("#taskname").attr("value")){
				basicPane.showPane();
				$("#taskname").focus();
				alert("д");
				return false;
			}
			return true;
		}
		var nextbutton = {
			text : "һ",
			handler : function(){
				if(basicPane.checkvalid()){
					itriggerPane.showPane();
				}
			}
		}
		SC.buttonTable([nextbutton,finishbutton,cancelbutton]).appendTo(basicPane);
		return basicPane;
	}//outputPane
	
	function itriggerPane(){
		var itriggerPane = $("<div>ڶʱ</div>");
//		var timezonetable = $('<table></table>').appendTo(itriggerPane);
//		var timezonetr = $('<tr><td>ʱ</td></tr>').appendTo(timezonetable);
//		var timezonecombo = $('<div></div>');
//		timezonecombo.wrap($('<td></td>')).parent().appendTo(timezonetr);
//		var timezoneConfig = {
//			editable : false,
//			width : 130,
//			allowBlank : false,
//			mode: 'local',
//			items: [{value: "US/Hawaii", text: "US/Hawaii"},
//					{value: "America/Los_Angeles", text: "America/Los_Angeles"},
//					{value: "America/New_York", text: "America/New_York"},
//					{value: "Europe/London", text: "Europe/London"},
//					{value: "Europe/Paris", text: "Europe/Paris"},
//					{value: "Europe/Moscow", text: "Europe/Moscow"},
//					{value: "Asia/Urumqi", text: "Asia/Urumqi"},
//					{value: "Asia/Shanghai", text: "Asia/Shanghai"},
//					{value: "Asia/Tokyo", text: "Asia/Tokyo"}]
//		};
//		var timezone = timezonecombo.asComponent("combo", timezoneConfig);
		
		var starttable = $('<table></table>').appendTo(itriggerPane);
		$('<tr><td><p class="frequentTitle">ʼʱ趨</p></td></tr>').appendTo(starttable);
		var immediately = $('<tr><td><input type="radio" name="start" value=1 id="immediately"/>ɺ̿ʼ</td></tr>').appendTo(starttable);
		var on =  $('<tr><td><input type="radio" name="start" value=2 id="on"/>趨ʼʱ䣺</td></tr>').appendTo(starttable);
		var starttimediv = $('<div></div>');
		starttimediv.wrap($('<td></td>')).parent().appendTo(on);
		var timeConfig = {
			width : 180,
			disable : false,
			editable : true,
			allowBlank : false,
			format : "yyyy-MM-dd HH:mm:ss"
		};
		var starttime = starttimediv.asComponent("datetime", timeConfig);
		
		$('<p>ע⣺ִƵеִֻһκͼظִʼʱͻִУԶظִʼִС</p>').appendTo(itriggerPane);
		
		var recurrenceType = $('<p class="frequentTitle">ִƵʣ</p>').appendTo(itriggerPane);
		var recurrenceRadios = $('<div/>').appendTo(itriggerPane);
		var recurrencePane = $('<div></div>').appendTo(itriggerPane);

		var oncePane = oncePane();
		oncePane.appendTo(recurrencePane).hide();
		var simplePane = simplePane();
		simplePane.appendTo(recurrencePane).hide();
		var calendarPane = calendarPane();
		calendarPane.appendTo(recurrencePane).hide();
		
		var onceRadio = $('<input type="radio" name="recurrenceType" value="once" id="once">')
		.click(function(){
			oncePane.showPane();
		}).appendTo(recurrenceRadios);
		
		$('<span title="ʼִֻһ">ִֻһ</span>').appendTo(recurrenceRadios);
		var simpleRadio = $('<input type="radio" name="recurrenceType" value="simple" id="simple">')
		.click(function(){
			simplePane.showPane();
		}).appendTo(recurrenceRadios);
		$('<span title="ʱձܱ">ظִ</span>').appendTo(recurrenceRadios);
		var calendarRadio = $('<input type="radio" name="recurrenceType" value="calendar" id="calendar">')
		.click(function(){
			calendarPane.showPane();
		}).appendTo(recurrenceRadios);
		$('<span title="Ƶ趨">Զظִ</span>').appendTo(recurrenceRadios);

		function oncePane(){
			var oncePane = $("<div><p class='frequentTitle'>ʱ趨</p></div>");
			$("<p>ִһκ󼴽</p>").appendTo(oncePane);
			return oncePane;
		}//oncePane
		
		function simplePane(){
			var simplePane = $("<div></div>");
			
			var frequencetable = $('<table></table>').appendTo(simplePane);
			var frequencetr = $('<tr><td><p>ִƵʣÿ<input id="recurrenceInterval"/></p></td></tr>').appendTo(frequencetable);
			var frequencetypecombo = $('<div></div>');
			frequencetypecombo.wrap($('<td></td>')).parent().appendTo(frequencetr);
			var frequencetypeConfig = {
				editable : false,
				allowBlank : false,
				width: 70,
				mode: 'local',
				items: [{value: 1, text: ""},
						{value: 2, text: "Сʱ"},
						{value: 3, text: ""},
						{value: 4, text: ""}]
			};
			var frequencetype = frequencetypecombo.asComponent("combo", frequencetypeConfig);
			
			var occurtable = $('<table></table>').appendTo(simplePane);
			$('<tr><td><p class="frequentTitle">ʱ趨</p></td></tr>').appendTo(occurtable);
			var indifinitely = $('<tr><td><input type="radio" name="occur" value="indifinitely" id="indifinitely"/></td><td></td></tr>').appendTo(occurtable);
			var until =  $('<tr><td><input type="radio" name="occur" value="until" id="until"/>ʱ䣺</td></tr>').appendTo(occurtable);
			var untiltimediv = $('<div></div>');
			untiltimediv.wrap($('<td></td>')).parent().appendTo(until);
			var untiltime = untiltimediv.asComponent("datetime", timeConfig);
			var repeat =  $('<tr><td><input type="radio" name="occur" value="repeat" id="repeat"/>ظִд</td><td><input id="repeatCount"/></td></tr>').appendTo(occurtable);
			
			simplePane.populate = function(iTrigger){
				if(iTrigger.endTime){
					$('#until').attr('checked',true);
					untiltime.setValue(iTrigger.endTime);
					$('#repeatCount').attr('value','');
				} else if(iTrigger.repeatCount > 0 || iTrigger.repeatCount == -1){
					$('#indifinitely').attr('checked',true);
					$('#repeatCount').attr('value','');
					untiltime.setValue("");
				} else {
					$('#repeat').attr('checked',true);
					$('#repeatCount').attr('value',iTrigger.repeatCount);
					untiltime.setValue("");
				}
				$('#recurrenceInterval').val((iTrigger.recurrenceInterval)? iTrigger.recurrenceInterval : 1);
				frequencetype.setValue((iTrigger.recurrenceIntervalUnit)? iTrigger.recurrenceIntervalUnit : 1);
			}
			simplePane.update = function(iTrigger){
				if(getCheckedRadio($('input[name="occur"]'))== "indifinitely"){
					iTrigger.repeatCount = -1;
					delete iTrigger.endTime;
				}else if(getCheckedRadio($('input[name="occur"]'))== "until"){
					iTrigger.endTime = untiltime.getValue();
					delete iTrigger.repeatCount;
				}else if(getCheckedRadio($('input[name="occur"]'))== "repeat"){
					iTrigger.repeatCount = $('#repeatCount').val();
					delete iTrigger.endTime;
				}
				iTrigger.recurrenceInterval = $('#recurrenceInterval').val();
				iTrigger.recurrenceIntervalUnit = frequencetype.getValue();
			}
			simplePane.checkvalid = function(){
				if (frequencetype.isExpanded()) {
					frequencetype.collapse();				
				}

				if(getCheckedRadio($('input[name="occur"]'))== "until"){
					var time = untiltime.getValue();
					if(!(/^(\d{4})-(0[1-9]|1[0-2])-(0[1-9]|[12]\d|3[01])\s([01]\d|2[0-3])(:[0-5]\d){2}$/).test(time)){
						itriggerPane.showPane();
						alert("ȷʽʱ䣺yyyy-MM-dd HH:mm:ss");
						return false;
					}
					var begintime = starttime.getValue();
					if (Date.parse(begintime.replace(/-/g, "/")) > Date.parse(time.replace(/-/g, "/"))) {
						itriggerPane.showPane();
						alert("ʼʱ䲻ܴڽʱ䣡");
						return false;	
					}
				}else if(getCheckedRadio($('input[name="occur"]'))== "repeat"){
					var count = $('#repeatCount').val()
					if(!(/^\d+$/).test(count)){
						itriggerPane.showPane();
						$('#repeatCount').focus();
						alert("ȷд");
						return false;
					}
				}
				var interval = $('#recurrenceInterval').val();
				if(!(/^\d+$/).test(interval)){
					itriggerPane.showPane();
					$('#recurrenceInterval').focus();
					alert("ʱ");
					return false;
				}
				return true;
			}
			
			return simplePane;
		}//simplePane
		
		function calendarPane(){
			var calendarPane = $("<div></div>");
			var timeTable = $('<table></table>').appendTo(calendarPane);
			var mh = $('<tr><td><p>ʱã</p></td><td><div><input id="hours"/>(ʱ)</div></td><td><div><input id="minutes"/>()</div></td></tr>').appendTo(timeTable);
//			var minutes = $('<tr><td>ӣ</td><td><div><input id="minutes"/></div></td></tr>').appendTo(timeTable);
//			var hours = $('<tr><td>Сʱ</td><td><div><input id="hours"/></div></td></tr>').appendTo(timeTable);
			var daystable = $('<table></table>').appendTo(calendarPane);
			var dayCheckBox = $('<input type="radio" name="days" value=1 id="everyday"/>').click(function() {
				if (this.checked) {
					weekdaystable.hide();
				}
			});
			
			var everyday = $('<tr><td>죺</td></tr>').append($('<td/>').append(dayCheckBox)).append('<td>ÿ</td>').appendTo(daystable);
			
			
			var weekdaystr1 = $('<tr><td></td></tr>').appendTo(daystable);
			var weekdayCheckBox = $('<input type="radio" name="days" value=2 id="weekday"/>')
				.click(function() {
					if (this.checked) {
						weekdaystable.show();
					}
				});
			weekdaystr1.append($('<td valign="top"></td>').append(weekdayCheckBox));
			var weekdaystable = $('<table><tr><td>һ</td><td>ܶ</td><td></td><td></td><td></td><td></td><td></td></tr></table>');
			weekdaystable.wrap($('<td>ÿܵ</td>')).parent().appendTo(weekdaystr1);
			var weekdaystr2 = $('<tr></tr>').appendTo(weekdaystable);
			var weekdays = new Array(7);
			for(var i=0; i < weekdays.length; i++){
				weekdays[i] = $('<input type="checkbox"/>');
				weekdays[i].wrap($('<td></td>')).parent().appendTo(weekdaystr2);
			}
			weekdaystable.hide();
			
			var monthCheckBox = $('<input type="radio" name="days" value=3 id="monthday"/>').click(function() {
				if (this.checked) {
					weekdaystable.hide();
				}
			});
			var monthdays = $('<tr><td></td></tr>').append($('<td/>').append(monthCheckBox)).append($('<td>ÿµ<input id="monthdays"/></td>')).appendTo(daystable);
			
			
			var monthstable = $('<table></table>').appendTo(calendarPane);
			var allmonthstr = $('<tr><td>£</td></tr>').appendTo(monthstable);
			var allmonths = $('<input class="test" type="checkbox"/>')
			.click(function(){
				if(this.checked){
					for(var i=0; i<months.length; i++){
						months[i][0].checked = true;
					}
				}
			});

			$('<td></td>').append(allmonths).appendTo(allmonthstr);
			$('<td></td>').appendTo(allmonthstr);
			var monthsnametr = $('<tr><td></td><td>һ</td><td></td><td></td><td></td><td></td><td></td>' +
					'<td></td><td></td><td></td><td>ʮ</td><td>ʮһ</td><td>ʮ</td></tr>').appendTo(monthstable);
			var monthstr = $('<tr><td></td></tr>').appendTo(monthstable);
			var months = new Array(12);
			for(var i=0; i<months.length; i++){
				months[i] = $('<input type="checkbox"/>')
				.click(function(){
					if(!this.checked){
						allmonths[0].checked = false;
					}
				});
				months[i].wrap($('<td></td>')).parent().appendTo(monthstr);
			}
			
			var endtimeTable = $('<table></table>').appendTo(calendarPane);
			$('<tr><td><p class="frequentTitle">ʱ趨</p></td></tr>').appendTo(endtimeTable);
			var indifinitely = $('<tr><td><input type="radio" name="occurcalendar" value="indifi" id="indifi"/></td><td></td></tr>').appendTo(endtimeTable);
			var endtimeTR = $('<tr><td><input type="radio" name="occurcalendar" value="endtimeRadio" id="endtimeRadio"/>ʱ䣺</td></tr>').appendTo(endtimeTable);
			var endtimediv = $('<div></div>').wrap($('<td></td>')).parent().appendTo(endtimeTR);
			var endtime = endtimediv.asComponent("datetime", timeConfig);

			calendarPane.populate = function(iTrigger){
				$('#minutes').val((iTrigger.minutes)? iTrigger.minutes : 0);
				$('#hours').val((iTrigger.hours)? iTrigger.hours : 0);
				if(!iTrigger.dayType || iTrigger.dayType == 1){
					$('#everyday').attr('checked',true);
					for(var i=0; i<weekdays.length; i++){
						weekdays[i][0].checked = false;
					}
					$('#monthdays').val("");
				} else if(iTrigger.dayType == 2){
					$('#weekday').attr('checked',true);
					weekdaystable.show();
					var checkeddays = iTrigger.weekDays.split(",");
					for(var j=0; j<checkeddays.length; j++){
						for(var i=0; i<weekdays.length; i++){
							if(checkeddays[j] == i+1){
								weekdays[i][0].checked = true;
								break;
							}
						}
					}
					$('#monthdays').val("");
				} else if(iTrigger.dayType == 3){
					$('#monthday').attr('checked',true);
					for(var i=0; i<weekdays.length; i++){
						weekdays[i][0].checked = false;
					}
					$('#monthdays').val(iTrigger.monthDays);
				}
				if(iTrigger.months){
					var checkedmonths = iTrigger.months.split(",");
					allmonths[0].checked = (checkedmonths.length == months.length);
					for(var j=0; j<checkedmonths.length; j++){
						for(var i=0; i<months.length; i++){
							if(checkedmonths[j] == i+1){
								months[i][0].checked = true;
								break;
							}
						}
					}
				}else{
					allmonths[0].checked = false;
					for(var i=0; i<months.length; i++){
						months[i][0].checked = false;
					}
				}
	
				if (iTrigger.endTime) {
					endtime.setValue(iTrigger.endTime);
				} else {
					$('#indifi').attr('checked',true);
					endtime.setValue("");
				}
			}
			calendarPane.update = function(iTrigger){
				iTrigger.endTime = $('#indifi').attr('checked') ? "" : endtime.getValue();
				iTrigger.minutes = $('#minutes').val();
				iTrigger.hours = $('#hours').val();
				iTrigger.dayType = getCheckedRadio($('input[name="days"]'));
				if(getCheckedRadio($('input[name="days"]'))==2){
					var checkeddays = [];
					for(var i=0; i<weekdays.length; i++){
						if(weekdays[i][0].checked){
							checkeddays.push(i+1);
						}
					}
					iTrigger.weekDays = checkeddays.toString();
				}else if(getCheckedRadio($('input[name="days"]'))==3){
					iTrigger.monthDays = $('#monthdays').val();
				}
				var checkedmonths = [];
				for(var i=0; i<months.length; i++){
					if(months[i][0].checked){
						checkedmonths.push(i+1);
					}
				}
				iTrigger.months = checkedmonths.toString();
			}
			calendarPane.checkvalid = function(){
				var time = endtime.getValue();			
				if (!$('#indifi').attr('checked')) {
					var time = endtime.getValue();
					if(!(/^(\d{4})-(0[1-9]|1[0-2])-(0[1-9]|[12]\d|3[01])\s([01]\d|2[0-3])(:[0-5]\d){2}$/).test(time)){
						itriggerPane.showPane();
						alert("ȷʽʱ䣺yyyy-MM-dd HH:mm:ss");
						return false;
					}
				}
				
				var begintime = starttime.getValue();
				if (Date.parse(begintime.replace(/-/g, "/")) > Date.parse(time.replace(/-/g, "/"))) {
					itriggerPane.showPane();
					alert("ʼʱ䲻ܴڽʱ䣡");
					return false;	
				}
				var minutes = $('#minutes').val();
				if(!(/^((0)?\d|[1-5]\d)$/).test(minutes)){
					itriggerPane.showPane();
					$('#minutes').focus();
					alert("ִʱķ");
					return false;
				}
				var hours = $('#hours').val();
				if(!(/^((0)?\d|1\d|2[0-3])$/).test(hours)){
					itriggerPane.showPane();
					$('#hours').focus();
					alert("ִʱСʱ");
					return false;
				}
				if(getCheckedRadio($('input[name="days"]'))==2){
					var daychecked = false;
					for(var i=0; i<weekdays.length; i++){
						if(weekdays[i][0].checked){
							daychecked = true;
							break;
						}
					}
					if(!daychecked){
						itriggerPane.showPane();
						alert("ѡ");
						return false;
					}
				}else if(getCheckedRadio($('input[name="days"]'))==3){
					var days = $('#monthdays').val();
					if(!(/^((0)?[1-9]|[12]\d|3[01])(,((0)?[1-9]|[12]\d|3[01]))*$/).test(days)){
						itriggerPane.showPane();
						$('#monthdays').focus();
						alert("ȷʽ");
						return false;
					}
				}
				var monthchecked = false;
				for(var i=0; i<months.length; i++){
					if(months[i][0].checked){
						monthchecked = true;
						break;
					}
				}
				if(!monthchecked){
					itriggerPane.showPane();
					alert("ѡִ");
					return false;
				}
				return true;
			}
			
			return calendarPane;
		}//calendarPane
		
		itriggerPane.populate = function (iTrigger){
//			timezone.setValue((iTrigger.timeZoneID) ? iTrigger.timeZoneID : "Asia/Shanghai");
			if(iTrigger.startType && iTrigger.startType == 2){
				$('#on').attr('checked',true);
				if(iTrigger.startTime){
					starttime.setValue(iTrigger.startTime);
				}else{
					starttime.setValue("");
				}
			}else{
				$('#immediately').attr('checked',true);
				starttime.setValue("");
			}
			if(!iTrigger.recurrenceType || iTrigger.recurrenceType == "once"){
				$("#once").click();
				simplePane.populate({});
				calendarPane.populate({});
			}else if(iTrigger.recurrenceType == "simple"){
				$("#simple").click();
				simplePane.populate(iTrigger);
				calendarPane.populate({});
			}else if(iTrigger.recurrenceType == "calendar"){
				$("#calendar").click();
				calendarPane.populate(iTrigger);
				simplePane.populate({});
			}
		}
		itriggerPane.update = function(iTrigger){
//			iTrigger.timeZoneID = timezone.getValue();
			iTrigger.startType = getCheckedRadio($('input[name="start"]'));
			if(getCheckedRadio($('input[name="start"]'))==2){
				iTrigger.startTime = starttime.getValue();
			}
			iTrigger.recurrenceType = getCheckedRadio($('input[name="recurrenceType"]'));
			if(getCheckedRadio($('input[name="recurrenceType"]')) == "simple"){
				simplePane.update(iTrigger);
			}else if(getCheckedRadio($('input[name="recurrenceType"]')) == "calendar"){
				calendarPane.update(iTrigger);
			}
		}
		itriggerPane.checkvalid = function (){
//			if (timezone.isExpanded()) {
//				timezone.collapse();
//			}
			if(getCheckedRadio($('input[name="start"]'))==2){
				var time = starttime.getValue();
				if(!(/^(\d{4})-(0[1-9]|1[0-2])-(0[1-9]|[12]\d|3[01])\s([01]\d|2[0-3])(:[0-5]\d){2}$/).test(time)){
					itriggerPane.showPane();
					alert("ȷʽʱ䣺yyyy-MM-dd HH:mm:ss");
					return false;
				}
			}
			if(getCheckedRadio($('input[name="recurrenceType"]')) == "simple"){
				return simplePane.checkvalid();
			}else if(getCheckedRadio($('input[name="recurrenceType"]')) == "calendar"){
				return calendarPane.checkvalid();
			}
			return true;
		}
		var pastbutton = {
			text : "һ",
			handler : function(){
				basicPane.showPane();
			}
		}
		var nextbutton = {
			text : "һ",
			handler : function(){
				if(itriggerPane.checkvalid()){
					parameterPane.showPane();
				}
			}
		}
		SC.buttonTable([pastbutton,nextbutton,finishbutton,cancelbutton]).appendTo(itriggerPane);
		return itriggerPane;
	}//itriggerPane
	
	function parameterPane(){
		var parameterPane = $("<div></div>");
	
		var isView;
		
		var pastbutton = {
			text : "һ",
			handler : function(){
				itriggerPane.showPane();
			}
		}
		
		var nextbutton = {
			text : "һ",
			handler : function(){
				if (isView === false) {
					return;
				}
				if(parameterPane.checkvalid()){
					outputPane.showPane();
				}
			}
		}
		
		var parameterTable = $('<div/>').addClass('platform_schedule_parameterPane');
		FR.PLATFORM.createParameterTable(parameterTable);
		
		parameterPane.append(parameterTable);
		
		var buttonTable = SC.buttonTable([pastbutton,nextbutton,finishbutton,cancelbutton]);
		
		buttonTable.appendTo(parameterPane);

		parameterPane.populate = function(parameters, iv){
			parameterTable.setReport(processPane.report);
			parameterTable.updateParameters(parameters);
			isView = iv;
			var nextbuttonTD = buttonTable.data('1');
			if (isView) {
				nextbuttonTD.show();
			} else {
				nextbuttonTD.hide();
			}
		}
		parameterPane.update = function(){
			return parameterTable.getParameters();
		}
		parameterPane.checkvalid = function(){
			return true;
		}

		
		return parameterPane;		
	}//parameterPane

	function outputPane(){
		var outputPane = $("<div>Ĳ</div>");
		
		var baseFileName = $('<p>ļʾ*</p><input id="baseFileName"/>').appendTo(outputPane);
		var description = $('<p>ļ</p><textarea id="description" cols="30" rows="3"></textarea>').appendTo(outputPane);
		var folderEntryId = 0;
		var folderEntryPane = folderEntryPane();
		folderEntryPane.appendTo(outputPane);
		var outputFileFormatPane = outputFileFormatPane();
		outputFileFormatPane.appendTo(outputPane);
		var isemail = $('<input id="isemail" type="checkbox"/input>')
		.click(function(){
			if(this.checked) {
				emailNotificationPane.show();
			}else {
				emailNotificationPane.hide();
			}
		}).appendTo($("<p>Ƿʼ֪ͨ</p>")).parent().appendTo(outputPane);
		var emailNotificationPane = emailNotificationPane();
		emailNotificationPane.appendTo(outputPane);
		
		emailAttrSet().appendTo(outputPane);
		
		function emailAttrSet() {
			var emailPane = $('<div></div>');
			var emailTable = $('<table></table>').appendTo(emailPane);
			var emailAttrSet = $('<tr><td>ʼÿ  еʼ鿴</td></tr>').appendTo(emailTable);
			
			//barry:еʼúϲ
//			var attrButton = $('<div></div>');
//			attrButton.appendTo($('<td/>')).parent().appendTo(emailAttrSet);
//			attrButton.asComponent("button", {
//				text: "", 
//				handler : function() {
//					$.ajax({
//						url : '${servletURL}',
//						type : 'POST',
//						data : {
//							op : 'fr_schedule_getEmailAttr'
//						},
//						async : false,
//						complete : function(res, status) {
//							var emailAttr = JSON.parse(res.responseText);						
//							FR.showDialog("ʼ", 340, -1, SC.emailAttrDialogPane(emailAttr));
//						}
//					});
//				}
//			});
			
			return emailPane;
		}
		
		function folderEntryPane(){
			var folderEntryPane = $('<div><p>ѡļʾڵĿ¼</p></div>');
			var pathTable =$('<table></table>').appendTo(folderEntryPane);
			var pathTR = $('<tr></tr>').appendTo(pathTable);
			var treePane = $('<div></div>').addClass("tree").appendTo(folderEntryPane).hide();//
			var pathTD = $('<input id="outputPath" class="pathInput"/>').wrap($('<td></td>')).parent().appendTo(pathTR);
			var selectButton = $('<div></div>');
			selectButton.wrap($("<td></td>")).parent().appendTo(pathTR);
			selectButton.asComponent("button", {
				text: "ѡ",
				handler: function() {
					treePane.toggle();
				}//handler
			});
			folderEntryPane.populate = function(folderEntryId){
				var treedata = tree.getData();
				var o = {
					data: treedata,
					onlyfolder: true,
					onnodeclick: function(){
						var currentItem = treePane.getTCT();
						if (currentItem.id == "0-1") {
							return;
						}
						var path = treePane.getPath(currentItem);
						$("#outputPath").attr("value", path);
						folderEntryPane.folderEntryId = currentItem.id;
					}
				};
				treePane.empty().hide();
				treePane.treeview(o);
				folderEntryPane.folderEntryId = folderEntryId;
				if(folderEntryPane.folderEntryId){
					var node = treePane.getNode(folderEntryPane.folderEntryId);
					node.click();
				}else{
					$('#outputPath').attr("value", "");
				}
			}
			folderEntryPane.update = function(){
				if (folderEntryPane.folderEntryId  && $('#outputPath').val()) {
					return folderEntryPane.folderEntryId.substr(1);
				}
			}
			folderEntryPane.checkvalid = function(){
				//b:ǿд
//				if(!$("#outputPath").attr("value")){
//					outputPane.showPane();
//					$("#outputPath").focus();
//					alert("ѡ񵼳ļ·");
//					return false;
//				}
				return true;
			}
			return folderEntryPane;
		}
		
		function outputFileFormatPane(){
			var outputFileFormatPane = $('<p>ļͣ*</p><div>' +
				'<input type="checkbox" id="isConvertToCpt">cpt' +
				'<input type="checkbox" id="isConvertToExcel">excel' +
				'<input type="checkbox" id="isConvertToPdf">pdf' +
				'<input type="checkbox" id="isConvertToWord">word' +
				'</div>');
			outputFileFormatPane.populate = function(outputFileFormat){
				$('#isConvertToCpt').attr("checked", (outputFileFormat.isConvertToCpt)? outputFileFormat.isConvertToCpt : false);
				$('#isConvertToExcel').attr("checked", (outputFileFormat.isConvertToExcel)? outputFileFormat.isConvertToExcel : false);
				$('#isConvertToPdf').attr("checked", (outputFileFormat.isConvertToPdf)? outputFileFormat.isConvertToPdf : false);
				$('#isConvertToWord').attr("checked", (outputFileFormat.isConvertToWord)? outputFileFormat.isConvertToWord : false);
			}
			outputFileFormatPane.update = function(outputFileFormat){
				outputFileFormat.isConvertToCpt = $('#isConvertToCpt').attr("checked");
				outputFileFormat.isConvertToExcel = $('#isConvertToExcel').attr("checked");
				outputFileFormat.isConvertToPdf = $('#isConvertToPdf').attr("checked");
				outputFileFormat.isConvertToWord = $('#isConvertToWord').attr("checked");
			}
			outputFileFormatPane.checkvalid = function(outputFileFormat){
				if(!($('#isConvertToCpt').attr("checked")||$('#isConvertToExcel').attr("checked")||$('#isConvertToPdf').attr("checked")||$('#isConvertToWord').attr("checked"))){
					outputPane.showPane();
					alert("ѡ񵼳ļ");
					return false;
				}
				return true;
			}
			return outputFileFormatPane;
		}//outputFileFormatPane
		
		function emailNotificationPane(){
			var emailNotificationPane = $("<div></div>");
			
			var toAddress = $('<p>ռˣ*<input id="emailNotification_toAddress"/></p>').appendTo(emailNotificationPane);
			var ccAddress = $('<p>ͣ<input id="emailNotification_ccAddress"/></p>').appendTo(emailNotificationPane);
			var bccAddress = $('<p>ͣ<input id="emailNotification_bccAddress"/></p>').appendTo(emailNotificationPane);
			var subject = $('<p>⣺<input id="emailNotification_subject"/></p>').appendTo(emailNotificationPane);
			var bodyContent = $('<p>ݣ</p><textarea id="emailNotification_bodyContent" cols="30" rows="3"></textarea>').appendTo(emailNotificationPane);	
			emailNotificationPane.populate = function(emailNotification){
				$("#emailNotification_toAddress").attr({value:(emailNotification.toAddress)? emailNotification.toAddress : ""});
				$("#emailNotification_ccAddress").attr({value:(emailNotification.ccAddress)? emailNotification.ccAddress : ""});
				$("#emailNotification_bccAddress").attr({value:(emailNotification.bccAddress)? emailNotification.bccAddress : ""});
				$("#emailNotification_subject").attr({value:(emailNotification.subject)? emailNotification.subject : ""});
				$("#emailNotification_bodyContent").attr({value:(emailNotification.bodyContent)? emailNotification.bodyContent : ""});
			}
			emailNotificationPane.update = function(emailNotification){
				emailNotification.toAddress = $("#emailNotification_toAddress").attr("value");
				emailNotification.ccAddress = $("#emailNotification_ccAddress").attr("value");
				emailNotification.bccAddress = $("#emailNotification_bccAddress").attr("value");
				emailNotification.subject = $("#emailNotification_subject").attr("value");
				emailNotification.bodyContent = $("#emailNotification_bodyContent").attr("value");
			}
			emailNotificationPane.checkvalid = function(){
				var emailString = $("#emailNotification_toAddress").attr("value");
				if(!((/^\w+((-\w+)|(\.\w+))*\@[A-Za-z0-9]+((\.|-)[A-Za-z0-9]+)*\.[A-Za-z0-9]+$/).test(emailString))){
					outputPane.showPane();
					$("#emailNotification_toAddress").focus();
					alert("ʼ͵ַϷ");
					return false;
				}
				return true;
			}
			return emailNotificationPane;
		}//emailNotificationPane
		
		outputPane.populate = function (scheduledOutput){
			$("#baseFileName").attr({value:(scheduledOutput.baseFileName)? scheduledOutput.baseFileName : ""});
			$("#description").attr({value:(scheduledOutput.description)? scheduledOutput.description : ""});
			folderEntryPane.populate(scheduledOutput.folderEntryId);			
			if(!scheduledOutput.outputFileFormat){
				scheduledOutput.outputFileFormat = {};
			}
			outputFileFormatPane.populate(scheduledOutput.outputFileFormat);
			if(!scheduledOutput.emailNotification || !(scheduledOutput.emailNotification.toAddress)){
				scheduledOutput.emailNotification = {};
				$('#isemail').attr("checked", false);
				emailNotificationPane.hide();
			}else {
				$('#isemail').attr("checked", true);
				emailNotificationPane.show();
			}
			emailNotificationPane.populate(scheduledOutput.emailNotification);
		}
		outputPane.update = function(scheduledOutput){
			scheduledOutput.baseFileName = $("#baseFileName").attr("value");
			scheduledOutput.description = $("#description").attr("value");
			scheduledOutput.folderEntryId = folderEntryPane.update();
			outputFileFormatPane.update(scheduledOutput.outputFileFormat);
			if($('#isemail').attr("checked")){
				emailNotificationPane.update(scheduledOutput.emailNotification);
			}else {
				delete scheduledOutput.emailNotification;
			}
		}
		outputPane.checkvalid = function(){
			if(!$("#baseFileName").attr("value")){
				outputPane.showPane();
				$("#baseFileName").focus();
				alert("뵼ļ");
				return false;
			}
			return folderEntryPane.checkvalid() && outputFileFormatPane.checkvalid()
				&& ($('#isemail').attr("checked")? emailNotificationPane.checkvalid() : true);
		}
		var pastbutton = {
			text : "һ",
			handler : function(){
				parameterPane.showPane();
			}
		}
		SC.buttonTable([pastbutton,finishbutton,cancelbutton]).appendTo(outputPane);
		return outputPane;
	}//outputPane
	
	processPane.populate = function(report, task, isView){
		this.isView = isView;
		if(task=="new"){
			task = {};
		}
		processPane.report = report;
		processPane.task = task;
		basicPane.populate(task);
		if(!task.iTrigger){
			task.iTrigger = {};
		}
		itriggerPane.populate(task.iTrigger);
		if(!task.taskParameters){
			task.taskParameters = [];
		}
		parameterPane.populate(task.taskParameters, isView);
		if(!task.scheduledOutput){
			task.scheduledOutput = {};
		}
		if (isView) {
			outputPane.populate(task.scheduledOutput);
		}
		
		basicPane.showPane();
	}
	processPane.update = function(task){
		basicPane.update(task);
		itriggerPane.update(task.iTrigger);
		task.taskParameters = parameterPane.update();
		if (this.isView) {
			outputPane.update(task.scheduledOutput);
		}
	}
	processPane.checkvalid = function(){
		return basicPane.checkvalid() && itriggerPane.checkvalid()
		&& parameterPane.checkvalid() && (!this.isView || outputPane.checkvalid());
	}

	return processPane;
}//createProcessPane

//$.fn.createViewPane = function(){//չʾ
//	var right = this;
//	var viewPane = $('<div id="viewPane"></div>');
//	viewPane.css('height', '100%');
//	var viewFrame = $('<iframe name=viewFrame></iframe>');
//	var returnButton = {
//		text: "",
//		handler: function(){
//			//b:emptyЧԺ
//			viewFrame.remove();
//			viewFrame = $('<iframe name=viewFrame></iframe>').appendTo(viewPane);
//			right.filePane.showPane();
//		}
//	}
//	var buttonTable = SC.buttonTable([returnButton]).appendTo(viewPane);
//	viewFrame.appendTo(viewPane);
//	return viewPane;
//}//createViewPane

})(jQuery);